/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.dto;

import jp.mosp.common.common.BaseDto;

/**
 * M_KINTAI(ΑӏWv)DTONXB
 */
public class MKintaiDto extends BaseDto {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID	= 3447712140906824961L;
	// tB[h
	private String				kcode				= "";
	private String				sikyuym				= "";
	private int					snen				= 0;
	private int					stuki				= 0;
	private int					shi					= 0;
	private double				snissu				= 0;
	private int					skaisu				= 0;
	private int					kinmuji				= 0;
	private int					kyukeiji			= 0;
	private double				yukyu				= 0;
	private double				tokukyu				= 0;
	private double				kekkin				= 0;
	private double				skekkin				= 0;
	private double				daikyu				= 0;
	private double				furikae				= 0;
	private int					sonota				= 0;
	private int					tisokai				= 0;
	private int					tijikan				= 0;
	private int					zajikan				= 0;
	private int					ksjikan				= 0;
	private int					snjikan				= 0;
	private int					kaikin				= 0;
	private int					syokujikaisu		= 0;
	private int					cyokukaisu1			= 0;
	private int					cyokukaisu2			= 0;
	private int					cyokukaisu3			= 0;
	private int					hokakaisu1			= 0;
	private int					hokakaisu2			= 0;
	private int					hokakaisu3			= 0;
	private int					hokakaisu4			= 0;
	private int					hokakaisu5			= 0;
	private int					sinseigaku			= 0;
	private int					nijikyu				= 0;
	private int					warimasi1			= 0;
	

	/**
	 * RXgN^B
	 */
	public MKintaiDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return kcode 	ЈR[hB
	 */
	public String getKCode() {
		return kcode;
	}
	
	/**
	 * @return sikyuym 	xNB
	 */
	public String getSikyuYM() {
		return sikyuym;
	}
	
	/**
	 * @return snen 	xNB
	 */
	public int getSNen() {
		return snen;
	}
	
	/**
	 * @return stuki 	xB
	 */
	public int getSTuki() {
		return stuki;
	}
	
	/**
	 * @return shi 	xB
	 */
	public int getSHi() {
		return shi;
	}
	
	/**
	 * @return snissu 	oΓB
	 */
	public double getSNissu() {
		return snissu;
	}
	
	/**
	 * @return skaisu 	oΉ񐔁B
	 */
	public int getSKaisu() {
		return skaisu;
	}
	
	/**
	 * @return kinmuji 	ΖԁB
	 */
	public int getKinmuJi() {
		return kinmuji;
	}
	
	/**
	 * @return kyukeiji 	xeԁB
	 */
	public int getKyukeiJi() {
		return kyukeiji;
	}
	
	/**
	 * @return yukyu 	LB
	 */
	public double getYukyu() {
		return yukyu;
	}
	
	/**
	 * @return tokukyu 	ʋxɁB
	 */
	public double getTokuKyu() {
		return tokukyu;
	}
	
	/**
	 * @return kekkin 	ʌΓB
	 */
	public double getKekkin() {
		return kekkin;
	}
	
	/**
	 * @return skekkin 	aΓB
	 */
	public double getSKekkin() {
		return skekkin;
	}
	
	/**
	 * @return daikyu 	֋xɁB
	 */
	public double getDaiKyu() {
		return daikyu;
	}
	
	/**
	 * @return furikae 	U֋xɁB
	 */
	public double getFurikae() {
		return furikae;
	}
	
	/**
	 * @return sonota 	̑xɁB
	 */
	public int getSonota() {
		return sonota;
	}
	
	/**
	 * @return tisokai 	xމ񐔁B
	 */
	public int getTiSoKai() {
		return tisokai;
	}
	
	/**
	 * @return tijikan 	xގԁB
	 */
	public int getTiJikan() {
		return tijikan;
	}
	
	/**
	 * @return zajikan 	ʎcƎԁB
	 */
	public int getZaJikan() {
		return zajikan;
	}
	
	/**
	 * @return ksjikan 	xoΎԁB
	 */
	public int getKsJikan() {
		return ksjikan;
	}
	
	/**
	 * @return snjikan 	[ΖԁB
	 */
	public int getSnJikan() {
		return snjikan;
	}
	
	/**
	 * @return kaikin 	FΎ蓖xB
	 */
	public int getKaikin() {
		return kaikin;
	}
	
	/**
	 * @return syokujikaisu 	H蓖x񐔁B
	 */
	public int getSyokujiKaisu() {
		return syokujikaisu;
	}
	
	/**
	 * @return cyokukaisu1 	1蓖x񐔁B
	 */
	public int getCyokuKaisu1() {
		return cyokukaisu1;
	}
	
	/**
	 * @return cyokukaisu2 	2蓖x񐔁B
	 */
	public int getCyokuKaisu2() {
		return cyokukaisu2;
	}
	
	/**
	 * @return cyokukaisu3 	3蓖x񐔁B
	 */
	public int getCyokuKaisu3() {
		return cyokukaisu3;
	}
	
	/**
	 * @return hokakaisu1 	̑x1B
	 */
	public int getHokaKaisu1() {
		return hokakaisu1;
	}
	
	/**
	 * @return hokakaisu2 	̑x2B
	 */
	public int getHokaKaisu2() {
		return hokakaisu2;
	}
	
	/**
	 * @return hokakaisu3 	̑x3B
	 */
	public int getHokaKaisu3() {
		return hokakaisu3;
	}
	
	/**
	 * @return hokakaisu4 	̑x4B
	 */
	public int getHokaKaisu4() {
		return hokakaisu4;
	}
	
	/**
	 * @return hokakaisu5 	̑x5B
	 */
	public int getHokaKaisu5() {
		return hokakaisu5;
	}
	
	/**
	 * @return sinseigaku 	x\zB
	 */
	public int getSinseiGaku() {
		return sinseigaku;
	}
	
	/**
	 * @return nijikyu 	񎞊ԔNxB
	 */
	public int getNijiKyu() {
		return nijikyu;
	}
	
	/**
	 * @return warimasi1 	1.00B
	 */
	public int getWarimasi1() {
		return warimasi1;
	}
	
	/**
	 * @param kcode 	ZbgЈR[hB
	 */
	public void setKCode(String kcode) {
		this.kcode = kcode;
	}
	
	/**
	 * @param sikyuym 	ZbgxNB
	 */
	public void setSikyuYM(String sikyuym) {
		this.sikyuym = sikyuym;
	}
	
	/**
	 * @param snen 	ZbgxNB
	 */
	public void setSNen(int snen) {
		this.snen = snen;
	}
	
	/**
	 * @param stuki 	ZbgxB
	 */
	public void setSTuki(int stuki) {
		this.stuki = stuki;
	}
	
	/**
	 * @param shi 	ZbgxB
	 */
	public void setSHi(int shi) {
		this.shi = shi;
	}
	
	/**
	 * @param snissu 	ZbgoΓB
	 */
	public void setSNissu(double snissu) {
		this.snissu = snissu;
	}
	
	/**
	 * @param skaisu 	ZbgoΉ񐔁B
	 */
	public void setSKaisu(int skaisu) {
		this.skaisu = skaisu;
	}
	
	/**
	 * @param kinmuji 	ZbgΖԁB
	 */
	public void setKinmuJi(int kinmuji) {
		this.kinmuji = kinmuji;
	}
	
	/**
	 * @param kyukeiji 	ZbgxeԁB
	 */
	public void setKyukeiJi(int kyukeiji) {
		this.kyukeiji = kyukeiji;
	}
	
	/**
	 * @param yukyu 	ZbgLB
	 */
	public void setYukyu(double yukyu) {
		this.yukyu = yukyu;
	}
	
	/**
	 * @param tokukyu 	ZbgʋxɁB
	 */
	public void setTokuKyu(double tokukyu) {
		this.tokukyu = tokukyu;
	}
	
	/**
	 * @param kekkin 	ZbgʌΓB
	 */
	public void setKekkin(double kekkin) {
		this.kekkin = kekkin;
	}
	
	/**
	 * @param skekkin 	Zbg鏝aΓB
	 */
	public void setSKekkin(double skekkin) {
		this.skekkin = skekkin;
	}
	
	/**
	 * @param daikyu 	Zbg֋xɁB
	 */
	public void setDaiKyu(double daikyu) {
		this.daikyu = daikyu;
	}
	
	/**
	 * @param furikae 	ZbgU֋xɁB
	 */
	public void setFurikae(double furikae) {
		this.furikae = furikae;
	}
	
	/**
	 * @param sonota 	Zbg邻̑xɁB
	 */
	public void setSonota(int sonota) {
		this.sonota = sonota;
	}
	
	/**
	 * @param tisokai 	Zbgxމ񐔁B
	 */
	public void setTiSoKai(int tisokai) {
		this.tisokai = tisokai;
	}
	
	/**
	 * @param tijikan 	ZbgxގԁB
	 */
	public void setTiJikan(int tijikan) {
		this.tijikan = tijikan;
	}
	
	/**
	 * @param zajikan 	Zbg镁ʎcƎԁB
	 */
	public void setZaJikan(int zajikan) {
		this.zajikan = zajikan;
	}
	
	/**
	 * @param ksjikan 	ZbgxoΎԁB
	 */
	public void setKsJikan(int ksjikan) {
		this.ksjikan = ksjikan;
	}
	
	/**
	 * @param snjikan 	Zbg[ΖԁB
	 */
	public void setSnJikan(int snjikan) {
		this.snjikan = snjikan;
	}
	
	/**
	 * @param kaikin 	Zbg鐸FΎ蓖xB
	 */
	public void setKaikin(int kaikin) {
		this.kaikin = kaikin;
	}
	
	/**
	 * @param syokujikaisu 	ZbgH蓖x񐔁B
	 */
	public void setSyokujiKaisu(int syokujikaisu) {
		this.syokujikaisu = syokujikaisu;
	}
	
	/**
	 * @param cyokukaisu1 	Zbg1蓖x񐔁B
	 */
	public void setCyokuKaisu1(int cyokukaisu1) {
		this.cyokukaisu1 = cyokukaisu1;
	}
	
	/**
	 * @param cyokukaisu2 	Zbg2蓖x񐔁B
	 */
	public void setCyokuKaisu2(int cyokukaisu2) {
		this.cyokukaisu2 = cyokukaisu2;
	}
	
	/**
	 * @param cyokukaisu3 	Zbg3蓖x񐔁B
	 */
	public void setCyokuKaisu3(int cyokukaisu3) {
		this.cyokukaisu3 = cyokukaisu3;
	}
	
	/**
	 * @param hokakaisu1 	Zbg邻̑x1B
	 */
	public void setHokaKaisu1(int hokakaisu1) {
		this.hokakaisu1 = hokakaisu1;
	}
	
	/**
	 * @param hokakaisu2 	Zbg邻̑x2B
	 */
	public void setHokaKaisu2(int hokakaisu2) {
		this.hokakaisu2 = hokakaisu2;
	}
	
	/**
	 * @param hokakaisu3 	Zbg邻̑x3B
	 */
	public void setHokaKaisu3(int hokakaisu3) {
		this.hokakaisu3 = hokakaisu3;
	}
	
	/**
	 * @param hokakaisu4 	Zbg邻̑x4B
	 */
	public void setHokaKaisu4(int hokakaisu4) {
		this.hokakaisu4 = hokakaisu4;
	}
	
	/**
	 * @param hokakaisu5 	Zbg邻̑x5B
	 */
	public void setHokaKaisu5(int hokakaisu5) {
		this.hokakaisu5 = hokakaisu5;
	}
	
	/**
	 * @param sinseigaku 	Zbgx\zB
	 */
	public void setSinseiGaku(int sinseigaku) {
		this.sinseigaku = sinseigaku;
	}
	
	/**
	 * @param nijikyu 	Zbg񎞊ԔNxB
	 */
	public void setNijiKyu(int nijikyu) {
		this.nijikyu = nijikyu;
	}
	
	/**
	 * @param warimasi1 	Zbg1.00B
	 */
	public void setWarimasi1(int warimasi1) {
		this.warimasi1 = warimasi1;
	}
	
}
