/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.dto;

import jp.mosp.common.common.BaseDto;

/**
 * @author yoshida
 *
 */
public class CompileAmendmentDto extends BaseDto {
	
	private static final long	serialVersionUID	= -7610225524781485271L;
	
	// tB[h
	private String				kCode				= "";
	private String				kName				= "";
	private String				sCode				= "";
	private double				sNissu				= 0;
	private double				yukyu				= 0;
	private double				tokuKyu				= 0;
	private double				kekkin				= 0;
	private int					kinmuJi				= 0;
	private int					kyukeiJi			= 0;
	private int					tisoJi				= 0;
	private int					zaJikan				= 0;
	private int					ksJikan				= 0;
	private int					snJikan				= 0;
	
	private boolean				approvedFlag		= false;
	private boolean				compiledFlag		= false;
	
	private int					cautionMonthly		= 0;
	

	/**
	 * RXgN^
	 */
	public CompileAmendmentDto() {
		super();
	}
	
	/**
	 * @return kCode
	 */
	public String getKCode() {
		return kCode;
	}
	
	/**
	 * @return kName
	 */
	public String getKName() {
		return kName;
	}
	
	/**
	 * @return sCode
	 */
	public String getSCode() {
		return sCode;
	}
	
	/**
	 * @return sNissu
	 */
	public double getSNissu() {
		return sNissu;
	}
	
	/**
	 * @return yukyu
	 */
	public double getYukyu() {
		return yukyu;
	}
	
	/**
	 * @return tokuKyu
	 */
	public double getTokuKyu() {
		return tokuKyu;
	}
	
	/**
	 * @return kekkin
	 */
	public double getKekkin() {
		return kekkin;
	}
	
	/**
	 * @return kinmuJi
	 */
	public int getKinmuJi() {
		return kinmuJi;
	}
	
	/**
	 * @return kyukeiJi
	 */
	public int getKyukeiJi() {
		return kyukeiJi;
	}
	
	/**
	 * @return tisoJi
	 */
	public int getTisoJi() {
		return tisoJi;
	}
	
	/**
	 * @return zaJikan
	 */
	public int getZaJikan() {
		return zaJikan;
	}
	
	/**
	 * @return ksJikan
	 */
	public int getKsJikan() {
		return ksJikan;
	}
	
	/**
	 * @return snJikan
	 */
	public int getSnJikan() {
		return snJikan;
	}
	
	/**
	 * @return approvedFlag
	 */
	public boolean isApprovedFlag() {
		return approvedFlag;
	}
	
	/**
	 * @return compiledFlag
	 */
	public boolean isCompiledFlag() {
		return compiledFlag;
	}
	
	/**
	 * @return cautionMonthly
	 */
	public int getCautionMonthly() {
		return cautionMonthly;
	}
	
	/**
	 * @param kCode Zbg kCode
	 */
	public void setKCode(String kCode) {
		this.kCode = kCode;
	}
	
	/**
	 * @param kName Zbg kName
	 */
	public void setKName(String kName) {
		this.kName = kName;
	}
	
	/**
	 * @param sCode Zbg sCode
	 */
	public void setSCode(String sCode) {
		this.sCode = sCode;
	}
	
	/**
	 * @param sNissu Zbg sNissu
	 */
	public void setSNissu(double sNissu) {
		this.sNissu = sNissu;
	}
	
	/**
	 * @param yukyu Zbg yukyu
	 */
	public void setYukyu(double yukyu) {
		this.yukyu = yukyu;
	}
	
	/**
	 * @param tokuKyu Zbg tokuKyu
	 */
	public void setTokuKyu(double tokuKyu) {
		this.tokuKyu = tokuKyu;
	}
	
	/**
	 * @param kekkin Zbg kekkin
	 */
	public void setKekkin(double kekkin) {
		this.kekkin = kekkin;
	}
	
	/**
	 * @param kinmuJi Zbg kinmuJi
	 */
	public void setKinmuJi(int kinmuJi) {
		this.kinmuJi = kinmuJi;
	}
	
	/**
	 * @param kyukeiJi Zbg kyukeiJi
	 */
	public void setKyukeiJi(int kyukeiJi) {
		this.kyukeiJi = kyukeiJi;
	}
	
	/**
	 * @param tisoJi Zbg tisoJi
	 */
	public void setTisoJi(int tisoJi) {
		this.tisoJi = tisoJi;
	}
	
	/**
	 * @param zaJikan Zbg zaJikan
	 */
	public void setZaJikan(int zaJikan) {
		this.zaJikan = zaJikan;
	}
	
	/**
	 * @param ksJikan Zbg ksJikan
	 */
	public void setKsJikan(int ksJikan) {
		this.ksJikan = ksJikan;
	}
	
	/**
	 * @param snJikan Zbg snJikan
	 */
	public void setSnJikan(int snJikan) {
		this.snJikan = snJikan;
	}
	
	/**
	 * @param approvedFlag Zbg approvedFlag
	 */
	public void setApprovedFlag(boolean approvedFlag) {
		this.approvedFlag = approvedFlag;
	}
	
	/**
	 * @param compiledFlag Zbg compiledFlag
	 */
	public void setCompiledFlag(boolean compiledFlag) {
		this.compiledFlag = compiledFlag;
	}
	
	/**
	 * @param cautionMonthly Zbg cautionMonthly
	 */
	public void setCautionMonthly(int cautionMonthly) {
		this.cautionMonthly = cautionMonthly;
	}
	
}
