/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.payroll.dto.KdWorkDto;

/**
 * KD_WORK(ΑӏWv)DAONX B
 */
public class KdWorkDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * KD_WORK(ΑӏWv)B
	 */
	public static final String	TABLE						= "KD_WORK";
	
	/**
	 * KEY_1 = K_CODE(ЈR[h)B
	 */
	public static final String	KEY_1						= "K_CODE";
	/**
	 * KEY_2 = SIKYU_YM(xN)B
	 */
	public static final String	KEY_2						= "SIKYU_YM";
	
	// 
	/**
	 * K_CODE(ЈR[h)B
	 */
	public static final String	COL_K_CODE					= "K_CODE";
	/**
	 * SIKYU_YM(xN)B
	 */
	public static final String	COL_SIKYU_YM				= "SIKYU_YM";
	/**
	 * S_NEN(xN)B
	 */
	public static final String	COL_S_NEN					= "S_NEN";
	/**
	 * S_TUKI(x)B
	 */
	public static final String	COL_S_TUKI					= "S_TUKI";
	/**
	 * S_HI(x)B
	 */
	public static final String	COL_S_HI					= "S_HI";
	/**
	 * S_NISSU(oΓ)B
	 */
	public static final String	COL_S_NISSU					= "S_NISSU";
	/**
	 * S_KAISU(oΉ)B
	 */
	public static final String	COL_S_KAISU					= "S_KAISU";
	/**
	 * KINMU_JI(Ζ)B
	 */
	public static final String	COL_KINMU_JI				= "KINMU_JI";
	/**
	 * KYUKEI_JI(xe)B
	 */
	public static final String	COL_KYUKEI_JI				= "KYUKEI_JI";
	/**
	 * YUKYU(L)B
	 */
	public static final String	COL_YUKYU					= "YUKYU";
	/**
	 * TOKUKYU(ʋx)B
	 */
	public static final String	COL_TOKUKYU					= "TOKUKYU";
	/**
	 * KEKKIN(ʌΓ)B
	 */
	public static final String	COL_KEKKIN					= "KEKKIN";
	/**
	 * S_KEKKIN(aΓ)B
	 */
	public static final String	COL_S_KEKKIN				= "S_KEKKIN";
	/**
	 * DAIKYU(֋x)B
	 */
	public static final String	COL_DAIKYU					= "DAIKYU";
	/**
	 * FURIKAE(U֋x)B
	 */
	public static final String	COL_FURIKAE					= "FURIKAE";
	/**
	 * KK_RIYUU_6(xɗR6)B
	 */
	public static final String	COL_KK_RIYUU_6				= "KK_RIYUU_6";
	/**
	 * KK_RIYUU_7(xɗR7)B
	 */
	public static final String	COL_KK_RIYUU_7				= "KK_RIYUU_7";
	/**
	 * KK_RIYUU_8(xɗR8)B
	 */
	public static final String	COL_KK_RIYUU_8				= "KK_RIYUU_8";
	/**
	 * KK_RIYUU_9(xɗR9)B
	 */
	public static final String	COL_KK_RIYUU_9				= "KK_RIYUU_9";
	/**
	 * SONOTA(̑x)B
	 */
	public static final String	COL_SONOTA					= "SONOTA";
	/**
	 * TI_SO_KAI(xމ)B
	 */
	public static final String	COL_TI_SO_KAI				= "TI_SO_KAI";
	/**
	 * TI_JIKAN(xގ)B
	 */
	public static final String	COL_TI_SO_JIKAN				= "TI_SO_JIKAN";
	/**
	 * ZA_JIKAN(ʎcƎ)B
	 */
	public static final String	COL_ZA_JIKAN				= "ZA_JIKAN";
	/**
	 * KS_JIKAN(xoΎ)B
	 */
	public static final String	COL_KS_JIKAN				= "KS_JIKAN";
	/**
	 * SN_JIKAN([Ζ)B
	 */
	public static final String	COL_SN_JIKAN				= "SN_JIKAN";
	/**
	 * KAIKIN(FΎ蓖x)B
	 */
	public static final String	COL_KAIKIN					= "KAIKIN";
	/**
	 * SYOKUJI_KAISU(H蓖x)B
	 */
	public static final String	COL_SYOKUJI_KAISU			= "SYOKUJI_KAISU";
	/**
	 * CYOKU_KAISU_1(1蓖x)B
	 */
	public static final String	COL_CYOKU_KAISU_1			= "CYOKU_KAISU_1";
	/**
	 * CYOKU_KAISU_2(2蓖x)B
	 */
	public static final String	COL_CYOKU_KAISU_2			= "CYOKU_KAISU_2";
	/**
	 * CYOKU_KAISU_3(3蓖x)B
	 */
	public static final String	COL_CYOKU_KAISU_3			= "CYOKU_KAISU_3";
	/**
	 * HOKA_KAISU_1(̑x1)B
	 */
	public static final String	COL_HOKA_KAISU_1			= "HOKA_KAISU_1";
	/**
	 * HOKA_KAISU_2(̑x2)B
	 */
	public static final String	COL_HOKA_KAISU_2			= "HOKA_KAISU_2";
	/**
	 * HOKA_KAISU_3(̑x3)B
	 */
	public static final String	COL_HOKA_KAISU_3			= "HOKA_KAISU_3";
	/**
	 * HOKA_KAISU_4(̑x4)B
	 */
	public static final String	COL_HOKA_KAISU_4			= "HOKA_KAISU_4";
	/**
	 * HOKA_KAISU_5(̑x5)B
	 */
	public static final String	COL_HOKA_KAISU_5			= "HOKA_KAISU_5";
	/**
	 * SINSEI_GAKU(x\z)B
	 */
	public static final String	COL_SINSEI_GAKU				= "SINSEI_GAKU";
	/**
	 * WARIMASI_1(1.00)B
	 */
	public static final String	COL_WARIMASI_1				= "WARIMASI_1";
	/**
	 * WEEK_DAY_OVER_TIME(ԊO)B
	 */
	public static final String	COL_WEEK_DAY_OVER_TIME		= "WEEK_DAY_OVER_TIME";
	/**
	 * WEEK_HOLIDAY_OVER_TIME(xԊO)B
	 */
	public static final String	COL_WEEK_HOLIDAY_OVER_TIME	= "WEEK_HOLIDAY_OVER_TIME";
	/**
	 * MONTHLY_OVER_TIME(60ԒߕԊO)B
	 */
	public static final String	COL_MONTHLY_OVER_TIME		= "MONTHLY_OVER_TIME";
	/**
	 * MONTHLY_WEEK_HOLIDAY(60ԒߏxԊO)B
	 */
	public static final String	COL_MONTHLY_WEEK_HOLIDAY	= "MONTHLY_WEEK_HOLIDAY";
	/**
	 * HOUR_HOLIDAY(ԒPʔNx擾)B
	 */
	public static final String	COL_HOUR_HOLIDAY			= "HOUR_HOLIDAY";
	/**
	 * SUBSTITUTE_HOLIDAY(ԊOԑ֋xɎ擾)B
	 */
	public static final String	COL_SUBSTITUTE_HOLIDAY		= "SUBSTITUTE_HOLIDAY";
	/**
	 * AMEND_FLAG(CtO)B
	 */
	public static final String	COL_AMEND_FLAG				= "AMEND_FLAG";
	

	/**
	 * RXgN^B
	 */
	public KdWorkDao() {
		super();
		INSERT_DATE = "INSERT_DATE";
		INSERT_USER = "INSERT_USER";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
	/**
	 * ʎ擾(DTOList)B
	 * @return ʃXg
	 * @throws SQLException 	SQLOꍇ
	 */
	private List<KdWorkDto> mappingAll() throws SQLException {
		List<KdWorkDto> all = new ArrayList<KdWorkDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)B
	 * @return KD_WORKR[h
	 * @throws SQLException 	SQLOꍇ
	 */
	private KdWorkDto mapping() throws SQLException {
		KdWorkDto dto = new KdWorkDto();
		dto.setKCode(rs.getString(COL_K_CODE));
		dto.setSikyuYm(rs.getString(COL_SIKYU_YM));
		dto.setSNen(rs.getInt(COL_S_NEN));
		dto.setSTuki(rs.getInt(COL_S_TUKI));
		dto.setSHi(rs.getInt(COL_S_HI));
		dto.setSNissu(rs.getDouble(COL_S_NISSU));
		dto.setSKaisu(rs.getInt(COL_S_KAISU));
		dto.setKinmuJi(rs.getInt(COL_KINMU_JI));
		dto.setKyukeiJi(rs.getInt(COL_KYUKEI_JI));
		dto.setYukyu(rs.getDouble(COL_YUKYU));
		dto.setTokukyu(rs.getDouble(COL_TOKUKYU));
		dto.setKekkin(rs.getDouble(COL_KEKKIN));
		dto.setSKekkin(rs.getDouble(COL_S_KEKKIN));
		dto.setDaikyu(rs.getDouble(COL_DAIKYU));
		dto.setFurikae(rs.getDouble(COL_FURIKAE));
		dto.setKkRiyuu6(rs.getDouble(COL_KK_RIYUU_6));
		dto.setKkRiyuu7(rs.getDouble(COL_KK_RIYUU_7));
		dto.setKkRiyuu8(rs.getDouble(COL_KK_RIYUU_8));
		dto.setKkRiyuu9(rs.getDouble(COL_KK_RIYUU_9));
		dto.setSonota(rs.getDouble(COL_SONOTA));
		dto.setTiSoKai(rs.getInt(COL_TI_SO_KAI));
		dto.setTiSoJikan(rs.getInt(COL_TI_SO_JIKAN));
		dto.setZaJikan(rs.getInt(COL_ZA_JIKAN));
		dto.setKsJikan(rs.getInt(COL_KS_JIKAN));
		dto.setSnJikan(rs.getInt(COL_SN_JIKAN));
		dto.setKaikin(rs.getInt(COL_KAIKIN));
		dto.setSyokujiKaisu(rs.getInt(COL_SYOKUJI_KAISU));
		dto.setCyokuKaisu1(rs.getInt(COL_CYOKU_KAISU_1));
		dto.setCyokuKaisu2(rs.getInt(COL_CYOKU_KAISU_2));
		dto.setCyokuKaisu3(rs.getInt(COL_CYOKU_KAISU_3));
		dto.setHokaKaisu1(rs.getInt(COL_HOKA_KAISU_1));
		dto.setHokaKaisu2(rs.getInt(COL_HOKA_KAISU_2));
		dto.setHokaKaisu3(rs.getInt(COL_HOKA_KAISU_3));
		dto.setHokaKaisu4(rs.getInt(COL_HOKA_KAISU_4));
		dto.setHokaKaisu5(rs.getInt(COL_HOKA_KAISU_5));
		dto.setSinseiGaku(rs.getInt(COL_SINSEI_GAKU));
		dto.setWarimasi1(rs.getInt(COL_WARIMASI_1));
		dto.setWeekDayOverTime(rs.getInt(COL_WEEK_DAY_OVER_TIME));
		dto.setWeekHolidayOverTime(rs.getInt(COL_WEEK_HOLIDAY_OVER_TIME));
		dto.setMonthlyOverTime(rs.getInt(COL_MONTHLY_OVER_TIME));
		dto.setMonthlyWeekHoliday(rs.getInt(COL_MONTHLY_WEEK_HOLIDAY));
		dto.setHourHoliday(rs.getInt(COL_HOUR_HOLIDAY));
		dto.setSubstituteHoliday(rs.getDouble(COL_SUBSTITUTE_HOLIDAY));
		dto.setAmendFlag(rs.getInt(COL_AMEND_FLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾B
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<KdWorkDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @param sikyuYm xN(L[)
	 * @return KdWorkDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public KdWorkDto findForKey(String kCode, String sikyuYm) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, sikyuYm);
			executeQuery();
			KdWorkDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @param sikyuYm xN(L[)
	 * @return KdWorkDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public KdWorkDto findForUpdate(String kCode, String sikyuYm) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			setParam(index++, sikyuYm);
			executeQuery();
			KdWorkDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param sikyuYm xN(L[)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public void findForUpdate(String sikyuYm) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_SIKYU_YM);
			sb.append(" = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getForUpdate());
			setParam(index++, sikyuYm);
			executeQuery();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode ЈR[h
	 * @param sikyuYm xN
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<?> findForCondition(String kCode, String sikyuYm) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_SIKYU_YM);
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, sikyuYm + "%");
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param sikyuYm xN
	 * @return (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<KdWorkDto> findForCondition(String sikyuYm) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_SIKYU_YM);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, sikyuYm);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(͈͎w)
	 * @param kCode ЈR[h
	 * @param startSikyuNen JnN
	 * @param startSikyuTuki IN
	 * @param endSikyuNen Jn
	 * @param endSikyuTuki I
	 * @param dif N
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<KdWorkDto> findForCondition(String kCode, int startSikyuNen, int startSikyuTuki, int endSikyuNen,
			int endSikyuTuki, int dif) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE);
		sb.append(" = ? AND ");
		if (dif != 0) {
			sb.append("((");
			sb.append(COL_S_NEN);
			sb.append(" = ? AND ");
			sb.append(COL_S_TUKI);
			sb.append(" BETWEEN");
			sb.append(" ? AND ? )");
			sb.append(" OR ");
		}
		for (int i = 1; dif > i; i++) {
			sb.append(COL_S_NEN);
			sb.append(" = ?");
			sb.append(" OR ");
		}
		sb.append("(");
		sb.append(COL_S_NEN);
		sb.append(" = ? AND ");
		sb.append(COL_S_TUKI);
		sb.append(" BETWEEN");
		sb.append(" ? AND ? )");
		if (dif != 0) {
			sb.append(")");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			if (dif != 0) {
				setParam(index++, startSikyuNen);
				setParam(index++, startSikyuTuki);
				setParam(index++, 12);
			}
			for (int i = 1; dif > i; i++) {
				setParam(index++, startSikyuNen + i);
			}
			setParam(index++, endSikyuNen);
			if (dif == 0) {
				setParam(index++, startSikyuTuki);
			} else {
				setParam(index++, 1);
			}
			setParam(index++, endSikyuTuki);
			executeQuery();
			List<KdWorkDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param sikyuYm xN
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<KdWorkDto> findForExport(String sikyuYm) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_SIKYU_YM);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, sikyuYm);
			executeQuery();
			List<KdWorkDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public int insert(KdWorkDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * @param list		VΑӏ
	 * @param divSize	
	 * @return	}()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(List<KdWorkDto> list, int divSize) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			int listSize = list.size();
			int rev = listSize / divSize + 1;
			if (listSize % divSize == 0) {
				rev--;
			}
			int insertCount = 0;
			List<KdWorkDto> divList = new ArrayList<KdWorkDto>();
			for (int i = 0; i < rev; i++) {
				// XgdivƕB
				for (int k = 0; k < divSize; k++) {
					int count = k + (i * divSize);
					if (count >= listSize) {
						break;
					}
					divList.add(list.get(count));
				}
				int divListSize = divList.size();
				prepareStatement(getInsertQuery(getClass(), divListSize, divSize));
				for (KdWorkDto dto : divList) {
					setParams(dto, true);
				}
				executeUpdate();
				clearParams();
				index = 1;
				divList.clear();
				chkInsert(divListSize);
				insertCount += cnt;
			}
			return insertCount;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param 	aryDto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public int insert(KdWorkDto[] aryDto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass(), aryDto.length, aryDto.length));
			for (KdWorkDto dto : aryDto) {
				setParams(dto, true);
			}
			executeUpdate();
			chkInsert(aryDto.length);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public int update(KdWorkDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getSikyuYm());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public int delete(KdWorkDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getSikyuYm());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param aryDto XVΏDTO
	 * @param sikyuYm xN
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public int delete(KdWorkDto[] aryDto, String sikyuYm) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" WHERE (");
			int i = 0;
			while (i != aryDto.length) {
				sb.append(COL_K_CODE);
				sb.append(" = ? OR ");
				i++;
			}
			sb.delete(sb.length() - 4, sb.length());
			sb.append(") AND ");
			sb.append(COL_SIKYU_YM);
			sb.append(" = ?");
			prepareStatement(sb.toString());
			for (KdWorkDto dto : aryDto) {
				setParam(index++, dto.getKCode());
			}
			setParam(index++, sikyuYm);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param 	sikyuYm	XVΏ۔N
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public int delete(String sikyuYm) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" ");
			sb.append("WHERE ");
			sb.append(COL_SIKYU_YM);
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			setParam(index++, sikyuYm);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒB
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseF})
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(KdWorkDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode());
		setParam(index++, dto.getSikyuYm());
		setParam(index++, dto.getSNen());
		setParam(index++, dto.getSTuki());
		setParam(index++, dto.getSHi());
		setParam(index++, dto.getSNissu());
		setParam(index++, dto.getSKaisu());
		setParam(index++, dto.getKinmuJi());
		setParam(index++, dto.getKyukeiJi());
		setParam(index++, dto.getYukyu());
		setParam(index++, dto.getTokukyu());
		setParam(index++, dto.getKekkin());
		setParam(index++, dto.getSKekkin());
		setParam(index++, dto.getDaikyu());
		setParam(index++, dto.getFurikae());
		setParam(index++, dto.getKkRiyuu6());
		setParam(index++, dto.getKkRiyuu7());
		setParam(index++, dto.getKkRiyuu8());
		setParam(index++, dto.getKkRiyuu9());
		setParam(index++, dto.getSonota());
		setParam(index++, dto.getTiSoKai());
		setParam(index++, dto.getTiSoJikan());
		setParam(index++, dto.getZaJikan());
		setParam(index++, dto.getKsJikan());
		setParam(index++, dto.getSnJikan());
		setParam(index++, dto.getKaikin());
		setParam(index++, dto.getSyokujiKaisu());
		setParam(index++, dto.getCyokuKaisu1());
		setParam(index++, dto.getCyokuKaisu2());
		setParam(index++, dto.getCyokuKaisu3());
		setParam(index++, dto.getHokaKaisu1());
		setParam(index++, dto.getHokaKaisu2());
		setParam(index++, dto.getHokaKaisu3());
		setParam(index++, dto.getHokaKaisu4());
		setParam(index++, dto.getHokaKaisu5());
		setParam(index++, dto.getSinseiGaku());
		setParam(index++, dto.getWarimasi1());
		setParam(index++, dto.getWeekDayOverTime());
		setParam(index++, dto.getWeekHolidayOverTime());
		setParam(index++, dto.getMonthlyOverTime());
		setParam(index++, dto.getMonthlyWeekHoliday());
		setParam(index++, dto.getHourHoliday());
		setParam(index++, dto.getSubstituteHoliday());
		setParam(index++, dto.getAmendFlag());
		setCommonParams(isInsert);
	}
	
	/**
	 * e[ubN
	 * @param 	sikyuYm	XVΏ۔N
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public void tableLock(String sikyuYm) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				findForUpdate(sikyuYm);
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * e[ubN
	 * @param	kCode ЈR[h
	 * @param 	sikyuYm	XVΏ۔N
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public void tableLock(String kCode, String sikyuYm) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				findForUpdate(kCode, sikyuYm);
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * e[ubN
	 * @param listKdWork DTO
	 * @param sikyuYm XVΏ۔N
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public void tableLock(List<KdWorkDto> listKdWork, String sikyuYm) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				for (KdWorkDto kdWork : listKdWork) {
					KdWorkDto dto = kdWork;
					findForUpdate(dto.getKCode(), sikyuYm);
				}
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
}
