/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.CsvUtil;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.kintai.payroll.dao.KdWorkDao;
import jp.mosp.kintai.payroll.dao.MKintaiDao;
import jp.mosp.kintai.payroll.dto.KdWorkDto;
import jp.mosp.kintai.payroll.dto.MKintaiDto;
import jp.mosp.kintai.payroll.vo.WorkCompileExportCardVo;

/**
 * @author nakamura
 *
 */
public class WorkCompileExportCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_SHOW	= "S1230";
	private static final String	CMD_EXPORT	= "S1231";
	
	// 萔
	private static final int	NUM_2010	= 2010;
	

	/**
	 * RXgN^[
	 */
	public WorkCompileExportCardAction() {
		super();
	}
	
	/* ( Javadoc)
	 * @see jp.mosp.common.common.ActionInterface#action()
	 */
	public void action() throws Exception {
		// VȌ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (CMD_SHOW.equals(cmd)) {
			// \
			show();
		} else if (CMD_EXPORT.equals(cmd)) {
			// GNX|[g
			export();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new WorkCompileExportCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// [U̎擾
		getInfo(user.getUserId());
		// v_E̐ݒ
		WorkCompileExportCardVo vo = (WorkCompileExportCardVo)getVo();
		vo.aryPltSection = getSectionArrayAll();
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), 9, 1);
		vo.aryPltMonth = StringUtil.getMonthArray();
		vo.aryPltWorkTable = getWorkTableArray();
		vo.aryOldYear = StringUtil.getYearArray(NUM_2010, 3, 0);
		if ((MospUtility.getYear(DateUtil.getSystemDate()) - NUM_2010) != 0) {
			vo.aryNewYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), MospUtility
				.getYear(DateUtil.getSystemDate())
					- NUM_2010, 1);
		} else {
			vo.aryNewYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), 0, 1);
		}
		vo.aryOldMonth = getOldMonthArray();
		vo.aryNewMonth = getNewMonthArray();
	}
	
	/**
	 * VΑӏWve[uIv_E
	 * @return		VΑӃe[u
	 */
	private String[][] getWorkTableArray() {
		String[][] arrayWorkTable = new String[2][2];
		arrayWorkTable[0][0] = "0";
		arrayWorkTable[0][1] = "`2010N3܂";
		arrayWorkTable[1][0] = "1";
		arrayWorkTable[1][1] = "2010N4`";
		return arrayWorkTable;
	}
	
	/**
	 * ΑӏWve[uIv_E
	 * @return		1`3v_E
	 */
	private String[][] getOldMonthArray() {
		String[][] arrayOldMonth = new String[3][2];
		for (int i = 0; i < 3; i++) {
			arrayOldMonth[i][0] = String.valueOf(i + 1);
			arrayOldMonth[i][1] = String.valueOf(i + 1);
		}
		return arrayOldMonth;
	}
	
	/**
	 * VΑӏWve[uIv_E
	 * @return		4`12v_E
	 */
	private String[][] getNewMonthArray() {
		String[][] arrayNewMonth = new String[9][2];
		for (int i = 3; i < 12; i++) {
			arrayNewMonth[i - 3][0] = String.valueOf(i + 1);
			arrayNewMonth[i - 3][1] = String.valueOf(i + 1);
		}
		return arrayNewMonth;
	}
	
	@Override
	protected void show() throws Exception {
		WorkCompileExportCardVo vo = (WorkCompileExportCardVo)getVo();
		// l
		vo.setDefaultValues();
		Date todayDate = DateUtil.getSystemDate();
		vo.setPltSection(userBasis.getSCode());
		// JnN
		vo.setPltStartYear(String.valueOf(MospUtility.getYear(todayDate)));
		vo.setPltStartMonth(String.valueOf(MospUtility.getMonth(todayDate)));
		// IN
		vo.setPltEndYear(String.valueOf(MospUtility.getYear(todayDate)));
		vo.setPltEndMonth(String.valueOf(MospUtility.getMonth(todayDate)));
	}
	
	/**
	 * GNX|[g
	 * @throws Exception 	Oꍇ
	 */
	private void export() throws Exception {
		WorkCompileExportCardVo vo = (WorkCompileExportCardVo)getVo();
		// p[^擾
		vo.setParams(request);
		// ÓmF
		vo.validate();
		// ЈR[hXg
		List<String> kCodeList = new ArrayList<String>();
		// JnN
		String startSikyuNen = vo.getPltStartYear();
		String startSikyuTuki = vo.getPltStartMonth();
		// IN
		String endSikyuNen = vo.getPltEndYear();
		String endSikyuTuki = vo.getPltEndMonth();
		// ЈR[h͂Ăꍇ
		if (StringUtil.isNotNull(vo.getTxtKCode())) {
			kCodeList.add(vo.getTxtKCode());
		} else {
			List<MKihonDto> mkihonList = part().human().getMKihonDao().findForSection(vo.getPltSection(),
					DateUtil.convDateToInteger(DateUtil.getFirstDateOfMonth(startSikyuNen, startSikyuTuki)),
					DateUtil.convDateToInteger(DateUtil.getLastDateOfMonth(endSikyuNen, endSikyuTuki)));
			for (MKihonDto dto : mkihonList) {
				kCodeList.add(dto.getKCode());
			}
		}
		// o̓t@C
		StringBuffer fileName = new StringBuffer();
		fileName.append("Work");
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		if (StringUtil.isNotNull(vo.getTxtKCode())) {
			fileName.append(vo.getTxtKCode());
			fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		} else {
			fileName.append(vo.getPltSection());
			fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		}
		fileName.append(startSikyuNen + "-" + startSikyuTuki);
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		fileName.append(endSikyuNen + "-" + endSikyuTuki);
		fileName.append(CommonConst.FILE_COMMON_CSV);
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName.toString());
		// o̓t@CIuWFNg
		request.setAttribute(MospConst.ATT_FILE_OBJECT, makeWorkExportData(vo, kCodeList, startSikyuNen,
				startSikyuTuki, endSikyuNen, endSikyuTuki));
		// V[PX𔭍sȂB
		setNeedProcSeq(false);
	}
	
	/**
	 * GNX|[gf[^
	 * @param vo			ΑӃGNX|[gVO
	 * @param kCodeList		ΏێЈR[hXg
	 * @param startSikyuNen JnN
	 * @param startSikyuTuki Jn
	 * @param endSikyuNen IN
	 * @param endSikyuTuki I
	 * @return	ΑӃf[^iCSVj
	 * @throws Exception 	Oꍇ
	 */
	private StringBuffer makeWorkExportData(WorkCompileExportCardVo vo, List<String> kCodeList, String startSikyuNen,
			String startSikyuTuki, String endSikyuNen, String endSikyuTuki) throws Exception {
		// [쐬
		StringBuffer sb = new StringBuffer();
		// wb_[ݒ
		sb.append(CsvUtil.toCsvLine(part().compile().getNewWorkCsvHeader()));
		if (vo.getPltWorkTable().equals("0")) {
			// f[^ǋL
			sb.append(appendOldData(kCodeList, startSikyuNen, startSikyuTuki, endSikyuNen, endSikyuTuki));
		} else if (vo.getPltWorkTable().equals("1")) {
			// f[^ǋL
			sb.append(appendNewData(kCodeList, startSikyuNen, startSikyuTuki, endSikyuNen, endSikyuTuki));
		}
		return sb;
	}
	
	/**
	 * Αӏf[^
	 * @param kCodeList		ΏێЈR[hXg
	 * @param startSikyuNen JnN
	 * @param startSikyuTuki Jn
	 * @param endSikyuNen JnN
	 * @param endSikyuTuki Jn
	 * @return	Αӏf[^
	 * @throws Exception 	Oꍇ
	 */
	private StringBuffer appendOldData(List<String> kCodeList, String startSikyuNen, String startSikyuTuki,
			String endSikyuNen, String endSikyuTuki) throws Exception {
		StringBuffer sb = new StringBuffer();
		VariousUtil.sortList(kCodeList, new ComparatorKCode());
		for (String kCode : kCodeList) {
			List<MKintaiDto> kintaiList = getKintaiInfoList(kCode, startSikyuNen, startSikyuTuki, endSikyuNen,
					endSikyuTuki);
			for (MKintaiDto dto : kintaiList) {
				sb.append(CsvUtil.toCsvLine(toCsvOldDataArray(dto)));
			}
		}
		return sb;
	}
	
	/**
	 * VΑӏf[^
	 * @param kCodeList		ΏێЈR[hXg
	 * @param startSikyuNen JnN
	 * @param startSikyuTuki Jn
	 * @param endSikyuNen JnN
	 * @param endSikyuTuki Jn
	 * @return	VΑӏf[^
	 * @throws Exception 	Oꍇ
	 */
	private StringBuffer appendNewData(List<String> kCodeList, String startSikyuNen, String startSikyuTuki,
			String endSikyuNen, String endSikyuTuki) throws Exception {
		StringBuffer sb = new StringBuffer();
		VariousUtil.sortList(kCodeList, new ComparatorKCode());
		for (String kCode : kCodeList) {
			List<KdWorkDto> workList = getWorkInfoList(kCode, startSikyuNen, startSikyuTuki, endSikyuNen, endSikyuTuki);
			for (KdWorkDto dto : workList) {
				sb.append(CsvUtil.toCsvLine(toCsvNewDataArray(dto)));
			}
		}
		return sb;
	}
	
	/**
	 * Αӏ񃊃Xg擾
	 * @param kCode			ΏێЈR[h
	 * @param startSikyuNen JnN
	 * @param startSikyuTuki Jn
	 * @param endSikyuNen JnN
	 * @param endSikyuTuki Jn
	 * @return	(DTOList)
	 * @throws Exception	Oꍇ
	 */
	public List<MKintaiDto> getKintaiInfoList(String kCode, String startSikyuNen, String startSikyuTuki,
			String endSikyuNen, String endSikyuTuki) throws Exception {
		MKintaiDao dao = new MKintaiDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		return dao.findForCondition(kCode, Integer.parseInt(startSikyuNen), Integer.parseInt(startSikyuTuki), Integer
			.parseInt(endSikyuNen), Integer.parseInt(endSikyuTuki), Integer.parseInt(endSikyuNen)
				- Integer.parseInt(startSikyuNen));
	}
	
	/**
	 * VΑӏ񃊃Xg擾
	 * @param kCode			ΏێЈR[h
	 * @param startSikyuNen JnN
	 * @param startSikyuTuki Jn
	 * @param endSikyuNen JnN
	 * @param endSikyuTuki Jn
	 * @return	(DTOList)
	 * @throws Exception	Oꍇ
	 */
	public List<KdWorkDto> getWorkInfoList(String kCode, String startSikyuNen, String startSikyuTuki,
			String endSikyuNen, String endSikyuTuki) throws Exception {
		KdWorkDao dao = new KdWorkDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		return dao.findForCondition(kCode, Integer.parseInt(startSikyuNen), Integer.parseInt(startSikyuTuki), Integer
			.parseInt(endSikyuNen), Integer.parseInt(endSikyuTuki), Integer.parseInt(endSikyuNen)
				- Integer.parseInt(startSikyuNen));
	}
	
	/**
	 * CSVt@Cpϊ
	 * @param dto	ΏۋΑӏDTO
	 * @return	CSVt@Cpz
	 */
	public static String[] toCsvOldDataArray(MKintaiDto dto) {
		List<String> dataList = new LinkedList<String>();
		// ЈR[h
		dataList.add(dto.getKCode());
		// xN
		dataList.add(dto.getSikyuYM());
		// xN
		dataList.add(String.valueOf(dto.getSNen()));
		// x
		dataList.add(String.valueOf(dto.getSTuki()));
		// x
		dataList.add(String.valueOf(dto.getSHi()));
		// oΓ
		dataList.add(String.valueOf(dto.getSNissu()));
		// oΉ
		dataList.add(String.valueOf(dto.getSKaisu()));
		// Ζ
		dataList.add(String.valueOf(dto.getKinmuJi()));
		// xe
		dataList.add(String.valueOf(dto.getKyukeiJi()));
		// Lx
		dataList.add(String.valueOf(dto.getYukyu()));
		// ʋx
		dataList.add(String.valueOf(dto.getTokuKyu()));
		// ʌΓ
		dataList.add(String.valueOf(dto.getKekkin()));
		// aΓ
		dataList.add(String.valueOf(dto.getSKekkin()));
		// ֋x
		dataList.add(String.valueOf(dto.getDaiKyu()));
		// U֋x
		dataList.add(String.valueOf(dto.getFurikae()));
		// xɗR6
		dataList.add("0");
		// xɗR7
		dataList.add("0");
		// xɗR8
		dataList.add("0");
		// xɗR9
		dataList.add("0");
		// ̑x
		dataList.add(String.valueOf(dto.getSonota()));
		// xމ
		dataList.add(String.valueOf(dto.getTiSoKai()));
		// xގ
		dataList.add(String.valueOf(dto.getTiJikan()));
		// ʎcƎ
		dataList.add(String.valueOf(dto.getZaJikan()));
		// xoΎ
		dataList.add(String.valueOf(dto.getKsJikan()));
		// [Ζ
		dataList.add(String.valueOf(dto.getSnJikan()));
		// FΎ蓖x
		dataList.add(String.valueOf(dto.getKaikin()));
		// H蓖x
		dataList.add(String.valueOf(dto.getSyokujiKaisu()));
		// 1蓖x
		dataList.add(String.valueOf(dto.getCyokuKaisu1()));
		// 2蓖x
		dataList.add(String.valueOf(dto.getCyokuKaisu2()));
		// 3蓖x
		dataList.add(String.valueOf(dto.getCyokuKaisu3()));
		// ̑x1
		dataList.add(String.valueOf(dto.getHokaKaisu1()));
		// ̑x2
		dataList.add(String.valueOf(dto.getHokaKaisu2()));
		// ̑x3
		dataList.add(String.valueOf(dto.getHokaKaisu3()));
		// ̑x4
		dataList.add(String.valueOf(dto.getHokaKaisu4()));
		// ̑x5
		dataList.add(String.valueOf(dto.getHokaKaisu5()));
		// x\z
		dataList.add(String.valueOf(dto.getSinseiGaku()));
		// 1.00
		dataList.add(String.valueOf(dto.getWarimasi1()));
		// ԊO
		dataList.add("0");
		// xԊO
		dataList.add("0");
		// 60ԒߕԊO
		dataList.add("0");
		// 60ԒߏxԊO
		dataList.add("0");
		// ԒPʔNx擾
		dataList.add("0");
		// ԊOԑ֋xɎ擾
		dataList.add("0.0");
		// CtO
		dataList.add("0");
		// o^
		dataList.add(DateUtil.getDateTime(dto.getInsertDate()));
		// o^
		dataList.add(dto.getInsertUser());
		// XV
		dataList.add(DateUtil.getDateTime(dto.getUpdateDate()));
		// XV
		dataList.add(dto.getInsertUser());
		return StringUtil.listToArray(dataList);
	}
	
	/**
	 * CSVt@Cpϊ
	 * @param dto	ΏۋΑӏDTO
	 * @return	CSVt@Cpz
	 */
	public static String[] toCsvNewDataArray(KdWorkDto dto) {
		List<String> dataList = new LinkedList<String>();
		// ЈR[h
		dataList.add(dto.getKCode());
		// xN
		dataList.add(dto.getSikyuYm());
		// xN
		dataList.add(String.valueOf(dto.getSNen()));
		// x
		dataList.add(String.valueOf(dto.getSTuki()));
		// x
		dataList.add(String.valueOf(dto.getSHi()));
		// oΓ
		dataList.add(String.valueOf(dto.getSNissu()));
		// oΉ
		dataList.add(String.valueOf(dto.getSKaisu()));
		// Ζ
		dataList.add(String.valueOf(dto.getKinmuJi()));
		// xe
		dataList.add(String.valueOf(dto.getKyukeiJi()));
		// Lx
		dataList.add(String.valueOf(dto.getYukyu()));
		// ʋx
		dataList.add(String.valueOf(dto.getTokukyu()));
		// ʌΓ
		dataList.add(String.valueOf(dto.getKekkin()));
		// aΓ
		dataList.add(String.valueOf(dto.getSKekkin()));
		// ֋x
		dataList.add(String.valueOf(dto.getDaikyu()));
		// U֋x
		dataList.add(String.valueOf(dto.getFurikae()));
		// xɗR6
		dataList.add(String.valueOf(dto.getKkRiyuu6()));
		// xɗR7
		dataList.add(String.valueOf(dto.getKkRiyuu7()));
		// xɗR8
		dataList.add(String.valueOf(dto.getKkRiyuu8()));
		// xɗR9
		dataList.add(String.valueOf(dto.getKkRiyuu9()));
		// ̑x
		dataList.add(String.valueOf(dto.getSonota()));
		// xމ
		dataList.add(String.valueOf(dto.getTiSoKai()));
		// xގ
		dataList.add(String.valueOf(dto.getTiSoJikan()));
		// ʎcƎ
		dataList.add(String.valueOf(dto.getZaJikan()));
		// xoΎ
		dataList.add(String.valueOf(dto.getKsJikan()));
		// [Ζ
		dataList.add(String.valueOf(dto.getSnJikan()));
		// FΎ蓖x
		dataList.add(String.valueOf(dto.getKaikin()));
		// H蓖x
		dataList.add(String.valueOf(dto.getSyokujiKaisu()));
		// 1蓖x
		dataList.add(String.valueOf(dto.getCyokuKaisu1()));
		// 2蓖x
		dataList.add(String.valueOf(dto.getCyokuKaisu2()));
		// 3蓖x
		dataList.add(String.valueOf(dto.getCyokuKaisu3()));
		// ̑x1
		dataList.add(String.valueOf(dto.getHokaKaisu1()));
		// ̑x2
		dataList.add(String.valueOf(dto.getHokaKaisu2()));
		// ̑x3
		dataList.add(String.valueOf(dto.getHokaKaisu3()));
		// ̑x4
		dataList.add(String.valueOf(dto.getHokaKaisu4()));
		// ̑x5
		dataList.add(String.valueOf(dto.getHokaKaisu5()));
		// x\z
		dataList.add(String.valueOf(dto.getSinseiGaku()));
		// 1.00
		dataList.add(String.valueOf(dto.getWarimasi1()));
		// ԊO
		dataList.add(String.valueOf(dto.getWeekDayOverTime()));
		// xԊO
		dataList.add(String.valueOf(dto.getWeekHolidayOverTime()));
		// 60ԒߕԊO
		dataList.add(String.valueOf(dto.getMonthlyOverTime()));
		// 60ԒߏxԊO
		dataList.add(String.valueOf(dto.getMonthlyWeekHoliday()));
		// ԒPʔNx擾
		dataList.add(String.valueOf(dto.getHourHoliday()));
		// ԊOԑ֋xɎ擾
		dataList.add(String.valueOf(dto.getSubstituteHoliday()));
		// CtO
		dataList.add(String.valueOf(dto.getAmendFlag()));
		// o^
		dataList.add(DateUtil.getDateTime(dto.getInsertDate()));
		// o^
		dataList.add(dto.getInsertUser());
		// XV
		dataList.add(DateUtil.getDateTime(dto.getUpdateDate()));
		// XV
		dataList.add(dto.getInsertUser());
		return StringUtil.listToArray(dataList);
	}
	

	// \[g
	private class ComparatorKCode implements Serializable, Comparator<Object> {
		
		private static final long	serialVersionUID	= -3477068419987991550L;
		

		public int compare(Object o1, Object o2) {
			return o1.toString().compareTo(o2.toString());
		}
		
	}
	
}
