/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.action;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.payroll.vo.SubHolidayMenuVo;

/**
 * @author matsusita
 *
 */
public class SubHolidayMenuAction extends MosPAction {
	
	/**
	 * RXgN^
	 */
	public SubHolidayMenuAction() {
		super();
	}
	
	public void action() throws Exception {
		// VȌ
		prepareVo(false);
		// 
		init();
		// \
		show();
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new SubHolidayMenuVo();
	}
	
	@Override
	protected void init() throws Exception {
		// ZbVێ̏
		initStoredData();
		// PAYROLLmF
		confirmPayrollAuth();
	}
	
	@Override
	protected void show() throws Exception {
		SubHolidayMenuVo vo = (SubHolidayMenuVo)getVo();
		String[][] arySubHolidayMenu = StringUtil.getBlankArray(0);
		if (part().mospcode().useSubstituteHolidayFunction()) {
			arySubHolidayMenu = new String[][]{ { "P1310", "Јxꗗ" }, { "P1320", "O" }, { "P1330", "ߏ" }, };
		}
		vo.setArySubHolidayMenu(arySubHolidayMenu);
	}
	
}
