/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.part.SubstituteHolidayPart;
import jp.mosp.kintai.payroll.dto.KdSubstituteHolidayDto;
import jp.mosp.kintai.payroll.vo.SubHolidayCardVo;

/**
 * @author saitou
 *
 */
public class SubHolidayCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_CARD_SELECT	= "P1316";
	

	/**
	 * RXgN^
	 */
	public SubHolidayCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (CMD_CARD_SELECT.equals(cmd)) {
			select();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new SubHolidayCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		confirmPayrollAuth();
	}
	
	@Override
	protected void select() throws Exception {
		SubHolidayCardVo vo = (SubHolidayCardVo)getVo();
		KdSubstituteHolidayDto dto = part().subHoliday().getKdSubstituteHolidayDao().findForKey(Long.parseLong(key1));
		chkExist(dto);
		setLabelBasisInfo(dto.getKCode());
		if (SubstituteHolidayPart.isAttitudeFixed(dto)) {
			dto.setAttitudeStatus(CommonConst.NAM_ATTITUDE_STATUS_FIXED);
		} else if (SubstituteHolidayPart.isAttitudeInit(dto)) {
			dto.setAttitudeStatus(CommonConst.NAM_ATTITUDE_STATUS_INIT);
		}
		if (SubstituteHolidayPart.isAcquisitionFinish(dto)) {
			dto.setAcquisitionStatus(CommonConst.NAM_ACQUISITION_STATUS_FINISH);
		} else if (SubstituteHolidayPart.isAcquisitionRemain(dto)) {
			dto.setAcquisitionStatus(CommonConst.NAM_ACQUISITION_STATUS_REMAIN);
		}
		if (SubstituteHolidayPart.isDecisionPayment(dto)) {
			dto.setDecisionStatus(CommonConst.NAM_DECISION_STATUS_PAYMENT);
		} else if (SubstituteHolidayPart.isDecisionFixed(dto)) {
			dto.setDecisionStatus(CommonConst.NAM_DECISION_STATUS_FIXED);
		} else {
			dto.setDecisionStatus(CommonConst.NAM_DECISION_STATUS_INIT);
		}
		vo.setFields(dto);
	}
	
}
