/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.MosPCodePart;
import jp.mosp.common.utils.CsvUtil;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.kintai.payroll.dto.KdPaidHolidayDto;
import jp.mosp.kintai.payroll.dto.MYukyuDto;
import jp.mosp.kintai.payroll.vo.PaidHolidayExportCardVo;

/**
 * @author nakamura
 *
 */
public class PaidHolidayExportCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_SHOW	= "P1130";
	private static final String	CMD_EXPORT	= "P1131";
	

	/**
	 * RXgN^[
	 */
	public PaidHolidayExportCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VȌ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (CMD_SHOW.equals(cmd)) {
			// \
			show();
		} else if (CMD_EXPORT.equals(cmd)) {
			// GNX|[g
			export();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new PaidHolidayExportCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// [U̎擾
		getInfo(user.getUserId());
		// v_E̐ݒ
		PaidHolidayExportCardVo vo = (PaidHolidayExportCardVo)getVo();
		Date todayDate = DateUtil.getSystemDate();
		int todayYear = MospUtility.getYear(todayDate);
		final int year2010 = 2010;
		vo.aryPltSection = getSectionArrayAll();
		vo.aryPltYear = StringUtil.getYearArray(todayYear, 9, 1);
		vo.aryPltMonth = StringUtil.getMonthArray();
		vo.aryPltPaidHolidayTable = getPaidHolidayTableArray();
		vo.aryOldYear = StringUtil.getYearArray(year2010, 3, 0);
		if (todayYear - year2010 != 0) {
			vo.aryNewYear = StringUtil.getYearArray(todayYear, todayYear - year2010, 1);
		} else {
			vo.aryNewYear = StringUtil.getYearArray(todayYear, 0, 1);
		}
		vo.aryOldMonth = getOldMonthArray();
		vo.aryNewMonth = getNewMonthArray();
	}
	
	@Override
	protected void show() throws Exception {
		PaidHolidayExportCardVo vo = (PaidHolidayExportCardVo)getVo();
		// l
		Date todayDate = DateUtil.getSystemDate();
		vo.setPltSection(userBasis.getSCode());
		// JnN
		vo.setPltStartYear(String.valueOf(MospUtility.getYear(todayDate)));
		vo.setPltStartMonth(String.valueOf(MospUtility.getMonth(todayDate)));
		// IN
		vo.setPltEndYear(String.valueOf(MospUtility.getYear(todayDate)));
		vo.setPltEndMonth(String.valueOf(MospUtility.getMonth(todayDate)));
		vo.setPltPaidHolidayTable(CommonConst.NAM_COMMON_FLAG_OFF);
		if (MosPCodePart.afterLegalReformDate(todayDate)) {
			vo.setPltPaidHolidayTable(CommonConst.NAM_COMMON_FLAG_ON);
		}
	}
	
	/**
	 * GNX|[g
	 * @throws Exception 	Oꍇ
	 */
	private void export() throws Exception {
		PaidHolidayExportCardVo vo = (PaidHolidayExportCardVo)getVo();
		// p[^擾
		vo.setParams(request);
		// ÓmF
		vo.validate();
		// ЈR[hXg
		List<String> kCodeList = new ArrayList<String>();
		// JnN
		Date startDate = DateUtil.getFirstDateOfMonth(vo.getPltStartYear(), vo.getPltStartMonth());
		// IN
		Date endDate = DateUtil.getLastDateOfMonth(vo.getPltEndYear(), vo.getPltEndMonth());
		// ЈR[h͂Ăꍇ
		if (StringUtil.isNotNull(vo.getTxtKCode())) {
			kCodeList.add(vo.getTxtKCode());
		} else {
			List<MKihonDto> mkihonList = part().human().getMKihonDao().findForSection(vo.getPltSection(),
					DateUtil.convDateToInteger(startDate), DateUtil.convDateToInteger(endDate));
			for (MKihonDto dto : mkihonList) {
				kCodeList.add(dto.getKCode());
			}
		}
		// o̓t@C
		StringBuffer fileName = new StringBuffer();
		fileName.append("PaidHoliday");
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		if (StringUtil.isNotNull(vo.getTxtKCode())) {
			fileName.append(vo.getTxtKCode());
			fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		} else {
			fileName.append(vo.getPltSection());
			fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		}
		fileName.append(DateUtil.convDateToString(startDate));
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		fileName.append(DateUtil.convDateToString(endDate));
		fileName.append(CommonConst.FILE_COMMON_CSV);
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName.toString());
		// o̓t@CIuWFNg
		request.setAttribute(MospConst.ATT_FILE_OBJECT, makePaidHolidayExportData(kCodeList, startDate, endDate));
		// V[PX𔭍sȂB
		setNeedProcSeq(false);
	}
	
	/**
	 * GNX|[gf[^
	 * @param kCodeList		ΏێЈR[hXg
	 * @param startDate		JnN
	 * @param endDate		IN
	 * @return	LxɃf[^iCSVj
	 * @throws Exception 	Oꍇ
	 */
	private StringBuffer makePaidHolidayExportData(List<String> kCodeList, Date startDate, Date endDate)
			throws Exception {
		PaidHolidayExportCardVo vo = (PaidHolidayExportCardVo)getVo();
		// [쐬
		StringBuffer sb = new StringBuffer();
		if (CommonConst.NAM_COMMON_FLAG_OFF.equals(vo.getPltPaidHolidayTable())) {
			// wb_[ݒ
			sb.append(CsvUtil.toCsvLine(part().paidHoliday().getOldPaidHolidayCsvHeader()));
			// f[^ǋL
			for (String kCode : kCodeList) {
				List<MYukyuDto> yukyuList = part().paidHoliday().getOldYukyuInfoList(kCode, startDate, endDate);
				for (MYukyuDto dto : yukyuList) {
					sb.append(CsvUtil.toCsvLine(toCsvOldDataArray(dto)));
				}
			}
		} else if (CommonConst.NAM_COMMON_FLAG_ON.equals(vo.getPltPaidHolidayTable())) {
			// wb_[ݒ
			sb.append(CsvUtil.toCsvLine(part().paidHoliday().getNewPaidHolidayCsvHeader()));
			// f[^ǋL
			for (String kCode : kCodeList) {
				List<KdPaidHolidayDto> paidHolidayList = part().paidHoliday().getPaidHolidayInfoList(kCode, startDate,
						endDate);
				for (KdPaidHolidayDto dto : paidHolidayList) {
					sb.append(CsvUtil.toCsvLine(toCsvNewDataArray(dto)));
				}
			}
		}
		return sb;
	}
	
	/**
	 * VLxɃe[uIv_E
	 * @return		VLxɃe[u
	 */
	private String[][] getPaidHolidayTableArray() {
		return StringUtil.getFlagArray("`2010N3܂", "2010N4`");
	}
	
	/**
	 * LxɃe[uIv_E
	 * @return		1`3v_E
	 */
	private String[][] getOldMonthArray() {
		String[][] arrayOldMonth = new String[3][2];
		for (int i = 0; i < 3; i++) {
			arrayOldMonth[i][0] = String.valueOf(i + 1);
			arrayOldMonth[i][1] = String.valueOf(i + 1);
		}
		return arrayOldMonth;
	}
	
	/**
	 * VLxɃe[uIv_E
	 * @return		4`12v_E
	 */
	private String[][] getNewMonthArray() {
		String[][] arrayNewMonth = new String[9][2];
		for (int i = 3; i < 12; i++) {
			arrayNewMonth[i - 3][0] = String.valueOf(i + 1);
			arrayNewMonth[i - 3][1] = String.valueOf(i + 1);
		}
		return arrayNewMonth;
	}
	
	/**
	 * CSVt@Cpϊ
	 * @param dto	ΏۗLxɏDTO
	 * @return	CSVt@Cpz
	 */
	public static String[] toCsvOldDataArray(MYukyuDto dto) {
		List<String> dataList = new LinkedList<String>();
		// ЈR[h
		dataList.add(dto.getKCode());
		// ^vZN
		dataList.add(String.valueOf(dto.getKyuyoYMD()));
		// OciNj
		dataList.add(String.valueOf(dto.getZZanT()));
		// OciONj
		dataList.add(String.valueOf(dto.getZZanZ()));
		// gp
		dataList.add(String.valueOf(dto.getSyoka()));
		// 擾
		dataList.add(String.valueOf(dto.getSyutoku()));
		// p
		dataList.add(String.valueOf(dto.getHaiki()));
		// ciNj
		dataList.add(String.valueOf(dto.getTZanT()));
		// ciONj
		dataList.add(String.valueOf(dto.getTZanZ()));
		// o^
		//dataList.add(DateUtil.getDateTime(dto.get));
		// o^
		//dataList.add(dto.getInsertUser());
		// XV
		//dataList.add(DateUtil.getDateTime(dto.getUpdateDate()));
		// XV
		//dataList.add(dto.getInsertUser());
		return StringUtil.listToArray(dataList);
	}
	
	/**
	 * CSVt@Cpϊ
	 * @param dto	ΏۗLxɏDTO
	 * @return	CSVt@Cpz
	 */
	public static String[] toCsvNewDataArray(KdPaidHolidayDto dto) {
		List<String> dataList = new LinkedList<String>();
		// LxID
		dataList.add(String.valueOf(dto.getPaidId()));
		// ЈR[h
		dataList.add(dto.getKCode());
		// R[h
		dataList.add(dto.getProcessType());
		// 
		dataList.add(DateUtil.convDateFormattedByHyphen(dto.getProcessDate()));
		// ONxc
		dataList.add(String.valueOf(dto.getLastRemainDays()));
		// ONxc
		dataList.add(String.valueOf(dto.getLastRemainHour()));
		// Nxc
		dataList.add(String.valueOf(dto.getRemainDays()));
		// Nxc
		dataList.add(String.valueOf(dto.getRemainHour()));
		// ԒPʎ擾\
		dataList.add(String.valueOf(dto.getPossible()));
		// 폜tO
		dataList.add(String.valueOf(dto.getDeleteFlag()));
		// o^
		dataList.add(DateUtil.getDateTime(dto.getInsertDate()));
		// o^
		dataList.add(dto.getInsertUser());
		// XV
		dataList.add(DateUtil.getDateTime(dto.getUpdateDate()));
		// XV
		dataList.add(dto.getInsertUser());
		return StringUtil.listToArray(dataList);
	}
	
}
