/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.MosPCodePart;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.AttendanceTotalAction;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.common.part.KintaiCompilePart;
import jp.mosp.kintai.common.part.PaidHolidayPart;
import jp.mosp.kintai.payroll.dto.KdWorkDto;
import jp.mosp.kintai.payroll.dto.KintaiCompileDto;
import jp.mosp.kintai.payroll.dto.MKintaiDto;
import jp.mosp.kintai.payroll.vo.CompileAmendmentCardVo;

/**
 * @author yoshida
 *
 */
public class CompileAmendmentCardAction extends AttendanceTotalAction {
	
	// R}h
	private static final String	CMD_AMENDMENT_CARD_SELECT	= "P1046";	// \(I)
	private static final String	CMD_AMENDMENT_CARD_REGIST	= "P1047";	// o^
																		
	
	/**
	 * RXgN^
	 */
	public CompileAmendmentCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_AMENDMENT_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_AMENDMENT_CARD_REGIST)) {
			// o^
			regist();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new CompileAmendmentCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// v_EXg̐ݒ
		CompileAmendmentCardVo vo = (CompileAmendmentCardVo)getVo();
		// 蓖
		vo.aryAllowance = getMosPCodeArray(CommonConst.TID_ALLOWANCE_NAME);
		// FΎ蓖L
		vo.aryPerfectAttendanceFlag = StringUtil.getExistenceArray();
		// xɗR
		vo.NAM_PAID_HOLIDAY = part().mospcode().getHolidayName(CommonConst.CODE_HOLIDAY_REASON_PAID);
		vo.NAM_PARTICULAR_HOLIDAY = part().mospcode().getHolidayName(CommonConst.CODE_HOLIDAY_REASON_PARTICULAR);
		vo.NAM_ABSENCE = part().mospcode().getHolidayName(CommonConst.CODE_HOLIDAY_REASON_ABSENCE);
		vo.NAM_MEDICAL = part().mospcode().getHolidayName(CommonConst.CODE_HOLIDAY_REASON_MEDICAL);
		vo.NAM_COMPENSATION_DAY = part().mospcode().getHolidayName(CommonConst.CODE_HOLIDAY_REASON_COMPENSATION);
		vo.NAM_TRANSFER = part().mospcode().getHolidayName(CommonConst.CODE_HOLIDAY_REASON_TRANSFER);
		vo.NAM_HOLIDAY_REASON_6 = part().mospcode().getHolidayName(CommonConst.CODE_HOLIDAY_REASON_6);
		vo.NAM_HOLIDAY_REASON_7 = part().mospcode().getHolidayName(CommonConst.CODE_HOLIDAY_REASON_7);
		vo.NAM_HOLIDAY_REASON_8 = part().mospcode().getHolidayName(CommonConst.CODE_HOLIDAY_REASON_8);
		vo.NAM_HOLIDAY_REASON_9 = part().mospcode().getHolidayName(CommonConst.CODE_HOLIDAY_REASON_9);
		vo.aryHolidayReason = getReasonCodeArray(CommonConst.TID_LEAVE_REASON);
		String[][] aryHolidayReasonTerm = getReasonCodeArray(CommonConst.TID_LEAVE_REASON);
		for (String[] term : aryHolidayReasonTerm) {
			// idAname
			term[0] = CompileAmendmentCardVo.PRM_TXT_HOLIDAY_REASON + term[0];
		}
		vo.setAryHolidayReasonTerm(aryHolidayReasonTerm);
		vo.setUseHourHoliday(part().mospcode().useHourPaidHolidayFunction());
		vo.setUseOver60Hour(part().mospcode().useOverTime60HourFunction());
		vo.setUseSubstitute(part().mospcode().useSubstituteHolidayFunction());
		vo.setHourPaidHoliday(part().mospcode().getHourPaidHolidayUnit());
	}
	
	@Override
	protected void select() throws Exception {
		CompileAmendmentCardVo vo = (CompileAmendmentCardVo)getVo();
		vo.setDefaultValues();
		// ЈR[h擾
		String kCode = key1;
		// IN
		String[] target = StringUtil.divideByHyphen(key2);
		vo.setHidYearMonth(key2);
		Date yearMonth = DateUtil.getYearMonth(target[0], target[1]);
		// ΑӏWvݒ
		setAmendmentInfo(kCode, yearMonth);
		// DTÕZbg
		KintaiCompileDto dto = compile().getCompileInfo(kCode, yearMonth);
		// VOɏZbg
		setFields(dto);
		setAryTxtHolidayReason();
		setFunction(yearMonth, dto);
		// [h̐ݒ
		if (!chkExistDto(part().calculate().findForCalc())) {
			vo.setMode(CompileAmendmentCardVo.MODE_IMPOSSIBLE);
		} else if (DateUtil.getDate(MospUtility.getYear(yearMonth), MospUtility.getMonth(yearMonth),
				MospUtility.getDay(getCalcMonth())).compareTo(getCalcMonth()) < 0) {
			vo.setMode(CompileAmendmentCardVo.MODE_IMPOSSIBLE);
		} else {
			vo.setMode(CompileAmendmentCardVo.MODE_EDIT);
		}
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	/**
	 * o^
	 * @throws Exception  	Oꍇ
	 */
	private void regist() throws Exception {
		// DTO̎擾
		KintaiCompileDto dto = (KintaiCompileDto)getSessionDto();
		chkExist(dto);
		CompileAmendmentCardVo vo = (CompileAmendmentCardVo)getVo();
		vo.setParams(request);
		setAryTxtHolidayReason();
		Date yearMonth = DateUtil.getYearMonth(vo.getHidYear(), vo.getHidMonth());
		String kCode = vo.getHidKCode();
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		setDtoFields(dto);
		setFunction(yearMonth, dto);
		String sikyuYM = DateUtil.convDateToStringYearMonthShort(yearMonth);
		// J@{sf
		if (MosPCodePart.afterLegalReformDate(getEndDate(yearMonth))) {
			// Ve[u
			KdWorkDto currentDto = compile().getKdWorkDao().findForKey(kCode, sikyuYM);
			if (VariousUtil.isNotNull(currentDto)) {
				// ꍇ
				// KintaiCompileDtȍ݂֒u
				KintaiCompilePart.margeKdWorkAndCompile(kCode, yearMonth, getCalcPayment(yearMonth), currentDto, dto);
				// Cς݃tOON
				currentDto.setAmendFlag(MospConst.DELETE_FLAG_ON);
				// XV
				compile().getKdWorkDao().update(currentDto);
				chkUpdate(compile().getKdWorkDao().findForKey(currentDto.getKCode(), currentDto.getSikyuYm()));
			} else {
				// ꍇ
				// KintaiCompileDtoVe[uɕϊ
				KdWorkDto kdWorkDto = compile().convCompileToKdWork(kCode, yearMonth, dto);
				// o^
				compile().getKdWorkDao().insert(kdWorkDto);
				chkInsert(compile().getKdWorkDao().findForKey(kdWorkDto.getKCode(), kdWorkDto.getSikyuYm()));
			}
		} else {
			// e[u
			MKintaiDto currentDto = compile().getMKintaiDao().findForUpdate(kCode, sikyuYM);
			if (VariousUtil.isNotNull(currentDto)) {
				// ꍇ
				// KintaiCompileDtȍ݂֒u
				KintaiCompilePart.margeKintaiAndCompile(kCode, yearMonth, getCalcPayment(yearMonth), currentDto, dto);
				// XV
				compile().getMKintaiDao().update(currentDto);
				chkUpdate(compile().getMKintaiDao().findForKey(currentDto.getKCode(), currentDto.getSikyuYM()));
			} else {
				// ꍇ
				// KintaiCompileDtoe[uɕϊ
				MKintaiDto kintaiDto = compile().convCompileToKintai(kCode, yearMonth, dto);
				// o^
				compile().getMKintaiDao().insert(kintaiDto);
				chkInsert(compile().getMKintaiDao().findForKey(kintaiDto.getKCode(), kintaiDto.getSikyuYM()));
			}
		}
		// DTO̍Ď擾
		KintaiCompileDto retDto = compile().getCompileInfo(kCode, yearMonth);
		chkUpdate(retDto);
		// R~bg
		commit();
		// VOɏZbg
		setFields(retDto);
		// ΑӏWvݒ
		setAmendmentInfo(kCode, yearMonth);
		// bZ[Wݒ
		setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// [hݒ
		vo.setMode(CompileAmendmentCardVo.MODE_EDIT);
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	/**
	 * ΑӏWvݒ
	 * @param kCode IЈR[h
	 * @param targetMonth Ώ۔N
	 * @throws Exception  	Oꍇ
	 */
	private void setAmendmentInfo(String kCode, Date targetMonth) throws Exception {
		CompileAmendmentCardVo vo = (CompileAmendmentCardVo)getVo();
		// lݒ
		vo.setHidKCode(kCode);
		setLabelBasisInfo(kCode);
		// ΑӏWvݒ
		vo.setHidYear(String.valueOf(MospUtility.getYear(targetMonth)));
		vo.setHidMonth(String.valueOf(MospUtility.getMonth(targetMonth)));
		vo.setLblSelectDate(DateUtil.convDateToJPYearMonthShort(targetMonth));
		// CtO
		vo.setLblAmendment(KintaiCompilePart.getAmendFlagName(part().compile().getAmendFlagCode(kCode, vo.getHidYear(),
				vo.getHidMonth())));
	}
	
	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 * @throws Exception Oꍇ
	 */
	private void setFields(KintaiCompileDto dto) throws Exception {
		CompileAmendmentCardVo vo = (CompileAmendmentCardVo)getVo();
		vo.setTxtPresence(String.valueOf(dto.getTotalWorkDays()));
		vo.setTxtPresenceNumber(String.valueOf(dto.getTotalWorkNumber()));
		vo.setTxtWorkHour(TimeUtil.convIntegerTimeToStringHour(dto.getTotalWork()));
		vo.setTxtWorkMin(TimeUtil.convIntegerTimeToStringMinutes(dto.getTotalWork()));
		vo.setTxtBreakHour(TimeUtil.convIntegerTimeToStringHour(dto.getTotalInterbal()));
		vo.setTxtBreakMin(TimeUtil.convIntegerTimeToStringMinutes(dto.getTotalInterbal()));
		vo.setTxtPaidHoliday(String.valueOf(dto.getTotalPaidHoliday()));
		vo.setTxtParticularHoliday(String.valueOf(dto.getTotalParticularHoliday()));
		vo.setTxtAbsence(String.valueOf(dto.getTotalAbsence()));
		vo.setTxtMedical(String.valueOf(dto.getTotalMedicalLeave()));
		vo.setTxtCompensationDay(String.valueOf(dto.getTotalCompensationDay()));
		vo.setTxtTransfer(String.valueOf(dto.getTotalTransfer()));
		// xɗR6
		vo.setTxtHolidayReason6(String.valueOf(dto.getTotalKkRiyuu6()));
		// xɗR7
		vo.setTxtHolidayReason7(String.valueOf(dto.getTotalKkRiyuu7()));
		// xɗR8
		vo.setTxtHolidayReason8(String.valueOf(dto.getTotalKkRiyuu8()));
		// xɗR9
		vo.setTxtHolidayReason9(String.valueOf(dto.getTotalKkRiyuu9()));
		vo.setTxtOther(String.valueOf(dto.getTotalOther()));
		vo.setTxtLeaveAndLate(String.valueOf(dto.getLeaveAndLate()));
		vo.setTxtLeaveAndLateHour(TimeUtil.convIntegerTimeToStringHour(dto.getTotalLeaveAndLate()));
		vo.setTxtLeaveAndLateMin(TimeUtil.convIntegerTimeToStringMinutes(dto.getTotalLeaveAndLate()));
		vo.setTxtOverHour(TimeUtil.convIntegerTimeToStringHour(dto.getTotalOver()));
		vo.setTxtOverMin(TimeUtil.convIntegerTimeToStringMinutes(dto.getTotalOver()));
		vo.setTxtWorkOnHolidayHour(TimeUtil.convIntegerTimeToStringHour(dto.getTotalHolidayWork()));
		vo.setTxtWorkOnHolidayMin(TimeUtil.convIntegerTimeToStringMinutes(dto.getTotalHolidayWork()));
		vo.setTxtLateNightHour(TimeUtil.convIntegerTimeToStringHour(dto.getTotalLateNight()));
		vo.setTxtLateNightMin(TimeUtil.convIntegerTimeToStringMinutes(dto.getTotalLateNight()));
		vo.setPltPerfectAttendance(StringUtil.convTrueIsOn(dto.isApplyAttendanceAllowance()));
		vo.setTxtSyokuji(String.valueOf(dto.getSyokuji()));
		vo.setTxtCyoku1(String.valueOf(dto.getCyoku1()));
		vo.setTxtCyoku2(String.valueOf(dto.getCyoku2()));
		vo.setTxtCyoku3(String.valueOf(dto.getCyoku3()));
		vo.setTxtHoka1(String.valueOf(dto.getHoka1()));
		vo.setTxtHoka2(String.valueOf(dto.getHoka2()));
		vo.setTxtHoka3(String.valueOf(dto.getHoka3()));
		vo.setTxtHoka4(String.valueOf(dto.getHoka4()));
		vo.setTxtHoka5(String.valueOf(dto.getHoka5()));
		vo.setTxtHourHoliday(String.valueOf(dto.getUnitHourHoliday() * part().mospcode().getHourPaidHolidayUnit()));
		vo.setTxtWarimashi1Hour(TimeUtil.convIntegerTimeToStringHour(dto.getWarimasi1()));
		vo.setTxtWarimashi1Min(TimeUtil.convIntegerTimeToStringMinutes(dto.getWarimasi1()));
		// ԊO
		vo.setTxtWeekdayOverHour(TimeUtil.convIntegerTimeToStringHour(dto.getTotalWeekDayOverTime()));
		vo.setTxtWeekdayOverMin(TimeUtil.convIntegerTimeToStringMinutes(dto.getTotalWeekDayOverTime()));
		// xԊO
		vo.setTxtWeekHolidayOverHour(TimeUtil.convIntegerTimeToStringHour(dto.getTotalWeekHolidayOverTime()));
		vo.setTxtWeekHolidayOverMin(TimeUtil.convIntegerTimeToStringMinutes(dto.getTotalWeekHolidayOverTime()));
		// 60ԒߕԊO
		vo.setTxtMonthlyOverHour(TimeUtil.convIntegerTimeToStringHour(dto.getTotalMonthlyOverTime()));
		vo.setTxtMonthlyOverMin(TimeUtil.convIntegerTimeToStringMinutes(dto.getTotalMonthlyOverTime()));
		// 60ԒߏxԊO
		vo.setTxtMonthlyWeekHolidayHour(TimeUtil.convIntegerTimeToStringHour(dto.getTotalMonthlyWeekHoliday()));
		vo.setTxtMonthlyWeekHolidayMin(TimeUtil.convIntegerTimeToStringMinutes(dto.getTotalMonthlyWeekHoliday()));
		// ԊOԑ֋xɎ擾
		vo.setTxtSubstituteHoliday(String.valueOf(dto.getTotalSubstituteHoliday()));
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 * @throws Exception Oꍇ
	 */
	private void setDtoFields(KintaiCompileDto dto) throws Exception {
		CompileAmendmentCardVo vo = (CompileAmendmentCardVo)getVo();
		dto.setTotalWork(TimeUtil.convStringTimeToIntegerTime(vo.getTxtWorkHour(), vo.getTxtWorkMin()));
		dto.setTotalInterbal(TimeUtil.convStringTimeToIntegerTime(vo.getTxtBreakHour(), vo.getTxtBreakMin()));
		dto.setLeaveAndLate(NumberUtil.getIntParam(vo.getTxtLeaveAndLate()));
		dto.setTotalLeaveAndLate(TimeUtil.convStringTimeToIntegerTime(vo.getTxtLeaveAndLateHour(), vo
			.getTxtLeaveAndLateMin()));
		dto.setTotalOver(TimeUtil.convStringTimeToIntegerTime(vo.getTxtOverHour(), vo.getTxtOverMin()));
		dto.setTotalHolidayWork(TimeUtil.convStringTimeToIntegerTime(vo.getTxtWorkOnHolidayHour(), vo
			.getTxtWorkOnHolidayMin()));
		dto.setTotalLateNight(TimeUtil.convStringTimeToIntegerTime(vo.getTxtLateNightHour(), vo.getTxtLateNightMin()));
		dto.setTotalWorkDays(NumberUtil.getDoubleParam(vo.getTxtPresence()));
		dto.setTotalWorkNumber(NumberUtil.getIntParam(vo.getTxtPresenceNumber()));
		dto.setTotalPaidHoliday(NumberUtil.getDoubleParam(vo.getTxtPaidHoliday()));
		dto.setTotalParticularHoliday(NumberUtil.getDoubleParam(vo.getTxtParticularHoliday()));
		dto.setTotalAbsence(NumberUtil.getDoubleParam(vo.getTxtAbsence()));
		dto.setTotalMedicalLeave(NumberUtil.getDoubleParam(vo.getTxtMedical()));
		dto.setTotalCompensationDay(NumberUtil.getDoubleParam(vo.getTxtCompensationDay()));
		dto.setTotalTransfer(NumberUtil.getDoubleParam(vo.getTxtTransfer()));
		dto.setTotalKkRiyuu6(NumberUtil.getDoubleParam(vo.getTxtHolidayReason6()));
		dto.setTotalKkRiyuu7(NumberUtil.getDoubleParam(vo.getTxtHolidayReason7()));
		dto.setTotalKkRiyuu8(NumberUtil.getDoubleParam(vo.getTxtHolidayReason8()));
		dto.setTotalKkRiyuu9(NumberUtil.getDoubleParam(vo.getTxtHolidayReason9()));
		dto.setTotalOther(NumberUtil.getDoubleParam(vo.getTxtOther()));
		dto.setSyokuji(NumberUtil.getIntParam(vo.getTxtSyokuji()));
		dto.setCyoku1(NumberUtil.getIntParam(vo.getTxtCyoku1()));
		dto.setCyoku2(NumberUtil.getIntParam(vo.getTxtCyoku2()));
		dto.setCyoku3(NumberUtil.getIntParam(vo.getTxtCyoku3()));
		dto.setHoka1(NumberUtil.getIntParam(vo.getTxtHoka1()));
		dto.setHoka2(NumberUtil.getIntParam(vo.getTxtHoka2()));
		dto.setHoka3(NumberUtil.getIntParam(vo.getTxtHoka3()));
		dto.setHoka4(NumberUtil.getIntParam(vo.getTxtHoka4()));
		dto.setHoka5(NumberUtil.getIntParam(vo.getTxtHoka5()));
		if (part().mospcode().useHourPaidHolidayFunction()) {
			dto.setUnitHourHoliday(NumberUtil.getIntParam(vo.getTxtHourHoliday())
					/ part().mospcode().getHourPaidHolidayUnit());
		}
		dto.setApplyAttendanceAllowance(StringUtil.isFlagOn(vo.getPltPerfectAttendance()));
		dto.setWarimasi1(TimeUtil.convStringTimeToIntegerTime(vo.getTxtWarimashi1Hour(), vo.getTxtWarimashi1Min()));
		dto.setTotalWeekDayOverTime(TimeUtil.convStringTimeToIntegerTime(vo.getTxtWeekdayOverHour(), vo
			.getTxtWeekdayOverMin()));
		dto.setTotalWeekHolidayOverTime(TimeUtil.convStringTimeToIntegerTime(vo.getTxtWeekHolidayOverHour(), vo
			.getTxtWeekHolidayOverMin()));
		dto.setTotalMonthlyOverTime(TimeUtil.convStringTimeToIntegerTime(vo.getTxtMonthlyOverHour(), vo
			.getTxtMonthlyOverMin()));
		dto.setTotalMonthlyWeekHoliday(TimeUtil.convStringTimeToIntegerTime(vo.getTxtMonthlyWeekHolidayHour(), vo
			.getTxtMonthlyWeekHolidayMin()));
		dto.setTotalSubstituteHoliday(NumberUtil.getDoubleParam(vo.getTxtSubstituteHoliday()));
	}
	
	private void setAryTxtHolidayReason() throws Exception {
		CompileAmendmentCardVo vo = (CompileAmendmentCardVo)getVo();
		List<String> valueList = new ArrayList<String>();
		for (String[] reason : vo.aryHolidayReason) {
			String value = "";
			if (PaidHolidayPart.isPaidHoliday(reason[0])) {
				value = vo.getTxtPaidHoliday();
			}
			if (KintaiCommonPart.isParticularHoliday(reason[0])) {
				value = vo.getTxtParticularHoliday();
			}
			if (KintaiCommonPart.isAbsence(reason[0])) {
				value = vo.getTxtAbsence();
			}
			if (KintaiCommonPart.isMedical(reason[0])) {
				value = vo.getTxtMedical();
			}
			if (KintaiCommonPart.isCompensation(reason[0])) {
				value = vo.getTxtCompensationDay();
			}
			if (KintaiCommonPart.isTransfer(reason[0])) {
				value = vo.getTxtTransfer();
			}
			if (KintaiCommonPart.isHolidayReason6(reason[0])) {
				value = vo.getTxtHolidayReason6();
			}
			if (KintaiCommonPart.isHolidayReason7(reason[0])) {
				value = vo.getTxtHolidayReason7();
			}
			if (KintaiCommonPart.isHolidayReason8(reason[0])) {
				value = vo.getTxtHolidayReason8();
			}
			if (KintaiCommonPart.isHolidayReason9(reason[0])) {
				value = vo.getTxtHolidayReason9();
			}
			// value
			valueList.add(value);
		}
		vo.setAryTxtHolidayReason(StringUtil.listToArray(valueList));
	}
	
	private void setFunction(Date yearMonth, KintaiCompileDto dto) throws Exception {
		CompileAmendmentCardVo vo = (CompileAmendmentCardVo)getVo();
		if (MosPCodePart.afterLegalReformDate(getEndDate(yearMonth))) {
			vo.setAfterReform(true);
		} else {
			vo.setUseHourHoliday(false);
			vo.setUseOver60Hour(false);
			vo.setUseSubstitute(false);
		}
		if (vo.isUseOver60Hour()) {
			// Jgݒ
			setLaborAgreementInfo(vo.getHidKCode(), getStartDate(yearMonth));
			vo.setCaution(checkCautionOverTime(dto.getTotalOver(), 0));
			vo.setWarning(checkWarningOverTime(dto.getTotalOver(), 0));
		}
	}
	
}
