/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.MosPCodePart;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.AttendanceTotalAction;
import jp.mosp.kintai.common.part.CalculatePart;
import jp.mosp.kintai.payroll.dto.KdWorkDto;
import jp.mosp.kintai.payroll.dto.MKintaiDto;
import jp.mosp.kintai.payroll.dto.MKintaiKeisanDto;
import jp.mosp.kintai.payroll.dto.MKintaiKinmuDto;
import jp.mosp.kintai.payroll.vo.AttendanceCompileCardVo;

/**
 * @author yoshida
 *
 */
public class AttendanceCompileCardAction extends AttendanceTotalAction {
	
	// R}h
	private static final String			CMD_COMPILE_CARD_SHOW	= "P1030";
	private static final String			CMD_COMPILE_CARD_REGIST	= "P1031";
	
	/**
	 * WvI
	 */
	private Date						periodEnd;
	/**
	 * Ώ۔N
	 */
	private Date						targetMonth;
	
	/**
	 * ΑӏWvpXg쐬
	 */
	private final List<MKintaiDto>		listMKintai				= new ArrayList<MKintaiDto>();
	
	/**
	 *  Ζ`ԕʏWvpXg쐬
	 */
	private final List<MKintaiKinmuDto>	listMKinmu				= new ArrayList<MKintaiKinmuDto>();
	
	/**
	 *  VΖ`ԕʏWvpXg쐬
	 */
	private final List<KdWorkDto>		listKdWork				= new ArrayList<KdWorkDto>();
	

	/**
	 * RXgN^
	 */
	public AttendanceCompileCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_COMPILE_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_COMPILE_CARD_REGIST)) {
			// vZ
			runAttendanceCompile();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceCompileCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		AttendanceCompileCardVo vo = (AttendanceCompileCardVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// v_ẼZbg
		vo.aryPltSection = getSectionScopeArrayForPayroll();
	}
	
	@Override
	protected void show() throws Exception {
		AttendanceCompileCardVo vo = (AttendanceCompileCardVo)getVo();
		// ΑӌvZΏ۔N擾
		Date calcMonth = getCalcMonth();
		// ΑӌvZΏ۔NZbg
		vo.setHidCompileYear(String.valueOf(MospUtility.getYear(calcMonth)));
		vo.setHidCompileMonth(String.valueOf(MospUtility.getMonth(calcMonth)));
		// IR[hZbg
		vo.setPltSection(userBasis.getSCode());
		// IԂ̃Zbg
		vo.setLblStartCompileDate(DateUtil.convDateFormatted(getStartDate(calcMonth)));
		vo.setLblEndCompileDate(DateUtil.convDateFormatted(getEndDate(calcMonth)));
		// [hݒ
		setMode();
	}
	
	/**
	 * ΑӌvZ
	 * @throws Exception 	Oꍇ
	 */
	private void runAttendanceCompile() throws Exception {
		AttendanceCompileCardVo vo = (AttendanceCompileCardVo)getVo();
		// ͍ڎ擾
		vo.setParams(request);
		// Wv{ݒ
		targetMonth = getCalcMonth();
		periodEnd = getEndDate(getCalcMonth());
		// Αӏݒ
		setCalcParam();
		if (StringUtil.isNull(vo.getPltSection())) {
			// SБI
			compileAll();
		} else if (StringUtil.isNotNull(vo.getTxtKCode())) {
			// ЈR[h͎
			compileKCode(vo.getTxtKCode());
		} else {
			// ЈR[h
			// Î݌vZ
			compileSection(vo.getPltSection());
		}
		// R~bg
		commit();
		// ꗗ\
		setNextCmd(CompileAmendmentListAction.CMD_AMENDMENT_LIST_RE_SEARCH);
		// ꗗւ̏Zbg
		setNextCmdInfo();
	}
	
	/**
	 * SЈ
	 * @throws Exception 	Oꍇ
	 */
	private void compileAll() throws Exception {
		// Sꗗ擾
		String[] arySection = part().section().getSectionCodeArrayAll();
		for (String section : arySection) {
			// ݐЎЈꗗ
			String[] arySectionUsers = part().human().getBasisArray(section, targetMonth);
			for (String kCode : arySectionUsers) {
				// ΑӃf[^擾
				getAttendanceList(kCode, targetMonth);
				// ΑӏWvp
				listMKinmu.addAll(getWorkTypeList(kCode, targetMonth, attendanceList));
				// J@{sf
				if (MosPCodePart.afterLegalReformDate(periodEnd)) {
					// VΑӏWvɐݒ
					listKdWork.add(compile().getNewCompiledInfo(kCode, targetMonth, attendanceList));
				} else {
					// ΑӏWvɐݒ
					listMKintai.add(compile().getCompiledInfo(kCode, targetMonth, attendanceList));
				}
			}
		}
		// ΑӏWv폜
		String yearMonth = DateUtil.convDateToStringYearMonthShort(targetMonth);
		// J@{sf
		if (MosPCodePart.afterLegalReformDate(periodEnd)) {
			// e[ubN̏
			prepareTableLock();
			// Ώۃe[u̒ǉ
			addTargetTable(compile().getKdWorkDao(), true);
			// e[ubN
			lockTables();
			// 폜
			compile().getKdWorkDao().delete(yearMonth);
			// o^
			registKdWork(listKdWork);
			// e[ubN
			unLockTables();
		} else {
			// e[ubN
			compile().getMKintaiDao().tableLock(yearMonth);
			// f[^̍폜
			compile().getMKintaiDao().delete(yearMonth);
			// ΑӏWvo^
			registMKintai(listMKintai);
		}
		// Ζ`ԕʏWv폜
		// e[ubN
		compile().getMKintaiKinmuDao().tableLock(yearMonth);
		// 폜
		compile().getMKintaiKinmuDao().delete(yearMonth);
		// Ζ`ԕʏWvo^
		registMKinmu(listMKinmu);
	}
	
	/**
	 * IЈ
	 * @param pltSection ΏۏR[h
	 * @throws Exception 	Oꍇ
	 */
	private void compileSection(String pltSection) throws Exception {
		// IЈR[hꗗ̎擾
		String[] aryUsers = part().human().getBasisArray(pltSection, targetMonth);
		int listSize = 0;
		for (String kCode : aryUsers) {
			// ΑӃf[^擾
			getAttendanceList(kCode, targetMonth);
			// VΑӏWvɐݒ
			listMKinmu.addAll(getWorkTypeList(kCode, targetMonth, attendanceList));
			// J@{sf
			if (MosPCodePart.afterLegalReformDate(periodEnd)) {
				// VΑӏWvɐݒ
				listKdWork.add(compile().getNewCompiledInfo(kCode, targetMonth, attendanceList));
			} else {
				// ΑӏWvɐݒ
				listMKintai.add(compile().getCompiledInfo(kCode, targetMonth, attendanceList));
			}
		}
		// ΑӏWv폜Eo^
		String yearMonth = DateUtil.convDateToStringYearMonthShort(targetMonth);
		// J@{sf
		if (MosPCodePart.afterLegalReformDate(periodEnd)) {
			// e[ubN̏
			prepareTableLock();
			// Ώۃe[u̒ǉ
			addTargetTable(compile().getKdWorkDao(), true);
			// e[ubNibNJnj
			lockTables();
			// VΑӏWṽTCYݒ
			listSize = listKdWork.size();
		} else {
			// e[ubN
			compile().getMKintaiDao().tableLock(listMKintai, yearMonth);
			// ΑӏWṽTCYݒ
			listSize = listMKintai.size();
		}
		// o^
		int insertCount = 0;
		// 񂷉
		int rev = listSize / CommonConst.NUM_DIVIDE_NUMBER + 1;
		if (listSize % CommonConst.NUM_DIVIDE_NUMBER == 0) {
			rev--;
		}
		for (int i = 0; i < rev; i++) {
			List<MKintaiDto> kintaiList = new ArrayList<MKintaiDto>();
			List<KdWorkDto> kdWorkList = new ArrayList<KdWorkDto>();
			// XgdivƕB
			for (int k = 0; k < CommonConst.NUM_DIVIDE_NUMBER; k++) {
				int count = k + i * CommonConst.NUM_DIVIDE_NUMBER;
				if (count >= listSize) {
					break;
				}
				// J@{sf
				if (MosPCodePart.afterLegalReformDate(periodEnd)) {
					KdWorkDto kdWorkDto = listKdWork.get(count);
					if (chkExistDto(kdWorkDto)) {
						kdWorkList.add(kdWorkDto);
					} else {
						break;
					}
				} else {
					MKintaiDto mKintaiDto = listMKintai.get(count);
					if (chkExistDto(mKintaiDto)) {
						kintaiList.add(mKintaiDto);
					} else {
						break;
					}
				}
			}
			// J@{sf
			if (MosPCodePart.afterLegalReformDate(periodEnd)) {
				// XgzɃZbgB
				KdWorkDto[] aryKdWork = kdWorkList.toArray(new KdWorkDto[kdWorkList.size()]);
				// 폜
				compile().getKdWorkDao().delete(aryKdWork, yearMonth);
				// o^
				insertCount += compile().getKdWorkDao().insert(aryKdWork);
				// e[ubN
				unLockTables();
			} else {
				// XgzɃZbgB
				MKintaiDto[] aryKintai = kintaiList.toArray(new MKintaiDto[kintaiList.size()]);
				// 폜
				compile().getMKintaiDao().delete(aryKintai, yearMonth);
				// o^
				insertCount += compile().getMKintaiDao().insert(aryKintai);
			}
		}
		if (insertCount != listSize) {
			throw new MospException(MospConst.EX_INSERT_FAILED);
		}
		// Ζ`ԕʏWv폜
		// e[ubN
		compile().getMKintaiKinmuDao().tableLock(aryUsers, yearMonth);
		// zdivƕB
		int i = 0;
		while ((aryUsers.length - (i * CommonConst.NUM_DIVIDE_NUMBER)) >= CommonConst.NUM_DIVIDE_NUMBER) {
			String[] aryKcode = new String[CommonConst.NUM_DIVIDE_NUMBER];
			System.arraycopy(aryUsers, i * CommonConst.NUM_DIVIDE_NUMBER, aryKcode, 0, CommonConst.NUM_DIVIDE_NUMBER);
			// f[^̍폜
			compile().getMKintaiKinmuDao().delete(aryKcode, yearMonth);
			i++;
		}
		if (aryUsers.length % CommonConst.NUM_DIVIDE_NUMBER != 0) {
			String[] aryKcode = new String[aryUsers.length % CommonConst.NUM_DIVIDE_NUMBER];
			System.arraycopy(aryUsers, i * CommonConst.NUM_DIVIDE_NUMBER, aryKcode, 0, aryKcode.length);
			// f[^̍폜
			compile().getMKintaiKinmuDao().delete(aryKcode, yearMonth);
		}
		// Ζ`ԕʏWvo^
		registMKinmu(listMKinmu);
	}
	
	/**
	 * Јl
	 * @param kCode ΏێЈR[h
	 * @throws Exception 	Oꍇ
	 */
	private void compileKCode(String kCode) throws Exception {
		// l̂݌vZ
		if (part().human().isExist(kCode)) {
			// ΑӃf[^擾
			getAttendanceList(kCode, targetMonth);
			// Ώ۔N
			String yearMonth = DateUtil.convDateToStringYearMonthShort(targetMonth);
			// J@{sf
			if (MosPCodePart.afterLegalReformDate(periodEnd)) {
				listKdWork.add(compile().getNewCompiledInfo(kCode, targetMonth, attendanceList));
				// e[ubN
				prepareTableLock();
				// KdWorkWRITE
				addTargetTable(compile().getKdWorkDao(), true);
				// e[ubNibNJnj
				lockTables();
				// f[^擾
				KdWorkDto currentDto = compile().getKdWorkDao().findForUpdate(kCode, yearMonth);
				// 폜
				if (chkExistDto(currentDto)) {
					// 폜
					compile().getKdWorkDao().delete(currentDto);
				}
				// o^
				registKdWork(listKdWork);
				// e[ubN
				unLockTables();
			} else {
				listMKintai.add(compile().getCompiledInfo(kCode, targetMonth, attendanceList));
				// e[ubN
				compile().getMKintaiDao().tableLock(kCode, yearMonth);
				// f[^擾
				MKintaiDto currentDto = compile().getMKintaiDao().findForUpdate(kCode, yearMonth);
				if (chkExistDto(currentDto)) {
					// 폜
					compile().getMKintaiDao().delete(currentDto);
				}
				// ΑӏWvo^
				registMKintai(listMKintai);
			}
			listMKinmu.addAll(getWorkTypeList(kCode, targetMonth, attendanceList));
			// Ζ`ԕʏWv폜
			compile().getMKintaiKinmuDao().tableLock(kCode, DateUtil.convDateToStringYearMonthShort(targetMonth));
			compile().getMKintaiKinmuDao().delete(kCode, DateUtil.convDateToStringYearMonthShort(targetMonth));
			// Ζ`ԕʏWvo^
			registMKinmu(listMKinmu);
		}
	}
	
	/**
	 * Ζ`ԕʓo^
	 * @param kCode			ΏێЈR[h
	 * @param targetMonth	Ώ۔N
	 * @param attendanceList	ΏۏoΕ냊Xg
	 * @return	Ζ`ԕʋΑӏWvXg
	 * @throws Exception	Oꍇ
	 */
	private List<MKintaiKinmuDto> getWorkTypeList(String kCode, Date targetMonth, List<?> attendanceList)
			throws Exception {
		List<MKintaiKinmuDto> kinmuList = new ArrayList<MKintaiKinmuDto>();
		// Ζ`ԕʏWvo^
		String[] aryWorkType = part().worktype().getWorkTypeCodeArrayAll();
		for (String workTypeCode : aryWorkType) {
			// o^f[^̃Zbg
			kinmuList.add(part().compile().getCompileForWorkType(kCode, targetMonth, workTypeCode, attendanceList,
					inputUnit));
		}
		return kinmuList;
	}
	
	/**
	 * o^iΑӏWvj
	 * @param listMKintai	ΑӏWvDTOXg
	 * @throws Exception 	Oꍇ
	 */
	private void registMKintai(List<MKintaiDto> listMKintai) throws Exception {
		// o^
		int insertCount = 0;
		int listSize = listMKintai.size();
		// 񂷉
		int rev = listSize / CommonConst.NUM_DIVIDE_NUMBER + 1;
		if (listSize % CommonConst.NUM_DIVIDE_NUMBER == 0) {
			rev--;
		}
		for (int i = 0; i < rev; i++) {
			List<MKintaiDto> currentList = new ArrayList<MKintaiDto>();
			// XgdivƕB
			for (int k = 0; k < CommonConst.NUM_DIVIDE_NUMBER; k++) {
				int count = k + i * CommonConst.NUM_DIVIDE_NUMBER;
				if (count >= listSize) {
					break;
				}
				MKintaiDto mKintaiDto = listMKintai.get(count);
				if (chkExistDto(mKintaiDto)) {
					currentList.add(mKintaiDto);
				} else {
					break;
				}
			}
			// o^			
			insertCount += compile().getMKintaiDao().insert(currentList.toArray(new MKintaiDto[currentList.size()]));
		}
		if (insertCount != listSize) {
			throw new MospException(MospConst.EX_INSERT_FAILED);
		}
	}
	
	/**
	 * o^iΑӏWvj
	 * @param listKdWork	ΑӏWvDTOXg
	 * @throws Exception 	Oꍇ
	 */
	private void registKdWork(List<KdWorkDto> listKdWork) throws Exception {
		// o^
		int insertCount = 0;
		int listSize = listKdWork.size();
		// 񂷉
		int rev = listSize / CommonConst.NUM_DIVIDE_NUMBER + 1;
		if (listSize % CommonConst.NUM_DIVIDE_NUMBER == 0) {
			rev--;
		}
		for (int i = 0; i < rev; i++) {
			List<KdWorkDto> currentList = new ArrayList<KdWorkDto>();
			// XgdivƕB
			for (int k = 0; k < CommonConst.NUM_DIVIDE_NUMBER; k++) {
				int count = k + i * CommonConst.NUM_DIVIDE_NUMBER;
				if (count >= listSize) {
					break;
				}
				KdWorkDto mKintaiDto = listKdWork.get(count);
				if (chkExistDto(mKintaiDto)) {
					currentList.add(mKintaiDto);
				} else {
					break;
				}
			}
			// o^			
			insertCount += compile().getKdWorkDao().insert(currentList.toArray(new KdWorkDto[currentList.size()]));
		}
		if (insertCount != listSize) {
			throw new MospException(MospConst.EX_INSERT_FAILED);
		}
	}
	
	/**
	 * o^iΖ`ԕʁj
	 * @param listMKinmu	Ζ`ԕʏWvDTOXg
	 * @throws Exception	Oꍇ
	 */
	private void registMKinmu(List<MKintaiKinmuDto> listMKinmu) throws Exception {
		// o^
		int insertCount = 0;
		int listSize = listMKinmu.size();
		// 񂷉
		int rev = listSize / CommonConst.NUM_DIVIDE_NUMBER + 1;
		if (listSize % CommonConst.NUM_DIVIDE_NUMBER == 0) {
			rev--;
		}
		for (int i = 0; i < rev; i++) {
			List<MKintaiKinmuDto> currentList = new ArrayList<MKintaiKinmuDto>();
			// XgdivƕB
			for (int k = 0; k < CommonConst.NUM_DIVIDE_NUMBER; k++) {
				int count = k + i * CommonConst.NUM_DIVIDE_NUMBER;
				if (count >= listSize) {
					break;
				}
				MKintaiKinmuDto mKinmuDto = listMKinmu.get(count);
				if (chkExistDto(mKinmuDto)) {
					currentList.add(mKinmuDto);
				} else {
					break;
				}
			}
			// zZbgB			
			insertCount += compile().getMKintaiKinmuDao().insert(
					currentList.toArray(new MKintaiKinmuDto[currentList.size()]));
		}
		if (insertCount != listSize) {
			throw new MospException(MospConst.EX_INSERT_FAILED);
		}
	}
	
	/**
	 * [hݒivZj
	 * @throws Exception	Oꍇ
	 */
	private void setMode() throws Exception {
		AttendanceCompileCardVo vo = (AttendanceCompileCardVo)getVo();
		MKintaiKeisanDto dto = part().calculate().findForCalc();
		if (chkExistDto(dto)) {
			if (CalculatePart.isCalculateFinish(dto)) {
				// [hݒ
				vo.setMode(AttendanceCompileCardVo.MODE_IMPOSSIBLE);
				// bZ[WpvZN
				// INvZ
				vo.addErrMessage(getMessage(CommonConst.MSG_ALREADY_CALCULATE,
				// bZ[WpvZN
						dto.getKTNen() + CommonConst.STR_UNDER_SEPARATOR + dto.getKTTuki()));
			} else {
				vo.setMode(AttendanceCompileCardVo.MODE_UPDATE);
			}
		} else {
			// [hݒ
			vo.setMode(AttendanceCompileCardVo.MODE_IMPOSSIBLE);
			// vZ񖳂
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	/**
	 * ꗗւ̏Zbg
	 * @throws Exception	Oꍇ
	 */
	private void setNextCmdInfo() throws Exception {
		AttendanceCompileCardVo vo = (AttendanceCompileCardVo)getVo();
		// IR[h̃Zbg
		request.setAttribute(COMPILE_SECTION, vo.getPltSection());
		// IЈR[h̃Zbg
		request.setAttribute(COMPILE_K_CODE, vo.getTxtKCode());
		// bZ[Wݒ
		if (StringUtil.isNotNull(vo.getTxtKCode()) && part().human().isNotUseKCode(vo.getTxtKCode())) {
			setMessage(getMessage(MospConst.MSG_NO_CODE, ""));
		} else {
			setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		}
	}
	
}
