/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.kintai.vo;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;

/**
 * @author yoshida
 *
 */
public class PaidHolidayConfirmCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 4422751719733412912L;
	
	// tB[h
	private String				lblAttendanceCalcY;
	private String				lblAttendanceCalcM;
	private String				lblPaidHolidayTY;
	private String				lblPaidHolidayTimeTY;
	private String				lblPaidHolidayLY;
	private String				lblPaidHolidayTimeLY;
	private String				lblRemainApproved;
	private String				lblRemainApprovedTime;
	private String				lblApproved;
	private String				lblApprovedTime;
	private String				lblThisMGet;
	private String				lblThisMGetTime;
	private String				lblThisMDispose;
	private String				lblThisMDisposeTime;
	private String				lblThisMRestLY;
	private String				lblThisMRestTimeLY;
	private String				lblThisMRestTY;
	private String				lblThisMRestTimeTY;
	private String				lblPaidHolidayPossibleTime;
	private String				lblPaidHolidayPossibleThisTime;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_PAYROLL_CALC;
	/**
	 * 
	 */
	public String				NAM_LAST_M_REST;
	
	/**
	 * ǉ\()
	 */
	public String				NAM_THIS_M_GET;
	
	/**
	 * ǉ\()
	 */
	public String				NAM_THIS_M_GET_TIME;
	
	/**
	 * p\()
	 */
	public String				NAM_THIS_M_DISPOSE;
	
	/**
	 * p\()
	 */
	public String				NAM_THIS_M_DISPOSETIME;
	
	/**
	 * 
	 */
	public String				NAM_THIS_M_REST;
	/**
	 * 
	 */
	public String				NAM_USE;
	
	/**
	 * \()
	 */
	public String				NAM_REMAIN_APPROVED;
	
	/**
	 * \()
	 */
	public String				NAM_REMAIN_APPROVED_TIME;
	
	/**
	 * Fς()
	 */
	public String				NAM_APPROVED;
	
	/**
	 * Fς()
	 */
	public String				NAM_APPROVED_TIME;
	
	/**
	 * 
	 */
	public String				NAM_THIS_YEAR;
	/**
	 * 
	 */
	public String				NAM_LAST_YEAR;
	
	/**
	 * ON()
	 */
	public String				NAM_LAST_YEAR_TIME;
	
	/**
	 * N()
	 */
	public String				NAM_THIS_YEAR_TIME;
	
	/**
	 * ԒPʗp\
	 */
	public String				NAM_TIME_UNIT_FORMER;
	

	/**
	 * RXgN^
	 */
	public PaidHolidayConfirmCardVo() {
		super();
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_PAID_HOLIDAY_CHECK;
		aryMenu = new String[][]{ { CMD_MENU_INPUT, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_PAYROLL_CALC = CommonConst.NAM_CONFIRM_PAYMENT + CommonConst.NAM_PROVIDED_YEAR_MONTH;
		NAM_LAST_M_REST = CommonConst.NAM_CUT_OFF_MONTH_THIS + CommonConst.NAM_POSSIBLE_AMOUNT;
		NAM_THIS_M_GET = CommonConst.NAM_GET_SCHEDULE;
		NAM_THIS_M_GET_TIME = CommonConst.NAM_GET_SCHEDULE;
		NAM_THIS_M_DISPOSE = CommonConst.NAM_DISPOSE_SCHEDULE;
		NAM_THIS_M_DISPOSETIME = CommonConst.NAM_DISPOSE_SCHEDULE;
		NAM_THIS_M_REST = CommonConst.NAM_CUT_OFF_MONTH_AFTER + CommonConst.NAM_POSSIBLE_SCHEDULE;
		NAM_USE = CommonConst.NAM_USE;
		NAM_REMAIN_APPROVED = CommonConst.NAM_APPROVAL_REQUEST;
		NAM_REMAIN_APPROVED_TIME = CommonConst.NAM_APPROVAL_REQUEST;
		NAM_APPROVED = CommonConst.NAM_ALREADY_APPROVED + CommonConst.NAM_PAID_HOLIDAY_AMOUNT;
		NAM_APPROVED_TIME = CommonConst.NAM_ALREADY_APPROVED + CommonConst.NAM_PAID_HOLIDAY_AMOUNT;
		NAM_THIS_YEAR = CommonConst.NAM_YEAR_THIS;
		NAM_LAST_YEAR = CommonConst.NAM_YEAR_FORMER;
		NAM_LAST_YEAR_TIME = CommonConst.NAM_YEAR_FORMER;
		NAM_THIS_YEAR_TIME = CommonConst.NAM_YEAR_THIS;
		NAM_TIME_UNIT_FORMER = CommonConst.TCD_HOUR_PAID_HOLIDAY_FUNCTION;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setLblAttendanceCalcY("");
		setLblAttendanceCalcM("");
		setLblPaidHolidayLY("0");
		setLblPaidHolidayTY("0");
		setLblRemainApproved("0");
		setLblApproved("0");
		setLblThisMGet("0");
		setLblThisMDispose("0");
		setLblThisMRestLY("0");
		setLblThisMRestTY("0");
	}
	
	/**
	 * @return lblAttendanceCalcY
	 */
	public String getLblAttendanceCalcY() {
		return lblAttendanceCalcY;
	}
	
	/**
	 * @return lblAttendanceCalcM
	 */
	public String getLblAttendanceCalcM() {
		return lblAttendanceCalcM;
	}
	
	/**
	 * @return lblPaidHolidayTY
	 */
	public String getLblPaidHolidayTY() {
		return lblPaidHolidayTY;
	}
	
	/**
	 * @return lblPaidHolidayTimeTY
	 */
	public String getLblPaidHolidayTimeTY() {
		return lblPaidHolidayTimeTY;
	}
	
	/**
	 * @return lblPaidHolidayLY
	 */
	public String getLblPaidHolidayLY() {
		return lblPaidHolidayLY;
	}
	
	/**
	 * @return lblPaidHolidayTimeLY
	 */
	public String getLblPaidHolidayTimeLY() {
		return lblPaidHolidayTimeLY;
	}
	
	/**
	 * @return lblRemainApproved
	 */
	public String getLblRemainApproved() {
		return lblRemainApproved;
	}
	
	/**
	 * @return lblRemainApprovedTime
	 */
	public String getLblRemainApprovedTime() {
		return lblRemainApprovedTime;
	}
	
	/**
	 * @return lblApproved
	 */
	public String getLblApproved() {
		return lblApproved;
	}
	
	/**
	 * @return lblApprovedTime
	 */
	public String getLblApprovedTime() {
		return lblApprovedTime;
	}
	
	/**
	 * @return lblThisMGet
	 */
	public String getLblThisMGet() {
		return lblThisMGet;
	}
	
	/**
	 * @return lblThisMGetTime
	 */
	public String getLblThisMGetTime() {
		return lblThisMGetTime;
	}
	
	/**
	 * @return lblThisMDispose
	 */
	public String getLblThisMDispose() {
		return lblThisMDispose;
	}
	
	/**
	 * @return lblThisMDisposeTime
	 */
	public String getLblThisMDisposeTime() {
		return lblThisMDisposeTime;
	}
	
	/**
	 * @return lblThisMRestLY
	 */
	public String getLblThisMRestLY() {
		return lblThisMRestLY;
	}
	
	/**
	 * @return lblThisMRestTimeLY
	 */
	public String getLblThisMRestTimeLY() {
		return lblThisMRestTimeLY;
	}
	
	/**
	 * @return lblThisMRestTY
	 */
	public String getLblThisMRestTY() {
		return lblThisMRestTY;
	}
	
	/**
	 * @return lblThisMRestTimeTY
	 */
	public String getLblThisMRestTimeTY() {
		return lblThisMRestTimeTY;
	}
	
	/**
	 * @return lblPaidHolidayPossibleTime
	 */
	public String getLblPaidHolidayPossibleTime() {
		return lblPaidHolidayPossibleTime;
	}
	
	/**
	 * @return lblPaidHolidayPossibleThisTime
	 */
	public String getLblPaidHolidayPossibleThisTime() {
		return lblPaidHolidayPossibleThisTime;
	}
	
	/**
	 * @param lblAttendanceCalcY Zbg lblAttendanceCalcY
	 */
	public void setLblAttendanceCalcY(String lblAttendanceCalcY) {
		this.lblAttendanceCalcY = lblAttendanceCalcY;
	}
	
	/**
	 * @param lblAttendanceCalcM Zbg lblAttendanceCalcM
	 */
	public void setLblAttendanceCalcM(String lblAttendanceCalcM) {
		this.lblAttendanceCalcM = lblAttendanceCalcM;
	}
	
	/**
	 * @param lblPaidHolidayTY Zbg lblPaidHolidayTY
	 */
	public void setLblPaidHolidayTY(String lblPaidHolidayTY) {
		this.lblPaidHolidayTY = lblPaidHolidayTY;
	}
	
	/**
	 * @param lblPaidHolidayPossibleTime Zbg lblPaidHolidayPossibleTime
	 */
	public void setLblPaidHolidayPossibleTime(String lblPaidHolidayPossibleTime) {
		this.lblPaidHolidayPossibleTime = lblPaidHolidayPossibleTime;
	}
	
	/**
	 * @param lblPaidHolidayPossibleThisTime Zbg lblPaidHolidayPossibleThisTime
	 */
	public void setLblPaidHolidayPossibleThisTime(String lblPaidHolidayPossibleThisTime) {
		this.lblPaidHolidayPossibleThisTime = lblPaidHolidayPossibleThisTime;
	}
	
	/**
	 * @param lblPaidHolidayTimeTY Zbg lblPaidHolidayTimeTY
	 */
	public void setLblPaidHolidayTimeTY(String lblPaidHolidayTimeTY) {
		this.lblPaidHolidayTimeTY = lblPaidHolidayTimeTY;
	}
	
	/**
	 * @param lblPaidHolidayLY Zbg lblPaidHolidayLY
	 */
	public void setLblPaidHolidayLY(String lblPaidHolidayLY) {
		this.lblPaidHolidayLY = lblPaidHolidayLY;
	}
	
	/**
	 * @param lblPaidHolidayTimeLY Zbg lblPaidHolidayTimeLY
	 */
	public void setLblPaidHolidayTimeLY(String lblPaidHolidayTimeLY) {
		this.lblPaidHolidayTimeLY = lblPaidHolidayTimeLY;
	}
	
	/**
	 * @param lblRemainApproved Zbg lblRemainApproved
	 */
	public void setLblRemainApproved(String lblRemainApproved) {
		this.lblRemainApproved = lblRemainApproved;
	}
	
	/**
	 * @param lblRemainApprovedTime Zbg lblRemainApprovedTime
	 */
	public void setLblRemainApprovedTime(String lblRemainApprovedTime) {
		this.lblRemainApprovedTime = lblRemainApprovedTime;
	}
	
	/**
	 * @param lblApproved Zbg lblApproved
	 */
	public void setLblApproved(String lblApproved) {
		this.lblApproved = lblApproved;
	}
	
	/**
	 * @param lblApprovedTime Zbg lblApprovedTime
	 */
	public void setLblApprovedTime(String lblApprovedTime) {
		this.lblApprovedTime = lblApprovedTime;
	}
	
	/**
	 * @param lblThisMGet Zbg lblThisMGet
	 */
	public void setLblThisMGet(String lblThisMGet) {
		this.lblThisMGet = lblThisMGet;
	}
	
	/**
	 * @param lblThisMGetTime Zbg lblThisMGetTime
	 */
	public void setLblThisMGetTime(String lblThisMGetTime) {
		this.lblThisMGetTime = lblThisMGetTime;
	}
	
	/**
	 * @param lblThisMDispose Zbg lblThisMDispose
	 */
	public void setLblThisMDispose(String lblThisMDispose) {
		this.lblThisMDispose = lblThisMDispose;
	}
	
	/**
	 * @param lblThisMDisposeTime Zbg lblThisMDisposeTime
	 */
	public void setLblThisMDisposeTime(String lblThisMDisposeTime) {
		this.lblThisMDisposeTime = lblThisMDisposeTime;
	}
	
	/**
	 * @param lblThisMRestLY Zbg lblThisMRestLY
	 */
	public void setLblThisMRestLY(String lblThisMRestLY) {
		this.lblThisMRestLY = lblThisMRestLY;
	}
	
	/**
	 * @param lblThisMRestTimeLY Zbg lblThisMRestTimeLY
	 */
	public void setLblThisMRestTimeLY(String lblThisMRestTimeLY) {
		this.lblThisMRestTimeLY = lblThisMRestTimeLY;
	}
	
	/**
	 * @param lblThisMRestTY Zbg lblThisMRestTY
	 */
	public void setLblThisMRestTY(String lblThisMRestTY) {
		this.lblThisMRestTY = lblThisMRestTY;
	}
	
	/**
	 * @param lblThisMRestTimeTY Zbg lblThisMRestTimeTY
	 */
	public void setLblThisMRestTimeTY(String lblThisMRestTimeTY) {
		this.lblThisMRestTimeTY = lblThisMRestTimeTY;
	}
	
}
