/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.kintai.dto.MSyukkinboDto;

/**
 * @author yoshida
 *
 */
public abstract class AttendanceMenuVo extends MosPVo {
	
	private static final long	serialVersionUID	= 3059406656261478934L;
	
	// p[^
	/**
	 * hidKCode
	 */
	public static final String	PRM_HID_K_CODE		= "hidKCode";
	/**
	 * hidYear
	 */
	public static final String	PRM_HID_YEAR		= "hidYear";
	/**
	 * hidMonth
	 */
	public static final String	PRM_HID_MONTH		= "hidMonth";
	/**
	 * hidDay
	 */
	public static final String	PRM_HID_DAY			= "hidDay";
	
	// ҏW[htO
	/**
	 * 0
	 */
	public static final int		MODE_INSERT			= 0;
	/**
	 * 1
	 */
	public static final int		MODE_EDIT			= 1;
	/**
	 * 2
	 */
	public static final int		MODE_APPROVED		= 2;
	
	// ҏW[h
	/**
	 * 
	 */
	public static final String	NAM_MODE_INSERT		= CommonConst.NAM_MODE_INSERT;
	/**
	 * 
	 */
	public static final String	NAM_MODE_EDIT		= CommonConst.NAM_MODE_EDIT;
	/**
	 * [F]
	 */
	public static final String	NAM_MODE_APPROVED	= CommonConst.NAM_MODE_APPROVED;
	
	// tB[h
	private String				lblDate;
	private String				lblDayOfWeek;
	
	// tB[h(ʑJڗp)
	private String				hidKCode;
	private String				hidYear;
	private String				hidMonth;
	private String				hidDay;
	private String				hidDate;
	
	private String				hidFormerDate;
	private String				hidNextDate;
	private String				lblFormerDate;
	private String				lblNextDate;
	
	// ҏW[h(0FVKo^A1FXVA2:F)
	private int					mode;
	
	// Tu^Cgj[R}h
	private String				cmdMenuButton;
	private String				cmdListButton;
	private String				namListButton;
	
	// ҏW[h
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_REQUEST;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_REQUEST;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME;
	/**
	 * 
	 */
	public String				NAM_REQUEST_STATUS;
	
	// cƐ\
	private String				lblOverTimeRequest;
	private String				lblOverTimeRequestStatus;
	private String[]			aryHolidayRequestStatus;
	
	private boolean				isDraft;
	private String				dayOfWeekColorClass;
	
	private boolean				isCaution;
	private boolean				isWarning;
	

	/**
	 * RXgN^
	 */
	public AttendanceMenuVo() {
		super();
		isDraft = true;
	}
	
	@Override
	protected void setFieldsName() {
		NAM_OVER_TIME_REQUEST = CommonConst.NAM_OVER_TIME_REQUEST;
		NAM_HOLIDAY_REQUEST = CommonConst.NAM_HOLIDAY_REQUEST;
		NAM_OVER_TIME = CommonConst.NAM_OVERTIME + CommonConst.NAM_COMMON_TIME;
		NAM_REQUEST_STATUS = CommonConst.NAM_APPROVAL_STATE;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		hidKCode = request.getParameter(PRM_HID_K_CODE);
		hidYear = request.getParameter(PRM_HID_YEAR);
		hidMonth = request.getParameter(PRM_HID_MONTH);
		hidDay = request.getParameter(PRM_HID_DAY);
		hidDate = DateUtil.convStringDateFormatted(hidYear, hidMonth, hidDay);
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto	ΏDTO
	 */
	public void setDtoFields(MSyukkinboDto dto) {
		dto.setKCode(getHidKCode());
		dto.setHizuke(DateUtil.convStringDateFormatted(getHidYear(), getHidMonth(), getHidDay()));
		dto.setNen(Integer.parseInt(getHidYear()));
		dto.setTuki(Integer.parseInt(getHidMonth()));
		dto.setHi(Integer.parseInt(getHidDay()));
	}
	
	/**
	 * j[{^ݒ
	 * @param addListButton j[{^ǉtO
	 */
	public void setAryMenu(boolean addListButton) {
		aryMenu = new String[][]{ { getCmdMenuButton(), CommonConst.NAM_TO_MENU }, };
		if (addListButton) {
			aryMenu = StringUtil.addArrayLastRowValue(aryMenu, getCmdListButton(), getNamListButton());
		}
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append("var isDraft = ");
		sb.append(isDraft);
		sb.append(";");
		sb.append("var CAUTION = ");
		sb.append(isCaution);
		sb.append(";");
		sb.append("var WARNING = ");
		sb.append(isWarning);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return lblDate
	 */
	public String getEscLblDate() {
		return escapeHTML(lblDate);
	}
	
	/**
	 * @return hidKCode
	 */
	public String getEscHidKCode() {
		return escapeHTML(hidKCode);
	}
	
	/**
	 * @return hidYear
	 */
	public String getEscHidYear() {
		return escapeHTML(hidYear);
	}
	
	/**
	 * @return hidMonth
	 */
	public String getEscHidMonth() {
		return escapeHTML(hidMonth);
	}
	
	/**
	 * @return hidDay
	 */
	public String getEscHidDay() {
		return escapeHTML(hidDay);
	}
	
	/**
	 * @return hidDate
	 */
	public String getEscHidDate() {
		return escapeHTML(hidDate);
	}
	
	/**
	 * @return lblOverTimeRequest
	 */
	public String getEscLblOverTimeRequest() {
		return escapeHTML(lblOverTimeRequest);
	}
	
	/**
	 * @return lblOverTimeRequestStatus
	 */
	public String getEscLblOverTimeRequestStatus() {
		return escapeHTML(lblOverTimeRequestStatus);
	}
	
	/**
	 * @return hidFormerDate
	 */
	public String getHidFormerDate() {
		return escapeHTML(hidFormerDate);
	}
	
	/**
	 * @return hidNextDate
	 */
	public String getHidNextDate() {
		return escapeHTML(hidNextDate);
	}
	
	/**
	 * @return lblFormerDate
	 */
	public String getEscLblFormerDate() {
		return escapeHTML(lblFormerDate);
	}
	
	/**
	 * @return lblNextDate
	 */
	public String getEscLblNextDate() {
		return escapeHTML(lblNextDate);
	}
	
	/**
	 * Αӓ͉ʃj[pCSS
	 */
	protected void addAttendanceMenuCss() {
		addExtraCss("/pub/kintai/kintai/css/attendanceMenu.css");
	}
	
	/**
	 * Αӓ͉ʃj[pJS
	 */
	protected void addAttendanceMenuJs() {
		addExtraJs("/pub/kintai/kintai/js/attendanceMenu.js");
	}
	
	/**
	 * @return lblDayOfWeek
	 */
	public String getEscLblDayOfWeek() {
		return escapeHTML(lblDayOfWeek);
	}
	
	/**
	 * @return dayOfWeekColorClass
	 */
	public String getEscDayOfWeekColorClass() {
		return escapeHTML(dayOfWeekColorClass);
	}
	
	/**
	 * @return lblDate
	 */
	public String getLblDate() {
		return lblDate;
	}
	
	/**
	 * @return lblDayOfWeek
	 */
	public String getLblDayOfWeek() {
		return lblDayOfWeek;
	}
	
	/**
	 * @return hidKCode
	 */
	public String getHidKCode() {
		return hidKCode;
	}
	
	/**
	 * @return hidYear
	 */
	public String getHidYear() {
		return hidYear;
	}
	
	/**
	 * @return hidMonth
	 */
	public String getHidMonth() {
		return hidMonth;
	}
	
	/**
	 * @return hidDay
	 */
	public String getHidDay() {
		return hidDay;
	}
	
	/**
	 * @return hidDate
	 */
	public String getHidDate() {
		return hidDate;
	}
	
	/**
	 * @return lblFormerDate
	 */
	public String getLblFormerDate() {
		return lblFormerDate;
	}
	
	/**
	 * @return lblNextDate
	 */
	public String getLblNextDate() {
		return lblNextDate;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @return cmdMenuButton
	 */
	public String getCmdMenuButton() {
		return cmdMenuButton;
	}
	
	/**
	 * @return cmdListButton
	 */
	public String getCmdListButton() {
		return cmdListButton;
	}
	
	/**
	 * @return namListButton
	 */
	public String getNamListButton() {
		return namListButton;
	}
	
	/**
	 * @return lblOverTimeRequest
	 */
	public String getLblOverTimeRequest() {
		return lblOverTimeRequest;
	}
	
	/**
	 * @return lblOverTimeRequestStatus
	 */
	public String getLblOverTimeRequestStatus() {
		return lblOverTimeRequestStatus;
	}
	
	/**
	 * @return aryHolidayRequestStatus
	 */
	public String[] getAryHolidayRequestStatus() {
		return aryHolidayRequestStatus.clone();
	}
	
	/**
	 * @return isDraft
	 */
	public boolean isDraft() {
		return isDraft;
	}
	
	/**
	 * @return dayOfWeekColorClass
	 */
	public String getDayOfWeekColorClass() {
		return dayOfWeekColorClass;
	}
	
	/**
	 * @return isCaution
	 */
	public boolean isCaution() {
		return isCaution;
	}
	
	/**
	 * @return isWarning
	 */
	public boolean isWarning() {
		return isWarning;
	}
	
	/**
	 * @param lblDate Zbg lblDate
	 */
	public void setLblDate(String lblDate) {
		this.lblDate = lblDate;
	}
	
	/**
	 * @param lblDayOfWeek Zbg lblDayOfWeek
	 */
	public void setLblDayOfWeek(String lblDayOfWeek) {
		this.lblDayOfWeek = lblDayOfWeek;
	}
	
	/**
	 * @param hidKCode Zbg hidKCode
	 */
	public void setHidKCode(String hidKCode) {
		this.hidKCode = hidKCode;
	}
	
	/**
	 * @param hidYear Zbg hidYear
	 */
	public void setHidYear(String hidYear) {
		this.hidYear = hidYear;
	}
	
	/**
	 * @param hidMonth Zbg hidMonth
	 */
	public void setHidMonth(String hidMonth) {
		this.hidMonth = hidMonth;
	}
	
	/**
	 * @param hidDay Zbg hidDay
	 */
	public void setHidDay(String hidDay) {
		this.hidDay = hidDay;
	}
	
	/**
	 * @param hidDate Zbg hidDate
	 */
	public void setHidDate(String hidDate) {
		this.hidDate = hidDate;
	}
	
	/**
	 * @param hidFormerDate Zbg hidFormerDate
	 */
	public void setHidFormerDate(String hidFormerDate) {
		this.hidFormerDate = hidFormerDate;
	}
	
	/**
	 * @param hidNextDate Zbg hidNextDate
	 */
	public void setHidNextDate(String hidNextDate) {
		this.hidNextDate = hidNextDate;
	}
	
	/**
	 * @param lblFormerDate Zbg lblFormerDate
	 */
	public void setLblFormerDate(String lblFormerDate) {
		this.lblFormerDate = lblFormerDate;
	}
	
	/**
	 * @param lblNextDate Zbg lblNextDate
	 */
	public void setLblNextDate(String lblNextDate) {
		this.lblNextDate = lblNextDate;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @param cmdMenuButton Zbg cmdMenuButton
	 */
	public void setCmdMenuButton(String cmdMenuButton) {
		this.cmdMenuButton = cmdMenuButton;
	}
	
	/**
	 * @param cmdListButton Zbg cmdListButton
	 */
	public void setCmdListButton(String cmdListButton) {
		this.cmdListButton = cmdListButton;
	}
	
	/**
	 * @param namListButton Zbg namListButton
	 */
	public void setNamListButton(String namListButton) {
		this.namListButton = namListButton;
	}
	
	/**
	 * @param lblOverTimeRequest Zbg lblOverTimeRequest
	 */
	public void setLblOverTimeRequest(String lblOverTimeRequest) {
		this.lblOverTimeRequest = lblOverTimeRequest;
	}
	
	/**
	 * @param lblOverTimeRequestStatus Zbg lblOverTimeRequestStatus
	 */
	public void setLblOverTimeRequestStatus(String lblOverTimeRequestStatus) {
		this.lblOverTimeRequestStatus = lblOverTimeRequestStatus;
	}
	
	/**
	 * @param aryHolidayRequestStatus Zbg aryHolidayRequestStatus
	 */
	public void setAryHolidayRequestStatus(String[] aryHolidayRequestStatus) {
		this.aryHolidayRequestStatus = aryHolidayRequestStatus.clone();
	}
	
	/**
	 * @param isDraft Zbg isDraft
	 */
	public void setDraft(boolean isDraft) {
		this.isDraft = isDraft;
	}
	
	/**
	 * @param dayOfWeekColorClass Zbg dayOfWeekColorClass
	 */
	public void setDayOfWeekColorClass(String dayOfWeekColorClass) {
		this.dayOfWeekColorClass = dayOfWeekColorClass;
	}
	
	/**
	 * @param isCaution Zbg isCaution
	 */
	public void setCaution(boolean isCaution) {
		this.isCaution = isCaution;
	}
	
	/**
	 * @param isWarning Zbg isWarning
	 */
	public void setWarning(boolean isWarning) {
		this.isWarning = isWarning;
	}
	
}
