/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;

/**
 * @author yoshida
 *
 */
public class AttendanceListVo extends AttendanceMenuVo {
	
	private static final long	serialVersionUID	= 5745704400845358952L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_IMPOSSIBLE		= 0;
	/**
	 * 
	 */
	public static final int		MODE_POSSIBLE		= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_PLT_YEAR		= "pltYear";
	/**
	 * 
	 */
	public static final String	PRM_PLT_MONTH		= "pltMonth";
	
	/**
	 * 
	 */
	public static final String	PRM_HID_KCODE		= "hidKCode";
	
	// tB[h
	private String				selectKCode;
	
	private String				workTimes;
	private String				breakTimes;
	private String				lateTimes;
	private String				leaveEarlyTimes;
	private String				overTimes;
	private String				workOnHoliday;
	private String				lateNightTimes;
	
	private String				presence;
	private String				paidHoliday;
	private String				particularHoliday;
	private String				absence;
	private String				sick;
	private String				compensationLeave;
	private String				transfer;
	private String				other;
	
	private String				leaveAndLate;
	
	private String				allowance;
	private String				perfectAttendance;
	
	private String[][]			aryAttendance;
	private String[]			aryLabel;
	
	private String				pltYear;
	private String				pltMonth;
	
	//private String hidKCode;
	
	/*						
	 *  	2009/01/20	m.yoshida	ߓΉ
	 */
	//private String hidDay;
	
	// Tu^Cgj[R}h
	//private String cmdMenuButton;
	//private String cmdListButton;
	//private String namListButton;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	
	private String				overTimeCssClass;
	

	/**
	 * RXgN^
	 */
	public AttendanceListVo() {
		super();
		setMode(MODE_IMPOSSIBLE);
		setViewPath(getClassName());
		pltYear = "";
		pltMonth = "";
		//hidKCode = "";
		aryAttendance = new String[0][0];
		aryLabel = new String[0];
		overTimeCssClass = "";
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		//hidDay = "";
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_ATTENDANCE_LIST;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltYear = request.getParameter(PRM_PLT_YEAR);
		pltMonth = request.getParameter(PRM_PLT_MONTH);
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		//hidDay = "";
		// oΕo͗p
		//hidKCode = request.getParameter(PRM_HID_KCODE);
		//super.setParams(request);
	}
	
	/**
	 * tB[hݒ
	 * @param aryAttendance	Wvf[^Xg
	 * @param aryCompile	Wvf[^
	 * @param aryLabel		Wvf[^x
	 */
	public void setFields(String[][] aryAttendance, String[] aryCompile, String[] aryLabel) {
		this.aryAttendance = escapeArray(aryAttendance.clone());
		this.aryLabel = escapeArray(aryLabel.clone());
		
		workTimes = aryCompile[0];
		breakTimes = aryCompile[1];
		lateTimes = aryCompile[2];
		leaveEarlyTimes = aryCompile[3];
		overTimes = aryCompile[4];
		workOnHoliday = aryCompile[5];
		lateNightTimes = aryCompile[6];
		
		presence = aryCompile[7];
		paidHoliday = aryCompile[8];
		particularHoliday = aryCompile[9];
		absence = aryCompile[10];
		sick = aryCompile[11];
		compensationLeave = aryCompile[12];
		transfer = aryCompile[13];
		other = aryCompile[14];
		
		leaveAndLate = aryCompile[15];
		allowance = aryCompile[16];
		perfectAttendance = aryCompile[17];
		
		overTimeCssClass = aryCompile[18];
	}
	
	/**
	 * @return selectKCode
	 */
	public String getSelectKCode() {
		return selectKCode;
	}
	
	/**
	 * @return workTimes
	 */
	public String getWorkTimes() {
		return workTimes;
	}
	
	/**
	 * @return breakTimes
	 */
	public String getBreakTimes() {
		return breakTimes;
	}
	
	/**
	 * @return lateTimes
	 */
	public String getLateTimes() {
		return lateTimes;
	}
	
	/**
	 * @return leaveEarlyTimes
	 */
	public String getLeaveEarlyTimes() {
		return leaveEarlyTimes;
	}
	
	/**
	 * @return overTimes
	 */
	public String getOverTimes() {
		return overTimes;
	}
	
	/**
	 * @return workOnHoliday
	 */
	public String getWorkOnHoliday() {
		return workOnHoliday;
	}
	
	/**
	 * @return lateNightTimes
	 */
	public String getLateNightTimes() {
		return lateNightTimes;
	}
	
	/**
	 * @return presence
	 */
	public String getPresence() {
		return presence;
	}
	
	/**
	 * @return paidHoliday
	 */
	public String getPaidHoliday() {
		return paidHoliday;
	}
	
	/**
	 * @return particularHoliday
	 */
	public String getParticularHoliday() {
		return particularHoliday;
	}
	
	/**
	 * @return absence
	 */
	public String getAbsence() {
		return absence;
	}
	
	/**
	 * @return sick
	 */
	public String getSick() {
		return sick;
	}
	
	/**
	 * @return compensationLeave
	 */
	public String getCompensationLeave() {
		return compensationLeave;
	}
	
	/**
	 * @return transfer
	 */
	public String getTransfer() {
		return transfer;
	}
	
	/**
	 * @return other
	 */
	public String getOther() {
		return other;
	}
	
	/**
	 * @return leaveAndLate
	 */
	public String getLeaveAndLate() {
		return leaveAndLate;
	}
	
	/**
	 * @return allowance
	 */
	public String getAllowance() {
		return allowance;
	}
	
	/**
	 * @return perfectAttendance
	 */
	public String getPerfectAttendance() {
		return perfectAttendance;
	}
	
	/**
	 * @return aryAttendance
	 */
	public String[][] getAryAttendance() {
		return aryAttendance.clone();
	}
	
	/**
	 * @return aryLabel
	 */
	public String[] getAryLabel() {
		return aryLabel.clone();
	}
	
	/**
	 * @return pltYear
	 */
	public String getPltYear() {
		return pltYear;
	}
	
	/**
	 * @return pltMonth
	 */
	public String getPltMonth() {
		return pltMonth;
	}
	
	/**
	 * @return overTimeCssClass
	 */
	public String getOverTimeCssClass() {
		return overTimeCssClass;
	}
	
	/**
	 * @param selectKCode Zbg selectKCode
	 */
	public void setSelectKCode(String selectKCode) {
		this.selectKCode = selectKCode;
	}
	
	/**
	 * @param workTimes Zbg workTimes
	 */
	public void setWorkTimes(String workTimes) {
		this.workTimes = workTimes;
	}
	
	/**
	 * @param breakTimes Zbg breakTimes
	 */
	public void setBreakTimes(String breakTimes) {
		this.breakTimes = breakTimes;
	}
	
	/**
	 * @param lateTimes Zbg lateTimes
	 */
	public void setLateTimes(String lateTimes) {
		this.lateTimes = lateTimes;
	}
	
	/**
	 * @param leaveEarlyTimes Zbg leaveEarlyTimes
	 */
	public void setLeaveEarlyTimes(String leaveEarlyTimes) {
		this.leaveEarlyTimes = leaveEarlyTimes;
	}
	
	/**
	 * @param overTimes Zbg overTimes
	 */
	public void setOverTimes(String overTimes) {
		this.overTimes = overTimes;
	}
	
	/**
	 * @param workOnHoliday Zbg workOnHoliday
	 */
	public void setWorkOnHoliday(String workOnHoliday) {
		this.workOnHoliday = workOnHoliday;
	}
	
	/**
	 * @param lateNightTimes Zbg lateNightTimes
	 */
	public void setLateNightTimes(String lateNightTimes) {
		this.lateNightTimes = lateNightTimes;
	}
	
	/**
	 * @param presence Zbg presence
	 */
	public void setPresence(String presence) {
		this.presence = presence;
	}
	
	/**
	 * @param paidHoliday Zbg paidHoliday
	 */
	public void setPaidHoliday(String paidHoliday) {
		this.paidHoliday = paidHoliday;
	}
	
	/**
	 * @param particularHoliday Zbg particularHoliday
	 */
	public void setParticularHoliday(String particularHoliday) {
		this.particularHoliday = particularHoliday;
	}
	
	/**
	 * @param absence Zbg absence
	 */
	public void setAbsence(String absence) {
		this.absence = absence;
	}
	
	/**
	 * @param sick Zbg sick
	 */
	public void setSick(String sick) {
		this.sick = sick;
	}
	
	/**
	 * @param compensationLeave Zbg compensationLeave
	 */
	public void setCompensationLeave(String compensationLeave) {
		this.compensationLeave = compensationLeave;
	}
	
	/**
	 * @param transfer Zbg transfer
	 */
	public void setTransfer(String transfer) {
		this.transfer = transfer;
	}
	
	/**
	 * @param other Zbg other
	 */
	public void setOther(String other) {
		this.other = other;
	}
	
	/**
	 * @param leaveAndLate Zbg leaveAndLate
	 */
	public void setLeaveAndLate(String leaveAndLate) {
		this.leaveAndLate = leaveAndLate;
	}
	
	/**
	 * @param allowance Zbg allowance
	 */
	public void setAllowance(String allowance) {
		this.allowance = allowance;
	}
	
	/**
	 * @param perfectAttendance Zbg perfectAttendance
	 */
	public void setPerfectAttendance(String perfectAttendance) {
		this.perfectAttendance = perfectAttendance;
	}
	
	/**
	 * @param aryAttendance Zbg aryAttendance
	 */
	public void setAryAttendance(String[][] aryAttendance) {
		this.aryAttendance = aryAttendance.clone();
	}
	
	/**
	 * @param aryLabel Zbg aryLabel
	 */
	public void setAryLabel(String[] aryLabel) {
		this.aryLabel = aryLabel.clone();
	}
	
	/**
	 * @param pltYear Zbg pltYear
	 */
	public void setPltYear(String pltYear) {
		this.pltYear = pltYear;
	}
	
	/**
	 * @param pltMonth Zbg pltMonth
	 */
	public void setPltMonth(String pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	/**
	 * @param overTimeCssClass Zbg overTimeCssClass
	 */
	public void setOverTimeCssClass(String overTimeCssClass) {
		this.overTimeCssClass = overTimeCssClass;
	}
	
}
