/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.kintai.vo;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.kintai.dto.MSyukkinboDto;

/**
 * @author yoshida
 *
 */
public class AttendanceCheckCardVo extends AttendanceMenuVo {
	
	private static final long	serialVersionUID				= -1881098247641817291L;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_START_HOUR				= "txtStartHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_START_MIN				= "txtStartMin";
	/**
	 * 
	 */
	public static final String	PRM_PLT_WORK_TYPE				= "pltWorkType";
	/**
	 * 
	 */
	public static final String	PRM_PLT_START_HALF_HOLIDAY		= "pltStartHalfHoliday";
	/**
	 * 
	 */
	public static final String	PRM_PLT_WORK_ON_HOLIDAY			= "pltWorkOnHoliday";
	/**
	 * 
	 */
	public static final String	PRM_TXT_LATE_HOUR				= "txtLateHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_LATE_MIN				= "txtLateMin";
	/**
	 * 
	 */
	public static final String	PRM_PLT_LATE_REASON				= "pltLateReason";
	/**
	 * 
	 */
	public static final String	PRM_PLT_LATE_CERTIFICATE		= "pltLateCertificate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_LATE_COMMENT			= "txtLateComment";
	/**
	 * 
	 */
	public static final String	PRM_TXT_QUIT_HOUR				= "txtQuitHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_QUIT_MIN				= "txtQuitMin";
	/**
	 * 
	 */
	public static final String	PRM_PLT_QUIT_HALF_HOLIDAY		= "pltQuitHalfHoliday";
	/**
	 * 
	 */
	public static final String	PRM_TXT_WORK_HOUR				= "txtWorkHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_WORK_MIN				= "txtWorkMin";
	/**
	 * 
	 */
	public static final String	PRM_TXT_BREAK_HOUR				= "txtBreakHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_BREAK_MIN				= "txtBreakMin";
	/**
	 * 
	 */
	public static final String	PRM_LBL_ACTUAL_HOUR				= "lblActualHour";
	/**
	 * 
	 */
	public static final String	PRM_LBL_ACTUAL_MIN				= "lblActualMin";
	/**
	 * 
	 */
	public static final String	PRM_PLT_LEAVE_EARLY_REASON		= "pltLeaveEarlyReason";
	/**
	 * 
	 */
	public static final String	PRM_TXT_LEAVE_EARLY_HOUR		= "txtLeaveEarlyHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_LEAVE_EARLY_MIN			= "txtLeaveEarlyMin";
	/**
	 * 
	 */
	public static final String	PRM_PLT_LEAVE_EARLY_CERTIFICATE	= "pltLeaveEarlyCertificate";
	/**
	 * 
	 */
	public static final String	PRM_TXT_LEAVE_EARLY_COMMENT		= "txtLeaveEarlyComment";
	/**
	 * 
	 */
	public static final String	PRM_TXT_OVER_HOUR				= "txtOverHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_OVER_MIN				= "txtOverMin";
	/**
	 * 
	 */
	public static final String	PRM_TXT_WORK_ON_HOLIDAY_HOUR	= "txtWorkOnHolidayHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_WORK_ON_HOLIDAY_MIN		= "txtWorkOnHolidayMin";
	/**
	 * 
	 */
	public static final String	PRM_TXT_LATE_NIGHT_HOUR			= "txtLateNightHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_LATE_NIGHT_MIN			= "txtLateNightMin";
	/**
	 * 
	 */
	public static final String	PRM_CKB_SYOKUJI					= "ckbSyokuji";
	/**
	 * 
	 */
	public static final String	PRM_CKB_CYOKU1					= "ckbCyoku1";
	/**
	 * 
	 */
	public static final String	PRM_CKB_CYOKU2					= "ckbCyoku2";
	/**
	 * 
	 */
	public static final String	PRM_CKB_CYOKU3					= "ckbCyoku3";
	/**
	 * 
	 */
	public static final String	PRM_CKB_HOKA1					= "ckbHoka1";
	/**
	 * 
	 */
	public static final String	PRM_CKB_HOKA2					= "ckbHoka2";
	/**
	 * 
	 */
	public static final String	PRM_CKB_HOKA3					= "ckbHoka3";
	/**
	 * 
	 */
	public static final String	PRM_CKB_HOKA4					= "ckbHoka4";
	/**
	 * 
	 */
	public static final String	PRM_CKB_HOKA5					= "ckbHoka5";
	/**
	 * 
	 */
	public static final String	PRM_LBL_APPROVAL_COMMENT		= "lblApprovalComment";
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_START_TIME;
	/**
	 * 
	 */
	public String				NAM_START_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_START_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_WORKING_TYPE;
	/**
	 * 
	 */
	public String				NAM_START_HALF_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_WORK_ON_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_LATE_TIME;
	/**
	 * 
	 */
	public String				NAM_LATE_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_LATE_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_LATE_REASON;
	/**
	 * 
	 */
	public String				NAM_LATE_CERTIFICATE;
	/**
	 * 
	 */
	public String				NAM_LATE_COMMENT;
	/**
	 * 
	 */
	public String				NAM_QUIT_TIME;
	/**
	 * 
	 */
	public String				NAM_QUIT_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_QUIT_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_QUIT_HALF_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_WORKING_TIME;
	/**
	 * 
	 */
	public String				NAM_WORKING_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_WORKING_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_INTERVAL_TIME;
	/**
	 * 
	 */
	public String				NAM_INTERVAL_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_INTERVAL_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_ACTUAL_WORK_TIME;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_REASON;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_TIME;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_CERTIFICATE;
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_COMMENT;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_WORK_ON_HOLIDAY_TIME;
	/**
	 * 
	 */
	public String				NAM_WORK_ON_HOLIDAY_HOUR;
	/**
	 * 
	 */
	public String				NAM_WORK_ON_HOLIDAY_MIN;
	/**
	 * 
	 */
	public String				NAM_LATE_NIGHT;
	/**
	 * 
	 */
	public String				NAM_LATE_NIGHT_HOUR;
	/**
	 * 
	 */
	public String				NAM_LATE_NIGHT_MIN;
	/**
	 * 
	 */
	public String				NAM_ALLOWANCE;
	/**
	 * 
	 */
	public String				NAM_APPROVAL_COMMENT;
	/**
	 * 
	 */
	public int					LEN_HOUR;
	/**
	 * 
	 */
	public int					LEN_MIN;
	/**
	 * 
	 */
	public int					LEN_COMMENT;
	
	// tB[h	
	private String				txtStartHour;
	private String				txtStartMin;
	private String				pltWorkType;
	private String				pltStartHalfHoliday;
	private String				pltWorkOnHoliday;
	
	private String				txtLateHour;
	private String				txtLateMin;
	private String				pltLateReason;
	private String				pltLateCertificate;
	private String				txtLateComment;
	
	private String				txtQuitHour;
	private String				txtQuitMin;
	private String				pltQuitHalfHoliday;
	private String				txtWorkHour;
	private String				txtWorkMin;
	private String				txtBreakHour;
	private String				txtBreakMin;
	private String				lblActualHour;
	private String				lblActualMin;
	
	private String				pltLeaveEarlyReason;
	private String				txtLeaveEarlyHour;
	private String				txtLeaveEarlyMin;
	private String				pltLeaveEarlyCertificate;
	private String				txtLeaveEarlyComment;
	
	private String				txtOverHour;
	private String				txtOverMin;
	private String				txtWorkOnHolidayHour;
	private String				txtWorkOnHolidayMin;
	private String				txtLateNightHour;
	private String				txtLateNightMin;
	
	private String				ckbSyokuji;
	private String				ckbCyoku1;
	private String				ckbCyoku2;
	private String				ckbCyoku3;
	private String				ckbHoka1;
	private String				ckbHoka2;
	private String				ckbHoka3;
	private String				ckbHoka4;
	private String				ckbHoka5;
	
	private String				lblApprovalComment;
	
	// 蓖
	private String[][]			aryAllowance;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltWorkType;
	/**
	 * 
	 */
	public String[][]			aryPltStartHalfHoliday;
	/**
	 * 
	 */
	public String[][]			aryPltQuitHalfHoliday;
	/**
	 * 
	 */
	public String[][]			aryPltWorkOnHoliday;
	/**
	 * 
	 */
	public String[][]			aryPltLateReason;
	/**
	 * 
	 */
	public String[][]			aryPltLateCertificate;
	/**
	 * 
	 */
	public String[][]			aryPltLeaveEarlyReason;
	/**
	 * 
	 */
	public String[][]			aryPltLeaveEarlyCertificate;
	

	/**
	 * RXgN^
	 */
	public AttendanceCheckCardVo() {
		super();
		setViewPath(getClassName());
		setMode(MODE_EDIT);
		aryAllowance = new String[0][0];
		addAttendanceMenuCss();
		addAttendanceMenuJs();
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.NAM_CHECK_ATTENDANCE;
	}
	
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		NAM_START_TIME = CommonConst.NAM_START_TIME + CommonConst.NAM_TIME;
		NAM_START_TIME_HOUR = CommonConst.NAM_START_TIME + CommonConst.MSG_HOUR;
		NAM_START_TIME_MIN = CommonConst.NAM_START_TIME + CommonConst.MSG_MINUTES;
		NAM_WORKING_TYPE = CommonConst.NAM_WORKING_TYPE;
		NAM_START_HALF_HOLIDAY = CommonConst.NAM_START_TIME + CommonConst.NAM_VACATION_LEAVE_HALF
				+ CommonConst.NAM_COMMON_TYPE;
		NAM_WORK_ON_HOLIDAY = CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_TYPE;
		NAM_LATE_TIME = CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_COMMON_TIME;
		NAM_LATE_TIME_HOUR = NAM_LATE_TIME + CommonConst.MSG_HOUR;
		NAM_LATE_TIME_MIN = NAM_LATE_TIME + CommonConst.MSG_MINUTES;
		NAM_LATE_REASON = CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_REASON;
		NAM_LATE_CERTIFICATE = CommonConst.NAM_CERTIFICATE;
		NAM_LATE_COMMENT = CommonConst.NAM_COMMENT;
		NAM_QUIT_TIME = CommonConst.NAM_QUIT_TIME + CommonConst.NAM_TIME;
		NAM_QUIT_TIME_HOUR = NAM_QUIT_TIME + CommonConst.MSG_HOUR;
		NAM_QUIT_TIME_MIN = NAM_QUIT_TIME + CommonConst.MSG_MINUTES;
		NAM_QUIT_HALF_HOLIDAY = CommonConst.NAM_QUIT_TIME + CommonConst.NAM_VACATION_LEAVE_HALF
				+ CommonConst.NAM_COMMON_TYPE;
		NAM_WORKING_TIME = CommonConst.NAM_WORKING + CommonConst.NAM_COMMON_TIME;
		NAM_WORKING_TIME_HOUR = NAM_WORKING_TIME + CommonConst.MSG_HOUR;
		NAM_WORKING_TIME_MIN = NAM_WORKING_TIME + CommonConst.MSG_MINUTES;
		NAM_INTERVAL_TIME = CommonConst.NAM_INTERVAL_TIME + CommonConst.NAM_COMMON_TIME;
		NAM_INTERVAL_TIME_HOUR = NAM_INTERVAL_TIME + CommonConst.MSG_HOUR;
		NAM_INTERVAL_TIME_MIN = NAM_INTERVAL_TIME + CommonConst.MSG_MINUTES;
		NAM_ACTUAL_WORK_TIME = CommonConst.NAM_ACTUAL_WORK_TIME + CommonConst.NAM_COMMON_TIME;
		NAM_LEAVE_EARLY_REASON = CommonConst.NAM_LEAVE_EARLY + CommonConst.NAM_REASON;
		NAM_LEAVE_EARLY_TIME = CommonConst.NAM_LEAVE_EARLY + CommonConst.NAM_COMMON_TIME;
		NAM_LEAVE_EARLY_TIME_HOUR = NAM_LEAVE_EARLY_TIME + CommonConst.MSG_HOUR;
		NAM_LEAVE_EARLY_TIME_MIN = NAM_LEAVE_EARLY_TIME + CommonConst.MSG_MINUTES;
		NAM_LEAVE_EARLY_CERTIFICATE = CommonConst.NAM_CERTIFICATE;
		NAM_LEAVE_EARLY_COMMENT = CommonConst.NAM_COMMENT;
		NAM_OVER_TIME = CommonConst.NAM_OVERTIME + CommonConst.NAM_COMMON_TIME;
		NAM_OVER_TIME_HOUR = NAM_OVER_TIME + CommonConst.MSG_HOUR;
		NAM_OVER_TIME_MIN = NAM_OVER_TIME + CommonConst.MSG_MINUTES;
		NAM_WORK_ON_HOLIDAY_TIME = CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_TIME;
		NAM_WORK_ON_HOLIDAY_HOUR = NAM_WORK_ON_HOLIDAY_TIME + CommonConst.MSG_HOUR;
		NAM_WORK_ON_HOLIDAY_MIN = NAM_WORK_ON_HOLIDAY_TIME + CommonConst.MSG_MINUTES;
		NAM_LATE_NIGHT = CommonConst.NAM_LATE_NIGHT + CommonConst.NAM_COMMON_TIME;
		NAM_LATE_NIGHT_HOUR = NAM_LATE_NIGHT + CommonConst.MSG_HOUR;
		NAM_LATE_NIGHT_MIN = NAM_LATE_NIGHT + CommonConst.MSG_MINUTES;
		NAM_ALLOWANCE = CommonConst.NAM_ALLOWANCE;
		NAM_APPROVAL_COMMENT = CommonConst.NAM_APPROVED + CommonConst.NAM_COMMENT;
		LEN_HOUR = CommonConst.LEN_TIME_HOUR;
		LEN_MIN = CommonConst.LEN_TIME_MIN;
		LEN_COMMENT = 50;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		txtStartHour = request.getParameter(PRM_TXT_START_HOUR);
		txtStartMin = request.getParameter(PRM_TXT_START_MIN);
		pltWorkType = request.getParameter(PRM_PLT_WORK_TYPE);
		pltStartHalfHoliday = request.getParameter(PRM_PLT_START_HALF_HOLIDAY);
		pltWorkOnHoliday = request.getParameter(PRM_PLT_WORK_ON_HOLIDAY);
		txtLateHour = request.getParameter(PRM_TXT_LATE_HOUR);
		txtLateMin = request.getParameter(PRM_TXT_LATE_MIN);
		pltLateReason = request.getParameter(PRM_PLT_LATE_REASON);
		pltLateCertificate = request.getParameter(PRM_PLT_LATE_CERTIFICATE);
		txtLateComment = request.getParameter(PRM_TXT_LATE_COMMENT);
		txtQuitHour = request.getParameter(PRM_TXT_QUIT_HOUR);
		txtQuitMin = request.getParameter(PRM_TXT_QUIT_MIN);
		pltQuitHalfHoliday = request.getParameter(PRM_PLT_QUIT_HALF_HOLIDAY);
		txtWorkHour = request.getParameter(PRM_TXT_WORK_HOUR);
		txtWorkMin = request.getParameter(PRM_TXT_WORK_MIN);
		txtBreakHour = request.getParameter(PRM_TXT_BREAK_HOUR);
		txtBreakMin = request.getParameter(PRM_TXT_BREAK_MIN);
		pltLeaveEarlyReason = request.getParameter(PRM_PLT_LEAVE_EARLY_REASON);
		txtLeaveEarlyHour = request.getParameter(PRM_TXT_LEAVE_EARLY_HOUR);
		txtLeaveEarlyMin = request.getParameter(PRM_TXT_LEAVE_EARLY_MIN);
		pltLeaveEarlyCertificate = request.getParameter(PRM_PLT_LEAVE_EARLY_CERTIFICATE);
		txtLeaveEarlyComment = request.getParameter(PRM_TXT_LEAVE_EARLY_COMMENT);
		txtOverHour = request.getParameter(PRM_TXT_OVER_HOUR);
		txtOverMin = request.getParameter(PRM_TXT_OVER_MIN);
		txtWorkOnHolidayHour = request.getParameter(PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		txtWorkOnHolidayMin = request.getParameter(PRM_TXT_WORK_ON_HOLIDAY_MIN);
		txtLateNightHour = request.getParameter(PRM_TXT_LATE_NIGHT_HOUR);
		txtLateNightMin = request.getParameter(PRM_TXT_LATE_NIGHT_MIN);
		ckbSyokuji = getCheckBoxParam(request.getParameter(PRM_CKB_SYOKUJI));
		ckbCyoku1 = getCheckBoxParam(request.getParameter(PRM_CKB_CYOKU1));
		ckbCyoku2 = getCheckBoxParam(request.getParameter(PRM_CKB_CYOKU2));
		ckbCyoku3 = getCheckBoxParam(request.getParameter(PRM_CKB_CYOKU3));
		ckbHoka1 = getCheckBoxParam(request.getParameter(PRM_CKB_HOKA1));
		ckbHoka2 = getCheckBoxParam(request.getParameter(PRM_CKB_HOKA2));
		ckbHoka3 = getCheckBoxParam(request.getParameter(PRM_CKB_HOKA3));
		ckbHoka4 = getCheckBoxParam(request.getParameter(PRM_CKB_HOKA4));
		ckbHoka5 = getCheckBoxParam(request.getParameter(PRM_CKB_HOKA5));
	}
	
	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 */
	public void setFields(MSyukkinboDto dto) {
		txtStartHour = TimeUtil.convStringTimeToStringHour(dto.getSyJikoku());
		txtStartMin = TimeUtil.convStringTimeToStringMinutes(dto.getSyJikoku());
		pltWorkType = dto.getKinmu();
		pltStartHalfHoliday = dto.getSHankyuKb();
		pltWorkOnHoliday = dto.getKyusyuKb();
		txtLateHour = String.valueOf(TimeUtil.convIntegerTimeToStringHour(dto.getTiJikan()));
		txtLateMin = String.valueOf(TimeUtil.convIntegerTimeToStringMinutes(dto.getTiJikan()));
		pltLateReason = dto.getTiRiyuu();
		pltLateCertificate = dto.getTiSyoumei();
		txtLateComment = dto.getTiComent();
		txtQuitHour = TimeUtil.convStringTimeToStringHour(dto.getTaJikoku());
		txtQuitMin = TimeUtil.convStringTimeToStringMinutes(dto.getTaJikoku());
		pltQuitHalfHoliday = dto.getTHankyuKb();
		txtWorkHour = TimeUtil.convIntegerTimeToStringHour(dto.getKinmuJi());
		txtWorkMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getKinmuJi());
		txtBreakHour = TimeUtil.convIntegerTimeToStringHour(dto.getKyukeiJi());
		txtBreakMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getKyukeiJi());
		pltLeaveEarlyReason = dto.getSoRiyuu();
		txtLeaveEarlyHour = TimeUtil.convIntegerTimeToStringHour(dto.getSoJikan());
		txtLeaveEarlyMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getSoJikan());
		pltLeaveEarlyCertificate = dto.getSoSyoumei();
		txtLeaveEarlyComment = dto.getSoComent();
		txtOverHour = TimeUtil.convIntegerTimeToStringHour(dto.getZaJikan());
		txtOverMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getZaJikan());
		txtWorkOnHolidayHour = TimeUtil.convIntegerTimeToStringHour(dto.getKsJikan());
		txtWorkOnHolidayMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getKsJikan());
		txtLateNightHour = TimeUtil.convIntegerTimeToStringHour(dto.getSnJikan());
		txtLateNightMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getSnJikan());
		ckbSyokuji = String.valueOf(dto.getSyokuji());
		ckbCyoku1 = String.valueOf(dto.getCyoku1());
		ckbCyoku2 = String.valueOf(dto.getCyoku2());
		ckbCyoku3 = String.valueOf(dto.getCyoku3());
		ckbHoka1 = String.valueOf(dto.getHoka1());
		ckbHoka2 = String.valueOf(dto.getHoka2());
		ckbHoka3 = String.valueOf(dto.getHoka3());
		ckbHoka4 = String.valueOf(dto.getHoka4());
		ckbHoka5 = String.valueOf(dto.getHoka5());
	}
	
	@Override
	public void setDtoFields(MSyukkinboDto dto) {
		super.setDtoFields(dto);
		dto.setSyJikoku(TimeUtil.convStringTimeFormatted(txtStartHour, txtStartMin));
		dto.setKinmu(pltWorkType);
		dto.setSHankyuKb(pltStartHalfHoliday);
		dto.setKyusyuKb(pltWorkOnHoliday);
		dto.setTiJikan(TimeUtil.convStringTimeToIntegerTime(txtLateHour, txtLateMin));
		dto.setTiRiyuu(pltLateReason);
		dto.setTiSyoumei(pltLateCertificate);
		dto.setTiComent(txtLateComment);
		dto.setTaJikoku(TimeUtil.convStringTimeFormatted(txtQuitHour, txtQuitMin));
		dto.setTHankyuKb(pltQuitHalfHoliday);
		dto.setKinmuJi(TimeUtil.convStringTimeToIntegerTime(txtWorkHour, txtWorkMin));
		dto.setKyukeiJi(TimeUtil.convStringTimeToIntegerTime(txtBreakHour, txtBreakMin));
		dto.setSoRiyuu(pltLeaveEarlyReason);
		dto.setSoJikan(TimeUtil.convStringTimeToIntegerTime(txtLeaveEarlyHour, txtLeaveEarlyMin));
		dto.setSoSyoumei(pltLeaveEarlyCertificate);
		dto.setSoComent(txtLeaveEarlyComment);
		dto.setZaJikan(TimeUtil.convStringTimeToIntegerTime(txtOverHour, txtOverMin));
		dto.setKsJikan(TimeUtil.convStringTimeToIntegerTime(txtWorkOnHolidayHour, txtWorkOnHolidayMin));
		dto.setSnJikan(TimeUtil.convStringTimeToIntegerTime(txtLateNightHour, txtLateNightMin));
		dto.setSyokuji(Integer.parseInt(ckbSyokuji));
		dto.setCyoku1(Integer.parseInt(ckbCyoku1));
		dto.setCyoku2(Integer.parseInt(ckbCyoku2));
		dto.setCyoku3(Integer.parseInt(ckbCyoku3));
		dto.setHoka1(Integer.parseInt(ckbHoka1));
		dto.setHoka2(Integer.parseInt(ckbHoka2));
		dto.setHoka3(Integer.parseInt(ckbHoka3));
		dto.setHoka4(Integer.parseInt(ckbHoka4));
		dto.setHoka5(Integer.parseInt(ckbHoka5));
		dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
		dto.setUpdtTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
	}
	
	/**
	 * tB[h
	 */
	public void initFields() {
		Date nowDate = new Date();
		txtStartHour = String.valueOf(MospUtility.getHour(nowDate));
		txtStartMin = String.valueOf(MospUtility.getMinute(nowDate));
		pltWorkType = "";
		pltStartHalfHoliday = "";
		pltWorkOnHoliday = "";
		txtLateHour = "0";
		txtLateMin = "0";
		pltLateReason = "";
		pltLateCertificate = "";
		txtLateComment = "";
		txtQuitHour = String.valueOf(MospUtility.getHour(nowDate));
		txtQuitMin = String.valueOf(MospUtility.getMinute(nowDate));
		pltQuitHalfHoliday = "";
		txtWorkHour = "0";
		txtWorkMin = "0";
		txtBreakHour = "0";
		txtBreakMin = "0";
		pltLeaveEarlyReason = "";
		txtLeaveEarlyHour = "0";
		txtLeaveEarlyMin = "0";
		pltLeaveEarlyCertificate = "";
		txtLeaveEarlyComment = "";
		txtOverHour = "0";
		txtOverMin = "0";
		txtWorkOnHolidayHour = "0";
		txtWorkOnHolidayMin = "0";
		txtLateNightHour = "0";
		txtLateNightMin = "0";
		ckbSyokuji = "0";
		ckbCyoku1 = "0";
		ckbCyoku2 = "0";
		ckbCyoku3 = "0";
		ckbHoka1 = "0";
		ckbHoka2 = "0";
		ckbHoka3 = "0";
		ckbHoka4 = "0";
		ckbHoka5 = "0";
		lblApprovalComment = "";
	}
	
	/**
	 * x\ڃZbg
	 * @param dto	ΏDTO
	 */
	public void setLabelInfo(MSyukkinboDto dto) {
		// Ԃ̃Zbg
		//  = Ζ - xeԁicƋxeԊ܂ށj
		int actual = 0;
		if (dto.getKinmuJi() != 0) {
			actual = dto.getKinmuJi() - dto.getKyukeiJi();
		}
		setLblActualHour(TimeUtil.convIntegerTimeToStringHour(actual));
		setLblActualMin(TimeUtil.convIntegerTimeToStringMinutes(actual));
		lblApprovalComment = dto.getSnComent();
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtStartHour, NAM_START_TIME, PRM_TXT_START_HOUR);
		checkRequired(txtStartMin, NAM_START_TIME, PRM_TXT_START_MIN);
		checkRequired(txtLateHour, NAM_LATE_TIME, PRM_TXT_LATE_HOUR);
		checkRequired(txtLateMin, NAM_LATE_TIME, PRM_TXT_LATE_MIN);
		checkRequired(txtQuitHour, NAM_QUIT_TIME, PRM_TXT_QUIT_HOUR);
		checkRequired(txtQuitMin, NAM_QUIT_TIME, PRM_TXT_QUIT_MIN);
		checkRequired(txtWorkHour, NAM_WORKING_TIME, PRM_TXT_WORK_HOUR);
		checkRequired(txtWorkMin, NAM_WORKING_TIME, PRM_TXT_WORK_MIN);
		checkRequired(txtBreakHour, NAM_INTERVAL_TIME, PRM_TXT_BREAK_HOUR);
		checkRequired(txtBreakMin, NAM_INTERVAL_TIME, PRM_TXT_BREAK_MIN);
		checkRequired(txtLeaveEarlyHour, NAM_LEAVE_EARLY_TIME, PRM_TXT_LEAVE_EARLY_HOUR);
		checkRequired(txtLeaveEarlyMin, NAM_LEAVE_EARLY_TIME, PRM_TXT_LEAVE_EARLY_MIN);
		checkRequired(txtOverHour, NAM_OVER_TIME, PRM_TXT_OVER_HOUR);
		checkRequired(txtOverMin, NAM_OVER_TIME, PRM_TXT_OVER_MIN);
		checkRequired(txtWorkOnHolidayHour, NAM_WORK_ON_HOLIDAY, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkRequired(txtWorkOnHolidayMin, NAM_WORK_ON_HOLIDAY, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkRequired(txtLateNightHour, NAM_LATE_NIGHT, PRM_TXT_LATE_NIGHT_HOUR);
		checkRequired(txtLateNightMin, NAM_LATE_NIGHT, PRM_TXT_LATE_NIGHT_MIN);
		// mF
		checkNumber(txtStartHour, NAM_START_TIME, PRM_TXT_START_HOUR);
		checkNumber(txtStartMin, NAM_START_TIME, PRM_TXT_START_MIN);
		checkNumber(txtLateHour, NAM_LATE_TIME, PRM_TXT_LATE_HOUR);
		checkNumber(txtLateMin, NAM_LATE_TIME, PRM_TXT_LATE_MIN);
		checkNumber(txtQuitHour, NAM_QUIT_TIME, PRM_TXT_QUIT_HOUR);
		checkNumber(txtQuitMin, NAM_QUIT_TIME, PRM_TXT_QUIT_MIN);
		checkNumber(txtWorkHour, NAM_WORKING_TIME, PRM_TXT_WORK_HOUR);
		checkNumber(txtWorkMin, NAM_WORKING_TIME, PRM_TXT_WORK_MIN);
		checkNumber(txtBreakHour, NAM_INTERVAL_TIME, PRM_TXT_BREAK_HOUR);
		checkNumber(txtBreakMin, NAM_INTERVAL_TIME, PRM_TXT_BREAK_MIN);
		checkNumber(txtLeaveEarlyHour, NAM_LEAVE_EARLY_TIME, PRM_TXT_LEAVE_EARLY_HOUR);
		checkNumber(txtLeaveEarlyMin, NAM_LEAVE_EARLY_TIME, PRM_TXT_LEAVE_EARLY_MIN);
		checkNumber(txtOverHour, NAM_OVER_TIME, PRM_TXT_OVER_HOUR);
		checkNumber(txtOverMin, NAM_OVER_TIME, PRM_TXT_OVER_MIN);
		checkNumber(txtWorkOnHolidayHour, NAM_WORK_ON_HOLIDAY, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkNumber(txtWorkOnHolidayMin, NAM_WORK_ON_HOLIDAY, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkNumber(txtLateNightHour, NAM_LATE_NIGHT, PRM_TXT_LATE_NIGHT_HOUR);
		checkNumber(txtLateNightMin, NAM_LATE_NIGHT, PRM_TXT_LATE_NIGHT_MIN);
		// mF	
		checkLength(txtStartHour, LEN_HOUR, NAM_START_TIME, PRM_TXT_START_HOUR);
		checkLength(txtStartMin, LEN_MIN, NAM_START_TIME, PRM_TXT_START_MIN);
		checkLength(txtLateHour, LEN_HOUR, NAM_LATE_TIME, PRM_TXT_LATE_HOUR);
		checkLength(txtLateMin, LEN_MIN, NAM_LATE_TIME, PRM_TXT_LATE_MIN);
		checkLength(txtLateComment, LEN_COMMENT, NAM_LATE_COMMENT, PRM_TXT_LATE_COMMENT);
		checkLength(txtQuitHour, LEN_HOUR, NAM_QUIT_TIME, PRM_TXT_QUIT_HOUR);
		checkLength(txtQuitMin, LEN_MIN, NAM_QUIT_TIME, PRM_TXT_QUIT_MIN);
		checkLength(txtWorkHour, LEN_HOUR, NAM_WORKING_TIME, PRM_TXT_WORK_HOUR);
		checkLength(txtWorkMin, LEN_MIN, NAM_WORKING_TIME, PRM_TXT_WORK_MIN);
		checkLength(txtBreakHour, LEN_HOUR, NAM_INTERVAL_TIME, PRM_TXT_BREAK_HOUR);
		checkLength(txtBreakMin, LEN_MIN, NAM_INTERVAL_TIME, PRM_TXT_BREAK_MIN);
		checkLength(txtLeaveEarlyHour, LEN_HOUR, NAM_LEAVE_EARLY_TIME, PRM_TXT_LEAVE_EARLY_HOUR);
		checkLength(txtLeaveEarlyMin, LEN_MIN, NAM_LEAVE_EARLY_TIME, PRM_TXT_LEAVE_EARLY_MIN);
		checkLength(txtOverHour, LEN_HOUR, NAM_OVER_TIME, PRM_TXT_OVER_HOUR);
		checkLength(txtOverMin, LEN_MIN, NAM_OVER_TIME, PRM_TXT_OVER_MIN);
		checkLength(txtWorkOnHolidayHour, LEN_HOUR, NAM_WORK_ON_HOLIDAY, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkLength(txtWorkOnHolidayMin, LEN_MIN, NAM_WORK_ON_HOLIDAY, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkLength(txtLateNightHour, LEN_HOUR, NAM_LATE_NIGHT, PRM_TXT_LATE_NIGHT_HOUR);
		checkLength(txtLateNightMin, LEN_MIN, NAM_LATE_NIGHT, PRM_TXT_LATE_NIGHT_MIN);
		checkLength(txtLeaveEarlyComment, LEN_COMMENT, NAM_LEAVE_EARLY_COMMENT, PRM_TXT_LEAVE_EARLY_COMMENT);
		// ÓmFI
		endValidation();
	}
	
	/**
	 * @return txtStartHour
	 */
	public String getTxtStartHour() {
		return txtStartHour;
	}
	
	/**
	 * @return txtStartMin
	 */
	public String getTxtStartMin() {
		return txtStartMin;
	}
	
	/**
	 * @return pltWorkType
	 */
	public String getPltWorkType() {
		return pltWorkType;
	}
	
	/**
	 * @return pltStartHalfHoliday
	 */
	public String getPltStartHalfHoliday() {
		return pltStartHalfHoliday;
	}
	
	/**
	 * @return pltWorkOnHoliday
	 */
	public String getPltWorkOnHoliday() {
		return pltWorkOnHoliday;
	}
	
	/**
	 * @return txtLateHour
	 */
	public String getTxtLateHour() {
		return txtLateHour;
	}
	
	/**
	 * @return txtLateMin
	 */
	public String getTxtLateMin() {
		return txtLateMin;
	}
	
	/**
	 * @return pltLateReason
	 */
	public String getPltLateReason() {
		return pltLateReason;
	}
	
	/**
	 * @return pltLateCertificate
	 */
	public String getPltLateCertificate() {
		return pltLateCertificate;
	}
	
	/**
	 * @return txtLateComment
	 */
	public String getTxtLateComment() {
		return txtLateComment;
	}
	
	/**
	 * @return txtQuitHour
	 */
	public String getTxtQuitHour() {
		return txtQuitHour;
	}
	
	/**
	 * @return txtQuitMin
	 */
	public String getTxtQuitMin() {
		return txtQuitMin;
	}
	
	/**
	 * @return pltQuitHalfHoliday
	 */
	public String getPltQuitHalfHoliday() {
		return pltQuitHalfHoliday;
	}
	
	/**
	 * @return txtWorkHour
	 */
	public String getTxtWorkHour() {
		return txtWorkHour;
	}
	
	/**
	 * @return txtWorkMin
	 */
	public String getTxtWorkMin() {
		return txtWorkMin;
	}
	
	/**
	 * @return txtBreakHour
	 */
	public String getTxtBreakHour() {
		return txtBreakHour;
	}
	
	/**
	 * @return txtBreakMin
	 */
	public String getTxtBreakMin() {
		return txtBreakMin;
	}
	
	/**
	 * @return lblActualHour
	 */
	public String getLblActualHour() {
		return lblActualHour;
	}
	
	/**
	 * @return lblActualMin
	 */
	public String getLblActualMin() {
		return lblActualMin;
	}
	
	/**
	 * @return pltLeaveEarlyReason
	 */
	public String getPltLeaveEarlyReason() {
		return pltLeaveEarlyReason;
	}
	
	/**
	 * @return txtLeaveEarlyHour
	 */
	public String getTxtLeaveEarlyHour() {
		return txtLeaveEarlyHour;
	}
	
	/**
	 * @return txtLeaveEarlyMin
	 */
	public String getTxtLeaveEarlyMin() {
		return txtLeaveEarlyMin;
	}
	
	/**
	 * @return pltLeaveEarlyCertificate
	 */
	public String getPltLeaveEarlyCertificate() {
		return pltLeaveEarlyCertificate;
	}
	
	/**
	 * @return txtLeaveEarlyComment
	 */
	public String getTxtLeaveEarlyComment() {
		return txtLeaveEarlyComment;
	}
	
	/**
	 * @return txtOverHour
	 */
	public String getTxtOverHour() {
		return txtOverHour;
	}
	
	/**
	 * @return txtOverMin
	 */
	public String getTxtOverMin() {
		return txtOverMin;
	}
	
	/**
	 * @return txtWorkOnHolidayHour
	 */
	public String getTxtWorkOnHolidayHour() {
		return txtWorkOnHolidayHour;
	}
	
	/**
	 * @return txtWorkOnHolidayMin
	 */
	public String getTxtWorkOnHolidayMin() {
		return txtWorkOnHolidayMin;
	}
	
	/**
	 * @return txtLateNightHour
	 */
	public String getTxtLateNightHour() {
		return txtLateNightHour;
	}
	
	/**
	 * @return txtLateNightMin
	 */
	public String getTxtLateNightMin() {
		return txtLateNightMin;
	}
	
	/**
	 * @return ckbSyokuji
	 */
	public String getCkbSyokuji() {
		return ckbSyokuji;
	}
	
	/**
	 * @return ckbCyoku1
	 */
	public String getCkbCyoku1() {
		return ckbCyoku1;
	}
	
	/**
	 * @return ckbCyoku2
	 */
	public String getCkbCyoku2() {
		return ckbCyoku2;
	}
	
	/**
	 * @return ckbCyoku3
	 */
	public String getCkbCyoku3() {
		return ckbCyoku3;
	}
	
	/**
	 * @return ckbHoka1
	 */
	public String getCkbHoka1() {
		return ckbHoka1;
	}
	
	/**
	 * @return ckbHoka2
	 */
	public String getCkbHoka2() {
		return ckbHoka2;
	}
	
	/**
	 * @return ckbHoka3
	 */
	public String getCkbHoka3() {
		return ckbHoka3;
	}
	
	/**
	 * @return ckbHoka4
	 */
	public String getCkbHoka4() {
		return ckbHoka4;
	}
	
	/**
	 * @return ckbHoka5
	 */
	public String getCkbHoka5() {
		return ckbHoka5;
	}
	
	/**
	 * @return lblApprovalComment
	 */
	public String getLblApprovalComment() {
		return lblApprovalComment;
	}
	
	/**
	 * @return aryAllowance
	 */
	public String[][] getAryAllowance() {
		return aryAllowance.clone();
	}
	
	/**
	 * @param txtStartHour Zbg txtStartHour
	 */
	public void setTxtStartHour(String txtStartHour) {
		this.txtStartHour = txtStartHour;
	}
	
	/**
	 * @param txtStartMin Zbg txtStartMin
	 */
	public void setTxtStartMin(String txtStartMin) {
		this.txtStartMin = txtStartMin;
	}
	
	/**
	 * @param pltWorkType Zbg pltWorkType
	 */
	public void setPltWorkType(String pltWorkType) {
		this.pltWorkType = pltWorkType;
	}
	
	/**
	 * @param pltStartHalfHoliday Zbg pltStartHalfHoliday
	 */
	public void setPltStartHalfHoliday(String pltStartHalfHoliday) {
		this.pltStartHalfHoliday = pltStartHalfHoliday;
	}
	
	/**
	 * @param pltWorkOnHoliday Zbg pltWorkOnHoliday
	 */
	public void setPltWorkOnHoliday(String pltWorkOnHoliday) {
		this.pltWorkOnHoliday = pltWorkOnHoliday;
	}
	
	/**
	 * @param txtLateHour Zbg txtLateHour
	 */
	public void setTxtLateHour(String txtLateHour) {
		this.txtLateHour = txtLateHour;
	}
	
	/**
	 * @param txtLateMin Zbg txtLateMin
	 */
	public void setTxtLateMin(String txtLateMin) {
		this.txtLateMin = txtLateMin;
	}
	
	/**
	 * @param pltLateReason Zbg pltLateReason
	 */
	public void setPltLateReason(String pltLateReason) {
		this.pltLateReason = pltLateReason;
	}
	
	/**
	 * @param pltLateCertificate Zbg pltLateCertificate
	 */
	public void setPltLateCertificate(String pltLateCertificate) {
		this.pltLateCertificate = pltLateCertificate;
	}
	
	/**
	 * @param txtLateComment Zbg txtLateComment
	 */
	public void setTxtLateComment(String txtLateComment) {
		this.txtLateComment = txtLateComment;
	}
	
	/**
	 * @param txtQuitHour Zbg txtQuitHour
	 */
	public void setTxtQuitHour(String txtQuitHour) {
		this.txtQuitHour = txtQuitHour;
	}
	
	/**
	 * @param txtQuitMin Zbg txtQuitMin
	 */
	public void setTxtQuitMin(String txtQuitMin) {
		this.txtQuitMin = txtQuitMin;
	}
	
	/**
	 * @param pltQuitHalfHoliday Zbg pltQuitHalfHoliday
	 */
	public void setPltQuitHalfHoliday(String pltQuitHalfHoliday) {
		this.pltQuitHalfHoliday = pltQuitHalfHoliday;
	}
	
	/**
	 * @param txtWorkHour Zbg txtWorkHour
	 */
	public void setTxtWorkHour(String txtWorkHour) {
		this.txtWorkHour = txtWorkHour;
	}
	
	/**
	 * @param txtWorkMin Zbg txtWorkMin
	 */
	public void setTxtWorkMin(String txtWorkMin) {
		this.txtWorkMin = txtWorkMin;
	}
	
	/**
	 * @param txtBreakHour Zbg txtBreakHour
	 */
	public void setTxtBreakHour(String txtBreakHour) {
		this.txtBreakHour = txtBreakHour;
	}
	
	/**
	 * @param txtBreakMin Zbg txtBreakMin
	 */
	public void setTxtBreakMin(String txtBreakMin) {
		this.txtBreakMin = txtBreakMin;
	}
	
	/**
	 * @param lblActualHour Zbg lblActualHour
	 */
	public void setLblActualHour(String lblActualHour) {
		this.lblActualHour = lblActualHour;
	}
	
	/**
	 * @param lblActualMin Zbg lblActualMin
	 */
	public void setLblActualMin(String lblActualMin) {
		this.lblActualMin = lblActualMin;
	}
	
	/**
	 * @param pltLeaveEarlyReason Zbg pltLeaveEarlyReason
	 */
	public void setPltLeaveEarlyReason(String pltLeaveEarlyReason) {
		this.pltLeaveEarlyReason = pltLeaveEarlyReason;
	}
	
	/**
	 * @param txtLeaveEarlyHour Zbg txtLeaveEarlyHour
	 */
	public void setTxtLeaveEarlyHour(String txtLeaveEarlyHour) {
		this.txtLeaveEarlyHour = txtLeaveEarlyHour;
	}
	
	/**
	 * @param txtLeaveEarlyMin Zbg txtLeaveEarlyMin
	 */
	public void setTxtLeaveEarlyMin(String txtLeaveEarlyMin) {
		this.txtLeaveEarlyMin = txtLeaveEarlyMin;
	}
	
	/**
	 * @param pltLeaveEarlyCertificate Zbg pltLeaveEarlyCertificate
	 */
	public void setPltLeaveEarlyCertificate(String pltLeaveEarlyCertificate) {
		this.pltLeaveEarlyCertificate = pltLeaveEarlyCertificate;
	}
	
	/**
	 * @param txtLeaveEarlyComment Zbg txtLeaveEarlyComment
	 */
	public void setTxtLeaveEarlyComment(String txtLeaveEarlyComment) {
		this.txtLeaveEarlyComment = txtLeaveEarlyComment;
	}
	
	/**
	 * @param txtOverHour Zbg txtOverHour
	 */
	public void setTxtOverHour(String txtOverHour) {
		this.txtOverHour = txtOverHour;
	}
	
	/**
	 * @param txtOverMin Zbg txtOverMin
	 */
	public void setTxtOverMin(String txtOverMin) {
		this.txtOverMin = txtOverMin;
	}
	
	/**
	 * @param txtWorkOnHolidayHour Zbg txtWorkOnHolidayHour
	 */
	public void setTxtWorkOnHolidayHour(String txtWorkOnHolidayHour) {
		this.txtWorkOnHolidayHour = txtWorkOnHolidayHour;
	}
	
	/**
	 * @param txtWorkOnHolidayMin Zbg txtWorkOnHolidayMin
	 */
	public void setTxtWorkOnHolidayMin(String txtWorkOnHolidayMin) {
		this.txtWorkOnHolidayMin = txtWorkOnHolidayMin;
	}
	
	/**
	 * @param txtLateNightHour Zbg txtLateNightHour
	 */
	public void setTxtLateNightHour(String txtLateNightHour) {
		this.txtLateNightHour = txtLateNightHour;
	}
	
	/**
	 * @param txtLateNightMin Zbg txtLateNightMin
	 */
	public void setTxtLateNightMin(String txtLateNightMin) {
		this.txtLateNightMin = txtLateNightMin;
	}
	
	/**
	 * @param ckbSyokuji Zbg ckbSyokuji
	 */
	public void setCkbSyokuji(String ckbSyokuji) {
		this.ckbSyokuji = ckbSyokuji;
	}
	
	/**
	 * @param ckbCyoku1 Zbg ckbCyoku1
	 */
	public void setCkbCyoku1(String ckbCyoku1) {
		this.ckbCyoku1 = ckbCyoku1;
	}
	
	/**
	 * @param ckbCyoku2 Zbg ckbCyoku2
	 */
	public void setCkbCyoku2(String ckbCyoku2) {
		this.ckbCyoku2 = ckbCyoku2;
	}
	
	/**
	 * @param ckbCyoku3 Zbg ckbCyoku3
	 */
	public void setCkbCyoku3(String ckbCyoku3) {
		this.ckbCyoku3 = ckbCyoku3;
	}
	
	/**
	 * @param ckbHoka1 Zbg ckbHoka1
	 */
	public void setCkbHoka1(String ckbHoka1) {
		this.ckbHoka1 = ckbHoka1;
	}
	
	/**
	 * @param ckbHoka2 Zbg ckbHoka2
	 */
	public void setCkbHoka2(String ckbHoka2) {
		this.ckbHoka2 = ckbHoka2;
	}
	
	/**
	 * @param ckbHoka3 Zbg ckbHoka3
	 */
	public void setCkbHoka3(String ckbHoka3) {
		this.ckbHoka3 = ckbHoka3;
	}
	
	/**
	 * @param ckbHoka4 Zbg ckbHoka4
	 */
	public void setCkbHoka4(String ckbHoka4) {
		this.ckbHoka4 = ckbHoka4;
	}
	
	/**
	 * @param ckbHoka5 Zbg ckbHoka5
	 */
	public void setCkbHoka5(String ckbHoka5) {
		this.ckbHoka5 = ckbHoka5;
	}
	
	/**
	 * @param lblApprovalComment Zbg lblApprovalComment
	 */
	public void setLblApprovalComment(String lblApprovalComment) {
		this.lblApprovalComment = lblApprovalComment;
	}
	
	/**
	 * @param aryAllowance Zbg aryAllowance
	 */
	public void setAryAllowance(String[][] aryAllowance) {
		this.aryAllowance = aryAllowance.clone();
	}
	
}
