/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.kintai.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.kintai.vo.AttendanceStartCardVo;
import jp.mosp.kintai.schedule.dto.MScheduleDto;

/**
 * @author yoshida
 *
 */
public class AttendanceStartCardAction extends MosPWorkflowAction {
	
	// R}h
	/**
	 * K1100
	 */
	public static final String	CMD_START_CARD_SHOW			= "K1100";
	private static final String	CMD_START_CARD_REGIST		= "K1102";
	private static final String	CMD_START_CARD_DELETE		= "K1103";
	private static final String	CMD_START_CARD_DRAFT		= "K1104";
	private static final String	CMD_START_CARD_REFLECT		= "K1105";
	private static final String	CMD_START_CARD_CALCULATE	= "K1106";
	

	/**
	 * RXgN^
	 */
	public AttendanceStartCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_START_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_START_CARD_REGIST)) {
			// o^
			regist(false);
		} else if (cmd.equals(CMD_START_CARD_DELETE)) {
			// 폜
			delete();
		} else if (CMD_START_CARD_DRAFT.equals(cmd)) {
			// 
			regist(true);
		} else if (CMD_START_CARD_REFLECT.equals(cmd)) {
			// \̔f
			reflect();
		} else if (CMD_START_CARD_CALCULATE.equals(cmd)) {
			// Wv
			runCalc();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceStartCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		AttendanceStartCardVo vo = (AttendanceStartCardVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// Ζ`ԃv_E
		vo.aryPltWorkType = part().worktype().getWorkTypeInfoArrayWithHoliday();
		// oΎx敪v_E
		vo.aryPltHalfHoliday = getHalfHolidayArray();
		// xo敪v_E
		vo.aryPltWorkOnHoliday = getMosPCodeArray(CommonConst.TID_WORK_ON_HOLIDAY_TYPE);
		// xRv_E
		vo.aryPltLateReason = getReasonCodeArray(CommonConst.TID_LATE_REASON);
		// xؖv_E
		vo.aryPltLateCertificate = getMosPCodeArray(CommonConst.TID_LATE_CERTIFICATE);
		// ΑӊǗR}h
		setSubTitleMenu();
	}
	
	@Override
	protected void show() throws Exception {
		AttendanceStartCardVo vo = (AttendanceStartCardVo)getVo();
		// \ڂ̏
		vo.initFields();
		// \Ao^̏
		setAttendanceInfo();
		// cƐ\ݒ
		setOverTimeRequestInfo();
		// Αӌ
		MSyukkinboDto dto = kintai().getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate(), false);
		if (VariousUtil.isNotNull(dto)) {
			// VOɏݒ
			vo.setFields(dto);
			if (!KintaiApprovalPart.isDraft(dto)) {
				vo.setDraft(false);
			}
		}
		// \[h̃Zbg
		setMode(dto);
	}
	
	/**
	 * oΓo^
	 * @param isDraft		tO
	 * @throws Exception	Oꍇ
	 */
	private void regist(boolean isDraft) throws Exception {
		AttendanceStartCardVo vo = (AttendanceStartCardVo)getVo();
		vo.setParams(request);
		String kCode = vo.getHidKCode();
		Date targetDate = DateUtil.convStringDateToDate(vo.getHidDate());
		// Αӌ
		MSyukkinboDto dto = kintai().getSyukkinboInfo(kCode, targetDate, true);
		if (VariousUtil.isNull(dto)) {
			// VKo^
			dto = new MSyukkinboDto();
			// Tx̏ꍇ
			if (KintaiCommonPart.isWeekHoliday(vo.getPltWorkType())) {
				setWeekHolidayDtoFields(dto);
			} else if (KintaiCommonPart.isOfficialHoliday(vo.getPltWorkType())) {
				// @x
				setOfficialHolidayDtoFields(dto);
			} else {
				vo.setDtoFields(dto);
			}
			dto.setSyozoku(getBelongSectionCode(kCode));
			// f
			if (isDraft) {
				dto.setSnRiyuu(CommonConst.CODE_DRAFT);
			}
			// ݃`FbN
			chkDuplicate(kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke(), false));
			// TxA@x̏ꍇ
			if (KintaiCommonPart.isWeekHoliday(dto) || KintaiCommonPart.isOfficialHoliday(dto)) {
				// vZ
				runAutoStartCalc(dto);
				// o^
				syukkinboDao().insert(dto);
				// bZ[Wݒ
				setMessage(getMessage(MospConst.MSG_INSERT, ""));
			} else {
				boolean insertFlag = true;
				// x̏ꍇAc`FbNB
				if (KintaiCommonPart.isStartHalfHoliday(dto)) {
					if (!part().holidayRequest().isApprovedPaidHolidayRequestStartHalf(dto)) {
						insertFlag = checkRemainPaidHoliday(kCode, targetDate, CommonConst.NUM_HALF_DAY, 0);
					}
				}
				// ԊOx()̏ꍇAc`FbNB
				if (part().mospcode().useSubstituteHolidayFunction() && KintaiCommonPart.isOverTimeSubHolidayStart(dto)) {
					if (!part().holidayRequest().isApprovedSubstituteHolidayRequestStartHalf(dto)) {
						insertFlag = checkRemainSubstitute(kCode, targetDate, CommonConst.NUM_HALF_DAY);
					}
				}
				if (insertFlag) {
					// vZ
					runAutoStartCalc(dto);
					// ߑOx̏FꍇAf
					margeHolidayRequest(dto);
					// o^io΍ڂ̂݁j
					syukkinboDao().insertStart(dto);
					// bZ[Wݒ
					setMessage(getMessage(MospConst.MSG_INSERT, ""));
				}
			}
		} else {
			// Fς݂̏ꍇ̓bZ[W\Ao^s
			if (KintaiApprovalPart.isApproved(dto)) {
				// bZ[Wݒ
				setMessage(getMessage(CommonConst.MSG_ALREADY_APPROVED, getMessageDate(dto)));
			} else {
				// rmF
				chkExclusive(dto, kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke(), true));
				// UPDATE
				vo.setDtoFields(dto);
				// f
				if (isDraft) {
					dto.setSnRiyuu(CommonConst.CODE_DRAFT);
				}
				boolean updateFlag = true;
				// x̏ꍇAc`FbNB
				if (KintaiCommonPart.isStartHalfHoliday(dto)) {
					if (!part().holidayRequest().isApprovedPaidHolidayRequestStartHalf(dto)) {
						updateFlag = checkRemainPaidHoliday(kCode, targetDate, CommonConst.NUM_HALF_DAY, 0);
					}
				}
				// ԊOx()̏ꍇAc`FbNB
				if (part().mospcode().useSubstituteHolidayFunction() && KintaiCommonPart.isOverTimeSubHolidayStart(dto)) {
					if (!part().holidayRequest().isApprovedSubstituteHolidayRequestStartHalf(dto)) {
						updateFlag = checkRemainSubstitute(kCode, targetDate, CommonConst.NUM_HALF_DAY);
					}
				}
				if (updateFlag) {
					// vZ
					runAutoStartCalc(dto);
					// ߑOxAԒPʂ̔Nx̏FꍇAf
					margeHolidayRequest(dto);
					// XVio΍ڂ̂݁j
					syukkinboDao().updateStart(dto);
					// bZ[Wݒ
					setMessage(getMessage(MospConst.MSG_UPDATE, ""));
				}
			}
		}
		// R~bg
		commit();
		// Αӈꗗ֑J
		setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
	}
	
	/**
	 * \̔f
	 * @throws Exception	Oꍇ
	 */
	private void reflect() throws Exception {
		AttendanceStartCardVo vo = (AttendanceStartCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		String kCode = vo.getHidKCode();
		String strTargetDate = vo.getHidDate();
		MScheduleDto dto = kintai().getScheduleInfo(kCode, strTargetDate);
		if (VariousUtil.isNull(dto)) {
			dto = kintai().createScheduleInfo(getBasisInfo(kCode), DateUtil.convStringDateToDate(strTargetDate),
					vo.getPltWorkType());
		}
		if (KintaiCommonPart.isAvailableWorkType(dto)) {
			// xɐ\ƃ}[W
			margeHolidayRequest(dto);
		}
		// VOɏݒ
		vo.setFields(KintaiCommonPart.copyToSyukkinbo(dto));
	}
	
	/**
	 * Wv
	 * @throws Exception	Oꍇ
	 */
	private void runCalc() throws Exception {
		AttendanceStartCardVo vo = (AttendanceStartCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		MSyukkinboDto dto = new MSyukkinboDto();
		vo.setDtoFields(dto);
		// Αӏݒ
		setCalcParam();
		if (KintaiCommonPart.isWeekHoliday(dto)) {
			vo.initFields();
			// Tx̏ꍇ
			dto.setKinmu(CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
		} else if (KintaiCommonPart.isOfficialHoliday(dto)) {
			vo.initFields();
			// @x
			dto.setKinmu(CommonConst.ATTENDANCE_TYPE_OFFICIAL_HOLIDAY);
		} else {
			kintai().runStartCalculate(dto);
		}
		// VOɏݒ
		vo.setFields(dto);
	}
	
	/**
	 * vZ\bh
	 * @param dto	ΏDTO
	 * @throws Exception	Oꍇ
	 */
	private void runAutoStartCalc(MSyukkinboDto dto) throws Exception {
		// Αӏݒ
		setCalcParam();
		// vZtOL芎TxȊÔ݁AΖ`ԂxԂvZ
		// vZtO
		if (isDailyAutoCalc && KintaiCommonPart.isAvailableWorkType(dto)) {
			// o΍ڂ̌vZ
			kintai().runStartCalculate(dto);
		}
	}
	
	/**
	 * tB[hݒiTxpj
	 * @param dto	ΏDTO
	 */
	private void setWeekHolidayDtoFields(MSyukkinboDto dto) {
		AttendanceStartCardVo vo = (AttendanceStartCardVo)getVo();
		dto.setKCode(vo.getHidKCode());
		dto.setHizuke(DateUtil.convStringDateFormatted(vo.getHidYear(), vo.getHidMonth(), vo.getHidDay()));
		dto.setNen(Integer.parseInt(vo.getHidYear()));
		dto.setTuki(Integer.parseInt(vo.getHidMonth()));
		dto.setHi(Integer.parseInt(vo.getHidDay()));
		dto.setKinmu(CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
		dto.setSyJikoku("");
		dto.setTaJikoku("");
		dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
		dto.setUpdtTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
	}
	
	/**
	 * tB[hݒi@xpj
	 * @param dto	ΏDTO
	 */
	private void setOfficialHolidayDtoFields(MSyukkinboDto dto) {
		AttendanceStartCardVo vo = (AttendanceStartCardVo)getVo();
		dto.setKCode(vo.getHidKCode());
		dto.setHizuke(DateUtil.convStringDateFormatted(vo.getHidYear(), vo.getHidMonth(), vo.getHidDay()));
		dto.setNen(Integer.parseInt(vo.getHidYear()));
		dto.setTuki(Integer.parseInt(vo.getHidMonth()));
		dto.setHi(Integer.parseInt(vo.getHidDay()));
		dto.setKinmu(CommonConst.ATTENDANCE_TYPE_OFFICIAL_HOLIDAY);
		dto.setSyJikoku("");
		dto.setTaJikoku("");
		dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
		dto.setUpdtTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
	}
	
}
