/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.kintai.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.kintai.vo.AttendanceCheckCardVo;

/**
 * @author yoshida
 *
 */
public class AttendanceCheckCardAction extends MosPWorkflowAction {
	
	// R}h
	/**
	 * 
	 */
	public static final String	CMD_CHECK_CARD_SELECT		= "K1121";
	private static final String	CMD_CHECK_CARD_REGIST		= "K1122";
	private static final String	CMD_CHECK_CARD_DELETE		= "K1123";
	private static final String	CMD_CHECK_CARD_DRAFT		= "K1124";
	private static final String	CMD_CHECK_CARD_CALCULATE	= "K1126";
	

	/**
	 * RXgN^
	 */
	public AttendanceCheckCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_CHECK_CARD_SELECT)) {
			// I
			select();
		} else if (cmd.equals(CMD_CHECK_CARD_REGIST)) {
			// o^
			regist(false);
		} else if (cmd.equals(CMD_CHECK_CARD_DELETE)) {
			// 폜
			delete();
		} else if (CMD_CHECK_CARD_DRAFT.equals(cmd)) {
			// 
			regist(true);
		} else if (CMD_CHECK_CARD_CALCULATE.equals(cmd)) {
			// Wv
			runCalc();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceCheckCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		AttendanceCheckCardVo vo = (AttendanceCheckCardVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// 蓖ꗗ
		vo.setAryAllowance(getMosPCodeArray(CommonConst.TID_ALLOWANCE_NAME));
		// Ζ`ԃv_E
		vo.aryPltWorkType = part().worktype().getWorkTypeInfoArrayWithHoliday();
		// xo敪v_E
		vo.aryPltWorkOnHoliday = getMosPCodeArray(CommonConst.TID_WORK_ON_HOLIDAY_TYPE);
		// oΎx敪v_E
		vo.aryPltStartHalfHoliday = getHalfHolidayArray();
		// xRv_E
		vo.aryPltLateReason = getReasonCodeArray(CommonConst.TID_LATE_REASON);
		// xؖv_E
		vo.aryPltLateCertificate = getMosPCodeArray(CommonConst.TID_LATE_CERTIFICATE);
		// ދΎx敪v_E
		vo.aryPltQuitHalfHoliday = getHalfHolidayArray();
		// ޗRv_E
		vo.aryPltLeaveEarlyReason = getReasonCodeArray(CommonConst.TID_LEAVE_EARLY_REASON);
		// ޏؖv_E
		vo.aryPltLeaveEarlyCertificate = getMosPCodeArray(CommonConst.TID_LEAVE_EARLY_CERTIFICATE);
		// ΑӊǗR}h
		setSubTitleMenu();
	}
	
	@Override
	protected void select() throws Exception {
		AttendanceCheckCardVo vo = (AttendanceCheckCardVo)getVo();
		// \̏
		setAttendanceInfo();
		// Αӌ
		MSyukkinboDto dto = kintai().getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate(), false);
		chkExist(dto);
		// VOɏݒ
		vo.setFields(dto);
		// f
		vo.setDraft(true);
		if (!KintaiApprovalPart.isDraft(dto)) {
			vo.setDraft(false);
		}
		// \[h̃Zbg
		setMode(dto);
		// x\̃Zbg
		vo.setLabelInfo(dto);
		// ԊOxΉ
		setOverTimeCaution(vo.getHidKCode(), DateUtil.convStringDateToDate(vo.getHidDate()));
	}
	
	/**
	 * Αӓo^
	 * @param isDraft	tO
	 * @throws Exception	Oꍇ
	 */
	private void regist(boolean isDraft) throws Exception {
		AttendanceCheckCardVo vo = (AttendanceCheckCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		MSyukkinboDto dto = kintai().getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate(), true);
		if (VariousUtil.isNull(dto)) {
			// Αӈꗗ֖߂(ΑӃf[^ꍇ)
			String errMessage = getMessage(CommonConst.MSG_NO_ATTENDANCE, "");
			addErrMessage(errMessage);
			setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
			throw new MospException(CommonConst.EX_NO_ATTENDANCE, errMessage);
		} else {
			// Fς݂̏ꍇ̓bZ[W\Ao^s
			if (KintaiApprovalPart.isApproved(dto)) {
				// bZ[Wݒ
				setMessage(getMessage(CommonConst.MSG_ALREADY_APPROVED, getMessageDate(dto)));
			} else {
				// UPDATE
				// rmF
				chkExclusive(dto, kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke(), true));
				// VO̒lZbg
				vo.setDtoFields(dto);
				// f
				if (isDraft) {
					dto.setSnRiyuu(CommonConst.CODE_DRAFT);
				}
				boolean startFlag = true;
				boolean quitFlag = true;
				Date targetDate = DateUtil.convStringDateToDate(dto.getHizuke());
				// ߑOx̏ꍇAc`FbNB
				if (KintaiCommonPart.isStartHalfHoliday(dto)) {
					if (!part().holidayRequest().isApprovedPaidHolidayRequestStartHalf(dto)) {
						startFlag = checkRemainPaidHoliday(dto.getKCode(), targetDate, CommonConst.NUM_HALF_DAY, 0);
					}
				}
				// ԊOx(ߑO)̏ꍇAc`FbNB
				if (part().mospcode().useSubstituteHolidayFunction() && KintaiCommonPart.isOverTimeSubHolidayStart(dto)) {
					if (!part().holidayRequest().isApprovedSubstituteHolidayRequestStartHalf(dto)) {
						startFlag = checkRemainSubstitute(dto.getKCode(), targetDate, CommonConst.NUM_HALF_DAY);
					}
				}
				// ߌ㔼x̏ꍇAc`FbNB
				if (KintaiCommonPart.isQuitHalfHoliday(dto)) {
					if (!part().holidayRequest().isApprovedPaidHolidayRequestQuitHalf(dto)) {
						quitFlag = checkRemainPaidHoliday(dto.getKCode(), targetDate, CommonConst.NUM_HALF_DAY, 0);
					}
				}
				// ԊOx(ߌ㔼)̏ꍇAc`FbNB
				if (part().mospcode().useSubstituteHolidayFunction() && KintaiCommonPart.isOverTimeSubHolidayQuit(dto)) {
					if (!part().holidayRequest().isApprovedSubstituteHolidayRequestQuitHalf(dto)) {
						quitFlag = checkRemainSubstitute(dto.getKCode(), targetDate, CommonConst.NUM_HALF_DAY);
					}
				}
				if (startFlag && quitFlag) {
					// vZ
					runAutoCheckCalc(dto);
					// ߑOxAߌ㔼xAԒPʂ̔Nx̏FꍇAf
					margeHolidayRequest(dto);
					// XViSځj
					syukkinboDao().update(dto);
					// bZ[Wݒ
					setMessage(getMessage(MospConst.MSG_UPDATE, ""));
				}
			}
		}
		// R~bg
		commit();
		// Αӈꗗ֑J
		setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
	}
	
	/**
	 * Wv
	 * @throws Exception	Oꍇ
	 */
	private void runCalc() throws Exception {
		AttendanceCheckCardVo vo = (AttendanceCheckCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		MSyukkinboDto dto = kintai().getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate());
		vo.setDtoFields(dto);
		if (KintaiCommonPart.isAvailableWorkType(dto)) {
			kintai().runCalculatedInfo(dto);
			// xɐ\ƃ}[W
			margeHolidayRequest(dto);
			vo.setFields(dto);
			vo.setLabelInfo(dto);
		}
		// ԊOxΉ
		setOverTimeCaution(vo.getHidKCode(), DateUtil.convStringDateToDate(vo.getHidDate()), dto.getZaJikan());
	}
	
	/**
	 * vZ\bh
	 * @param dto		ΏDTO
	 * @throws Exception	Oꍇ
	 */
	private void runAutoCheckCalc(MSyukkinboDto dto) throws Exception {
		// Αӏݒ
		setCalcParam();
		// vZtOL芎TxȊÔ
		// vZtO
		if (isDailyAutoCalc && KintaiCommonPart.isAvailableWorkType(dto)) {
			// ΑӍڌvZ 
			kintai().runCalculatedInfo(dto);
		}
	}
	
}
