/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.human.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.PrefectureUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.MosPHumanAction;
import jp.mosp.kintai.human.dto.MEmergencyDto;
import jp.mosp.kintai.human.dto.MKojinDto;
import jp.mosp.kintai.human.vo.HumanPersonalCardVo;

/**
 * @author yoshida
 *
 */
public class HumanPersonalCardAction extends MosPHumanAction {
	
	// R}h
	/**
	 * 
	 */
	public static final String	CMD_HUMAN_PERSONAL_SELECT	= "H1030";
	private static final String	CMD_HUMAN_PERSONAL_UPDATE	= "H1033";
	
	// tB[h
	private MKojinDto			storedmKojinDto;
	private MEmergencyDto		storedmEmergencyDto;
	

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_HUMAN_PERSONAL_SELECT)) {
			// \(ЈR[hŏ)
			select();
		} else if (cmd.equals(CMD_HUMAN_PERSONAL_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new HumanPersonalCardVo();
	}
	
	/**
	 * 
	 * @throws Exception	Oꍇ
	 */
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// HUMANmF
		confirmHumanAuth();
		// VO̎擾
		HumanPersonalCardVo vo = (HumanPersonalCardVo)getVo();
		// p[^擾
		vo.setParams(request);
		// ʃXg擾
		vo.aryPltGender = getMosPCodeArray(CommonConst.TID_SEIBETSU);
		// NXg擾
		final int former = 50;
		vo.aryPltBirthYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), former, 1);
		vo.aryPltBirthMonth = StringUtil.getMonthArray();
		vo.aryPltBirthDay = StringUtil.getDayArray();
		// {^eݒ
		setListButton();
		// v_Eݒ 
		setPulldownList();
		// @\{^ݒ
		setFunctionButton(false);
	}
	
	/**
	 * v_Eݒ
	 * @throws Exception	Oꍇ
	 */
	protected void setPulldownList() throws Exception {
		// VO̎擾
		HumanPersonalCardVo vo = (HumanPersonalCardVo)getVo();
		// Xg擾
		vo.aryPltPrefecture = PrefectureUtil.getPrefectureArray();
		// t^Xg
		vo.aryPltBloodType = getMosPCodeArray(CommonConst.TID_BLOOD_TYPE);
		// ^敪
		vo.aryPltSalaryKb = getMosPCodeArray(CommonConst.TID_SALARY);
		// ŋ敪
		vo.aryPltTaxKb = getMosPCodeArray(CommonConst.TID_TAX);
		// g敪
		vo.aryPltUnionKb = getMosPCodeArray(CommonConst.TID_UNION);
		// x敪
		vo.aryPltPaymentKb = getMosPCodeArray(CommonConst.TID_PAYMENT);
		// p[g敪
		vo.aryPltPartKb = getMosPCodeArray(CommonConst.TID_PARTTIME);
	}
	
	@Override
	protected void select() throws Exception {
		// VO̎擾
		HumanPersonalCardVo vo = (HumanPersonalCardVo)getVo();
		// IЈR[h擾
		String kCode = "";
		if (StringUtil.isNotNull(vo.getTxtChangeKCode())) {
			kCode = vo.getTxtChangeKCode();
		} else if (StringUtil.isNotNull(key1)) {
			kCode = key1;
		}
		// l{擾
		getHumanKihonInfo(kCode);
		// l擾
		getHumanKojinInfo(kCode);
		// ً}A擾
		getHumanmEmergencyInfo(kCode);
		// \pl{ݒ
		vo.setLblKCode(kCode);
		vo.setLblKName(mKihonDto.getSimei());
		vo.setLblKKana(mKihonDto.getFurigana());
		// ZbVDTOZbg
		setStoredDto();
	}
	
	@Override
	protected void update() throws Exception {
		// VO̎擾
		HumanPersonalCardVo vo = (HumanPersonalCardVo)getVo();
		// ZbVێDTO擾
		getStoredDto();
		// p[^̑ÓmF
		vo.validate();
		// o^
		String message = regist();
		// R~bg
		commit();
		// l{擾
		getHumanKihonInfo(vo.getTxtChangeKCode());
		getHumanKojinInfo(vo.getTxtChangeKCode());
		getHumanmEmergencyInfo(vo.getTxtChangeKCode());
		// bZ[Wݒ
		vo.setMessage(message);
		// \pl{ݒ
		vo.setLblKCode(vo.getTxtChangeKCode());
		vo.setLblKName(mKihonDto.getSimei());
		vo.setLblKKana(mKihonDto.getFurigana());
		// ZbVDTOZbg
		setStoredDto();
	}
	
	/**
	 * 擾
	 * @param kCode 擾ΏێЈR[h
	 * @throws Exception	Oꍇ
	 */
	private void getHumanKihonInfo(String kCode) throws Exception {
		HumanPersonalCardVo vo = (HumanPersonalCardVo)getVo();
		// l{擾
		findHumanBasisInfo(kCode, false);
		// Ώۃf[^݊mF
		if (mKihonDto == null) {
			vo.addErrMessage(getMessage(CommonConst.MSG_NO_HUMAN_DATA, ""));
			vo.setTxtChangeKCode(kCode);
			return;
		}
		// VOɏݒ
		vo.setFields(mKihonDto);
		vo.setMode(HumanPersonalCardVo.MODE_UPDATE);
		// ZbVێpDTOݒ
		storedmKihonDto = mKihonDto;
		// rݒ
		String editor = setExclusive(CommonConst.EXC_HUMAN_BASIS, user.getUserId(), kCode);
		if (editor != null) {
			vo.addErrMessage(getMessage(CommonConst.MSG_EXCLUSIVE, editor));
		}
		setNeedExclusive(true);
	}
	
	/**
	 * l擾
	 * @param kCode 擾ΏێЈR[h
	 * @throws Exception	Oꍇ
	 */
	private void getHumanKojinInfo(String kCode) throws Exception {
		HumanPersonalCardVo vo = (HumanPersonalCardVo)getVo();
		// l擾
		findHumanPersonnelInfo(kCode, false);
		// Ώۃf[^݊mF
		if (mKojinDto == null) {
			mKojinDto = new MKojinDto();
			vo.setTxtChangeKCode(kCode);
			return;
		}
		// VOɏݒ
		vo.setFields(mKojinDto);
		vo.setMode(HumanPersonalCardVo.MODE_UPDATE);
		// ZbVێpDTOݒ
		storedmKojinDto = mKojinDto;
	}
	
	/**
	 * ً}A擾
	 * @param kCode 擾ΏێЈR[h
	 * @throws Exception	Oꍇ
	 */
	private void getHumanmEmergencyInfo(String kCode) throws Exception {
		HumanPersonalCardVo vo = (HumanPersonalCardVo)getVo();
		// ً}A擾
		findHumanEmergencyInfo(kCode, false);
		// Ώۃf[^݊mF
		if (mEmergencyDto == null) {
			mEmergencyDto = new MEmergencyDto();
			vo.setTxtChangeKCode(kCode);
			return;
		}
		// VOɏݒ
		vo.setFields(mEmergencyDto);
		vo.setMode(HumanPersonalCardVo.MODE_UPDATE);
		// ZbVێpDTOݒ
		storedmEmergencyDto = mEmergencyDto;
	}
	
	/**
	 * ZbVێDTO擾
	 */
	@Override
	protected void getStoredDto() {
		super.getStoredDto();
		storedmKojinDto = (MKojinDto)session.getAttribute(MKojinDto.class.getName());
		storedmEmergencyDto = (MEmergencyDto)session.getAttribute(MEmergencyDto.class.getName());
	}
	
	/**
	 * ZbVێDTOݒ
	 */
	@Override
	protected void setStoredDto() {
		super.setStoredDto();
		session.setAttribute(MKojinDto.class.getName(), storedmKojinDto);
		session.setAttribute(MEmergencyDto.class.getName(), storedmEmergencyDto);
	}
	
	/**
	 * o^
	 * @return bZ[W
	 * @throws Exception	Oꍇ
	 */
	private String regist() throws Exception {
		HumanPersonalCardVo vo = (HumanPersonalCardVo)getVo();
		// DTȌ
		if (mKihonDto == null) {
			mKihonDto = storedmKihonDto;
		}
		vo.setDtoFields(mKihonDto);
		if (mKojinDto == null) {
			mKojinDto = new MKojinDto();
		}
		vo.setDtoFields(mKojinDto);
		if (mEmergencyDto == null) {
			mEmergencyDto = new MEmergencyDto();
		}
		vo.setDtoFields(mEmergencyDto);
		mKojinDto.setKCode(mKihonDto.getKCode());
		// l{񑶍݊mF
		String message = "";
		// l{XV
		chkExclusive(mKihonDto, humanBasisDao().findForUpdate(mKihonDto.getKCode()));
		// XV
		humanBasisDao().update(mKihonDto);
		// l擾
		MKojinDto chkMKojinDto = humanParsonalDao().findForUpdate(vo.getTxtChangeKCode());
		if (chkMKojinDto == null) {
			// lo^	
			humanParsonalDao().insert(mKojinDto);
		} else {
			// lXV
			humanParsonalDao().update(mKojinDto);
		}
		// ً}A擾		
		String maxEno = emergencyDao().findForMax();
		if (StringUtil.isNull(maxEno)) {
			maxEno = "-1";
		} else {
			emergencyDao().findForUpdate(maxEno);
		}
		if (emergencyDao().findForConditionUpdate(mKihonDto.getKCode()) != null) {
			storedmEmergencyDto.setDeleteFlag(1);
			// ً}AXV
			emergencyDao().update(storedmEmergencyDto);
		}
		// őlZbg
		mEmergencyDto.setEmCode(Integer.parseInt(maxEno) + 1);
		// ً}Ao^	
		emergencyDao().insert(mEmergencyDto);
		message = getMessage(MospConst.MSG_UPDATE, "");
		return message;
	}
	
}
