/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.common.part;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.payroll.dao.KdSubstituteHolidayDao;
import jp.mosp.kintai.payroll.dto.KdSubstituteHolidayDto;

/**
 * 60ԎԊOɂ֋xɂɊւNX
 * @author yoshida
 *
 */
public class SubstituteHolidayPart extends KintaiBasePart {
	
	/**
	 * RXgN^
	 */
	public SubstituteHolidayPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo	Part𗘗pۂɕKvȏ
	 */
	public SubstituteHolidayPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	private KdSubstituteHolidayDao	substituteHolidayDao;
	

	/**
	 * ςݑ֋xɊǗe[upDAO擾B
	 * @return substituteHolidayDao
	 * @throws MospException MosPOꍇ
	 */
	public KdSubstituteHolidayDao getKdSubstituteHolidayDao() throws MospException {
		if (VariousUtil.isNull(substituteHolidayDao)) {
			substituteHolidayDao = (KdSubstituteHolidayDao)getPreparedDao(KdSubstituteHolidayDao.class
				.getCanonicalName());
		}
		return substituteHolidayDao;
	}
	
	/**
	 * xC@\pf
	 * @since 	0.0.5
	 * @return 
	 * <p>
	 * xC@\𗘗pꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception  	Oꍇ
	 */
	public boolean useSubstituteHolidayAmendment() throws Exception {
		return part().mospcode().useSubstituteHolidayFunction()
				&& StringUtil.isFlagOff(part().mospcode().findTchange(CommonConst.TID_WORK_SYSTEM,
						CommonConst.TCD_SUBSTITUTE_AMENDMENT));
	}
	
	/**
	 * 60ԎԊOɂx̗LԃR[h擾
	 * @return 60ԎԊOɂx̗LԃR[h
	 * @throws Exception Oꍇ
	 */
	public String getPeriodCode() throws Exception {
		return part().mospcode().findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_SUBSTITUTE_PERIOD);
	}
	
	/**
	 * 60ԎԊOɂx̗Lԁi1jf
	 * @return
	 * <p>
	 * 60ԎԊOɂx̗LԂ1̏ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception Oꍇ
	 */
	public boolean isPeriodOneMonth() throws Exception {
		return StringUtil.isFlagOff(getPeriodCode()) && part().mospcode().useSubstituteHolidayFunction();
	}
	
	/**
	 * 60ԎԊOɂx̗Lԁi2jf
	 * @return
	 * <p>
	 * 60ԎԊOɂx̗LԂ2̏ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception Oꍇ
	 */
	public boolean isPeriodTwoMonths() throws Exception {
		return StringUtil.isFlagOn(getPeriodCode()) && part().mospcode().useSubstituteHolidayFunction();
	}
	
	/**
	 * ӌ󋵂Ԃǂf
	 * @param attitudeStatus ӌ󋵃R[h
	 * @return
	 * <p>
	 * ӌ󋵂init̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAttitudeInit(String attitudeStatus) {
		return CommonConst.CODE_ATTITUDE_STATUS_INIT.equals(attitudeStatus);
	}
	
	/**
	 * ӌ󋵂Ԃǂf
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * ӌ󋵂init̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAttitudeInit(KdSubstituteHolidayDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isAttitudeInit(dto.getAttitudeStatus());
		}
		return false;
	}
	
	/**
	 * ӌ󋵂mFςǂf
	 * @param attitudeStatus ӌ󋵃R[h
	 * @return
	 * <p>
	 * ӌ󋵂fixed̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAttitudeFixed(String attitudeStatus) {
		return CommonConst.CODE_ATTITUDE_STATUS_FIXED.equals(attitudeStatus);
	}
	
	/**
	 * ӌ󋵂mFςǂf
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * ӌ󋵂fixed̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAttitudeFixed(KdSubstituteHolidayDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isAttitudeFixed(dto.getAttitudeStatus());
		}
		return false;
	}
	
	/**
	 * 擾󋵎cf
	 * @param acquisitionStatus 擾󋵃R[h
	 * @return
	 * <p>
	 * 擾󋵂c̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAcquisitionRemain(String acquisitionStatus) {
		return CommonConst.CODE_ACQUISITION_STATUS_REMAIN.equals(acquisitionStatus);
	}
	
	/**
	 * 擾󋵖擾f
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * 擾󋵂c̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAcquisitionRemain(KdSubstituteHolidayDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isAcquisitionRemain(dto.getAcquisitionStatus());
		}
		return false;
	}
	
	/**
	 * 擾󋵊f
	 * @param acquisitionStatus 擾󋵃R[h
	 * @return
	 * <p>
	 * 擾󋵂̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAcquisitionFinish(String acquisitionStatus) {
		return CommonConst.CODE_ACQUISITION_STATUS_FINISH.equals(acquisitionStatus);
	}
	
	/**
	 * 擾󋵊f
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * 擾󋵂̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isAcquisitionFinish(KdSubstituteHolidayDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isAcquisitionFinish(dto.getAcquisitionStatus());
		}
		return false;
	}
	
	/**
	 * Ϗ󋵊m蔻f
	 * @param decisionStatus Ϗ󋵃R[h
	 * @return
	 * <p>
	 * Ϗ󋵂ύς݂̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isDecisionFixed(String decisionStatus) {
		return CommonConst.CODE_DECISION_STATUS_FIXED.equals(decisionStatus);
	}
	
	/**
	 * Ϗ󋵊m蔻f
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * Ϗ󋵂m̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isDecisionFixed(KdSubstituteHolidayDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isDecisionFixed(dto.getDecisionStatus());
		}
		return false;
	}
	
	/**
	 * Ϗ󋵌ύςݔf
	 * @param decisionStatus Ϗ󋵃R[h
	 * @return
	 * <p>
	 * Ϗ󋵂ύς݂̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isDecisionPayment(String decisionStatus) {
		return CommonConst.CODE_DECISION_STATUS_PAYMENT.equals(decisionStatus);
	}
	
	/**
	 * Ϗ󋵌ύςݔf
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * Ϗ󋵂ύς݂̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isDecisionPayment(KdSubstituteHolidayDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return isDecisionPayment(dto.getDecisionStatus());
		}
		return false;
	}
	
	/**
	 * x̏D揇ʂ̔fiDj
	 * @return D̏ꍇtrueAłȂꍇfalseB
	 * @throws Exception Oꍇ
	 */
	public boolean isPriorityWeekDay() throws Exception {
		if (part().mospcode().useSubstituteHolidayFunction()) {
			return StringUtil.isFlagOff(part().mospcode().findTchange(CommonConst.TID_WORK_SYSTEM,
					CommonConst.TCD_SUBSTITUTE_PRIORITY));
		}
		return false;
	}
	
	/**
	 * Ώ۔NɎ擾\ȑxԐ擾
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @return Ώ۔NɎ擾\ȑxԐ
	 * @throws Exception Oꍇ
	 */
	public int getAvairableSubstituteTime(String kCode, Date targetDate) throws Exception {
		List<KdSubstituteHolidayDto> list = getKdSubstituteHolidayDao().findForTargetDate(kCode, targetDate,
				CommonConst.CODE_ACQUISITION_STATUS_REMAIN, CommonConst.CODE_DECISION_STATUS_FIXED);
		// xΏێ
		int substituteTime = 0;
		for (KdSubstituteHolidayDto dto : list) {
			// 
			substituteTime += dto.getPaymentAcquireTime();
			// x
			substituteTime += dto.getPaymentAcquireHoliday();
			// p
			substituteTime -= dto.getUseHolidayTime();
		}
		return substituteTime;
	}
	
	/**
	 * ԊOx̎c擾
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @return ԊOx̎c
	 * @throws Exception 	Oꍇ
	 */
	public double getRemainSubstituteHoliday(String kCode, Date targetDate) throws Exception {
		// Ώێ
		int substituteTime = getAvairableSubstituteTime(kCode, targetDate);
		// J
		int prescribedTime = part().laborAgreement().getPrescribedTime(kCode, targetDate);
		if (substituteTime > 0) {
			double substituteDate = Double.valueOf(substituteTime) / prescribedTime;
			if (substituteDate - Math.floor(substituteDate) >= CommonConst.NUM_HALF_DAY) {
				return Math.floor(substituteDate) + CommonConst.NUM_HALF_DAY;
			}
			return Math.floor(substituteDate);
		}
		return 0;
	}
	
	/**
	 * Nɂx̎擾
	 * @param kCode ΏێЈR[h
	 * @param occurYear N
	 * @param occurMonth 
	 * @return Ώ۔N̑x
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public KdSubstituteHolidayDto getOccurSubstituteInfo(String kCode, int occurYear, int occurMonth)
			throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		return getKdSubstituteHolidayDao().findForOccurMonth(kCode, occurYear, occurMonth);
	}
	
	/**
	 * Nɂx̎擾
	 * @param kCode ΏێЈR[h
	 * @param occurYear N
	 * @param occurMonth 
	 * @return Ώ۔N̑x
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public KdSubstituteHolidayDto getOccurSubstituteInfo(String kCode, String occurYear, String occurMonth)
			throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		return getOccurSubstituteInfo(kCode, NumberUtil.getIntParam(occurYear), NumberUtil.getIntParam(occurMonth));
	}
	
	/**
	 * Nɂx̎擾
	 * @param kCode ΏێЈR[h
	 * @param yearMonth N
	 * @return Ώ۔N̑x
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public KdSubstituteHolidayDto getOccurSubstituteInfo(String kCode, Date yearMonth) throws SQLException,
			IllegalAccessException, NoSuchFieldException, MospException {
		return getOccurSubstituteInfo(kCode, MospUtility.getYear(yearMonth), MospUtility.getMonth(yearMonth));
	}
	
	/**
	 * xΏێԐEpԐɂ擾f
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * pԐƑxΏێԐꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isSubstituteUseFinished(KdSubstituteHolidayDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			int acquireTime = dto.getPaymentAcquireTime() + dto.getPaymentAcquireHoliday();
			return acquireTime == dto.getUseHolidayTime();
		}
		return false;
	}
	
	/**
	 * ̍쐬
	 * @param kCode ЈR[h
	 * @param occurYear N
	 * @param occurMonth 
	 * @param closeDate ؓ
	 * @param limitStartDate Jn
	 * @param limitEndDate I
	 * @return 
	 */
	public static KdSubstituteHolidayDto createInitalDto(String kCode, int occurYear, int occurMonth, Date closeDate,
			Date limitStartDate, Date limitEndDate) {
		KdSubstituteHolidayDto dto = new KdSubstituteHolidayDto();
		dto.setKCode(kCode);
		dto.setOccurYear(occurYear);
		dto.setOccurMonth(occurMonth);
		dto.setCloseDate(closeDate);
		dto.setLimitStartDate(limitStartDate);
		dto.setLimitEndDate(limitEndDate);
		dto.setAttitudeStatus(CommonConst.CODE_ATTITUDE_STATUS_INIT);
		dto.setAcquisitionStatus(CommonConst.CODE_ACQUISITION_STATUS_REMAIN);
		dto.setDecisionStatus(CommonConst.CODE_DECISION_STATUS_INIT);
		dto.setDeleteFlag(MospConst.DELETE_FLAG_OFF);
		return dto;
	}
	
	/**
	 * ߏp̊I܂ޑẍꗗ̎擾
	 * @param yearMonth Ώ۔N
	 * @return Ώ۔N̑O܂͑OX
	 * @throws Exception 	Oꍇ
	 */
	public List<KdSubstituteHolidayDto> getSubstituteListForLimitEnd(Date yearMonth) throws Exception {
		// Oꗗ擾
		if (isPeriodOneMonth()) {
			Date oneMonthBefore = DateUtil.addMonth(yearMonth, -1);
			return getKdSubstituteHolidayDao().findForOccurMonth(MospUtility.getYear(oneMonthBefore),
					MospUtility.getMonth(oneMonthBefore), CommonConst.CODE_ACQUISITION_STATUS_REMAIN);
		} else if (isPeriodTwoMonths()) {
			// OXꗗ擾
			Date twoMonthBefore = DateUtil.addMonth(yearMonth, -2);
			return getKdSubstituteHolidayDao().findForOccurMonth(MospUtility.getYear(twoMonthBefore),
					MospUtility.getMonth(twoMonthBefore), CommonConst.CODE_ACQUISITION_STATUS_REMAIN);
		}
		return null;
	}
	
	/**
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @return ؓȎxǗ
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public KdSubstituteHolidayDto getCloseDate(String kCode, Date targetDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException, MospException {
		return getKdSubstituteHolidayDao().findForCloseDate(kCode, targetDate);
	}
	
	/**
	 * ؓȎx񔻒fB
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @return
	 * <p>
	 * ؓOɑx񂪂ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public boolean existAttitudeInitial(String kCode, Date targetDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		KdSubstituteHolidayDto dto = getCloseDate(kCode, targetDate);
		if (VariousUtil.isNotNull(dto)) {
			return isAttitudeInit(dto);
		}
		return false;
	}
	
}
