/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.action;

import java.util.Date;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.vo.MosPPasswordVo;

/**
 * @author yoshida
 *
 */
public class MosPPasswordAction extends MosPAction {
	
	// R}h
	private static final String	CMD_PASSWORD_SHOW			= "C1050";
	private static final String	CMD_PASSWORD_CHANGE			= "C1051";
	/**
	 * ύX
	 */
	public static final String	CMD_PASSWORD_FORCE_CHANGE	= "C1052";
	

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_PASSWORD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_PASSWORD_CHANGE)) {
			// XV
			update();
		} else if (cmd.equals(CMD_PASSWORD_FORCE_CHANGE)) {
			// ύX
			forceChange();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new MosPPasswordVo();
	}
	
	@Override
	protected void init() throws Exception {
		MosPPasswordVo vo = (MosPPasswordVo)getVo();
		// j[R}hݒ
		vo.setAryMenu(vo.CMD_MENU_INPUT);
		if (hasSystemAuth()) {
			vo.setAryMenu(vo.CMD_MENU_SYSTEM2);
		}
		// j[փ{^̔\ݒ
		vo.setMode(MosPPasswordVo.MODE_FORCE_UPDATE);
	}
	
	@Override
	protected void show() throws Exception {
		MosPPasswordVo vo = (MosPPasswordVo)getVo();
		vo.setUserId(user.getUserId());
		vo.setUserName(user.getUserName());
		// j[փ{^̕\
		vo.setMode(MosPPasswordVo.MODE_SHOW);
	}
	
	/**
	 * ύX
	 * @throws Exception 	Oꍇ
	 */
	private void forceChange() throws Exception {
		MosPPasswordVo vo = (MosPPasswordVo)getVo();
		// \
		show();
		// j[փ{^̔\ݒ
		vo.setMode(MosPPasswordVo.MODE_FORCE_UPDATE);
	}
	
	@Override
	protected void update() throws Exception {
		MosPPasswordVo vo = (MosPPasswordVo)getVo();
		vo.setParams(request);
		// DAȌ
		MosPUserDao dao = part().mospuser().getMosPUserDao();
		// DTȌ
		CmUserDto dto = dao.findForUpdate(vo.getUserId());
		// ݊mF
		chkExist(dto);
		// p[^̑ÓmF
		vo.validate(dto.getPassword());
		// l̐ݒ
		dto.setPassword(MospUtility.encrypt(vo.getHdnNewPassword(), hasMospSeJar()));
		// pX[hύXZbgB
		dto.setChangePass(new Date());
		// f[^̍XV
		dao.update(dto, false);
		// R~bg
		commit();
		// bZ[Wݒ
		setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// j[փ{^̕\
		vo.setMode(MosPPasswordVo.MODE_SHOW);
		if (VariousUtil.isDefaultPassWord(user.getUserId(), vo.getHdnNewPassword())) {
			// j[փ{^̔\ݒ
			vo.setMode(MosPPasswordVo.MODE_FORCE_UPDATE);
		}
	}
	
}
