/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.bean.AuthBean;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.part.MosPCodePart;
import jp.mosp.common.part.MosPMenuPart;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.part.HumanPart;
import jp.mosp.kintai.common.vo.MosPLoginVo;

/**
 * @author yoshida
 *
 */
public class MosPAuthAction extends MosPAction {
	
	/**
	 * RXgN^
	 */
	public MosPAuthAction() {
		super();
		setNeedSession(false);
		setNeedAspUser(false);
		setNeedUser(false);
		setCheckAuth(false);
		setCheckProcSeq(false);
	}
	
	public void action() throws Exception {
		//  
		init();
		// F
		authentication();
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new MosPLoginVo(cfg, msg, nam, cmd, aspUser, user);
	}
	
	@Override
	protected void init() throws Exception {
		BaseVo vo = getSpecificVo();
		// VȌ
		// VO
		vo.initVo(cfg, msg, nam, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
	}
	
	/**
	 * F
	 * @throws Exception 	O
	 */
	protected void authentication() throws Exception {
		// ASP[U[擾(ݒt@CASPݒŔf)
		setAspUser();
		// F؏
		login();
		// Г`FbNB
		checkEmployDate();
		// ̃y[W֑Jڏ
		setNextPage();
		// [U[ۑ
		// ZbV̍Ď擾
		if (VariousUtil.isNotNull(session)) {
			session.invalidate();
		}
		session = request.getSession(true);
		// [U[ݒ
		session.setAttribute(MospConst.ATT_ASPUSER, aspUser);
		session.setAttribute(MospConst.ATT_USER, user);
		request.setAttribute(MospConst.ATT_USER, user);
		// Oo
		LogUtility.log(request, 4, MospConst.LOG_MOSPINF, MospConst.LOG_MSG_LOGIN);
	}
	
	/**
	 * F؏
	 * @throws Exception 	O
	 */
	protected void login() throws Exception {
		MosPLoginVo vo = (MosPLoginVo)getVo();
		// p[^̎擾
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DBRlNV̎擾
		getConnection();
		// F؏
		AuthBean auth = new AuthBean(cfg, cmd, aspUser, conn, hasMospSeJar());
		auth.login(vo.getUserId(), vo.getPass());
		// F؂sĂꍇ
		if (auth.isErrMessage()) {
			// G[bZ[W̐ݒ
			addErrMessage(getMessage(auth.getErrMessageCode(), ""));
			throw new MospException(auth.getMosPExceptionCode());
		}
		user = auth.getCmUserDto();
		// R~bg
		commit();
	}
	
	/**
	 * y[WJڏ
	 * @throws Exception	Oꍇ
	 */
	protected void setNextPage() throws Exception {
		MosPLoginVo vo = (MosPLoginVo)getVo();
		// R}hݒ
		String nextCmd = "C1060";
		// pX[hLmF
		boolean validPassWord = true;
		// PartNX̏
		// pX[hL߂ĂApX[hύXʂɑJڂB
		// [U[IDƃpX[hꍇApX[hύXʂɑJڂB
		MosPCodePart mospcode = (MosPCodePart)part().get(MosPCodePart.class);
		if (mospcode.isExpirePassWord(user.getChangePass())
				|| VariousUtil.isDefaultPassWord(user.getUserId(), vo.getPass())) {
			nextCmd = MospConst.CMD_PASS_FORCE;
			validPassWord = false;
		}
		// admin̏ꍇCSSƏR}hύX
		if (user.getAuthority().equals(CommonConst.AUTHORITY_ADMIN) && validPassWord) {
			user.setCommonCss(CommonConst.CSS_ADMIN);
			//nextCmd = vo.CMD_MENU_SYSTEM2;
			nextCmd = "S2910";
		}
		MosPMenuPart menu = (MosPMenuPart)part().get(MosPMenuPart.class);
		// ]ƈ݂̂̏ꍇA̋Αӓ͂ֈړ
		if (MosPMenuPart.isEmployeeUser(menu.getUserAuthInfo()) && validPassWord) {
			nextCmd = "K1014";
		}
		// y[WR}h
		setNextCmd(nextCmd);
		// T[ubg
		setUrl(MospConst.URL_SRV);
	}
	
	/**
	 * Г̃`FbN
	 * <p>	2009/06/18	m.yoshida	mosp-baseΉ	</p>
	 * @throws Exception	Oꍇ
	 */
	protected void checkEmployDate() throws Exception {
		// PartNX̏
		HumanPart human = (HumanPart)part().get(HumanPart.class);
		// Гȍ~OCłȂ悤ɂB
		HumanBasisDtoInterface dto = human.getBasisInfo(user.getKCode());
		Date entranceDate = null;
		if (VariousUtil.isNotNull(dto)) {
			entranceDate = DateUtil.convIntegerDateToDate(dto.getNyDate());
		}
		// ǗҌ̏ꍇAl{͖
		if (user.getAuthority().equals(CommonConst.AUTHORITY_ADMIN)) {
			entranceDate = new Date(0);
		}
		// ЃAГȌꍇAOCs
		if (entranceDate == null || DateUtil.getSystemDate().compareTo(entranceDate) < 0) {
			// G[bZ[W̐ݒ
			addErrMessage(getMessage(MospConst.MSG_AUTH_FAILED, ""));
			throw new MospException(MospConst.EX_AUTH_FAILED);
		}
	}
	
	/**
	 * ASP[U[擾(ݒt@CASPݒŔf)
	 * @throws Exception	Oꍇ
	 */
	protected void setAspUser() throws Exception {
		// ASP[U[擾(ݒt@CASPݒŔf)
		switch (MospUtility.getAspFlag(cfg)) {
			case 0:
				// 0FASP(x[U[:1Av)
			case 1:
				// 1FASP(1[U[:1Av)
				// ASP[U[Zbg(ZbV擾)
				session = request.getSession(false);
				aspUser = (CmAspUserDto)session.getAttribute(MospConst.ATT_ASPUSER);
				BaseVo aspVo = (BaseVo)request.getAttribute(MospConst.ATT_VO);
				// returnUrlݒ
				BaseVo vo = (BaseVo)getVo();
				vo.setRetUrl(aspVo.getRetUrl());
				break;
			case 2:
				// 2FASP
				// ASP[U[Zbg(OCʂł̃ZbVؒf)
				createAspUser();
				break;
			default:
				throw new MospException(MospConst.EX_ASP_PROPERTIES);
		}
	}
	
}
