/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.action;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.dto.KintaiCommonDtoInterface;
import jp.mosp.common.dto.MCodeDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.common.part.KintaiCompilePart;
import jp.mosp.kintai.kintai.action.AttendanceCheckCardAction;
import jp.mosp.kintai.kintai.action.AttendanceHolidayCardAction;
import jp.mosp.kintai.kintai.action.AttendanceListAction;
import jp.mosp.kintai.kintai.action.AttendanceQuitCardAction;
import jp.mosp.kintai.kintai.action.AttendanceStartCardAction;
import jp.mosp.kintai.kintai.action.EmployeeAttendanceListAction;
import jp.mosp.kintai.kintai.dao.MSyukkinboDao;
import jp.mosp.kintai.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.kintai.vo.AttendanceMenuVo;
import jp.mosp.kintai.kintai.vo.EmployeeAttendanceListVo;
import jp.mosp.kintai.payroll.dao.KdPaidHolidayDao;
import jp.mosp.kintai.payroll.dto.KdPaidHolidayDto;
import jp.mosp.kintai.payroll.dto.KintaiCompileDto;
import jp.mosp.kintai.schedule.dao.MScheduleDao;
import jp.mosp.kintai.schedule.dto.MScheduleDto;
import jp.mosp.kintai.schedule.vo.MosPScheduleVo;
import jp.mosp.kintai.workflow.dto.CtOvertimeRequestDto;

/**
 * @author yoshida
 *
 */
public abstract class AttendanceTotalAction extends KintaiCommonAction {
	
	// tB[h
	/**
	 * JnN(yyyy/MM/dd)
	 */
	protected String				startDate;
	/**
	 * IN(yyyy/MM/dd)
	 */
	protected String				endDate;
	/**
	 * [鎞ԊJn
	 */
	protected int					lateNightStart		= 0;
	/**
	 * [鎞ԏI
	 */
	protected int					lateNightEnd		= 0;
	/**
	 * Sx
	 */
	protected int					allHoliday			= 0;
	/**
	 * x
	 */
	protected int					halfHoliday			= 0;
	/**
	 * ͒P
	 */
	protected int					inputUnit			= 1;
	/**
	 * vZ
	 */
	protected boolean				isAutoCalc;
	/**
	 * Αӓ͎vZ
	 */
	protected boolean				isDailyAutoCalc;
	/**
	 * oΕ񃊃Xg
	 */
	protected List<MSyukkinboDto>	attendanceList;
	/**
	 * \񃊃Xg
	 */
	protected List<MScheduleDto>	scheduleList;
	/**
	 * xɗR
	 */
	protected String[][]			aryHolidayReason;
	/**
	 * Wvf[^
	 */
	protected String[][]			aryAttendance;
	/**
	 * Wvf[^
	 */
	protected String[][]			aryAttendanceCompile;
	/**
	 * Αӓ͑IЈR[h
	 */
	protected static final String	SELECT_K_CODE		= "selectKCode";
	/**
	 * Αӓ͑IN
	 */
	protected static final String	SELECT_DATE			= "selectDate";
	/**
	 * COMPILE_SECTION
	 */
	protected static final String	COMPILE_SECTION		= "COMPILE_SECTION";
	/**
	 * COMPILE_K_CODE
	 */
	protected static final String	COMPILE_K_CODE		= "COMPILE_K_CODE";
	/**
	 * 60ԎԊOԋ@\
	 */
	protected boolean				useOver60Hour;
	/**
	 * 60ԎԊOx
	 */
	protected int					caution60Hour		= 0;
	/**
	 * 60ԎԊO
	 */
	protected final int				warn60Hour			= CommonConst.NUM_OVER_TIME_60_HOUR;
	/**
	 * 1Ňxx
	 */
	protected int					cautionLimitYear	= 0;
	/**
	 * 1Ňx
	 */
	protected int					warnLimitYear		= 0;
	

	/**
	 * \pDAO擾
	 * @return	ςMScheduleDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	protected MScheduleDao scheduleDao() throws Exception {
		// \pDAO
		return kintai().getMScheduleDao();
	}
	
	/**
	 * oΕpDAO擾
	 * @return	ςMSyukkinboDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	protected MSyukkinboDao syukkinboDao() throws Exception {
		// oΕpDAO
		return kintai().getMSyukkinboDao();
	}
	
	/**
	 * Αӈꗗf[^
	 * @param kCode		ΏێЈR[h
	 * @return ΑӈꗗXg
	 * @throws Exception	Oꍇ
	 */
	protected List<MSyukkinboDto> getAttendanceList(String kCode) throws Exception {
		// ꗗ̎擾
		attendanceList = kintai().getAttendanceList(kCode, startDate, endDate);
		return attendanceList;
	}
	
	/**
	 * Αӌꗗf[^擾
	 * @param kCode       ΏێЈR[h
	 * @param targetMonth Ώی
	 * @return  ΑӈꗗXg
	 * @throws Exception	Oꍇ
	 */
	protected List<MSyukkinboDto> getAttendanceList(String kCode, Date targetMonth) throws Exception {
		// ͈͎擾
		startDate = DateUtil.convDateFormatted(getStartDate(targetMonth));
		endDate = DateUtil.convDateFormatted(getEndDate(targetMonth));
		// 
		getAttendanceList(kCode);
		return attendanceList;
	}
	
	/**
	 * Αӌꗗf[^擾i\pj
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return  ΑӈꗗXg
	 * @throws Exception	Oꍇ
	 */
	protected List<MSyukkinboDto> getAttendanceListForView(String kCode, Date targetDate) throws Exception {
		// ͈͎擾
		startDate = DateUtil.convDateFormatted(getStartDateForList(targetDate));
		endDate = DateUtil.convDateFormatted(getEndDateForList(targetDate));
		// 
		getAttendanceList(kCode);
		return attendanceList;
	}
	
	/**
	 * Wv
	 * @param kCode				ΏێЈR[h
	 * @param attendanceList	ΏۏoΕ냊Xg
	 * @throws Exception	Oꍇ
	 */
	protected void totalAttendanceDaily(String kCode, List<MSyukkinboDto> attendanceList) throws Exception {
		KintaiCompileDto dto = compile().getCompiledInfo(kCode, attendanceList, false);
		// z̏
		aryAttendanceCompile = StringUtil.getBlankArray(19, 2);
		// z
		// Ζԍv
		aryAttendanceCompile[0][0] = CommonConst.NAM_WORKING;
		aryAttendanceCompile[0][1] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getTotalWork()));
		// xeԍv
		aryAttendanceCompile[1][0] = CommonConst.NAM_INTERVAL_TIME;
		aryAttendanceCompile[1][1] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getTotalInterbal()));
		// xԍv
		aryAttendanceCompile[2][0] = CommonConst.NAM_ARRIVE_LATE;
		aryAttendanceCompile[2][1] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getTotalLate()));
		// ގԍv
		aryAttendanceCompile[3][0] = CommonConst.NAM_LEAVE_EARLY;
		aryAttendanceCompile[3][1] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getTotalLeave()));
		// cƎԍv
		aryAttendanceCompile[4][0] = CommonConst.NAM_OVERTIME;
		aryAttendanceCompile[4][1] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getTotalOver()));
		// xoԍv
		aryAttendanceCompile[5][0] = CommonConst.NAM_WORK_ON_HOLIDAY;
		aryAttendanceCompile[5][1] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getTotalHolidayWork()));
		// [鎞ԍv
		aryAttendanceCompile[6][0] = CommonConst.NAM_LATE_NIGHT;
		aryAttendanceCompile[6][1] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getTotalLateNight()));
		// oΓ
		aryAttendanceCompile[7][0] = CommonConst.NAM_PRESENCE;
		aryAttendanceCompile[7][1] = String.valueOf(dto.getTotalWorkDays());
		// Lxɓ
		aryAttendanceCompile[8][0] = aryHolidayReason[0][1];
		aryAttendanceCompile[8][1] = String.valueOf(dto.getTotalPaidHoliday());
		// ʋxɓ
		aryAttendanceCompile[9][0] = aryHolidayReason[1][1];
		aryAttendanceCompile[9][1] = String.valueOf(dto.getTotalParticularHoliday());
		// ΋xɓ
		aryAttendanceCompile[10][0] = aryHolidayReason[2][1];
		aryAttendanceCompile[10][1] = String.valueOf(dto.getTotalAbsence());
		// axɓ
		aryAttendanceCompile[11][0] = aryHolidayReason[3][1];
		aryAttendanceCompile[11][1] = String.valueOf(dto.getTotalMedicalLeave());
		// x
		aryAttendanceCompile[12][0] = aryHolidayReason[4][1];
		aryAttendanceCompile[12][1] = String.valueOf(dto.getTotalCompensationDay());
		// U֋xɓ
		aryAttendanceCompile[13][0] = aryHolidayReason[5][1];
		aryAttendanceCompile[13][1] = String.valueOf(dto.getTotalTransfer());
		// xɓ
		aryAttendanceCompile[14][0] = CommonConst.NAM_OTHER_SHORT;
		aryAttendanceCompile[14][1] = String.valueOf(dto.getTotalOther());
		// xސ
		aryAttendanceCompile[15][0] = CommonConst.NAM_LATE_AND_LEAVE_EARLY;
		aryAttendanceCompile[15][1] = String.valueOf(dto.getLeaveAndLate());
		// 蓖
		StringBuffer allowance = new StringBuffer();
		allowance.append(dto.getSyokuji());
		allowance.append(CommonConst.STR_SLASH_SEPARATOR);
		allowance.append(dto.getCyoku1());
		allowance.append(dto.getCyoku2());
		allowance.append(dto.getCyoku3());
		allowance.append(CommonConst.STR_SLASH_SEPARATOR);
		allowance.append(dto.getHoka1());
		allowance.append(dto.getHoka2());
		allowance.append(dto.getHoka3());
		allowance.append(dto.getHoka4());
		allowance.append(dto.getHoka5());
		aryAttendanceCompile[16][0] = CommonConst.NAM_ALLOWANCE;
		aryAttendanceCompile[16][1] = allowance.toString();
		// F΁i΁AʋxɁAaAxސ̍vj
		aryAttendanceCompile[17][0] = CommonConst.NAM_PERFECT_ATTENDANCE;
		aryAttendanceCompile[17][1] = "";
		if (dto.isApplyAttendanceAllowance()) {
			aryAttendanceCompile[17][1] = CommonConst.NAM_PERFECT_ATTENDANCE;
		}
		// ԊOx
		if (checkCautionOverTime(dto.getTotalOver(), 0)) {
			aryAttendanceCompile[18][1] = CommonConst.CSS_CLASS_CAUTION_TD;
		} else if (checkWarningOverTime(dto.getTotalOver(), 0)) {
			aryAttendanceCompile[18][1] = CommonConst.CSS_CLASS_WARNING_TD;
		}
	}
	
	/**
	 * [鎞Ԏ擾
	 * @throws Exception 	O
	 */
	private void setLateNightTime() throws Exception {
		// l̐ݒ
		lateNightStart = kintai().getLateNightStart();
		lateNightEnd = lateNightStart + kintai().getLateNightEnd();
	}
	
	/**
	 * vZtO擾
	 * @throws Exception	Oꍇ
	 */
	private void setAutoCalc() throws Exception {
		// vZtO擾
		isAutoCalc = kintai().isAutoCalc();
		// vZtO
		isDailyAutoCalc = kintai().isDailyAutoCalc();
	}
	
	/**
	 * xɎԎ擾
	 * @throws Exception	Oꍇ
	 */
	private void setHolidayTimes() throws Exception {
		allHoliday = kintai().getAllHolidayTimes();
		halfHoliday = kintai().getHalfHolidayTimes();
	}
	
	/**
	 * ͒PʎԐݒ
	 * @throws Exception	Oꍇ
	 */
	protected void setInputUnit() throws Exception {
		// ͒Pʎ
		inputUnit = kintai().getInputUnitTimes();
	}
	
	/**
	 * xɗRݒ
	 * @throws Exception	Oꍇ
	 */
	protected void setHolidayReason() throws Exception {
		// xɗR
		aryHolidayReason = part().mospcode().getHolidayReasonArray();
	}
	
	/**
	 * 60ԎԊOԋ@\ݒ
	 * @throws Exception	Oꍇ
	 */
	protected void setUseOver60Hour() throws Exception {
		// 60ԎԊOԋ@\
		useOver60Hour = part().mospcode().useOverTime60HourFunction();
	}
	
	/**
	 * Wv{ݒ
	 * @throws Exception	Oꍇ
	 */
	protected void setCalcParam() throws Exception {
		// vZݒ
		setAutoCalc();
		// ͒Pʎ
		setInputUnit();
		// [鎞Ԑݒ
		setLateNightTime();
		// xɎԐݒ
		setHolidayTimes();
		// xɗRݒ
		setHolidayReason();
		// 60ԎԊOԋ@\
		setUseOver60Hour();
	}
	
	/**
	 * xxɗRz擾
	 * @return xxɗRz(ԊOxL̏ꍇǉ)
	 * @throws Exception	Oꍇ
	 */
	public String[][] getHalfHolidayArray() throws Exception {
		return part().mospcode().getHalfHolidayArray();
	}
	
	/**
	 * FR\
	 * @param riyuu FR
	 * @return	result
	 * @throws Exception	Oꍇ
	 */
	protected String[] getApproval(String riyuu) throws Exception {
		return part().kintaiApproval().getApproval(riyuu);
	}
	
	/**
	 * Αӓo^p[^ݒ
	 * @throws Exception	Oꍇ
	 */
	protected void setAttendanceInfo() throws Exception {
		AttendanceMenuVo vo = (AttendanceMenuVo)getVo();
		// ЈR[h
		String kCode;
		if (StringUtil.isNotNull(key1)) {
			kCode = key1;
		} else {
			Object obj = request.getAttribute(SELECT_K_CODE);
			if (VariousUtil.isNotNull(obj)) {
				kCode = obj.toString();
			} else {
				kCode = vo.getHidKCode();
			}
		}
		// Ώ۔N
		Date selectDate;
		if (StringUtil.isNotNull(key2)) {
			selectDate = MospUtility.getDate(key2);
		} else {
			Object obj = request.getAttribute(SELECT_DATE);
			if (VariousUtil.isNotNull(obj)) {
				selectDate = MospUtility.getDate(obj.toString());
			} else {
				selectDate = MospUtility.getDate(vo.getHidDate());
			}
		}
		vo.setHidKCode(kCode);
		vo.setHidYear(String.valueOf(MospUtility.getYear(selectDate)));
		vo.setHidMonth(String.valueOf(MospUtility.getMonth(selectDate)));
		vo.setHidDay(String.valueOf(MospUtility.getDay(selectDate)));
		vo.setHidDate(DateUtil.convDateFormatted(selectDate));
		// {\ݒ
		setLabelBasisInfo(kCode);
		// cƐ\ݒ
		setOverTimeRequestInfo();
		// xɐ\ݒ
		setHolidayRequestInfo();
		// \ݒ
		setLabelAttendanceInfo(selectDate);
		// Jgݒ
		setLaborAgreementInfo(kCode, selectDate);
	}
	
	/**
	 * \ӏݒ
	 * @param selectDate	Ώ۔N
	 * @throws Exception 	O
	 */
	protected void setLabelAttendanceInfo(Date selectDate) throws Exception {
		AttendanceMenuVo vo = (AttendanceMenuVo)getVo();
		if (VariousUtil.isNotNull(selectDate)) {
			vo.setLblDate(DateUtil.convDateToFormatDateJP(selectDate));
			vo.setLblDayOfWeek(VariousUtil.getDayOfWeek(DateUtil.getDayOfWeek(selectDate)));
			vo.setDayOfWeekColorClass(getDayOfWeekColorClass(selectDate));
			Date formerDate = DateUtil.addDay(selectDate, -1);
			Date nextDate = DateUtil.addDay(selectDate, 1);
			vo.setHidFormerDate(DateUtil.convDateFormatted(formerDate));
			vo.setLblFormerDate(DateUtil.convDateToFormatDateJP(formerDate));
			vo.setHidNextDate(DateUtil.convDateFormatted(nextDate));
			vo.setLblNextDate(DateUtil.convDateToFormatDateJP(nextDate));
		}
	}
	
	/**
	 * \[hZbg
	 * <p>[VK]A[XV]A[Fς]</p>
	 * @param dto	ΏDTO
	 * @throws Exception 	O
	 */
	protected void setMode(MSyukkinboDto dto) throws Exception {
		AttendanceMenuVo vo = (AttendanceMenuVo)getVo();
		vo.setMode(AttendanceMenuVo.MODE_INSERT);
		if (chkExistDto(dto)) {
			vo.setMode(AttendanceMenuVo.MODE_EDIT);
			if (KintaiApprovalPart.isApproved(dto)) {
				vo.setMode(AttendanceMenuVo.MODE_APPROVED);
			}
		}
	}
	
	/**
	 * Αӌ
	 * @throws Exception	Oꍇ
	 */
	protected void searchAttendance() throws Exception {
		// Αӌ
		String kCode = key1;
		String strDate = key2;
		if (StringUtil.isNull(key1)) {
			kCode = user.getKCode();
			request.setAttribute(SELECT_K_CODE, kCode);
		}
		if (StringUtil.isNull(key2)) {
			strDate = DateUtil.convDateFormatted(DateUtil.getSystemDate());
			request.setAttribute(SELECT_DATE, strDate);
		}
		MSyukkinboDto dto = kintai().getSyukkinboInfo(kCode, strDate, false);
		if (VariousUtil.chkExistDto(dto)) {
			if (!KintaiCommonPart.isHoliday(dto)) {
				// oΗLAދΖ
				if (StringUtil.isNull(dto.getTaJikoku()) && !KintaiCommonPart.isWeekHoliday(dto)
						&& !KintaiCommonPart.isOfficialHoliday(dto)) {
					// ދΕ\
					setNextCmd(AttendanceQuitCardAction.CMD_QUIT_CARD_SHOW);
				} else {
					// oΗLAދΗLiTx̏ꍇj
					// mF\
					setNextCmd(AttendanceCheckCardAction.CMD_CHECK_CARD_SELECT);
				}
			} else {
				// xɕ\
				setNextCmd(AttendanceHolidayCardAction.CMD_HOLIDAY_CARD_SHOW);
			}
		} else {
			// oΕ\
			setNextCmd(AttendanceStartCardAction.CMD_START_CARD_SHOW);
		}
		// T[ubg֓]
		setUrl(MospConst.URL_SRV);
	}
	
	/**
	 * j̎擾
	 * <p>	2009/02/25	m.yoshida	j\bhC </p>
	 * @param targetDate		Ώ۔N
	 * @return	Ώ۔Nj
	 * @throws Exception	Oꍇ
	 */
	protected String getPublicHolidayName(Date targetDate) throws Exception {
		return part().jpholiday().getPublicHolidayName(targetDate);
	}
	
	/**
	 * ΑӈꗗpTu^CgR}h̐ݒ
	 */
	protected void setSubTitleMenu() {
		AttendanceMenuVo vo = (AttendanceMenuVo)getVo();
		// ΑӊǗR}h
		if (VariousUtil.isNotNull(getStoredVo(EmployeeAttendanceListVo.class.getName()))) {
			// ԑJڊmF
			vo.setCmdMenuButton(CommonConst.CMD_MENU_MAMAGE);
			vo.setCmdListButton(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
			vo.setNamListButton(CommonConst.TTL_ATTENDANCE_LIST);
			// j[{^
			vo.setAryMenu(true);
		} else {
			vo.setCmdMenuButton(CommonConst.CMD_MENU_INPUT);
			vo.setCmdListButton(CommonConst.CMD_MENU_INPUT);
			vo.setNamListButton(CommonConst.NAM_MENU);
			// j[{^
			vo.setAryMenu(false);
		}
	}
	
	/**
	 * oἘo^
	 * @param dto			ΏDTO
	 * @throws Exception	Oꍇ
	 */
	protected void registSyukkinbo(MSyukkinboDto dto) throws Exception {
		if (VariousUtil.isNotNull(dto)) {
			MSyukkinboDto currentDto = kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke());
			if (VariousUtil.isNotNull(currentDto)) {
				if (!KintaiApprovalPart.isApproved(dto)) {
					// rmF
					chkExclusive(currentDto, kintai().lockSyukkinboInfo(dto.getKCode(), dto.getHizuke()));
					// XV
					syukkinboDao().update(dto);
				} else {
					// Fς݂̏ꍇ
					StringBuffer sb = new StringBuffer();
					sb.append(getKName(dto.getKCode()));
					sb.append(CommonConst.MSG_OF);
					sb.append(getMessage(CommonConst.MSG_ALREADY_APPROVED, getMessageDate(dto)));
					// G[bZ[W
					addErrMessage(sb.toString());
				}
			} else {
				// o^
				syukkinboDao().insert(dto);
			}
			// DTO̍Ď擾
			chkUpdate(kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke()));
		}
	}
	
	/**
	 * ΑӍڍ폜
	 * @throws Exception	Oꍇ
	 */
	protected void delete() throws Exception {
		AttendanceMenuVo vo = (AttendanceMenuVo)getVo();
		vo.setParams(request);
		MSyukkinboDto dto = kintai().getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate(), true);
		// f[^݊mF
		chkExist(dto);
		// Fς݂̏ꍇ̓bZ[W\A폜s
		if (KintaiApprovalPart.isApproved(dto)) {
			// bZ[Wݒ
			setMessage(getMessage(CommonConst.MSG_ALREADY_APPROVED, getMessageDate(dto)));
		} else {
			// 폜
			syukkinboDao().delete(dto);
			// R~bg
			commit();
			// bZ[Wݒ
			setMessage(getMessage(MospConst.MSG_DELETE, ""));
		}
		// Αӈꗗ֑J
		setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
	}
	
	/*XPW[֘A*/

	/**
	 * \茎ꗗf[^
	 * @param kCode		ΏێЈR[h
	 * @return scheduleList
	 * @throws Exception	Oꍇ
	 */
	protected List<MScheduleDto> getScheduleList(String kCode) throws Exception {
		// ꗗ̎擾
		scheduleList = kintai().getScheduleList(kCode, startDate, endDate);
		return scheduleList;
	}
	
	/**
	 * \茎ꗗf[^擾
	 * @param kCode       ΏێЈR[h
	 * @param targetMonth Ώی
	 * @return \냊Xg
	 * @throws Exception	Oꍇ
	 */
	protected List<MScheduleDto> getScheduleList(String kCode, Date targetMonth) throws Exception {
		// ͈͎擾
		startDate = DateUtil.convDateFormatted(getStartDate(targetMonth));
		endDate = DateUtil.convDateFormatted(getEndDate(targetMonth));
		// 
		getScheduleList(kCode);
		return scheduleList;
	}
	
	/**
	 * \茎ꗗf[^擾i\pj
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param kCode 		ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return \냊Xg
	 * @throws Exception	Oꍇ
	 */
	protected List<MScheduleDto> getScheduleListForView(String kCode, Date targetDate) throws Exception {
		// ͈͎擾
		startDate = DateUtil.convDateFormatted(getStartDateForList(targetDate));
		endDate = DateUtil.convDateFormatted(getEndDateForList(targetDate));
		// 
		getScheduleList(kCode);
		return scheduleList;
	}
	
	/**
	 * Wvf[^Ԑݒ
	 * @param scheduleList		Ώۗ\냊Xg
	 * @throws Exception	Oꍇ
	 */
	protected void setScheduleHours(List<MScheduleDto> scheduleList) throws Exception {
		// Αӏݒ
		setCalcParam();
		// Wvf[^擾
		for (MScheduleDto dto : scheduleList) {
			if (KintaiCommonPart.isHoliday(dto)) {
				// xɂ̏ꍇ
				dto.setKKJikan(allHoliday);
			} else {
				// o΂̏ꍇ
				if (KintaiCommonPart.isAvailableWorkType(dto)) {
					// ΑӍڂ̌vZ
					kintai().runCalculatedInfo(dto);
				}
			}
		}
	}
	
	/**
	 * XPW[o^
	 * @param kCode			ΏێЈR[h
	 * @param map	Ώۓo^XPW[
	 * @return	XVEo^
	 * @throws Exception	Oꍇ
	 */
	protected int registSchedule(String kCode, Map<Date, String> map) throws Exception {
		// XVEo^
		int number = 0;
		Set<Entry<Date, String>> entrySet = map.entrySet();
		HumanBasisDtoInterface targetBasis = getBasisInfo(kCode);
		// XPW[o^
		for (Entry<Date, String> entry : entrySet) {
			Date targetDate = entry.getKey();
			// Ζ`ԃR[h
			String workTypeCode = entry.getValue();
			boolean deleteFlag = false;
			if (StringUtil.isNull(workTypeCode)) {
				// Ζ`Ԃ󗓂ȂΏۓ̗\폜
				deleteFlag = true;
			}
			// Ώ۔NFĂꍇA\XVȂB
			if (!KintaiApprovalPart.isApproved(kintai().getSyukkinboInfo(kCode, targetDate))) {
				MScheduleDto dto;
				if (deleteFlag) {
					// 폜
					dto = kintai().getScheduleInfo(kCode, targetDate);
					if (VariousUtil.isNotNull(dto)) {
						// f[^̍폜
						scheduleDao().delete(dto);
						number++;
					}
				} else {
					// Ζ`ԂftHg̒l擾A\DTOɃZbg
					dto = kintai().createScheduleInfo(targetBasis, targetDate, workTypeCode);
					if (KintaiCommonPart.isWeekHoliday(dto) || KintaiCommonPart.isOfficialHoliday(dto)) {
						// x܂͖@x̏ꍇAoΕƗ\\ɓlo^
						registSyukkinbo(KintaiCommonPart.copyToSyukkinbo(dto));
					}
					// Fς݋xɐ\Ή
					margeHolidayRequest(dto);
					// \ɓo^
					registSchedule(dto);
					number++;
				}
			}
		}
		return number;
	}
	
	/**
	 * \̓o^
	 * @param dto	ΏDTO
	 * @throws Exception	Oꍇ
	 */
	protected void registSchedule(MScheduleDto dto) throws Exception {
		if (VariousUtil.isNotNull(dto)) {
			MScheduleDto currentDto = kintai().getScheduleInfo(dto.getKCode(), dto.getHizuke());
			if (chkExistDto(currentDto)) {
				// rmF
				chkExclusive(currentDto, kintai().lockScheduleInfo(dto.getKCode(), dto.getHizuke()));
				// XV
				scheduleDao().update(dto);
			} else {
				// o^
				scheduleDao().insert(dto);
			}
			// DTO̍Ď擾	
			chkUpdate(kintai().getScheduleInfo(dto.getKCode(), dto.getHizuke()));
		}
	}
	
	/**
	 * J}؂̓t擾
	 * @param dto ΏDTO
	 * @return	J}؂̓t
	 */
	protected String getMessageDate(KintaiCommonDtoInterface dto) {
		return DateUtil.convDateFormattedByComma(DateUtil.convStringDateToDate(dto.getHizuke()));
	}
	
	/**
	 * cƐ\ݒ
	 * @throws Exception	Oꍇ
	 */
	protected void setOverTimeRequestInfo() throws Exception {
		AttendanceMenuVo vo = (AttendanceMenuVo)getVo();
		// cƐ\擾
		CtOvertimeRequestDto dto = part().overtime().getOverTimeRequest(vo.getHidKCode(),
				DateUtil.convStringDateToDate(vo.getHidDate()));
		// 
		vo.setLblOverTimeRequest("");
		vo.setLblOverTimeRequestStatus("");
		if (VariousUtil.chkExistDto(dto)) {
			// \
			vo.setLblOverTimeRequest(TimeUtil.convIntegerTimeToJPHours(dto.getOverTime()));
			// F
			vo.setLblOverTimeRequestStatus(part().kintaiApproval().getApprovalName(
					part().workflow().toKintaiApprovalStatus(dto.getWorkflow())));
		}
	}
	
	/**
	 * xɐ\ݒ
	 * @throws Exception	Oꍇ
	 */
	protected void setHolidayRequestInfo() throws Exception {
		AttendanceMenuVo vo = (AttendanceMenuVo)getVo();
		// xɐ\擾
		vo.setAryHolidayRequestStatus(getLabelHolidayRequestStatusArray(vo.getHidKCode(), DateUtil
			.convStringDateToDate(vo.getHidDate())));
	}
	
	/**
	 * KintaiCommonPartCX^X擾
	 * @return	KintaiCommonPartCX^X
	 * @throws MospException	MosPOꍇ
	 * @throws ClassNotFoundException	 NXȂꍇ
	 * @throws SQLException	SQLOꍇ
	 */
	protected KintaiCommonPart kintai() throws MospException, ClassNotFoundException, SQLException {
		return part().kintai();
	}
	
	/**
	 * KintaiCompilePartCX^X擾
	 * @return	KintaiCompilePartCX^X
	 * @throws MospException	MosPOꍇ
	 * @throws ClassNotFoundException	 NXȂꍇ
	 * @throws SQLException	SQLOꍇ
	 */
	protected KintaiCompilePart compile() throws MospException, ClassNotFoundException, SQLException {
		return part().compile();
	}
	
	/**
	 * jtHgFݒ
	 * @param targetDate	Ώ۔N
	 * @return	tHgF̃NX
	 * @throws Exception	Oꍇ
	 */
	public String getDayOfWeekColorClass(Date targetDate) throws Exception {
		return kintai().getDayOfWeekColorClass(targetDate);
	}
	
	/**
	 * xɎԐ\ƏoΕ̃}[W
	 * @param dto		ΏDTO
	 * @throws Exception	Oꍇ
	 */
	protected void margeHolidayRequest(KintaiCommonDtoInterface dto) throws Exception {
		part().holidayRequest().margeHolidayRequest(dto);
	}
	
	/**
	 * XPW[pΑӊǗR}hݒ
	 */
	protected void setScheduleMenuButton() {
		MosPScheduleVo vo = (MosPScheduleVo)getVo();
		// ΑӊǗR}h
		if (VariousUtil.isNotNull(getStoredVo(EmployeeAttendanceListVo.class.getName()))) {
			// ԑJڊmF
			vo.setCmdMenuButton(CommonConst.CMD_MENU_MAMAGE);
			vo.setCmdListButton(EmployeeAttendanceListAction.CMD_EMPLOYEE_LIST_RE_SEARCH);
			vo.setNamListButton(CommonConst.TTL_EMPLOYEE_SELECT);
			// j[R}h̐ݒ
			vo.setAryMenu(true);
		} else {
			vo.setCmdMenuButton(CommonConst.CMD_MENU_INPUT);
			vo.setCmdListButton(MosPMenuConst.getMenuSchedule()[0]);
			vo.setNamListButton(MosPMenuConst.getMenuSchedule()[1]);
			// j[R}h̐ݒ
			vo.setAryMenu(true);
		}
	}
	
	/**
	 * ԊOxԐݒ
	 */
	protected void setUserOverTimeCautionInfo() {
		if (VariousUtil.isNotNull(agreement)) {
			// 60ԎԊOx
			caution60Hour = agreement.getCautionMonth();
			// 1Ňxx
			cautionLimitYear = agreement.getCautionYear();
			warnLimitYear = agreement.getLimitYear();
		}
	}
	
	/**
	 * LxiVe[uj̓o^EXV
	 * @param dto ΏDTO
	 * @param isUpdate XVf
	 * @return Lx̓o^łꍇtrueAłȂꍇfalseB
	 * @throws Exception 	Oꍇ
	 */
	protected boolean registPaidHoliday(KdPaidHolidayDto dto, boolean isUpdate) throws Exception {
		KdPaidHolidayDao dao = part().paidHoliday().getPaidHolidayDao();
		if (isUpdate) {
			// rmF
			chkExclusive(dto, dao.findForUpdate(dto.getPaidId(), dto.getKCode()));
			// XV
			dao.update(dto);
			chkUpdate(dao.findForKey(dto.getPaidId(), dto.getKCode()));
			return true;
		} else {
			String maxPaidId = dao.findForMax(dto.getKCode());
			if (StringUtil.isNotNull(maxPaidId)) {
				long paidId = Long.parseLong(maxPaidId) + 1;
				// dmF
				chkDuplicate(dao.findForUpdate(paidId, dto.getKCode()));
				dto.setPaidId(paidId);
				// o^
				dao.insert(dto);
				chkInsert(dao.findForKey(dto.getPaidId(), dto.getKCode()));
				return true;
			}
		}
		return false;
	}
	
	/**
	 * ԊOxf
	 * @param overTime ΏێԊO
	 * @param input ͎ԊO
	 * @return cƎԂ̍vxԈȏ̏ꍇtrueAłȂꍇfalseB
	 */
	protected boolean checkCautionOverTime(int overTime, int input) {
		setUserOverTimeCautionInfo();
		if (overTime + input >= caution60Hour && caution60Hour > 0) {
			return true;
		}
		return false;
	}
	
	/**
	 * ԊOߔf
	 * @param overTime ΏێԊO
	 * @param input ͎ԊO
	 * @return cƎԂ̍v60Ԉȏ̏ꍇtrueAłȂꍇfalseB
	 */
	protected boolean checkWarningOverTime(int overTime, int input) {
		setUserOverTimeCautionInfo();
		if (overTime + input > warn60Hour && caution60Hour > 0) {
			return true;
		}
		return false;
	}
	
	/**
	 * Ώ۔Ň60ԎԊOxf
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @param inputOverTime Ώ۔N̎cƎ
	 * @return
	 * <p>
	 * Ώ۔NWvԂ̎cƎԂƑΏ۔N̎cƎԂ̍vxԈȏ̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	protected boolean checkCautionOverTimeMonthly(String kCode, Date targetDate, int inputOverTime) throws Exception {
		// WvJnO܂ł̎cƎ
		int overTime = part().kintai().getOverTimeForPeriod(kCode, getStartDateForList(targetDate),
				DateUtil.addDay(targetDate, -1));
		// WvI܂ł̎cƎ
		overTime += part().kintai().getOverTimeForPeriod(kCode, DateUtil.addDay(targetDate, 1),
				getEndDateForList(targetDate));
		return checkCautionOverTime(overTime, inputOverTime);
	}
	
	/**
	 * Ώ۔Ň60ԎԊOߔf
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @param inputOverTime Ώ۔N̎cƎ
	 * @return
	 * <p>
	 * Ώ۔NWvԂ̎cƎԂƑΏ۔N̎cƎԂ̍v60Ԉȏ̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	protected boolean checkWarningOverTimeMonthly(String kCode, Date targetDate, int inputOverTime) throws Exception {
		// WvJnO܂ł̎cƎ
		int overTime = part().kintai().getOverTimeForPeriod(kCode, getStartDateForList(targetDate),
				DateUtil.addDay(targetDate, -1));
		// WvI܂ł̎cƎ
		overTime += part().kintai().getOverTimeForPeriod(kCode, DateUtil.addDay(targetDate, 1),
				getEndDateForList(targetDate));
		return checkWarningOverTime(overTime, inputOverTime);
	}
	
	/**
	 * Ώ۔Ň60ԎԊOxf
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @return 
	 * <p>
	 * Ώ۔N܂ł̎cƎԂxԈȏ̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	protected boolean checkCautionOverTimeMonthly(String kCode, Date targetDate) throws Exception {
		MSyukkinboDto dto = part().kintai().getSyukkinboInfo(kCode, targetDate);
		int overTime = 0;
		if (VariousUtil.isNotNull(dto)) {
			overTime = dto.getZaJikan();
		}
		return checkCautionOverTimeMonthly(kCode, targetDate, overTime);
	}
	
	/**
	 * Ώ۔Ň60ԎԊOߔf
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @return
	 * <p>
	 * Ώ۔N̎cƎԂ60Ԉȏ̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	protected boolean checkWarningOverTimeMonthly(String kCode, Date targetDate) throws Exception {
		MSyukkinboDto dto = part().kintai().getSyukkinboInfo(kCode, targetDate);
		int overTime = 0;
		if (VariousUtil.isNotNull(dto)) {
			overTime = dto.getZaJikan();
		}
		return checkWarningOverTimeMonthly(kCode, targetDate, overTime);
	}
	
	/**
	 * Ώ۔Ň60ԎԊOfݒ
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @throws Exception 	Oꍇ
	 */
	protected void setOverTimeCaution(String kCode, Date targetDate) throws Exception {
		AttendanceMenuVo vo = (AttendanceMenuVo)getVo();
		setLaborAgreementInfo(kCode, targetDate);
		vo.setCaution(checkCautionOverTimeMonthly(kCode, targetDate));
		vo.setWarning(checkWarningOverTimeMonthly(kCode, targetDate));
	}
	
	/**
	 * Ώ۔Ň60ԎԊOfݒ
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @param inputOverTime Ώ۔N̎cƎ
	 * @throws Exception 	Oꍇ
	 */
	protected void setOverTimeCaution(String kCode, Date targetDate, int inputOverTime) throws Exception {
		AttendanceMenuVo vo = (AttendanceMenuVo)getVo();
		setLaborAgreementInfo(kCode, targetDate);
		vo.setCaution(checkCautionOverTimeMonthly(kCode, targetDate, inputOverTime));
		vo.setWarning(checkWarningOverTimeMonthly(kCode, targetDate, inputOverTime));
	}
	
	/**
	 * \pΏۋxɈꗗiF󋵒ǉj擾B
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @return \pΏۋxɈꗗiF󋵒ǉj
	 * @throws Exception 	Oꍇ
	 */
	protected String[] getLabelHolidayRequestStatusArray(String kCode, Date targetDate) throws Exception {
		return part().holidayRequest().getLabelHolidayRequestStatusArray(
				part().holidayRequest().getDateRequestList(kCode, targetDate));
	}
	
	/**
	 * M_CODEw肳ꂽTCODẼR[hϊiȂ΃R[h́jlength擾
	 * @param tid M_CODE猟TID
	 * @param tcode M_CODE猟TCODE
	 * @param length 擾镶
	 * @return 擾(length0̏ꍇASԂ)
	 * @throws Exception    Oꍇ
	 */
	protected String getTChangeOrTName(String tid, String tcode, int length) throws Exception {
		MCodeDto dto = part().mospcode().findForKey(tid, tcode);
		if (VariousUtil.isNotNull(dto)) {
			String tName = dto.getTName();
			String tChange = dto.getTChange();
			if (StringUtil.isNotNull(tChange)) {
				if (length != 0) {
					return tChange.substring(0, length);
				} else {
					return tChange;
				}
			}
			if (StringUtil.isNotNull(tName)) {
				if (length != 0) {
					return tName.substring(0, length);
				} else {
					return tName;
				}
			}
		}
		return "";
	}
	
}
