/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.utils;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

/**
 * DataSourceɊւ郆[eBeB
 * @author yoshida
 *
 */
public class DataSourceUtil {
	
	/**
	 * Tomcat5.5pConst
	 */
	private static final String	TOMCAT_SERVER_ENV		= "java:comp/env";
	
	/**
	 * 
	 */
	public static final String	USE_DATA_SOURCE_MESSAGE	= "use DataSource.";
	

	/**
	 * 
	 */
	private DataSourceUtil() {
		// NXɂCX^Xh~
	}
	
	/**
	 * DataSource\bh
	 * @param datasource f[^\[X
	 * @return	DataSource
	 */
	public static DataSource getDataSource(String datasource) {
		DataSource ds = null;
		try {
			Context ctx = new InitialContext();
			Context env = (Context)ctx.lookup(TOMCAT_SERVER_ENV);
			if (datasource != null && datasource.length() != 0) {
				ds = (DataSource)env.lookup(datasource);
			}
		} catch (NamingException e) {
			return ds;
		}
		return ds;
	}
	
	/**
	 * DataSourcepۃ\bh
	 * @param datasource f[^\[X
	 * @return
	 * <p>
	 * DataSourcepł̂ȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean canUseDataSource(String datasource) {
		return getDataSource(datasource) == null ? false : true;
	}
	
}
