/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * ʓǍǉ
 * @param 
 * @return 
 * @throws sO
 */
function onLoadExtra() {
	// ڔwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID,     COLOR_FIELD_NORMAL);
	setFieldsBgColor(ARY_ERR_FIELDS_ID, COLOR_FIELD_ERROR);
	// ڒݒ
	);
	
	// tH[JX擾Cxgnhݒ
	setOnFocusHandler(aryTargetId);
	// \J}}
	setAllInsertComma();
	// tH[JXݒ
	setFocus(PRM_TXT_CHANGE_K_CODE);
	
	
}

function chkTargetObject(objTarget) {
	for (var i = 0; i < aryTargetId.length; i++) {
		if (objTarget == getObject(aryTargetId[i])) {
			return true;
		}
		if (i == aryTargetId.length - 1) {
			return false;
		}
	}
}

function onLostFocusExtra(e) {
	var objTarget = getSrcElement(e);
	if (chkTargetObject(objTarget)) {
		if(!objTarget.readOnly) {
			setZero(objTarget);
			insertComma(objTarget);
		}
	}

}


function onFocusExtra(e) {
	var objTarget = getSrcElement(e);
	if (chkTargetObject(objTarget)) {
		if(!objTarget.readOnly) {
			delComma(getObject(objTarget));
			setSpace(getObject(objTarget));
		}
	}

}

/**
 * SڃJ}}
 * @param 
 * @return 
 * @throws sO
 */
function setAllInsertComma() {
	// \J}}
	for (var i = 0; i < aryTargetId.length; i++) {
		insertComma(getObject(aryTargetId[i]));
	}
}

/**
 * SڃJ}폜
 * @param 
 * @return 
 * @throws sO
 */
function setAllDelComma() {
	// J}폜
	for (var i = 0; i < aryTargetId.length; i++) {
		delComma(getObject(aryTargetId[i]));
	}
}

/**
 * ̓`FbN
 * @param 
 * @return `FbN(trueFOKAfalseFNG)
 * @throws sO
 */
function validate() {
	// tB[hwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID, COLOR_FIELD_NORMAL);
	// ̓`FbN
//	var aryMessage = new Array();
}

/**
 * Ƒt
 * @param 
 * @return 
 * @throws 
 */
function addFamilyInfo() {
	try {
		var familyInfo       = getFormValue(PRM_HID_FAMILY_INFO        );
		var withholdSlipNote = getFormValue(PRM_TXT_WITHHOLD_SLIP_NOTES);
		var note             = withholdSlipNote + familyInfo;
		if (note.length <= LEN_WITHHOLD_NOTES) {
			setFormValue(PRM_TXT_WITHHOLD_SLIP_NOTES, withholdSlipNote + familyInfo);
		}
	} catch (e) {
		handleException(e);
	}
}

/**
 * یTzݒ
 * @param 
 * @return 
 * @throws 
 */
function setLifeInsDeduction() {
	try {
		// J}폜
		delComma(getObject(PRM_TXT_GENERAL_LIFE_INS));
		delComma(getObject(PRM_TXT_PRIVATE_PENSION));
		if (
			checkNumberNoMsg(PRM_TXT_GENERAL_LIFE_INS) &&
			checkNumberNoMsg(PRM_TXT_PRIVATE_PENSION )
		) {
			setFormValue(
				PRM_TXT_LIFE_INS_DEDUCTION, calcLifeInsDeduction(
				new Number(getFormValue(PRM_TXT_GENERAL_LIFE_INS)),
				new Number(getFormValue(PRM_TXT_PRIVATE_PENSION ))
			));
			// J}}
			insertComma(getObject(PRM_TXT_LIFE_INS_DEDUCTION));
			insertComma(getObject(PRM_TXT_GENERAL_LIFE_INS));
			insertComma(getObject(PRM_TXT_PRIVATE_PENSION));
			
		}
	} catch (e) {
		handleException(e);
	}
}

/**
 * QیTzݒ
 * @param 
 * @return 
 * @throws 
 */
function setDamageInsDeduction() {
	try {
		// J}폜
		delComma(getObject(PRM_TXT_EARTHQUAKE_INS));
		delComma(getObject(PRM_TXT_LONG_TERM_DAMAGE_INS));
		if (
			checkNumberNoMsg(PRM_TXT_EARTHQUAKE_INS      ) &&
			checkNumberNoMsg(PRM_TXT_LONG_TERM_DAMAGE_INS)
		) {
			setFormValue(
				PRM_TXT_DAMAGE_INS_DEDUCTION, calcDamageInsDeduction(
				new Number(getFormValue(PRM_TXT_EARTHQUAKE_INS      )),
				new Number(getFormValue(PRM_TXT_LONG_TERM_DAMAGE_INS))
			));
			// J}}
			insertComma(getObject(PRM_TXT_DAMAGE_INS_DEDUCTION));
			insertComma(getObject(PRM_TXT_EARTHQUAKE_INS));
			insertComma(getObject(PRM_TXT_LONG_TERM_DAMAGE_INS));
		}
	} catch (e) {
		handleException(e);
	}
}

/**
 * یTzZo
 * @param generalLifeIns ʂ̐یz
 * @param privatePension lNیz
 * @return یTz
 * @throws sO
 */
function calcLifeInsDeduction(generalLifeIns, privatePension) {
	return calcLifeInsDeductionEach(generalLifeIns) +
			calcLifeInsDeductionEach(privatePension);
}

/**
 * یTzZo()
 * @param premium ی
 * @return Tz
 * @throws sO
 */
function calcLifeInsDeductionEach(premium) {
	// 25000~ȉxی̑Sz
	if (premium <= 25000) {
		return premium;
	}
	// 25001~`50000~xی̋z2+12500
	if (premium <= 50000) {
		return Math.ceil(premium / 2) + 12500;
	}
	// 50001~`100000~xی̋z4+25000
	if (premium <= 100000) {
		return Math.ceil(premium / 4) + 25000;
	}
	// 100001~ȏとꗥ50000
	return 50000;
}

/**
 * QیTzZo
 * @param 
 * @return 
 * @throws sO
 */
function calcDamageInsDeduction(earthQuakeIns, longTermDamageIns) {
	var damageInsDeduction = 0;
	// nkی̋z(ō50000~)
	if (earthQuakeIns <= 50000) {
		damageInsDeduction += earthQuakeIns;
	} else {
		damageInsDeduction += 50000;
	}
	// zی̋z
	if (longTermDamageIns <= 10000) {
		// 10000~ȉxی̑Sz
		damageInsDeduction += longTermDamageIns;
	} else if (longTermDamageIns <= 20000) {
		// 10001~`20000~xی̋z2+5000
		damageInsDeduction += Math.ceil(longTermDamageIns / 2) + 5000;
	} else {
		// 20001~ȏとꗥ15000
		damageInsDeduction += 15000;
	}
	// QیTz(ō50000~)
	if (damageInsDeduction <= 50000) {
		return damageInsDeduction;
	}
	return 50000;
}

/**
 * J}}
 * @param sourceStr Ώە
 * @return 
 * @throws sO
 */
function insertComma(objTarget) {
	var destStr = getFormValue(objTarget);
	var tmpStr = "";
	while (destStr != (tmpStr = destStr.replace(/^([+-]?\d+)(\d\d\d)/,"$1,$2"))) {
		destStr = tmpStr;
	}
	setFormValue(objTarget, destStr);
}



/**
 * J}폜
 * @param w Ώە
 * @return 
 * @throws sO
 */
function delComma(objTarget) {

	var targetMonney = getFormValue(objTarget);
	setFormValue(objTarget, targetMonney.replace(/,/g,""));
}

/**
 * 0~󔒑}
 * @param w Ώە
 * @return 
 * @throws sO
 */
function setSpace(objTarget) {
	var targetMonney = getFormValue(objTarget);
	if(targetMonney == "0"){
		setFormValue(objTarget, "");
	}
}

/**
 * 󔒎0~}
 * @param w Ώە
 * @return 
 * @throws sO
 */
function setZero(objTarget) {
	var targetMonney = getFormValue(objTarget);
	if(targetMonney == ""){
		setFormValue(objTarget, "0");
	}
}


/**
 * T[o[ʐM
 * @param objForm tH[IuWFNg
 * @param cmd     R}h
 * @param msg     bZ[WR[h
 * @param rep     u
 * @return 
 * @throws sO
 */
function submitForm(objForm, cmd, msg, rep) {
	// J}폜
	setAllDelComma();
	// ̓`FbN
	if (validate()) {
		// T[o[ʐM
		submitMessageForm(objForm, cmd, msg, rep);
	}
}

/**
 * T[o[ʐM
 * @param objForm tH[IuWFNg
 * @param cmd     R}h
 * @param msg     bZ[WR[h
 * @param rep     u
 * @return 
 * @throws sO
 */
function submitMessageForm(objForm, cmd, code, rep) {
	if (!confirm(getMessage(code, rep))) {
		// J}}
		setAllInsertComma();
		return;
	}
	// submit
	doSubmit(objForm, cmd);
}

/**
 * keyݒtsubmit
 * @param objForm tH[IuWFNg
 * @param cmd     R}h
 * @param key1    L[1
 * @param key2    L[2
 * @return 
 * @throws sO
 */
function doSubmitKey(objForm, cmd, key1, key2) {
	// J}폜
	setAllDelComma();
	objForm.key1.value = key1;
	objForm.key2.value = key2;
	doSubmit(objForm, cmd);
}
