/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.util.Calendar;
import java.util.Date;

public final class ValidateUtility {
    public static boolean chkRequired(String value) {
        return value != null && !value.equals("");
    }

    public static boolean chkRegex(String regex, String value) {
        return value.matches(regex);
    }

    public static boolean chkNumeric(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean chkDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.set(year, month, day);
        try {
            calendar.getTime();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean chkTime(int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.set(1970, 0, 1, hour, minute, second);
        try {
            calendar.getTime();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean chkTerm(Date date, Date startDate, Date endDate) {
        return startDate.compareTo(date) <= 0 && endDate.compareTo(date) >= 0;
    }
}

