/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.spreadsheet.CalcNode;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.Column;
import org.jopendocument.dom.spreadsheet.ColumnStyle;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.dom.spreadsheet.TableCalcNode;
import org.jopendocument.dom.spreadsheet.TableStyle;
import org.jopendocument.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table<D extends ODDocument>
extends TableCalcNode<TableStyle, D> {
    private final List<Row<D>> rows = this.flatten(false);
    private final List<Column<D>> cols = this.flatten(true);
    private static final Pattern REF_PATTERN = Pattern.compile("([\\p{Alpha}]+)([\\p{Digit}]+)");

    static Element createEmpty(NS nS) {
        return new Element("table", nS.getTABLE());
    }

    public Table(D d, Element element) {
        super(d, element);
    }

    private List<? extends CalcNode> flatten(boolean bl) {
        Cloneable cloneable;
        String string = this.getName(bl);
        List list = this.getElement().getChildren("table-" + string, this.getTABLE());
        ListIterator<Element> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            cloneable = (Element)listIterator.next();
            Attribute attribute = ((Element)cloneable).getAttribute("number-" + string + "s-repeated", this.getTABLE());
            if (attribute == null) continue;
            ((Element)cloneable).removeAttribute(attribute);
            int n = listIterator.previousIndex();
            int n2 = Integer.parseInt(attribute.getValue());
            if (n2 > 60000) {
                n2 = 10;
            }
            for (int i = 0; i < n2 - 1; ++i) {
                Element element = (Element)((Element)cloneable).clone();
                listIterator.add(element);
            }
            listIterator = list.listIterator(n + n2);
        }
        cloneable = new ArrayList(list.size());
        for (Element element : list) {
            cloneable.add(bl ? new Column(this, element) : new Row(this, element, cloneable.size()));
        }
        return cloneable;
    }

    private final String getName(boolean bl) {
        return bl ? "column" : "row";
    }

    public final Object getPrintRanges() {
        return this.getElement().getAttributeValue("print-ranges", this.getTABLE());
    }

    public final void setPrintRanges(String string) {
        this.getElement().setAttribute("print-ranges", string, this.getTABLE());
    }

    public final void removePrintRanges() {
        this.getElement().removeAttribute("print-ranges", this.getTABLE());
    }

    public final synchronized void duplicateFirstRows(int n, int n2) {
        this.duplicateRows(0, n, n2);
    }

    public final synchronized void insertDuplicatedRows(int n, int n2) {
        this.duplicateRows(n, 1, n2);
    }

    public final synchronized void duplicateRows(int n, int n2, int n3) {
        int n4 = n + n2;
        List list = this.getElement().getChildren("table-row", this.getTABLE());
        ArrayList<Element> arrayList = new ArrayList<Element>(n2 * n3);
        for (int i = 0; i < n3; ++i) {
            for (int j = n; j < n4; ++j) {
                Element element = this.rows.get(j).getElement();
                arrayList.add((Element)element.clone());
            }
        }
        list.addAll(n4, arrayList);
        this.rows.clear();
        for (Element element : list) {
            this.addRow(element);
        }
    }

    private synchronized void addRow(Element element) {
        this.rows.add(new Row(this, element, this.rows.size()));
    }

    public final Point resolveHint(String string) {
        if (Table.isCellRef(string)) {
            return Table.resolve(string);
        }
        throw new IllegalArgumentException(string + " is not a cell ref, if it's a named range, you must use it on a SpreadSheet.");
    }

    public final boolean isCellValid(int n, int n2) {
        if (n > this.getColumnCount()) {
            return false;
        }
        if (n2 > this.getRowCount()) {
            return false;
        }
        return this.getImmutableCellAt(n, n2).isValid();
    }

    public final MutableCell<D> getCellAt(int n, int n2) {
        return this.getRow(n2).getMutableCellAt(n);
    }

    public final MutableCell<D> getCellAt(String string) {
        Point point = this.resolveHint(string);
        return this.getCellAt(point.x, point.y);
    }

    public final void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            object = "";
        }
        if (!object.equals(this.getValueAt(n, n2))) {
            this.getCellAt(n, n2).setValue(object);
        }
    }

    protected final Cell<D> getImmutableCellAt(int n, int n2) {
        return this.getRow(n2).getCellAt(n);
    }

    protected final Cell<D> getImmutableCellAt(String string) {
        Point point = this.resolveHint(string);
        return this.getImmutableCellAt(point.x, point.y);
    }

    public final Object getValueAt(int n, int n2) {
        return this.getImmutableCellAt(n, n2).getValue();
    }

    public final String getStyleNameAt(int n, int n2) {
        String string = this.getImmutableCellAt(n, n2).getStyleAttr();
        if (string != null) {
            return string;
        }
        string = this.getRow(n2).getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
        if (string != null) {
            return string;
        }
        return this.getColumn(n).getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
    }

    public final CellStyle getStyleAt(int n, int n2) {
        return StyleStyle.findStyle(this.getODDocument().getPackage(), CellStyle.class, this.getStyleNameAt(n, n2));
    }

    public final Object getValueAt(String string) {
        return this.getImmutableCellAt(string).getValue();
    }

    private Row<D> getRow(int n) {
        return this.rows.get(n);
    }

    public final Column<D> getColumn(int n) {
        return this.cols.get(n);
    }

    public final int getRowCount() {
        return this.rows.size();
    }

    public final int getColumnCount() {
        return this.cols.size();
    }

    public final void setColumnCount(int n) {
        this.setColumnCount(n, -1, false);
    }

    public final void ensureColumnCount(int n) {
        if (n > this.getColumnCount()) {
            this.setColumnCount(n);
        }
    }

    public final void setColumnCount(int n, int n2, boolean bl) {
        int n3 = n - this.getColumnCount();
        if (n3 < 0) {
            this.setCount(true, n);
        } else {
            int n4 = this.getColumnCount() == 0 ? this.getElement().getContentSize() - 1 : this.getElement().getContent().indexOf(this.getColumn(this.getColumnCount() - 1).getElement());
            Element element = n2 < 0 ? Column.createEmpty(this.getODDocument().getNS(), this.createDefaultColStyle()) : this.getColumn(n2).getElement();
            for (int i = 0; i < n3; ++i) {
                Element row2 = (Element)element.clone();
                this.getElement().addContent(n4 + 1 + i, row2);
                this.cols.add(new Column(this, row2));
            }
        }
        Float f = this.getWidth();
        float f2 = 0.0f;
        for (Column<D> column : this.cols) {
            f2 += column.getWidth();
        }
        if (bl && f != null) {
            float f3 = f.floatValue() / f2;
            HashSet hashSet = new HashSet();
            for (Column<D> column : this.cols) {
                hashSet.add(column.getStyle());
            }
            for (ColumnStyle columnStyle : hashSet) {
                columnStyle.setWidth(columnStyle.getWidth() * f3);
            }
        } else {
            if (this.getStyle() != null) {
                ((TableStyle)this.getStyle()).setWidth(f2);
            }
            for (Column<D> column : this.cols) {
                ((ColumnStyle)column.getStyle()).rmRelWidth();
            }
        }
        for (Row<D> row : this.rows) {
            row.columnCountChanged();
        }
    }

    public final Float getWidth() {
        TableStyle tableStyle = (TableStyle)this.getStyle();
        return tableStyle == null ? null : tableStyle.getWidth();
    }

    private final ColumnStyle createDefaultColStyle() {
        ColumnStyle columnStyle = StyleStyle.create(this.getODDocument(), ColumnStyle.class, "defaultCol");
        columnStyle.setWidth(20.0f);
        this.getContent().addAutoStyle(columnStyle.getElement());
        return columnStyle;
    }

    private final void setCount(boolean bl, int n) {
        CollectionUtils.delete(bl ? this.cols : this.rows, n);
        CollectionUtils.delete(this.getElement().getChildren("table-" + this.getName(bl), this.getTABLE()), n);
    }

    public final void ensureRowCount(int n) {
        if (n > this.getRowCount()) {
            this.setRowCount(n);
        }
    }

    public final void setRowCount(int n) {
        this.setRowCount(n, -1);
    }

    public final void setRowCount(int n, int n2) {
        Element element;
        if (n2 < 0) {
            element = Row.createEmpty(this.getODDocument().getNS());
            element.addContent(Cell.createEmpty(this.getODDocument().getNS(), this.getColumnCount()));
        } else {
            element = this.getRow(n2).getElement();
        }
        int n3 = n - this.getRowCount();
        if (n3 < 0) {
            this.setCount(false, n);
        } else {
            for (int i = 0; i < n3; ++i) {
                Element element2 = (Element)element.clone();
                this.getElement().addContent(element2);
                this.addRow(element2);
            }
        }
    }

    public final TableModel getTableModel(int n, int n2) {
        return new SheetTableModel(n2, n);
    }

    public final TableModel getTableModel(int n, int n2, int n3, int n4) {
        return new SheetTableModel(n2, n, n4, n3);
    }

    public final TableModel getMutableTableModel(int n, int n2) {
        return new MutableTableModel(n2, n);
    }

    public final void merge(TableModel tableModel, int n, int n2) {
        this.merge(tableModel, n, n2, false);
    }

    public final void merge(TableModel tableModel, int n, int n2, boolean bl) {
        int n3;
        int n4 = bl ? 1 : 0;
        this.ensureColumnCount(n + tableModel.getColumnCount());
        this.ensureRowCount(n2 + tableModel.getRowCount() + n4);
        TableModel tableModel2 = this.getMutableTableModel(n, n2);
        if (bl) {
            for (n3 = 0; n3 < tableModel.getColumnCount(); ++n3) {
                tableModel2.setValueAt(tableModel.getColumnName(n3), 0, n3);
            }
        }
        for (n3 = 0; n3 < tableModel.getRowCount(); ++n3) {
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                Object object = tableModel.getValueAt(n3, i);
                tableModel2.setValueAt(object, n3 + n4, i);
            }
        }
    }

    static final boolean isCellRef(String string) {
        return REF_PATTERN.matcher(string).matches();
    }

    static final Point resolve(String string) {
        Matcher matcher = REF_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string + " illegal");
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        return new Point(Table.toInt(string2), Integer.parseInt(string3) - 1);
    }

    static final int toInt(String string) {
        if (string.length() < 1) {
            throw new IllegalArgumentException("x cannot be empty");
        }
        string = string.toUpperCase();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = n * 26 + (string.charAt(i) - 65 + 1);
        }
        return n - 1;
    }

    private final class MutableTableModel
    extends SheetTableModel {
        private MutableTableModel(int n, int n2) {
            super(n, n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            Table.this.setValueAt(object, this.column + n2, this.row + n);
        }
    }

    private class SheetTableModel
    extends AbstractTableModel {
        protected final int row;
        protected final int column;
        protected final int lastRow;
        protected final int lastCol;

        private SheetTableModel(int n, int n2) {
            this(n, n2, table.getRowCount(), table.getColumnCount());
        }

        private SheetTableModel(int n, int n2, int n3, int n4) {
            this.row = n;
            this.column = n2;
            this.lastRow = n3;
            this.lastCol = n4;
        }

        public int getColumnCount() {
            return this.lastCol - this.column;
        }

        public int getRowCount() {
            return this.lastRow - this.row;
        }

        public Object getValueAt(int n, int n2) {
            return Table.this.getValueAt(this.column + n2, this.row + n);
        }
    }
}

