/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.util.JDOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Manifest {
    public static final String ENTRY_NAME = "META-INF/manifest.xml";
    private static final DocType DOC_TYPE = new DocType("manifest:manifest", "-//OpenOffice.org//DTD Manifest 1.0//EN", "Manifest.dtd");
    private final String version;
    private final Document doc;

    public static final Map<String, String> parse(InputStream inputStream) throws JDOMException, IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Document document = OOUtils.getBuilder().build(inputStream);
        for (Object e : document.getRootElement().getChildren()) {
            Element element = (Element)e;
            String string = element.getAttributeValue("full-path", element.getNamespace("manifest"));
            if (string.equals("/")) continue;
            String string2 = element.getAttributeValue("media-type", element.getNamespace("manifest"));
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public Manifest(String string, String string2) {
        this.version = string;
        this.doc = new Document(new Element("manifest", this.getNS()), (DocType)DOC_TYPE.clone());
        this.addEntry("/", string2);
    }

    private Namespace getNS() {
        return NS.get(this.version).getManifest();
    }

    public void addEntry(String string, String string2) {
        Element element = new Element("file-entry", this.getNS());
        element.setAttribute("media-type", string2, this.getNS());
        element.setAttribute("full-path", string, this.getNS());
        this.doc.getRootElement().addContent(element);
    }

    public String asString() {
        return JDOMUtils.output(this.doc);
    }
}

