/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.dto.MCodeDto;

/**
 * @author yoshida
 *
 */
public class HolidayMasterListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -5821780591448938644L;
	
	// 萔
	public static final int		SEARCH_OFF			= 0;
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	public static final String	PRM_TXT_H_DATE		= "txtHDate";
	public static final String	PRM_TXT_H_NAME		= "txtHName";
	
	// tB[h
	private String[]			aryHDate;
	private String[]			aryHName;
	private String				txtHDate;
	private String				txtHName;
	
	// tB[hyѐ
	public String				NAM_H_DATE;
	public String				NAM_H_NAME;
	public int					LEN_H_DATE;
	public int					LEN_H_NAME;
	
	// \[gL[	
	public final String			KEY_H_CODE			= "keyHDate";
	public final String			KEY_H_NAME			= "keyHName";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^
	 */
	public HolidayMasterListVo() {
		super();
		setViewPath(getClassName());
		txtHDate = "";
		txtHName = "";
		aryHDate = new String[0];
		aryHName = new String[0];
		setFormerKey(KEY_H_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_HOLIDAY_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_H_DATE = CommonConst.NAM_DATE;
		NAM_H_NAME = CommonConst.NAM_COMMON_MEISYO;
		LEN_H_DATE = 50;
		LEN_H_NAME = 50;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtHDate = request.getParameter(PRM_TXT_H_DATE);
		txtHName = request.getParameter(PRM_TXT_H_NAME);
	}
	
	@Override
	public void setFields(List<?> listCode) {
		// Xg̐ݒ
		list = listCode;
		// f[^̎擾
		count = listCode.size();
		// z̏
		aryHDate = new String[count];
		aryHName = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listCode.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			aryHDate[i] = escapeHTML(dto.getTCode());
			aryHName[i] = escapeHTML(dto.getTName());
			i++;
		}
	}
	
	// ANZT\bh
	public String[] getEscAryHDate() {
		return aryHDate.clone();
	}
	
	public String[] getEscAryHName() {
		return aryHName.clone();
	}
	
	public String getTxtHDate() {
		return txtHDate;
	}
	
	public String getTxtHName() {
		return txtHName;
	}
	
	public String getEscTxtHDate() {
		return escapeHTML(txtHDate);
	}
	
	public String getEscTxtHName() {
		return escapeHTML(txtHName);
	}
	
	public void setTxtHDate(String txtHDate) {
		this.txtHDate = txtHDate;
	}
	
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	public int getSearchmode() {
		return searchmode;
	}
	
}
