/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmUserDto;

/**
 * @author yoshida
 *
 */
public class AccountMasterListVo extends MosPVo {
	
	private static final long	serialVersionUID	= 445388768524423342L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	/**
	 * 
	 */
	public static final int		MODE_INSERT			= 0;
	/**
	 * 
	 */
	public static final int		MODE_VIEW			= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_USER_ID		= "txtUserId";
	/**
	 * 
	 */
	public static final String	PRM_TXT_USER_NAME	= "txtUserName";
	/**
	 * 
	 */
	public static final String	PRM_PLT_AUTHORITY	= "pltAuthority";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE		= "pltDelete";
	
	// tB[h
	private String[]			aryUserId;
	private String[]			aryUserName;
	private String[]			aryAuthority;
	private String[]			aryDelete;
	private String				txtUserId;
	private String				txtUserName;
	private String				pltAuthority;
	private String				pltDelete;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_USER_ID;
	/**
	 * 
	 */
	public String				NAM_USER_NAME;
	/**
	 * 
	 */
	public String				NAM_AUTHORITY;
	/**
	 * 
	 */
	public String				NAM_DELETE;
	/**
	 * 
	 */
	public int					LEN_USER_ID;
	/**
	 * 
	 */
	public int					LEN_USER_NAME;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_USER_ID			= "keyUserId";
	/**
	 * 
	 */
	public final String			KEY_USER_NAME		= "keyUserName";
	/**
	 * 
	 */
	public final String			KEY_AUTHORITY		= "keyAuthority";
	/**
	 * 
	 */
	public final String			KEY_DELETE			= "keyDelete";
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltAuthority;
	
	// [h(0FVKo^A1:\)
	private int					mode;
	

	/**
	 * RXgN^
	 */
	public AccountMasterListVo() {
		super();
		setViewPath(getClassName());
		txtUserId = "";
		txtUserName = "";
		pltAuthority = "";
		pltDelete = "";
		aryUserId = new String[0];
		aryUserName = new String[0];
		aryAuthority = new String[0];
		aryDelete = new String[0];
		setFormerKey(KEY_USER_ID);
		mode = MODE_INSERT;
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_ACCOUNT_MASTER;
		createAryMenu(CMD_MENU_SYSTEM2);
	}
	
	@Override
	protected void setFieldsName() {
		NAM_USER_ID = CommonConst.NAM_USER_ID;
		NAM_USER_NAME = CommonConst.NAM_USER_NAME;
		NAM_AUTHORITY = CommonConst.NAM_AUTHORITY;
		NAM_DELETE = CommonConst.NAM_DELETE_FLAG;
		LEN_USER_ID = 10;
		LEN_USER_NAME = 16;
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		txtUserId = request.getParameter(PRM_TXT_USER_ID);
		txtUserName = request.getParameter(PRM_TXT_USER_NAME);
		pltAuthority = request.getParameter(PRM_PLT_AUTHORITY);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	@Override
	public void setFields(List<?> listCmUser) throws MospException {
		// Xg̐ݒ
		list = listCmUser;
		// f[^̎擾
		count = listCmUser.size();
		// z̏
		aryUserId = new String[count];
		aryUserName = new String[count];
		aryAuthority = new String[count];
		aryDelete = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listCmUser.iterator();
		while (it.hasNext()) {
			CmUserDto dto = (CmUserDto)it.next();
			aryUserId[i] = escapeHTML(dto.getUserId());
			aryUserName[i] = escapeHTML(dto.getUserName());
			aryAuthority[i] = dto.getAuthority();
			aryDelete[i] = String.valueOf(dto.getDeleteFlag());
			aryAuthority[i] = escapeHTML(getCodeName(dto.getAuthority(), aryPltAuthority));
			if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_OFF) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_OFF_NAME);
			} else if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_ON) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_ON_NAME);
			} else {
				throw new MospException(MospConst.EX_CM_USER_ILLEGAL);
			}
			i++;
		}
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return	aryUserId
	 */
	public String[] getEscAryUserId() {
		return aryUserId.clone();
	}
	
	/**
	 * @return	aryUserName
	 */
	public String[] getEscAryUserName() {
		return aryUserName.clone();
	}
	
	/**
	 * @return	aryAuthority
	 */
	public String[] getEscAryAuthority() {
		return aryAuthority.clone();
	}
	
	/**
	 * @return	aryDelete
	 */
	public String[] getEscAryDelete() {
		return aryDelete.clone();
	}
	
	/**
	 * @return	txtUserId
	 */
	public String getTxtUserId() {
		return txtUserId;
	}
	
	/**
	 * @return	txtUserName
	 */
	public String getTxtUserName() {
		return txtUserName;
	}
	
	/**
	 * @return	pltAuthority
	 */
	public String getPltAuthority() {
		return pltAuthority;
	}
	
	/**
	 * @return	pltDelete
	 */
	public String getPltDelete() {
		return pltDelete;
	}
	
	/**
	 * @return	txtUserId
	 */
	public String getEscTxtUserId() {
		return escapeHTML(txtUserId);
	}
	
	/**
	 * @return	txtUserName
	 */
	public String getEscTxtUserName() {
		return escapeHTML(txtUserName);
	}
	
	/**
	 * @param pltDelete Zbg pltDelete
	 */
	public void setPltDelete(int pltDelete) {
		this.pltDelete = String.valueOf(pltDelete);
	}
	
	/**
	 * @param mode	Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
