/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.action.MosPCodeAction;
import jp.mosp.system.vo.LateReasonCardVo;

/**
 * @author yoshida
 *
 */
public class LateReasonCardAction extends MosPCodeAction {
	
	// R}h
	private static final String	CMD_LATE_REASON_CARD_SHOW	= "S2320";	// \
	private static final String	CMD_LATE_REASON_CARD_UPDATE	= "S2328";	// XV
																		
	
	/**
	 * RXgN^
	 */
	public LateReasonCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_LATE_REASON_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_LATE_REASON_CARD_UPDATE)) {
			// xRXV
			update();
			// \
			show();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new LateReasonCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmSystemAuth();
	}
	
	@Override
	protected void show() throws Exception {
		LateReasonCardVo vo = (LateReasonCardVo)getVo();
		// xR
		vo.setFields(part().mospcode().findForCondition(CommonConst.TID_LATE_REASON));
	}
	
	@Override
	protected void update() throws Exception {
		LateReasonCardVo vo = (LateReasonCardVo)getVo();
		vo.setParams(request);
		// tB[h̑ÓmF
		vo.validate();
		String[] aryReason = vo.getAryTxtLateReason();
		for (int i = 0; i < aryReason.length; i++) {
			// XV
			regist(CommonConst.TID_LATE_REASON, String.valueOf(i), aryReason[i], "");
		}
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
	}
	
}
