/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.action;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.Employee;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.InsuranceConfSetVo;
import jp.mosp.payroll.common.vo.InsuranceMonthlyCardVo;
import jp.mosp.payroll.dto.CdSocInsuranceDto;

public class InsuranceMonthlyCardAction extends AdjustmentAction {
	
	// R}h
	private static final String	CMD_INSURANCE_CARD_SHOW		= "P4002";	// Q
	private static final String	CMD_INSURANCE_CARD_NEXT		= "P4003";	// Ј
	private static final String	CMD_INSURANCE_CARD_BEFORE	= "P4004";	// OЈ
	private static final String	CMD_INSURANCE_CARD_REGIST	= "P4005";	// o^
	private static final String	CMD_INSURANCE_RECAL			= "P4006";	// ČvZ
	public static final String	CMD_INSURANCE_CARD_BACK		= "P4007";	// ߂
	public static final String	CMD_INSURANCE_CARD_NEWKCODE	= "P4008";	// ЈR[hύX
																		
	private int					nowYear						= 0;		// NxvZp
	private Date				startDate					= null;	// ZJntiNEj
	private Date				tekiyouDate					= null;	// KptiNEj
																		
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		int intCalcDate = 0; //N擾pwork
		InsuranceConfSetVo confVo;
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		Date nowDateTmp = getSystemDate(); //{t擾
		nowYear = MospUtility.getYear(nowDateTmp); //N擾
		// VO̎擾yѐݒ
		InsuranceMonthlyCardVo vo = new InsuranceMonthlyCardVo();
		vo = (InsuranceMonthlyCardVo)getStoredVo(vo.getClassName());
		if (vo == null || cmd.equals(CMD_INSURANCE_CARD_SHOW)) {
			vo = new InsuranceMonthlyCardVo();
			storeVo(vo.getClassName(), vo);
		}
		prepareDao(); //DBf[^쏀
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		setVo(vo); // VOyуtH[hURL̐ݒ
		setUrl(vo.getRetUrl());
		setNameArray(vo); // ̎擾pz擾
		
		confVo = (InsuranceConfSetVo)getStoredVo(PayrollConst.VO_INSURANCECONF_SET); // ZEϏݒVO̎擾
		vo.setConfVo(confVo); // ZEϏݒVO̐ݒ
		
		//(~)JniNj擾ݒ
		if ((confVo.prmSyoukyuTuki == null) || (confVo.prmSyoukyuTuki.equals("0"))) {
			intCalcDate = (nowYear * 10000) + (PayrollConst.MONTH_SYOUKYU_DEFAULT * 100)
					+ PayrollConst.TIME_DEFAULT_DAY;
		} else {
			intCalcDate = (nowYear * 10000) + (Integer.valueOf(confVo.prmSyoukyuTuki) * 100)
					+ PayrollConst.TIME_DEFAULT_DAY;
		}
		startDate = DateUtil.convIntegerDateToDate(intCalcDate);
		
		//KpiNj擾ݒ
		if (confVo.idButtonSyori.equals(InsuranceConfSetVo.PRM_CKR_SANTEI_KISO)) { //Zbw̏ꍇ
			intCalcDate = (nowYear * 10000) + (PayrollConst.MONTH_TEKIYOU_DEFAULT * 100)
					+ PayrollConst.TIME_DEFAULT_DAY;
		} else {
			if ((confVo.prmSyoukyuTuki == null) || (confVo.prmSyoukyuTuki.equals("0"))) {
				intCalcDate = (nowYear * 10000) + (PayrollConst.MONTH_TEKIYOU_DEFAULT * 100)
						+ PayrollConst.TIME_DEFAULT_DAY;
			} else {
				intCalcDate = (nowYear * 10000) + ((Integer.valueOf(confVo.prmSyoukyuTuki) + 3) * 100)
						+ PayrollConst.TIME_DEFAULT_DAY;
			}
		}
		tekiyouDate = DateUtil.convIntegerDateToDate(intCalcDate);
		
		// aNe[uݒ
		vo.aryCode = getCodeArray(PayrollConst.TID_JAPANESE);
		vo.listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		
		// R}h̏
		if (cmd.equals(CMD_INSURANCE_CARD_SHOW)) { //\
			// l擾
			List<Employee> listEmployee = new ArrayList<Employee>();
			vo.setTargetMonth(nowDateTmp); //ʕ\pwb_[tݒ
			confVo.setParamsAll(request); // ZEϏݒʂ̈pp[^̐ݒ
			//61̍ݐЂЈΏۂ̂ߍN61ݒ
			Calendar cal1 = Calendar.getInstance();
			Calendar cal2 = Calendar.getInstance();
			cal1.set(nowYear, PayrollConst.MONTH_SANTEI_DEFAULT, PayrollConst.TIME_DEFAULT_DAY, 0, 0, 0);
			cal2.set(nowYear, PayrollConst.TIME_ADJ_PAY_MONTH, PayrollConst.TIME_DAY_MAX, 0, 0, 0);
			int targetDate = DateUtil.convDateToInteger(cal1.getTime());
			int lastYearDate = DateUtil.convDateToInteger(cal2.getTime());
			List<MKihonDto> listKcode = mKihonPayrollDao.findForSection(targetDate, lastYearDate);
			for (int i = 0; i < listKcode.size(); i++) {
				Employee employee = getEmployee(listKcode.get(i).getKCode());
				if (null != employee) {
					listEmployee.add(employee);
				}
			}
			if (confVo.idButtonJyouken.equals(InsuranceConfSetVo.PRM_CKR_JYUNJYO_KCODE)) { //\e[u̍쐬(Ј)
				VariousUtil.sortList(listEmployee, new CompKCode()); // ЈR[hŃ\[g
			} else if (confVo.idButtonJyouken.equals(InsuranceConfSetVo.PRM_CKR_JYUNJYO_BUSHO)) { // WI{^uvI
				VariousUtil.sortList(listEmployee, new CompSCode()); // Ń\[g
			} else if (confVo.idButtonJyouken.equals(InsuranceConfSetVo.PRM_CKR_JYUNJYO_KENPO)) { // WI{^uۏvI
				VariousUtil.sortList(listEmployee, new CompKenCode()); // ۏŃ\[g
			} else if (confVo.idButtonJyouken.equals(InsuranceConfSetVo.PRM_CKR_JYUNJYO_KOUNEN)) { // WI{^uNvI
				VariousUtil.sortList(listEmployee, new CompKonCode()); // NŃ\[g
			}
			confVo.listEmployee = listEmployee;
			if (confVo.listEmployee.size() <= 0) {
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_SANTEI_KCODE, "");
				addErrMessage(errMessage);
				throw new MospException(PayrollConst.EX_NO_HUMAN_DATA, errMessage);
			} else {
				vo.kCodeIndx = 0;
				vo.setParams(request); // ZEϏݒʂ̈pp[^̐ݒ
				show(vo, confVo, 0); // \
			}
		} else if (cmd.equals(CMD_INSURANCE_CARD_NEXT)) { // Ј\
			if (vo.kCodeIndx >= (confVo.listEmployee.size() - 1)) {
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_NEXT_KCODE, "");
				addErrMessage(errMessage);
				throw new MospException(PayrollConst.EX_NO_HUMAN_DATA, errMessage);
			}
			vo.kCodeIndx++;
			show(vo, confVo, vo.kCodeIndx); // \
		} else if (cmd.equals(CMD_INSURANCE_CARD_BEFORE)) { // OЈ\
			if (vo.kCodeIndx <= 0) {
				vo.kCodeIndx = 0;
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_BEFORE_KCODE, "");
				addErrMessage(errMessage);
				throw new MospException(PayrollConst.EX_NO_HUMAN_DATA, errMessage);
			}
			vo.kCodeIndx--;
			show(vo, confVo, vo.kCodeIndx); // \
			
		} else if (cmd.equals(CMD_INSURANCE_CARD_REGIST)) { // o^
			vo.setParams(request); // ZEϏݒʂ̈pp[^̐ݒ
			CdSocInsuranceDto socDto = vo.cdSocInsuranceDto;
			if (null == socDto) {
				socDto = new CdSocInsuranceDto();
				vo.cdSocInsuranceDto = socDto;
			}
			setToSocInsuranceFromView(vo, socDto);
			if (2 == vo.dbTableFlg) { //DB̃f[^tOu2:f[^v̏ꍇ
				cdSocInsuranceDao.update(socDto);
			} else {
				cdSocInsuranceDao.insert(socDto);
			}
			commit();
			// bZ[Wݒ
			setMessage(MospUtility.getMessage(msg, "IC0001", ""));
			// ʕ\
			show(vo, confVo, vo.kCodeIndx); // \
		} else if (cmd.equals(CMD_INSURANCE_RECAL)) { // ČvZ
			vo.setTargetMonth(nowDateTmp); //ʕ\pwb_[tݒ
			vo.setParams(request); // ZEϏݒʂ̈pp[^̐ݒ
			// vZ
			reCalc(vo);
		} else if (cmd.equals(CMD_INSURANCE_CARD_BACK)) { // ߂			
		} else if (cmd.equals(CMD_INSURANCE_CARD_NEWKCODE)) { // ЈR[hύX			
			int tmpGetFlg = 0;
			Employee employee = null;
			vo.setTargetMonth(nowDateTmp); //ʕ\pwb_[tݒ
			vo.setParams(request); // ZEϏݒʂ̈pp[^̐ݒ
			String chgKcode = vo.getTxtChangeKCode();
			for (int i = 0; i < confVo.listEmployee.size(); i++) {
				employee = confVo.listEmployee.get(i);
				if ((null != employee) && (employee.getKCode().equals(chgKcode))) {
					tmpGetFlg = 1;
					vo.kCodeIndx = i;
					break;
				}
			}
			if (tmpGetFlg == 0) {
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_SELECT_KCODE, "");
				addErrMessage(errMessage);
				throw new MospException(PayrollConst.EX_NO_HUMAN_DATA, errMessage);
			} else {
				show(vo, confVo, vo.kCodeIndx); // \
			}
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * Z菈ʕ\
	 * @param vo   ݒΏVO
	 * @param indx \Ώۂ̎Јe[uCCfbNXi擪ЈCfbNXFOj
	 * @throws Exception 
	 */
	private void show(InsuranceMonthlyCardVo vo, InsuranceConfSetVo confVo, int indx) throws Exception {
		int intCalcDate;
		Date targetMonth;
		Employee employee = null;
		if (confVo.listEmployee.size() < indx) {
			String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_SANTEI_KCODE, "");
			addErrMessage(errMessage);
			throw new MospException(PayrollConst.EX_NO_HUMAN_DATA, errMessage);
		}
		
		//(~)JniNj3̌ݒ
		if ((confVo.prmSyoukyuTuki == null) || (confVo.prmSyoukyuTuki.equals("0"))) {
			intCalcDate = (nowYear * 10000) + ((PayrollConst.MONTH_SYOUKYU_DEFAULT + 3) * 100)
					+ PayrollConst.TIME_DEFAULT_DAY;
		} else {
			intCalcDate = (nowYear * 10000) + ((Integer.valueOf(confVo.prmSyoukyuTuki) + 3) * 100)
					+ PayrollConst.TIME_DEFAULT_DAY;
		}
		targetMonth = DateUtil.convIntegerDateToDate(intCalcDate);
		
		employee = confVo.listEmployee.get(indx);
		
		cdSocInsuranceDto = null;
		vo.dbTableFlg = 1; //DB̃f[^tOɁu1:VKf[^vݒ肷				
		if (null != employee) {
			mKihonDto = mKihonPayrollDao.findForKey(employee.getKCode());
			cdSocInsuranceDto = cdSocInsuranceDao.findForKey(employee.getKCode(), tekiyouDate);
			if (null == cdSocInsuranceDto) {
				cdSocInsuranceDto = new CdSocInsuranceDto();
				cdSocInsuranceDto.setCalcResult(0);
				cdSocInsuranceDto.setExpectedDate(tekiyouDate);
				cdSocInsuranceDto.setRaiseDownSalaryDate(startDate);
				cdSocInsuranceDto.setCalcResult(0);
				calcPayBasicDate(employee.getKCode(), targetMonth); //cdSocInsuranceDtoNEWƑO3̕Vzݒ
				getStandardPayment(employee.getKCode(), targetMonth); // WVz擾
				setSocInsuranceDto(employee, confVo, cdSocInsuranceDto);
			} else {
				vo.dbTableFlg = 2; //DB̃f[^tOɁu2:f[^vݒ
			}
			vo.setFields(employee, cdSocInsuranceDto);
		}
	}
	
	/**
	 * ̎擾pz擾
	 * @param vo ݒΏVO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 */
	private void setNameArray(InsuranceMonthlyCardVo vo) throws SQLException, NoSuchFieldException,
			IllegalAccessException, ClassNotFoundException {
		// DBRlNV擾
		getConnection();
		// 擾ϊmF
		if (vo.aryStation != null) {
			return;
		}
		// z擾
		vo.aryStation = getStationArrayAll();
		vo.aryPosition = getPositionArrayAll();
		vo.aryEra = getCodeArray(PayrollConst.TID_JAPANESE);
		vo.aryRelation = getCodeArray(PayrollConst.TID_RELATION);
		// aݒ擾
		vo.listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
	}
	
	/**
	 * ЉیvZf[^VO̐ݒ
	 * @param employee l{f[^WDao
	 * @param calcDate	ZEύXł̒vZ
	 * @param confVo ݒVO
	 * @param socDto Љیf[^VOCX^X
	 */
	private void setSocInsuranceDto(Employee employee, InsuranceConfSetVo confVo, CdSocInsuranceDto socDto) {
		if (null == employee) {
			return;
		}
		socDto.setKCode(employee.getKCode()); // ЈR[h
		socDto.setKName(employee.getKName()); // Ј
		socDto.setSCode(employee.getSectionCode()); // R[h
		socDto.setCalcDate(tekiyouDate); // vZN
		socDto.setRaiseDownSalaryDate(startDate); // ~N
		socDto.setExpectedDate(tekiyouDate); // KpN
	}
	
	/**
	 * ʂЉیvZf[^VO̐ݒ
	 * @param confVo ݒVO
	 * @param socDto Љیf[^VOCX^X
	 */
	private void setToSocInsuranceFromView(InsuranceMonthlyCardVo vo, CdSocInsuranceDto socDto) {
		socDto.setKCode(vo.getEscLblKCode()); // ЈR[h
		socDto.setKName(vo.getEscLblKName()); // Ј
		socDto.setSCode(vo.getEscLblStationCode()); // R[h
		socDto.setCalcDate(tekiyouDate); // vZN
		
		if (!vo.getEscTxtPayBasicMonth1().equals("")) {
			socDto.setPayBasicMonth1(Integer.valueOf(vo.getEscTxtPayBasicMonth1())); // xb1()
		}
		if (!vo.getEscTxtPayBasicMonth2().equals("")) {
			socDto.setPayBasicMonth2(Integer.valueOf(vo.getEscTxtPayBasicMonth2())); // xb2()
		}
		if (!vo.getEscTxtPayBasicMonth3().equals("")) {
			socDto.setPayBasicMonth3(Integer.valueOf(vo.getEscTxtPayBasicMonth3())); // xb3()
		}
		if (!vo.getEscTxtPayBasicDay1().equals("")) {
			socDto.setPayBasicDay1(Integer.valueOf(vo.getEscTxtPayBasicDay1())); // xb1()
		}
		if (!vo.getEscTxtPayBasicDay2().equals("")) {
			socDto.setPayBasicDay2(Integer.valueOf(vo.getEscTxtPayBasicDay2())); // xb2()
		}
		if (!vo.getEscTxtPayBasicDay3().equals("")) {
			socDto.setPayBasicDay3(Integer.valueOf(vo.getEscTxtPayBasicDay3())); // xb3()
		}
		if (!vo.getEscTxtPayAmount1().equals("")) {
			socDto.setPayAmount1(Integer.valueOf(vo.getEscTxtPayAmount1())); // K̊z1
		}
		if (!vo.getEscTxtPayAmount2().equals("")) {
			socDto.setPayAmount2(Integer.valueOf(vo.getEscTxtPayAmount2())); // K̊z2
		}
		if (!vo.getEscTxtPayAmount3().equals("")) {
			socDto.setPayAmount3(Integer.valueOf(vo.getEscTxtPayAmount3())); // K̊z3
		}
		if (!vo.getEscTxtGoodsAmount1().equals("")) {
			socDto.setGoodsAmount1(Integer.valueOf(vo.getEscTxtGoodsAmount1())); // ̊z1
		}
		if (!vo.getEscTxtGoodsAmount2().equals("")) {
			socDto.setGoodsAmount2(Integer.valueOf(vo.getEscTxtGoodsAmount2())); // ̊z2
		}
		if (!vo.getEscTxtGoodsAmount3().equals("")) {
			socDto.setGoodsAmount3(Integer.valueOf(vo.getEscTxtGoodsAmount3())); // ̊z3
		}
		if (!vo.getEscTxtRewardTotal1().equals("")) {
			socDto.setRewardTotal1(Integer.valueOf(vo.getEscTxtRewardTotal1())); // Vv1
		}
		if (!vo.getEscTxtRewardTotal2().equals("")) {
			socDto.setRewardTotal2(Integer.valueOf(vo.getEscTxtRewardTotal2())); // Vv2
		}
		if (!vo.getEscTxtRewardTotal3().equals("")) {
			socDto.setRewardTotal3(Integer.valueOf(vo.getEscTxtRewardTotal3())); // Vv3
		}
		if (!vo.getEscTxtRewardTotalSum().equals("")) {
			socDto.setRewardTotalSum(Integer.valueOf(vo.getEscTxtRewardTotalSum())); // Vz
		}
		if (!vo.getEscTxtAverageThreeMonths().equals("")) {
			socDto.setAverageThreeMonths(Integer.valueOf(vo.getEscTxtAverageThreeMonths())); // R
		}
		if (!vo.getEscTxtEditAverage().equals("")) {
			socDto.setEditAverage(Integer.valueOf(vo.getEscTxtEditAverage())); // C
		}
		if (!vo.getEscTxtRaiseDownSalaryBasis().equals("")) {
			socDto.setRaiseDownSalaryBasis(Integer.valueOf(vo.getEscTxtRaiseDownSalaryBasis())); // ~̌z
		}
		
		socDto.setRaiseDownSalaryDate(startDate); // ~N
		socDto.setExpectedDate(tekiyouDate); // KpN
		if (vo.confVo.idButtonSyori.equals(InsuranceConfSetVo.PRM_CKR_SANTEI_KISO)) { //Zbw̏ꍇ
			socDto.setCalcResult(1); //vZʂɎZKҁFPݒ
		} else { //ZbȊOw̏ꍇ
			socDto.setCalcResult(3); //vZʂɌϓKҁFRݒ
		}
	}
	
	/**
	 * ʃf[^ɂЉیf[^̍ČvZ
	 * @param vo VO
	 */
	private void reCalc(InsuranceMonthlyCardVo vo) {
		int intCntManth = 0; // vZ\
		int intPayBasicDay1 = 0; // 1Ob
		int intPayBasicDay2 = 0; // 2Ob
		int intPayBasicDay3 = 0; // 3Ob
		int intPayAmount1 = 0; // 1OVz
		int intPayAmount2 = 0; // 2OVz
		int intPayAmount3 = 0; // 3OVz
		int intGoodsAmount1 = 0; // 1Oxz
		int intGoodsAmount2 = 0; // 2Oxz
		int intGoodsAmount3 = 0; // 3Oxz
		int intRewardTotal1 = 0; // 1Ovz
		int intRewardTotal2 = 0; // 2Ovz
		int intRewardTotal3 = 0; // 3Ovz
		int intRewardTotalSum = 0; // Vz
		int intAverageThreeMonths = 0; // 3ԕϊz
		int intEditAverage = 0; // Cϊz
		int intHealthDecGrade = 0; // ㌒Nی
		int intHealthDecPremium = 0; // ㌒Nی
		int intPensionDecGrade = 0; // N
		int intPensionDecPremium = 0; // NVz
		int intRaiseDownSalaryBasis = 0; // ~̌z
		int intRetroactivePayment = 0; // kyxz
		
		if (!vo.getEscTxtPayBasicDay1().equals("")) {
			intPayBasicDay1 = Integer.valueOf(vo.getEscTxtPayBasicDay1()); // 1Ob
		}
		if (!vo.getEscTxtPayBasicDay2().equals("")) {
			intPayBasicDay2 = Integer.valueOf(vo.getEscTxtPayBasicDay2()); // 2Ob
		}
		if (!vo.getEscTxtPayBasicDay3().equals("")) {
			intPayBasicDay3 = Integer.valueOf(vo.getEscTxtPayBasicDay3()); // 3Ob
		}
		if (!vo.getEscTxtPayAmount1().equals("")) {
			intPayAmount1 = Integer.valueOf(vo.getEscTxtPayAmount1()); // 1OVz
		}
		if (!vo.getEscTxtPayAmount2().equals("")) {
			intPayAmount2 = Integer.valueOf(vo.getEscTxtPayAmount2()); // 2OVz
		}
		if (!vo.getEscTxtPayAmount3().equals("")) {
			intPayAmount3 = Integer.valueOf(vo.getEscTxtPayAmount3()); // 3OVz
		}
		if (!vo.getEscTxtGoodsAmount1().equals("")) {
			intGoodsAmount1 = Integer.valueOf(vo.getEscTxtGoodsAmount1()); // 1Oxz
		}
		if (!vo.getEscTxtGoodsAmount2().equals("")) {
			intGoodsAmount2 = Integer.valueOf(vo.getEscTxtGoodsAmount2()); // 2Oxz
		}
		if (!vo.getEscTxtGoodsAmount3().equals("")) {
			intGoodsAmount3 = Integer.valueOf(vo.getEscTxtGoodsAmount3()); // 3Oxz
		}
		if (!vo.getEscTxtRaiseDownSalaryBasis().equals("")) {
			intRaiseDownSalaryBasis = Integer.valueOf(vo.getEscTxtRaiseDownSalaryBasis()); // ~̌z;
		}
		if (!vo.getEscTxtRetroactivePayment().equals("")) {
			intRetroactivePayment = Integer.valueOf(vo.getEscTxtRetroactivePayment()); // kyxz
		}
		
		//		 1O
		if (intPayBasicDay1 >= 17) {
			intRewardTotal1 = intPayAmount1 + intGoodsAmount1;
			intRewardTotalSum = intRewardTotalSum + intRewardTotal1;
			intCntManth++;
		}
		
		// 2O
		if (intPayBasicDay2 >= 17) {
			intRewardTotal2 = intPayAmount2 + intGoodsAmount2;
			intRewardTotalSum = intRewardTotalSum + intRewardTotal2;
			intCntManth++;
		}
		
		// 3O
		if (intPayBasicDay3 >= 17) {
			intRewardTotal3 = intPayAmount3 + intGoodsAmount3;
			intRewardTotalSum = intRewardTotalSum + intRewardTotal3;
			intCntManth++;
		}
		
		// 
		if ((0 < intRewardTotalSum) && (0 < intCntManth)) {
			intAverageThreeMonths = intRewardTotalSum / intCntManth;
		}
		
		// kyxzyя~zCϋz
		if ((0 < intCntManth) && (0 < intRewardTotalSum)
				&& ((0 < intRetroactivePayment) || (0 < intRaiseDownSalaryBasis))) {
			if (intRewardTotalSum >= intRetroactivePayment) {
				intEditAverage = ((intRewardTotalSum - intRetroactivePayment) + (intRaiseDownSalaryBasis * 2))
						/ intCntManth;
			}
		}
		
		if (intEditAverage > 0) {
			intHealthDecGrade = getHealthDecGrade(intEditAverage);
			intPensionDecGrade = getPensionDecGrade(intEditAverage);
			intHealthDecPremium = getHealthDecPremium(intEditAverage);
			intPensionDecPremium = getPensionDecPremium(intEditAverage);
		} else {
			intHealthDecGrade = getHealthDecGrade(intAverageThreeMonths);
			intPensionDecGrade = getPensionDecGrade(intAverageThreeMonths);
			intHealthDecPremium = getHealthDecPremium(intAverageThreeMonths);
			intPensionDecPremium = getPensionDecPremium(intAverageThreeMonths);
		}
		
		vo.setTxtRewardTotal1(String.valueOf(intRewardTotal1));
		vo.setTxtRewardTotal2(String.valueOf(intRewardTotal2));
		vo.setTxtRewardTotal3(String.valueOf(intRewardTotal3));
		vo.setTxtRewardTotalSum(String.valueOf(intRewardTotalSum));
		vo.setTxtAverageThreeMonths(String.valueOf(intAverageThreeMonths));
		vo.setTxtEditAverage(String.valueOf(intEditAverage));
		vo.setTxtHealthDecGrade(String.valueOf(intHealthDecGrade));
		vo.setTxtHealthDecPremium(String.valueOf(intHealthDecPremium));
		vo.setTxtPensionDecGrade(String.valueOf(intPensionDecGrade));
		vo.setTxtPensionDecPremium(String.valueOf(intPensionDecPremium));
		vo.setTxtRaiseDownSalaryBasis(String.valueOf(intRaiseDownSalaryBasis));
		vo.setTxtRetroactivePayment(String.valueOf(intRetroactivePayment));
	}
	

	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -7706459710514164329L;
		

		public int compare(Object obj1, Object obj2) {
			Employee dto1 = (Employee)obj1;
			Employee dto2 = (Employee)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}
	
	/**
	 * R[hɂrNX
	 */
	protected static class CompSCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 3372034311242969584L;
		

		public int compare(Object obj1, Object obj2) {
			Employee dto1 = (Employee)obj1;
			Employee dto2 = (Employee)obj2;
			return dto1.getSectionCode().compareTo(dto2.getSectionCode());
		}
	}
	
	/**
	 * ۔ԍɂrNX
	 */
	protected static class CompKenCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -7057285913026987313L;
		

		public int compare(Object obj1, Object obj2) {
			Employee dto1 = (Employee)obj1;
			Employee dto2 = (Employee)obj2;
			return dto1.getKenpoNo().compareTo(dto2.getKenpoNo());
		}
	}
	
	/**
	 * NԍɂrNX
	 */
	protected static class CompKonCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 5471303087653114594L;
		

		public int compare(Object obj1, Object obj2) {
			Employee dto1 = (Employee)obj1;
			Employee dto2 = (Employee)obj2;
			return dto1.getKohoNo().compareTo(dto2.getKohoNo());
		}
	}
	
}
