/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.mospcommon.system.action;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.mospcommon.system.dao.CmLimitStandardDao;
import jp.mosp.mospcommon.system.dto.CmLimitStandardDto;
import jp.mosp.mospcommon.system.vo.LimitStandardMasterCardVo;

/**
 * @author nakamura
 *
 */
public class LimitStandardMasterCardAction extends MosPAction {
	
	// R}h
	private static final String	CMD_LIMIT_STANDARD_MASTER_CARD_SHOW		= "S2545";	// \(ǉ)
	private static final String	CMD_LIMIT_STANDARD_MASTER_CARD_SELECT	= "S2546";	// \(I)
	private static final String	CMD_LIMIT_STANDARD_MASTER_CARD_INSERT	= "S2547";	// o^
	private static final String	CMD_LIMIT_STANDARD_MASTER_CARD_UPDATE	= "S2548";	// XV
																					
	
	/**
	 * RXgN^[
	 */
	public LimitStandardMasterCardAction() {
		super();
	}
	
	/* ( Javadoc)
	 * @see jp.mosp.common.common.ActionInterface#action()
	 */
	public void action() throws Exception {
		// VO̎擾		
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_LIMIT_STANDARD_MASTER_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_LIMIT_STANDARD_MASTER_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_LIMIT_STANDARD_MASTER_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_LIMIT_STANDARD_MASTER_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new LimitStandardMasterCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		LimitStandardMasterCardVo vo = (LimitStandardMasterCardVo)getVo();
		vo.aryPltTermType = part().mospcode().getLimitStandardTermArray();
	}
	
	@Override
	protected void show() {
		LimitStandardMasterCardVo vo = (LimitStandardMasterCardVo)getVo();
		vo.setDefaultValues();
		vo.setMode(LimitStandardMasterCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		LimitStandardMasterCardVo vo = (LimitStandardMasterCardVo)getVo();
		// DAȌ
		CmLimitStandardDao dao = new CmLimitStandardDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		CmLimitStandardDto dto = dao.findForKey(key1);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		vo.setMode(LimitStandardMasterCardVo.MODE_UPDATE);
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		LimitStandardMasterCardVo vo = (LimitStandardMasterCardVo)getVo();
		vo.setParams(request);
		vo.setPltDeleteFlag(String.valueOf(MospConst.DELETE_FLAG_OFF));
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		CmLimitStandardDto dto = new CmLimitStandardDto();
		vo.setDtoFields(dto);
		// DAȌ
		CmLimitStandardDao dao = new CmLimitStandardDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ݃`FbN
		chkDuplicate(dao.findForKey(dto.getLimitCode()));
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		dto = dao.findForKey(dto.getLimitCode());
		chkInsert(dto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(LimitStandardMasterCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		CmLimitStandardDto dto = (CmLimitStandardDto)getSessionDto();
		LimitStandardMasterCardVo vo = (LimitStandardMasterCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		vo.setDtoFields(dto);
		// DAȌ
		CmLimitStandardDao dao = new CmLimitStandardDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, dao.findForUpdate(dto.getLimitCode()));
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		CmLimitStandardDto retDto = dao.findForKey(dto.getLimitCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(LimitStandardMasterCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
}
