/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.kintai.dto.CmRotationDto;

/**
 * @author yoshida
 *
 */
public class ScheduleRotationListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -2955682777312003130L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	/**
	 * txtRtCode
	 */
	public static final String	PRM_TXT_RT_CODE		= "txtRtCode";
	/**
	 * txtRtName
	 */
	public static final String	PRM_TXT_RT_NAME		= "txtRtName";
	
	// tB[h
	private String[]			aryRTCode;
	private String[]			aryRTName;
	private String[]			aryHoliday;
	private String[]			aryDay1;
	private String[]			aryDay2;
	private String[]			aryDay3;
	private String[]			aryDay4;
	private String[]			aryDay5;
	private String[]			aryDay6;
	private String[]			aryDay7;
	private String[]			aryDay8;
	private String[]			aryDay9;
	private String[]			aryDay10;
	
	private String				txtRTCode;
	private String				txtRTName;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltWorkType;
	/**
	 * 
	 */
	public String[][]			aryPltHoliday;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_RT_CODE;
	/**
	 * 
	 */
	public String				NAM_RT_NAME;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_DAY1;
	/**
	 * 
	 */
	public String				NAM_DAY2;
	/**
	 * 
	 */
	public String				NAM_DAY3;
	/**
	 * 
	 */
	public String				NAM_DAY4;
	/**
	 * 
	 */
	public String				NAM_DAY5;
	/**
	 * 
	 */
	public String				NAM_DAY6;
	/**
	 * 
	 */
	public String				NAM_DAY7;
	/**
	 * 
	 */
	public String				NAM_DAY8;
	/**
	 * 
	 */
	public String				NAM_DAY9;
	/**
	 * 
	 */
	public String				NAM_DAY10;
	
	/**
	 * 
	 */
	public int					LEN_RT_CODE;
	/**
	 * 
	 */
	public int					LEN_RT_NAME;
	
	// \[gL[	
	/**
	 * 
	 */
	public final String			KEY_RT_CODE			= "keyRtCode";
	/**
	 * 
	 */
	public final String			KEY_RT_NAME			= "keyRtName";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^
	 */
	public ScheduleRotationListVo() {
		super();
		setViewPath(getClassName());
		txtRTCode = "";
		txtRTName = "";
		aryRTCode = new String[0];
		aryRTName = new String[0];
		aryHoliday = new String[0];
		aryDay1 = new String[0];
		aryDay2 = new String[0];
		aryDay3 = new String[0];
		aryDay4 = new String[0];
		aryDay5 = new String[0];
		aryDay6 = new String[0];
		aryDay7 = new String[0];
		aryDay8 = new String[0];
		aryDay9 = new String[0];
		aryDay10 = new String[0];
		setFormerKey(KEY_RT_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_SCHEDULE_ROTATION_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_INPUT, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuSchedule() };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_RT_CODE = CommonConst.NAM_COMMON_CODE;
		NAM_RT_NAME = CommonConst.NAM_COMMON_MEISYO;
		NAM_HOLIDAY = CommonConst.NAM_PUBLIC_HOLIDAY;
		NAM_DAY1 = CommonConst.NAM_DAY1;
		NAM_DAY2 = CommonConst.NAM_DAY2;
		NAM_DAY3 = CommonConst.NAM_DAY3;
		NAM_DAY4 = CommonConst.NAM_DAY4;
		NAM_DAY5 = CommonConst.NAM_DAY5;
		NAM_DAY6 = CommonConst.NAM_DAY6;
		NAM_DAY7 = CommonConst.NAM_DAY7;
		NAM_DAY8 = CommonConst.NAM_DAY8;
		NAM_DAY9 = CommonConst.NAM_DAY9;
		NAM_DAY10 = CommonConst.NAM_DAY10;
		LEN_RT_CODE = 10;
		LEN_RT_NAME = 25;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtRTCode = request.getParameter(PRM_TXT_RT_CODE);
		txtRTName = request.getParameter(PRM_TXT_RT_NAME);
	}
	
	@Override
	public void setFields(List<?> listRotationTable) {
		// Xg̐ݒ
		list = listRotationTable;
		// f[^̎擾
		count = listRotationTable.size();
		// z̏
		aryRTCode = new String[count];
		aryRTName = new String[count];
		aryHoliday = new String[count];
		aryDay1 = new String[count];
		aryDay2 = new String[count];
		aryDay3 = new String[count];
		aryDay4 = new String[count];
		aryDay5 = new String[count];
		aryDay6 = new String[count];
		aryDay7 = new String[count];
		aryDay8 = new String[count];
		aryDay9 = new String[count];
		aryDay10 = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listRotationTable.iterator();
		while (it.hasNext()) {
			CmRotationDto dto = (CmRotationDto)it.next();
			aryRTCode[i] = escapeHTML(dto.getRtCode());
			aryRTName[i] = escapeHTML(dto.getRtName());
			aryHoliday[i] = escapeHTML(getCodeName(String.valueOf(dto.getHolidayFlag()), aryPltHoliday));
			aryDay1[i] = escapeHTML(getCodeName(dto.getDay1(), aryPltWorkType));
			aryDay2[i] = escapeHTML(getCodeName(dto.getDay2(), aryPltWorkType));
			aryDay3[i] = escapeHTML(getCodeName(dto.getDay3(), aryPltWorkType));
			aryDay4[i] = escapeHTML(getCodeName(dto.getDay4(), aryPltWorkType));
			aryDay5[i] = escapeHTML(getCodeName(dto.getDay5(), aryPltWorkType));
			aryDay6[i] = escapeHTML(getCodeName(dto.getDay6(), aryPltWorkType));
			aryDay7[i] = escapeHTML(getCodeName(dto.getDay7(), aryPltWorkType));
			aryDay8[i] = escapeHTML(getCodeName(dto.getDay8(), aryPltWorkType));
			aryDay9[i] = escapeHTML(getCodeName(dto.getDay9(), aryPltWorkType));
			aryDay10[i] = escapeHTML(getCodeName(dto.getDay10(), aryPltWorkType));
			i++;
		}
	}
	
	// ANZT\bh
	/**
	 * @return txtRTCode
	 */
	public String getEscTxtRTCode() {
		return escapeHTML(txtRTCode);
	}
	
	/**
	 * @return txtRTName
	 */
	public String getEscTxtRTName() {
		return escapeHTML(txtRTName);
	}
	
	/**
	 * @return aryRTCode
	 */
	public String[] getAryRTCode() {
		return aryRTCode.clone();
	}
	
	/**
	 * @return aryRTName
	 */
	public String[] getAryRTName() {
		return aryRTName.clone();
	}
	
	/**
	 * @return aryHoliday
	 */
	public String[] getAryHoliday() {
		return aryHoliday.clone();
	}
	
	/**
	 * @return aryDay1
	 */
	public String[] getAryDay1() {
		return aryDay1.clone();
	}
	
	/**
	 * @return aryDay2
	 */
	public String[] getAryDay2() {
		return aryDay2.clone();
	}
	
	/**
	 * @return aryDay3
	 */
	public String[] getAryDay3() {
		return aryDay3.clone();
	}
	
	/**
	 * @return aryDay4
	 */
	public String[] getAryDay4() {
		return aryDay4.clone();
	}
	
	/**
	 * @return aryDay5
	 */
	public String[] getAryDay5() {
		return aryDay5.clone();
	}
	
	/**
	 * @return aryDay6
	 */
	public String[] getAryDay6() {
		return aryDay6.clone();
	}
	
	/**
	 * @return aryDay7
	 */
	public String[] getAryDay7() {
		return aryDay7.clone();
	}
	
	/**
	 * @return aryDay8
	 */
	public String[] getAryDay8() {
		return aryDay8.clone();
	}
	
	/**
	 * @return aryDay9
	 */
	public String[] getAryDay9() {
		return aryDay9.clone();
	}
	
	/**
	 * @return aryDay10
	 */
	public String[] getAryDay10() {
		return aryDay10.clone();
	}
	
	/**
	 * @return txtRTCode
	 */
	public String getTxtRTCode() {
		return txtRTCode;
	}
	
	/**
	 * @return txtRTName
	 */
	public String getTxtRTName() {
		return txtRTName;
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @param txtRTCode Zbg txtRTCode
	 */
	public void setTxtRTCode(String txtRTCode) {
		this.txtRTCode = txtRTCode;
	}
	
	/**
	 * @param txtRTName Zbg txtRTName
	 */
	public void setTxtRTName(String txtRTName) {
		this.txtRTName = txtRTName;
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
}
