/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.part.SubstituteHolidayPart;
import jp.mosp.kintai.payroll.dto.KdSubstituteHolidayDto;
import jp.mosp.kintai.payroll.dto.SubstitudeHolidayDto;
import jp.mosp.kintai.payroll.vo.EmployeeSubHolidayListVo;

/**
 * @author saito
 *
 */
public class EmployeeSubHolidayListAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_LIST_SHOW		= "P1310";
	private static final String	CMD_LIST_SEARCH		= "P1311";
	private static final String	CMD_LIST_RE_SEARCH	= "P1312";
	private static final String	CMD_LIST_SORT		= "P1313";
	

	/**
	 * RXgN^
	 */
	public EmployeeSubHolidayListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_LIST_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new EmployeeSubHolidayListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// RlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// [U[擾
		getInfo(user.getUserId());
		EmployeeSubHolidayListVo vo = (EmployeeSubHolidayListVo)getVo();
		// Nݒ
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), 3, 1);
		// ݒ
		vo.aryPltMonth = StringUtil.getMonthArray();
		// ӌ󋵃v_Eݒ
		vo.aryPltAttitudeStatus = getAttitudeStatusArray();
		// 擾󋵃v_Eݒ
		vo.aryPltAcquisitionStatus = getAcquisityonStatusArray();
		// Ϗ󋵃v_Eݒ
		vo.aryPltDecisionStatus = getDecisionStatusArray();
	}
	
	@Override
	protected void show() throws Exception {
		EmployeeSubHolidayListVo vo = (EmployeeSubHolidayListVo)getVo();
		Date calcPayment = getCalcPayment();
		/* \ڂ(N/)ݒ */
		vo.setPltYear(String.valueOf(MospUtility.getYear(calcPayment)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(calcPayment)));
	}
	
	@Override
	protected void search() throws Exception {
		EmployeeSubHolidayListVo vo = (EmployeeSubHolidayListVo)getVo();
		vo.setParams(request);
		employeeSubHolidayList();
		vo.setFormerKey(vo.KEY_K_CODE);
		vo.setIsAscending(true);
		vo.initListInfo();
		sortList();
		// ɃZbg
		vo.setSearchmode(EmployeeSubHolidayListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		EmployeeSubHolidayListVo vo = (EmployeeSubHolidayListVo)getVo();
		if (vo.getSearchmode() == EmployeeSubHolidayListVo.SEARCH_ON) {
			removeSessionDto();
			employeeSubHolidayList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * ЈXg
	 * @throws Exception  	Oꍇ
	 */
	private void employeeSubHolidayList() throws Exception {
		EmployeeSubHolidayListVo vo = (EmployeeSubHolidayListVo)getVo();
		// eڂʂ擾
		List<KdSubstituteHolidayDto> list = part().subHoliday().getKdSubstituteHolidayDao().findForTargetDate(
				vo.getTxtKCode(), vo.getTxtKName(), vo.getPltYear(), vo.getPltMonth(), vo.getAryPltAttitudeStatus(),
				vo.getAryPltAcquisitionStatus(), vo.getAryPltDecisionStatus());
		// x擾ꗗ
		List<SubstitudeHolidayDto> viewList = new ArrayList<SubstitudeHolidayDto>();
		for (KdSubstituteHolidayDto dto : list) {
			SubstitudeHolidayDto viewDto = new SubstitudeHolidayDto(dto);
			// Ј
			viewDto.setKName(getKName(dto.getKCode()));
			// ӌ
			if (SubstituteHolidayPart.isAttitudeFixed(dto)) {
				viewDto.setAttitudeStatus(CommonConst.NAM_ATTITUDE_STATUS_FIXED);
			} else if (SubstituteHolidayPart.isAttitudeInit(dto)) {
				viewDto.setAttitudeStatus(CommonConst.NAM_ATTITUDE_STATUS_INIT);
			}
			// 擾
			if (SubstituteHolidayPart.isAcquisitionFinish(dto)) {
				viewDto.setAcquisitionStatus(CommonConst.NAM_ACQUISITION_STATUS_FINISH);
			} else if (SubstituteHolidayPart.isAcquisitionRemain(dto)) {
				viewDto.setAcquisitionStatus(CommonConst.NAM_ACQUISITION_STATUS_REMAIN);
			}
			// Ϗ
			if (SubstituteHolidayPart.isDecisionPayment(dto)) {
				viewDto.setDecisionStatus(CommonConst.NAM_DECISION_STATUS_PAYMENT);
			} else if (SubstituteHolidayPart.isDecisionFixed(dto)) {
				viewDto.setDecisionStatus(CommonConst.NAM_DECISION_STATUS_FIXED);
			} else {
				viewDto.setDecisionStatus(CommonConst.NAM_DECISION_STATUS_INIT);
			}
			viewList.add(viewDto);
		}
		// VOݒ
		vo.setFields(viewList);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryEmployee().length == 0) {
			addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	/**
	 * ӌ󋵂̃v_Ee擾NX
	 * @return ӌ󋵂̃v_EԂ
	 */
	private String[][] getAttitudeStatusArray() {
		return new String[][]{ { CommonConst.CODE_ATTITUDE_STATUS_INIT, CommonConst.NAM_ATTITUDE_STATUS_INIT },
			{ CommonConst.CODE_ATTITUDE_STATUS_FIXED, CommonConst.NAM_ATTITUDE_STATUS_FIXED } };
	}
	
	/**
	 * 擾󋵂̃v_Ee擾NX
	 * @return 擾󋵂̃v_EԂ
	 */
	private String[][] getAcquisityonStatusArray() {
		return new String[][]{
			{ CommonConst.CODE_ACQUISITION_STATUS_REMAIN, CommonConst.NAM_ACQUISITION_STATUS_REMAIN },
			{ CommonConst.CODE_ACQUISITION_STATUS_FINISH, CommonConst.NAM_ACQUISITION_STATUS_FINISH } };
	}
	
	/**
	 * Ϗ󋵂̃v_Ee擾NX
	 * @return Ϗ󋵂̃v_EԂ
	 */
	private String[][] getDecisionStatusArray() {
		return new String[][]{ { CommonConst.CODE_DECISION_STATUS_INIT, CommonConst.NAM_DECISION_STATUS_INIT },
			{ CommonConst.CODE_DECISION_STATUS_FIXED, CommonConst.NAM_DECISION_STATUS_FIXED },
			{ CommonConst.CODE_DECISION_STATUS_PAYMENT, CommonConst.NAM_DECISION_STATUS_PAYMENT } };
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		EmployeeSubHolidayListVo vo = (EmployeeSubHolidayListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_K_NAME)) {
			comp = new CompKName();
		} else if (key.equals(vo.KEY_YEAR)) {
			comp = new CompOccurYear();
		} else if (key.equals(vo.KEY_MONTH)) {
			comp = new CompOccurMonth();
		} else if (key.equals(vo.KEY_ATTITUDE)) {
			comp = new CompAttitude();
		} else if (key.equals(vo.KEY_ACQUISITION)) {
			comp = new CompAcquisition();
		} else if (key.equals(vo.KEY_DECISION)) {
			comp = new CompDecision();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator<Object>, Serializable {
		
		/**
		 * 
		 */
		private static final long	serialVersionUID	= 2785426316163131119L;
		

		public int compare(Object obj1, Object obj2) {
			KdSubstituteHolidayDto dto1 = (KdSubstituteHolidayDto)obj1;
			KdSubstituteHolidayDto dto2 = (KdSubstituteHolidayDto)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}
	
	/**
	 * ЈɂrNX
	 */
	protected static class CompKName implements Comparator<Object>, Serializable {
		
		/**
		 * 
		 */
		private static final long	serialVersionUID	= -2755367004014935586L;
		

		public int compare(Object obj1, Object obj2) {
			SubstitudeHolidayDto dto1 = (SubstitudeHolidayDto)obj1;
			SubstitudeHolidayDto dto2 = (SubstitudeHolidayDto)obj2;
			return dto1.getKName().compareTo(dto2.getKName());
		}
	}
	
	/**
	 * NɂrNX
	 */
	protected static class CompOccurYear implements Comparator<Object>, Serializable {
		
		/**
		 * 
		 */
		private static final long	serialVersionUID	= -8445091225321039317L;
		

		public int compare(Object obj1, Object obj2) {
			KdSubstituteHolidayDto dto1 = (KdSubstituteHolidayDto)obj1;
			KdSubstituteHolidayDto dto2 = (KdSubstituteHolidayDto)obj2;
			return Integer.valueOf(dto1.getOccurYear()).compareTo(Integer.valueOf(dto2.getOccurYear()));
		}
	}
	
	/**
	 * ɂrNX
	 */
	protected static class CompOccurMonth implements Comparator<Object>, Serializable {
		
		/**
		 * 
		 */
		private static final long	serialVersionUID	= -8848792894794746297L;
		

		public int compare(Object obj1, Object obj2) {
			KdSubstituteHolidayDto dto1 = (KdSubstituteHolidayDto)obj1;
			KdSubstituteHolidayDto dto2 = (KdSubstituteHolidayDto)obj2;
			return Integer.valueOf(dto1.getOccurMonth()).compareTo(Integer.valueOf(dto2.getOccurMonth()));
		}
	}
	
	/**
	 * ӌ󋵂ɂrNX
	 */
	protected static class CompAttitude implements Comparator<Object>, Serializable {
		
		/**
		 * 
		 */
		private static final long	serialVersionUID	= -7897823895513282698L;
		

		public int compare(Object obj1, Object obj2) {
			KdSubstituteHolidayDto dto1 = (KdSubstituteHolidayDto)obj1;
			KdSubstituteHolidayDto dto2 = (KdSubstituteHolidayDto)obj2;
			return dto1.getAttitudeStatus().compareTo(dto2.getAttitudeStatus());
		}
	}
	
	/**
	 * 擾󋵂ɂrNX
	 */
	protected static class CompAcquisition implements Comparator<Object>, Serializable {
		
		/**
		 * 
		 */
		private static final long	serialVersionUID	= 6741946147836872076L;
		

		public int compare(Object obj1, Object obj2) {
			KdSubstituteHolidayDto dto1 = (KdSubstituteHolidayDto)obj1;
			KdSubstituteHolidayDto dto2 = (KdSubstituteHolidayDto)obj2;
			return dto1.getAcquisitionStatus().compareTo(dto2.getAcquisitionStatus());
		}
	}
	
	/**
	 * Ϗ󋵂ɂrNX
	 */
	protected static class CompDecision implements Comparator<Object>, Serializable {
		
		/**
		 * 
		 */
		private static final long	serialVersionUID	= -830482743856714281L;
		

		public int compare(Object obj1, Object obj2) {
			KdSubstituteHolidayDto dto1 = (KdSubstituteHolidayDto)obj1;
			KdSubstituteHolidayDto dto2 = (KdSubstituteHolidayDto)obj2;
			return dto1.getDecisionStatus().compareTo(dto2.getDecisionStatus());
		}
	}
	
}
