/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.dto.MScheduleDto;

/**
 * M_SCHEDULE(oΗ\)DAONX B
 */
public class MScheduleDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * M_SCHEDULE(oΗ\)B
	 */
	public static final String	TABLE			= "M_SCHEDULE";
	
	/**
	 * KEY_1 = KCODE(ЈR[h)B
	 */
	public static final String	KEY_1			= "KCODE";
	/**
	 * KEY_2 = HIZUKE(t)B
	 */
	public static final String	KEY_2			= "HIZUKE";
	
	// 
	/**
	 * KCODE(ЈR[h)B
	 */
	public static final String	COL_KCODE		= "KCODE";
	/**
	 * HIZUKE(t)B
	 */
	public static final String	COL_HIZUKE		= "HIZUKE";
	/**
	 * NEN(N)B
	 */
	public static final String	COL_NEN			= "NEN";
	/**
	 * TUKI()B
	 */
	public static final String	COL_TUKI		= "TUKI";
	/**
	 * HI()B
	 */
	public static final String	COL_HI			= "HI";
	/**
	 * SYOZOKU(R[h)B
	 */
	public static final String	COL_SYOZOKU		= "SYOZOKU";
	/**
	 * NINSYO(F؎)B
	 */
	public static final String	COL_NINSYO		= "NINSYO";
	/**
	 * SYJIKOKU(oΎ)B
	 */
	public static final String	COL_SYJIKOKU	= "SYJIKOKU";
	/**
	 * KINMU(Ζ`)B
	 */
	public static final String	COL_KINMU		= "KINMU";
	/**
	 * SHANKYUKB(oΔx敪)B
	 */
	public static final String	COL_SHANKYUKB	= "SHANKYUKB";
	/**
	 * KYUSYUKB(xo敪)B
	 */
	public static final String	COL_KYUSYUKB	= "KYUSYUKB";
	/**
	 * TIRIYUU(xR)B
	 */
	public static final String	COL_TIRIYUU		= "TIRIYUU";
	/**
	 * TICOMENT(xRg)B
	 */
	public static final String	COL_TICOMENT	= "TICOMENT";
	/**
	 * TISYOUMEI(xؖ)B
	 */
	public static final String	COL_TISYOUMEI	= "TISYOUMEI";
	/**
	 * TIJIKAN(x)B
	 */
	public static final String	COL_TIJIKAN		= "TIJIKAN";
	/**
	 * SYTIMES(oΓ͓)B
	 */
	public static final String	COL_SYTIMES		= "SYTIMES";
	/**
	 * TAJIKOKU(ގЎ)B
	 */
	public static final String	COL_TAJIKOKU	= "TAJIKOKU";
	/**
	 * KINMUJI(Ζ)B
	 */
	public static final String	COL_KINMUJI		= "KINMUJI";
	/**
	 * KYUKEIJI(xe)B
	 */
	public static final String	COL_KYUKEIJI	= "KYUKEIJI";
	/**
	 * THANKYUKB(ދΔx敪)B
	 */
	public static final String	COL_THANKYUKB	= "THANKYUKB";
	/**
	 * SORIYUU(ޗR)B
	 */
	public static final String	COL_SORIYUU		= "SORIYUU";
	/**
	 * SOCOMENT(ރRg)B
	 */
	public static final String	COL_SOCOMENT	= "SOCOMENT";
	/**
	 * SOSYOUMEI(ޏؖ)B
	 */
	public static final String	COL_SOSYOUMEI	= "SOSYOUMEI";
	/**
	 * SOJIKAN(ގ)B
	 */
	public static final String	COL_SOJIKAN		= "SOJIKAN";
	/**
	 * ZAJIKAN(cƎ)B
	 */
	public static final String	COL_ZAJIKAN		= "ZAJIKAN";
	/**
	 * KSJIKAN(xo)B
	 */
	public static final String	COL_KSJIKAN		= "KSJIKAN";
	/**
	 * SNJIKAN([鎞)B
	 */
	public static final String	COL_SNJIKAN		= "SNJIKAN";
	/**
	 * SYOKUJI(H蓖x)B
	 */
	public static final String	COL_SYOKUJI		= "SYOKUJI";
	/**
	 * CYOKU1(1蓖x)B
	 */
	public static final String	COL_CYOKU1		= "CYOKU1";
	/**
	 * CYOKU2(2蓖x)B
	 */
	public static final String	COL_CYOKU2		= "CYOKU2";
	/**
	 * CYOKU3(3蓖x)B
	 */
	public static final String	COL_CYOKU3		= "CYOKU3";
	/**
	 * HOKA1(̑x1)B
	 */
	public static final String	COL_HOKA1		= "HOKA1";
	/**
	 * HOKA2(̑x2)B
	 */
	public static final String	COL_HOKA2		= "HOKA2";
	/**
	 * HOKA3(̑x3)B
	 */
	public static final String	COL_HOKA3		= "HOKA3";
	/**
	 * HOKA4(̑x4)B
	 */
	public static final String	COL_HOKA4		= "HOKA4";
	/**
	 * HOKA5(̑x5)B
	 */
	public static final String	COL_HOKA5		= "HOKA5";
	/**
	 * TATIMES(ގГ͓)B
	 */
	public static final String	COL_TATIMES		= "TATIMES";
	/**
	 * KKRIYUU(xɗR)B
	 */
	public static final String	COL_KKRIYUU		= "KKRIYUU";
	/**
	 * DAIKYUJYU(x[)B
	 */
	public static final String	COL_DAIKYUJYU	= "DAIKYUJYU";
	/**
	 * KKCOMENT(xɃRg)B
	 */
	public static final String	COL_KKCOMENT	= "KKCOMENT";
	/**
	 * KKSYOUMEI(xɏؖ)B
	 */
	public static final String	COL_KKSYOUMEI	= "KKSYOUMEI";
	/**
	 * KKJIKAN(xɎ)B
	 */
	public static final String	COL_KKJIKAN		= "KKJIKAN";
	/**
	 * KKTIMES(xɓ͓)B
	 */
	public static final String	COL_KKTIMES		= "KKTIMES";
	/**
	 * SNRIYUU(FR)B
	 */
	public static final String	COL_SNRIYUU		= "SNRIYUU";
	/**
	 * SNCOMENT(FRg)B
	 */
	public static final String	COL_SNCOMENT	= "SNCOMENT";
	/**
	 * SNTIMES(F͓)B
	 */
	public static final String	COL_SNTIMES		= "SNTIMES";
	/**
	 * UPDTTIMES(XV)B
	 */
	public static final String	COL_UPDTTIMES	= "UPDTTIMES";
	/**
	 * NIJIKYU(񎞊ԔNx)B
	 */
	public static final String	COL_NIJIKYU		= "NIJIKYU";
	/**
	 * WARIMASI1(1.00)B
	 */
	public static final String	COL_WARIMASI1	= "WARIMASI1";
	/**
	 * ZKINMU(OΖ`)B
	 */
	public static final String	COL_ZKINMU		= "ZKINMU";
	

	/**
	 * RXgN^
	 */
	public MScheduleDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<MScheduleDto> mappingAll() throws SQLException {
		List<MScheduleDto> all = new ArrayList<MScheduleDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return m_syukkinyoteiboDto m_syukkinyoteiboR[h
	 * @throws SQLException SQLOꍇ
	 */
	private MScheduleDto mapping() throws SQLException {
		MScheduleDto dto = new MScheduleDto();
		dto.setKCode(rs.getString(COL_KCODE)); //ЈR[h
		dto.setHizuke(rs.getString(COL_HIZUKE)); //t
		dto.setNen(rs.getInt(COL_NEN)); //N
		dto.setTuki(rs.getInt(COL_TUKI)); //
		dto.setHi(rs.getInt(COL_HI)); //
		dto.setSyozoku(rs.getString(COL_SYOZOKU)); //R[h
		dto.setNinsyo(rs.getString(COL_NINSYO)); //F؎
		dto.setSyJikoku(rs.getString(COL_SYJIKOKU)); //oΎ
		dto.setKinmu(rs.getString(COL_KINMU)); //Ζ`
		dto.setSHankyuKb(rs.getString(COL_SHANKYUKB)); //x敪
		dto.setKyusyuKb(rs.getString(COL_KYUSYUKB)); //xo敪
		dto.setTiRiyuu(rs.getString(COL_TIRIYUU)); //xR
		dto.setTiComent(rs.getString(COL_TICOMENT)); //xRg
		dto.setTiSyoumei(rs.getString(COL_TISYOUMEI)); //xؖ
		dto.setTiJikan(rs.getInt(COL_TIJIKAN)); //x
		dto.setSyTimes(rs.getString(COL_SYTIMES)); //oΓ͓
		dto.setTaJikoku(rs.getString(COL_TAJIKOKU)); //ގЎ
		dto.setKinmuJi(rs.getInt(COL_KINMUJI)); //Ζ
		dto.setKyukeiJi(rs.getInt(COL_KYUKEIJI)); //xe
		dto.setTHankyuKb(rs.getString(COL_THANKYUKB)); //x敪
		dto.setSoRiyuu(rs.getString(COL_SORIYUU)); //ޗR
		dto.setSoComent(rs.getString(COL_SOCOMENT)); //ރRg
		dto.setSoSyoumei(rs.getString(COL_SOSYOUMEI)); //ޏؖ
		dto.setSoJikan(rs.getInt(COL_SOJIKAN)); //ގ
		dto.setZaJikan(rs.getInt(COL_ZAJIKAN)); //cƎ
		dto.setKsJikan(rs.getInt(COL_KSJIKAN)); //xo
		dto.setSnJikan(rs.getInt(COL_SNJIKAN)); //[鎞
		dto.setSyokuji(rs.getInt(COL_SYOKUJI)); //H蓖x
		dto.setCyoku1(rs.getInt(COL_CYOKU1)); //1蓖x
		dto.setCyoku2(rs.getInt(COL_CYOKU2)); //2蓖x
		dto.setCyoku3(rs.getInt(COL_CYOKU3)); //3蓖x
		dto.setHoka1(rs.getInt(COL_HOKA1)); //̑x1
		dto.setHoka2(rs.getInt(COL_HOKA2)); //̑x2
		dto.setHoka3(rs.getInt(COL_HOKA3)); //̑x3
		dto.setHoka4(rs.getInt(COL_HOKA4)); //̑x4
		dto.setHoka5(rs.getInt(COL_HOKA5)); //̑x5
		dto.setTaTimes(rs.getString(COL_TATIMES)); //ގГ͓
		dto.setKKRiyuu(rs.getString(COL_KKRIYUU)); //xɗR
		dto.setDaiKyuJyu(rs.getString(COL_DAIKYUJYU)); //x[
		dto.setKKComent(rs.getString(COL_KKCOMENT)); //xɃRg
		dto.setKKSyoumei(rs.getString(COL_KKSYOUMEI)); //xɏؖ
		dto.setKKJikan(rs.getInt(COL_KKJIKAN)); //xɎ
		dto.setKKTimes(rs.getString(COL_KKTIMES)); //xɓ͓
		dto.setSnRiyuu(rs.getString(COL_SNRIYUU)); //FR
		dto.setSnComent(rs.getString(COL_SNCOMENT)); //FRg
		dto.setSnTimes(rs.getString(COL_SNTIMES)); //F͓
		dto.setUpdtTimes(rs.getString(COL_UPDTTIMES)); //XV
		dto.setNijiKyu(rs.getInt(COL_NIJIKYU)); //񎞊ԔNx
		dto.setWarimasi1(rs.getInt(COL_WARIMASI1)); //1.00
		dto.setZKinmu(rs.getString(COL_ZKINMU)); //OΖ`
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<?> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kcode ЈR[h(L[)
	 * @param hizuke t(L[)
	 * @return m_syukkinyoteiboDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MScheduleDto findForKey(String kcode, String hizuke) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, hizuke);
			executeQuery();
			MScheduleDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @param hizuke t(L[)
	 * @return m_syukkinyoteiboDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MScheduleDto findForUpdate(String kcode, String hizuke) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kcode);
			setParam(index++, hizuke);
			executeQuery();
			MScheduleDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param hizuke t
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MScheduleDto> findForCondition(String kcode, String hizuke) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? AND ");
		sb.append(COL_HIZUKE);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, hizuke + "%");
			executeQuery();
			List<MScheduleDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param startDate Jnt
	 * @param endDate It
	 * @return list (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MScheduleDto> findForScheduleList(String kcode, String startDate, String endDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? AND ");
		sb.append(COL_HIZUKE);
		sb.append(" >= ? AND ");
		sb.append(COL_HIZUKE);
		sb.append(" <= ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			List<MScheduleDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(MScheduleDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param 	aryDto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(MScheduleDto[] aryDto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass(), aryDto.length, aryDto.length));
			for (MScheduleDto element : aryDto) {
				setParams(element, true);
			}
			executeUpdate();
			chkInsert(aryDto.length);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(MScheduleDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getHizuke());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(MScheduleDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getHizuke());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert  }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(MScheduleDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode()); //ЈR[h
		setParam(index++, dto.getHizuke()); //t
		setParam(index++, dto.getNen()); //N
		setParam(index++, dto.getTuki()); //
		setParam(index++, dto.getHi()); //
		setParam(index++, dto.getSyozoku()); //R[h
		setParam(index++, dto.getNinsyo()); //F؎
		setParam(index++, dto.getSyJikoku()); //oΎ
		setParam(index++, dto.getKinmu()); //Ζ`
		setParam(index++, dto.getSHankyuKb()); //x敪
		setParam(index++, dto.getKyusyuKb()); //xo敪
		setParam(index++, dto.getTiRiyuu()); //xR
		setParam(index++, dto.getTiComent()); //xRg
		setParam(index++, dto.getTiSyoumei()); //xؖ
		setParam(index++, dto.getTiJikan()); //x
		setParam(index++, dto.getSyTimes()); //oΓ͓
		setParam(index++, dto.getTaJikoku()); //ގЎ
		setParam(index++, dto.getKinmuJi()); //Ζ
		setParam(index++, dto.getKyukeiJi()); //xe
		setParam(index++, dto.getTHankyuKb()); //x敪
		setParam(index++, dto.getSoRiyuu()); //ޗR
		setParam(index++, dto.getSoComent()); //ރRg
		setParam(index++, dto.getSoSyoumei()); //ޏؖ
		setParam(index++, dto.getSoJikan()); //ގ
		setParam(index++, dto.getZaJikan()); //cƎ
		setParam(index++, dto.getKsJikan()); //xo
		setParam(index++, dto.getSnJikan()); //[鎞
		setParam(index++, dto.getSyokuji()); //H蓖x
		setParam(index++, dto.getCyoku1()); //1蓖x
		setParam(index++, dto.getCyoku2()); //2蓖x
		setParam(index++, dto.getCyoku3()); //3蓖x
		setParam(index++, dto.getHoka1()); //̑x1
		setParam(index++, dto.getHoka2()); //̑x2
		setParam(index++, dto.getHoka3()); //̑x3
		setParam(index++, dto.getHoka4()); //̑x4
		setParam(index++, dto.getHoka5()); //̑x5
		setParam(index++, dto.getTaTimes()); //ގГ͓
		setParam(index++, dto.getKKRiyuu()); //xɗR
		setParam(index++, dto.getDaiKyuJyu()); //x[
		setParam(index++, dto.getKKComent()); //xɃRg
		setParam(index++, dto.getKKSyoumei()); //xɏؖ
		setParam(index++, dto.getKKJikan()); //xɎ
		setParam(index++, dto.getKKTimes()); //xɓ͓
		setParam(index++, dto.getSnRiyuu()); //FR
		setParam(index++, dto.getSnComent()); //FRg
		setParam(index++, dto.getSnTimes()); //F͓
		setParam(index++, dto.getUpdtTimes()); //XV
		setParam(index++, dto.getNijiKyu()); //񎞊ԔNx
		setParam(index++, dto.getWarimasi1()); //1.00
		setParam(index++, dto.getZKinmu()); //OΖ`
		setCommonParams(isInsert);
	}
	
}
