/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.human.dao.MEmergencyDao;
import jp.mosp.human.dao.MKojinDao;
import jp.mosp.kintai.common.dao.MKihonDao;
import jp.mosp.kintai.common.dto.MKihonDto;

/**
 * lɊւPartNX
 * @author yoshida
 *	@version	0.0.4
 */
public class HumanPart extends KintaiBasePart {
	
	/**
	 * M_KIHON
	 */
	public static final String	BASIS_TABLE		= MKihonDao.TABLE;
	
	/**
	 * M_KOJIN
	 */
	public static final String	PERSONAL_TABLE	= MKojinDao.TABLE;
	

	/**
	 * RXgN^
	 */
	public HumanPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public HumanPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * MKihonDaoCX^X
	 */
	private MKihonDao	kihonDao;
	

	/**
	 * M_KIHONe[upDAO擾
	 * @return	ςMKihonDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public MKihonDao getMKihonDao() throws Exception {
		if (VariousUtil.isNull(kihonDao)) {
			kihonDao = (MKihonDao)getPreparedDao(MKihonDao.class.getCanonicalName());
		}
		return kihonDao;
	}
	

	/**
	 * MKojinDaoCX^X
	 */
	private MKojinDao	kojinDao;
	

	/**
	 * M_KOJINe[upDAO̎擾
	 * @return	ςMKojinDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public MKojinDao getMKojinDao() throws Exception {
		if (VariousUtil.isNull(kojinDao)) {
			kojinDao = (MKojinDao)getPreparedDao(MKojinDao.class.getCanonicalName());
		}
		return kojinDao;
	}
	

	/**
	 * MEmergencyDaoCX^X
	 */
	private MEmergencyDao	emergencyDao;
	

	/**
	 * M_EMERGENCYe[upDAO̎擾
	 * @return	ςMEmergencyDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public MEmergencyDao getMEmergencyDao() throws Exception {
		if (VariousUtil.isNull(emergencyDao)) {
			emergencyDao = (MEmergencyDao)getPreparedDao(MEmergencyDao.class.getCanonicalName());
		}
		return emergencyDao;
	}
	
	/**
	 * l{擾(M_KIHON)
	 * @param kCode 擾ΏێЈR[h
	 * @return l{(MKihonDto)
	 * @throws Exception 	Oꍇ
	 */
	public MKihonDto getBasisInfo(String kCode) throws Exception {
		// ̎擾
		return getMKihonDao().findForKey(kCode);
	}
	
	/**
	 * Ј擾(M_KIHON)
	 * @param kCode 擾ΏێЈR[h
	 * @return Ј
	 * @throws Exception 	Oꍇ
	 */
	public String getKName(String kCode) throws Exception {
		MKihonDto dto = getBasisInfo(kCode);
		if (VariousUtil.isNull(dto)) {
			return kCode;
		}
		return dto.getSimei();
	}
	
	/**
	 * ЈR[h擾(M_KIHON)()
	 * @param sectionCode R[h
	 * @return ЈR[hXg
	 * @throws Exception 	Oꍇ
	 */
	public String[] getBasisArray(String sectionCode) throws Exception {
		return getBasisArray(sectionCode, DateUtil.getSystemDate());
	}
	
	/**
	 * ЈR[h擾(M_KIHON)(wN)
	 * @param sectionCode R[h
	 * @param targetMonth IN
	 * @return ЈR[hXg
	 * @throws Exception	Oꍇ
	 */
	public String[] getBasisArray(String sectionCode, Date targetMonth) throws Exception {
		// ̎擾
		List<MKihonDto> listKihon = getMKihonDao().findForSection(sectionCode, DateUtil.convDateToInteger(targetMonth),
				DateUtil.convDateToInteger(part().calculate().getEndDate(targetMonth)));
		// z̍쐬
		String[] aryKihon = new String[listKihon.size()];
		for (int i = 0; i < aryKihon.length; i++) {
			aryKihon[i] = listKihon.get(i).getKCode();
		}
		return aryKihon;
	}
	
	/**
	 * ЈR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws Exception 	Oꍇ
	 */
	public String[][] getBasisArrayAll() throws Exception {
		// ̎擾
		List<MKihonDto> listKihon = getMKihonDao().findAll();
		// z̍쐬
		String[][] aryKihon = new String[listKihon.size()][2];
		for (int i = 0; i < aryKihon.length; i++) {
			aryKihon[i][0] = listKihon.get(i).getKCode();
			aryKihon[i][1] = listKihon.get(i).getSimei();
		}
		return aryKihon;
	}
	
	/**
	 * ЈR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws Exception 	Oꍇ
	 */
	public String[][] getBasisArrayForApproval() throws Exception {
		// ̎擾
		List<MKihonDto> listKihon = getMKihonDao().findForAuth(CommonConst.AUTHORITY_MANAGER,
				CommonConst.AUTHORITY_SENIORS, DateUtil.convDateToInteger(DateUtil.getSystemDate()));
		// z̍쐬
		String[][] aryKihon = new String[listKihon.size()][2];
		for (int i = 0; i < aryKihon.length; i++) {
			aryKihon[i][0] = listKihon.get(i).getKCode();
			aryKihon[i][1] = listKihon.get(i).getSimei();
		}
		return aryKihon;
	}
	
	/**
	 * ЈR[hAR[h擾(M_KIHON)
	 * @return ЈR[hXg
	 * @throws Exception 	Oꍇ
	 */
	public String[][] getBasisArrayAllWithSectionCode() throws Exception {
		// ̎擾
		List<MKihonDto> listKihon = getMKihonDao().findAll();
		// z̍쐬
		String[][] aryKihon = new String[listKihon.size()][2];
		for (int i = 0; i < aryKihon.length; i++) {
			aryKihon[i][0] = listKihon.get(i).getKCode();
			aryKihon[i][1] = listKihon.get(i).getSCode();
		}
		return aryKihon;
	}
	
	/**
	 * ЈR[hAR[h擾(M_KIHON)
	 * @since	0.0.2
	 * @return ЈR[hXg
	 * @throws Exception 	Oꍇ
	 */
	public String[][] getBasisArrayAllWithOfficeCode() throws Exception {
		// ̎擾
		List<MKihonDto> listKihon = getMKihonDao().findAll();
		// z̍쐬
		String[][] aryKihon = new String[listKihon.size()][2];
		for (int i = 0; i < aryKihon.length; i++) {
			aryKihon[i][0] = listKihon.get(i).getKCode();
			aryKihon[i][1] = listKihon.get(i).getJCode();
		}
		return aryKihon;
	}
	
	/**
	 * IЈЈR[hꗗ擾(M_KIHON)
	 * @param kCode		ΏێЈR[h
	 * @return	ЈR[hXg
	 * @throws Exception	Oꍇ
	 */
	public String[][] getBasisArrayForBelongSection(String kCode) throws Exception {
		MKihonDto dto = getBasisInfo(kCode);
		// 
		List<MKihonDto> listMKihon = getMKihonDao().findForCondition(dto.getSCode(), dto.getJCode(), kCode,
				part().mospuser().getUserInfoForKCode(kCode).getDataLevel(),
				DateUtil.convDateToInteger(DateUtil.getSystemDate()));
		String[][] aryBasis = new String[listMKihon.size()][2];
		for (int i = 0; i < aryBasis.length; i++) {
			aryBasis[i][0] = listMKihon.get(i).getKCode();
			aryBasis[i][1] = listMKihon.get(i).getSimei();
		}
		return aryBasis;
	}
	
	/**
	 * ΑNij擾
	 * @param kCode ЈR[h
	 * @return y.m<br>͂̂܂
	 * 				[] 262.02N
	 * @throws Exception 	Oꍇ
	 */
	public double getYearsOfService(String kCode) throws Exception {
		MKihonDto dto = getBasisInfo(kCode);
		int difference = 0;
		if (VariousUtil.isNotNull(dto)) {
			difference = DateUtil.getMonthRemainder(DateUtil.getSystemDate(), DateUtil.convIntegerDateToDate(dto
				.getNyDate()));
		}
		return difference / 12 + difference % 12 / 100;
	}
	
	/**
	 * ސEf
	 * @param kCode		ΏێЈR[h
	 * @return
	 * <p>
	 * ސȄꍇBtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception	Oꍇ
	 */
	public boolean isRetiredEmployee(String kCode) throws Exception {
		return isRetiredEmployee(getBasisInfo(kCode));
	}
	
	/**
	 * ސEf
	 * @since	0.0.3
	 * @param dto	ΏێЈl
	 * @return
	 * <p>
	 * ސȄꍇBtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isRetiredEmployee(MKihonDto dto) {
		if (VariousUtil.chkExistDto(dto)) {
			// ސE敪ސEAސEt{ȌꍇB
			if (String.valueOf(CommonConst.RETIREMENT_FLAG_ON).equals(dto.getKnKubun())
					&& (dto.getTsDate() > 0 && dto.getTsDate() < DateUtil.convDateToInteger(DateUtil.getSystemDate()))) {
				return true;
			}
			return false;
		}
		return true;
	}
	
	/**
	 * ݐEЈ擾
	 * @param kCode		ΏێЈR[h
	 * @return			ݐEЈ
	 * @throws Exception	Oꍇ
	 */
	public MKihonDto getAvailableUserInfo(String kCode) throws Exception {
		MKihonDto dto = getBasisInfo(kCode);
		if (VariousUtil.chkExistDto(dto)) {
			// ސE敪ސȄꍇB
			if (isRetiredEmployee(dto)) {
				return null;
			}
			// ސE敪xȄꍇB
			if (String.valueOf(CommonConst.RETIREMENT_FLAG_LEAVE).equals(dto.getKnKubun())) {
				return null;
			}
		}
		return dto;
	}
	
	/**
	 * OCЈ{擾
	 * @return	OCЈ{
	 * @throws Exception	Oꍇ
	 */
	public MKihonDto getBasisInfoOfUser() throws Exception {
		return getBasisInfo(user.getKCode());
	}
	
	/**
	 * ΏێЈДN擾
	 * @since 0.0.4
	 * @param dto ΏێЈl{
	 * @return ДN
	 */
	public static Date getEmployDate(HumanBasisDtoInterface dto) {
		return DateUtil.convIntegerDateToDate(dto.getNyDate());
	}
	
	/**
	 * ΏێЈДN擾
	 * @since 0.0.4
	 * @param kCode ΏێЈR[h
	 * @return ДN 
	 * @throws Exception 	Oꍇ
	 */
	public Date getEmployDate(String kCode) throws Exception {
		return getEmployDate(getBasisInfo(kCode));
	}
	
}
