/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.sql.Connection;
import java.util.Properties;

import jp.mosp.common.common.InstanceFactory;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * Part}l[W[
 * @author yoshida
 *	@version	0.0.7
 */
public class PartManager {
	
	/**
	 * 
	 */
	private PartManager() {
		//  NXɂCX^Xh~B
	}
	
	/**
	 * PartInfo
	 * @param cfg	MosPAvP[Vݒ(/WEB-INF/mosp.properties)B
	 * @param cmd	NGXgꂽCommandB
	 * @param aspUser	OCASP[U[B
	 * @param user	OC[U[B
	 * @param conn 	DBRlNVB
	 * @return	PartInfoCX^X
	 */
	public static PartInfo createPartInfo(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user,
			Connection conn) {
		return new PartInfo(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * PartNXCX^X
	 * @param partClassName		ΏPartNX
	 * @param partInfo			Part𗘗pۂɕKvȏ
	 * @return					PartNXCX^X
	 * @throws MospException MosPOꍇ
	 */
	public static BasePart getPreparedPart(String partClassName, PartInfo partInfo) throws MospException {
		return create(partClassName, partInfo);
	}
	
	/**
	 * PartNXCX^X
	 * @since 0.0.7
	 * @param cls ΏPartNX
	 * @param partInfo			Part𗘗pۂɕKvȏ
	 * @return					PartNXCX^X
	 * @throws MospException MosPOꍇ
	 */
	public static BasePart getPreparedPart(Class<?> cls, PartInfo partInfo) throws MospException {
		return getPreparedPart(cls.getCanonicalName(), partInfo);
	}
	
	/**
	 * p[g
	 * @param className		BasePartpΏPartClass
	 * @param partInfo		CX^X̏ɕKvȏDTO
	 * @return				ΏPartClass̃CX^X
	 * @throws MospException  MosPOꍇ
	 */
	private static BasePart create(String className, PartInfo partInfo) throws MospException {
		BasePart part = null;
		Object obj = InstanceFactory.loadInstance(className);
		if (obj instanceof BasePart) {
			part = (BasePart)obj;
			part.init(partInfo);
		}
		return part;
	}
	
}
