-- 
-- MosP - Mind Open Source Project    http://www.mosp.jp/
-- Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
-- 
-- This program is free software; you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
-- 
DROP TABLE IF EXISTS `CT_HOLIDAYREQUEST`;
DROP TABLE IF EXISTS `PM_HOLIDAYREQUEST`;

DROP TABLE IF EXISTS `CT_HOLIDAY_REQUEST`;
DROP TABLE IF EXISTS `CT_TIMECARD`;

DROP TABLE IF EXISTS `CM_AGREEMENT_OVER_TIME`;
CREATE TABLE IF NOT EXISTS `CM_AGREEMENT_OVER_TIME` (
  `OVER_TIME_ID` int(10) unsigned zerofill NOT NULL default '0000000000' COMMENT 'ԊOID',
  `OVER_TIME_CODE` varchar(10) NOT NULL default '' COMMENT 'ԊOR[h',
  `WORK_TYPE_NAME` varchar(50) NOT NULL COMMENT 'Ɩ̎',
  `CAUSE` text NOT NULL COMMENT '̓IR',
  `AGREE_TYPE` varchar(10) NOT NULL default '' COMMENT '',
  `LIMIT_CODE` varchar(10) NOT NULL default '' COMMENT 'xR[h',
  `OVER_TIME_RATE` int(10) unsigned NOT NULL default '0' COMMENT 'ԊO',
  `CAUTION_MONTH` int(10) unsigned NOT NULL default '0' COMMENT '60ԎԊOx',
  `MONTHLY_OVER_TIME_RATE` int(10) unsigned NOT NULL default '0' COMMENT '60ԎԊO',
  `SUB_ACQUIRE_RATE` int(10) unsigned NOT NULL default '0' COMMENT '֋xɎ擾',
  `SUB_ACQUIRE_HOLIDAY_RATE` int(10) unsigned NOT NULL default '0' COMMENT '֋xɎ擾x',
  `SUB_QUIT_RATE` int(10) unsigned NOT NULL default '0' COMMENT '֋xɕ',
  `START_DATE` date NOT NULL COMMENT 'JnN',
  `DELETE_FLAG` int(10) unsigned NOT NULL default '0' COMMENT '폜tO',
  `INSERT_DATE` datetime NOT NULL COMMENT '쐬',
  `INSERT_USER` varchar(10) NOT NULL default '' COMMENT '쐬',
  `UPDATE_DATE` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT 'XV',
  `UPDATE_USER` varchar(10) NOT NULL default '' COMMENT 'XV',
  PRIMARY KEY  (`OVER_TIME_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=cp932 COMMENT='ԊO}X^';

DROP TABLE IF EXISTS `CM_AGREEMENT_WORK_ON`;
CREATE TABLE IF NOT EXISTS `CM_AGREEMENT_WORK_ON` (
  `WORK_ON_ID` int(10) unsigned zerofill NOT NULL default '0000000000' COMMENT 'xoID',
  `WORK_ON_CODE` varchar(10) NOT NULL default '' COMMENT 'xoR[h',
  `WORK_TYPE_NAME` varchar(50) NOT NULL COMMENT 'Ɩ̎',
  `CAUSE` text NOT NULL COMMENT '̓IR',
  `STANDARD_WEEK_HOLIDAY` varchar(14) NOT NULL COMMENT 'x',
  `OFFICIAL_HOLIDAY` varchar(1) NOT NULL COMMENT '@x',
  `JAPANESE_HOLIDAY_FLAG` varchar(1) NOT NULL COMMENT '̏jtO',
  `HOLIDAY_MASTER_FLAG` varchar(1) NOT NULL default '' COMMENT 'jՓ}X^tO',
  `STANDARD_HOLIDAY_RATE` int(10) unsigned NOT NULL default '0' COMMENT 'x',
  `OFFICIAL_HOLIDAY_RATE` int(10) unsigned NOT NULL default '0' COMMENT '@x',
  `NUMBER_OF_WORK_ON` int(10) unsigned NOT NULL default '0' COMMENT 'xo',
  `START_TIME` int(10) unsigned NOT NULL default '0' COMMENT 'Jn',
  `END_TIME` int(10) unsigned NOT NULL default '0' COMMENT 'I',
  `START_DATE` date NOT NULL COMMENT 'JnN',
  `DELETE_FLAG` int(10) unsigned NOT NULL default '0' COMMENT '폜tO',
  `INSERT_DATE` datetime NOT NULL COMMENT '쐬',
  `INSERT_USER` varchar(10) NOT NULL default '' COMMENT '쐬',
  `UPDATE_DATE` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT 'XV',
  `UPDATE_USER` varchar(10) NOT NULL default '' COMMENT 'XV',
  PRIMARY KEY  (`WORK_ON_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=cp932 COMMENT='xo}X^';

DROP TABLE IF EXISTS `CM_LABOR_AGREEMENT`;
CREATE TABLE IF NOT EXISTS `CM_LABOR_AGREEMENT` (
  `AGREE_CODE` varchar(10) NOT NULL default '' COMMENT 'R[h',
  `AGREE_TYPE` varchar(15) NOT NULL default '' COMMENT '',
  `OVER_TIME_CODE` varchar(10) NOT NULL default '' COMMENT 'ԊOR[h',
  `WORK_ON_CODE` varchar(10) NOT NULL default '' COMMENT 'xoR[h',
  `DELETE_FLAG` int(10) unsigned NOT NULL default '0' COMMENT '폜tO',
  `INSERT_DATE` datetime NOT NULL COMMENT '쐬',
  `INSERT_USER` varchar(10) NOT NULL default '' COMMENT '쐬',
  `UPDATE_DATE` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT 'XV',
  `UPDATE_USER` varchar(10) NOT NULL default '' COMMENT 'XV',
  PRIMARY KEY  (`AGREE_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=cp932 COMMENT='Jg}X^';

DROP TABLE IF EXISTS `CM_LIMIT_STANDARD`;
CREATE TABLE IF NOT EXISTS `CM_LIMIT_STANDARD` (
  `LIMIT_CODE` varchar(10) NOT NULL default '' COMMENT 'xR[h',
  `LIMIT_NAME` varchar(50) NOT NULL default '' COMMENT 'x',
  `TERM_TYPE` varchar(10) NOT NULL default '' COMMENT 'Ԃ̎',
  `PRESCRIBED_TIME` int(10) unsigned NOT NULL default '0' COMMENT 'J',
  `CAUTION_DAY` int(10) unsigned NOT NULL default '0' COMMENT '1̌x',
  `CAUTION_TERM` int(10) unsigned NOT NULL default '0' COMMENT 'wԂ̌x',
  `CAUTION_YEAR` int(10) unsigned NOT NULL default '0' COMMENT '1Ňx',
  `LIMIT_DAY` int(10) unsigned NOT NULL default '0' COMMENT '̌x',
  `LIMIT_TERM` int(10) unsigned NOT NULL default '0' COMMENT 'wԂ̌x',
  `LIMIT_YEAR` int(10) unsigned NOT NULL default '0' COMMENT '1Ňx',
  `RATE_TERM` int(10) unsigned NOT NULL default '0' COMMENT 'wԂ̊',
  `RATE_YEAR` int(10) unsigned NOT NULL default '0' COMMENT '1N̊',
  `DELETE_FLAG` int(10) unsigned NOT NULL default '0' COMMENT '폜tO',
  `INSERT_DATE` datetime NOT NULL COMMENT '쐬',
  `INSERT_USER` varchar(10) NOT NULL default '' COMMENT '쐬',
  `UPDATE_DATE` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT 'XV',
  `UPDATE_USER` varchar(10) NOT NULL default '' COMMENT 'XV',
  PRIMARY KEY  (`LIMIT_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=cp932 COMMENT='x}X^';

DROP TABLE IF EXISTS `KD_PAID_HOLIDAY`;
CREATE TABLE IF NOT EXISTS `KD_PAID_HOLIDAY` (
  `PAID_ID` bigint(20) unsigned zerofill NOT NULL default '00000000000000000000' COMMENT 'LxID',
  `K_CODE` varchar(10) NOT NULL default '' COMMENT 'ЈR[h',
  `PROCESS_TYPE` varchar(10) NOT NULL default '' COMMENT 'R[h',
  `PROCESS_DATE` date NOT NULL COMMENT 'x',
  `LAST_REMAIN_DAYS` double unsigned NOT NULL default '0' COMMENT 'ONxc',
  `LAST_REMAIN_HOUR` int(10) unsigned NOT NULL default '0' COMMENT 'ONxc',
  `REMAIN_DAYS` double unsigned NOT NULL default '0' COMMENT 'Nxc',
  `REMAIN_HOUR` int(10) unsigned NOT NULL default '0' COMMENT 'Nxc',
  `POSSIBLE` int(10) unsigned NOT NULL default '0' COMMENT 'ԒPʎ擾\',
  `DELETE_FLAG` int(10) unsigned NOT NULL default '0' COMMENT '폜tO',
  `INSERT_DATE` datetime NOT NULL COMMENT '쐬',
  `INSERT_USER` varchar(10) NOT NULL default '' COMMENT '쐬',
  `UPDATE_DATE` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT 'XV',
  `UPDATE_USER` varchar(10) NOT NULL default '' COMMENT 'XV',
  PRIMARY KEY  (`PAID_ID`,`K_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=cp932 COMMENT='LxǗe[u';

DROP TABLE IF EXISTS `KD_SUBSTITUTE_HOLIDAY`;
CREATE TABLE IF NOT EXISTS `KD_SUBSTITUTE_HOLIDAY` (
  `SUBSTITUTE_ID` bigint(20) unsigned zerofill NOT NULL default '00000000000000000000' COMMENT 'ǗID',
  `K_CODE` varchar(10) NOT NULL COMMENT 'ЈR[h',
  `OCCUR_YEAR` int(10) unsigned NOT NULL default '0' COMMENT 'N',
  `OCCUR_MONTH` int(10) unsigned NOT NULL default '0' COMMENT '',
  `CLOSE_DATE` date NOT NULL COMMENT 'ؓ',
  `LIMIT_START_DATE` date NOT NULL COMMENT 'Jn',
  `LIMIT_END_DATE` date NOT NULL COMMENT 'I',
  `ATTITUDE_STATUS` varchar(10) NOT NULL COMMENT 'ӌ',
  `PAYMENT_ACQUIRE_TIME` int(10) unsigned NOT NULL default '0' COMMENT '֋xɎ擾ԊO',
  `PAYMENT_ACQUIRE_HOLIDAY` int(10) unsigned NOT NULL default '0' COMMENT '֋xɎ擾xԊO',
  `PAYMENT_QUIT_TIME` int(10) unsigned NOT NULL default '0' COMMENT '֋xɕԊO',
  `USE_HOLIDAY_TIME` int(10) unsigned NOT NULL default '0' COMMENT 'p',
  `ACQUISITION_STATUS` varchar(10) NOT NULL COMMENT '擾',
  `LIQUIDATION_OVER_TIME` int(11) NOT NULL default '0' COMMENT 'xςɂ鎞ԊOZ',
  `LIQUIDATION_WEEK_HOLIDAY` int(11) NOT NULL default '0' COMMENT 'xςɂxԊOZ',
  `DECISION_STATUS` varchar(10) NOT NULL COMMENT 'Ϗ',
  `DELETE_FLAG` int(10) unsigned NOT NULL default '0' COMMENT '폜tO',
  `INSERT_DATE` datetime NOT NULL COMMENT '쐬',
  `INSERT_USER` varchar(10) NOT NULL default '' COMMENT '쐬',
  `UPDATE_DATE` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT 'XV',
  `UPDATE_USER` varchar(10) NOT NULL default '' COMMENT 'XV',
  PRIMARY KEY  (`SUBSTITUTE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=cp932 COMMENT='֋xɊǗe[u';

DROP TABLE IF EXISTS `KD_WORK`;
CREATE TABLE IF NOT EXISTS `KD_WORK` (
  `K_CODE` varchar(10) NOT NULL COMMENT 'ЈR[h',
  `SIKYU_YM` varchar(8) NOT NULL COMMENT 'xN',
  `S_NEN` int(4) NOT NULL default '0' COMMENT 'xN',
  `S_TUKI` int(2) NOT NULL default '0' COMMENT 'x',
  `S_HI` int(2) NOT NULL default '0' COMMENT 'x',
  `S_NISSU` double NOT NULL default '0' COMMENT 'oΓ',
  `S_KAISU` int(4) NOT NULL default '0' COMMENT 'oΉ',
  `KINMU_JI` int(4) NOT NULL default '0' COMMENT 'Ζ',
  `KYUKEI_JI` int(4) NOT NULL default '0' COMMENT 'xe',
  `YUKYU` double NOT NULL default '0' COMMENT 'L',
  `TOKUKYU` double NOT NULL default '0' COMMENT 'ʋx',
  `KEKKIN` double NOT NULL default '0' COMMENT 'ʌΓ',
  `S_KEKKIN` double NOT NULL default '0' COMMENT 'aΓ',
  `DAIKYU` double NOT NULL default '0' COMMENT '֋x',
  `FURIKAE` double NOT NULL default '0' COMMENT 'U֋x',
  `KK_RIYUU_6` double NOT NULL default '0' COMMENT 'xɗR6',
  `KK_RIYUU_7` double NOT NULL default '0' COMMENT 'xɗR7',
  `KK_RIYUU_8` double NOT NULL default '0' COMMENT 'xɗR8',
  `KK_RIYUU_9` double NOT NULL default '0' COMMENT 'xɗR9',
  `SONOTA` double NOT NULL default '0' COMMENT '̑x',
  `TI_SO_KAI` int(4) NOT NULL default '0' COMMENT 'xމ',
  `TI_SO_JIKAN` int(4) NOT NULL default '0' COMMENT 'xގ',
  `ZA_JIKAN` int(4) NOT NULL default '0' COMMENT 'ʎcƎ',
  `KS_JIKAN` int(4) NOT NULL default '0' COMMENT 'xoΎ',
  `SN_JIKAN` int(4) NOT NULL default '0' COMMENT '[Ζ',
  `KAIKIN` int(1) NOT NULL default '0' COMMENT 'FΎ蓖x',
  `SYOKUJI_KAISU` int(4) NOT NULL default '0' COMMENT 'H蓖x',
  `CYOKU_KAISU_1` int(4) NOT NULL default '0' COMMENT '1蓖x',
  `CYOKU_KAISU_2` int(4) NOT NULL default '0' COMMENT '2蓖x',
  `CYOKU_KAISU_3` int(4) NOT NULL default '0' COMMENT '3蓖x',
  `HOKA_KAISU_1` int(4) NOT NULL default '0' COMMENT '̑x1',
  `HOKA_KAISU_2` int(4) NOT NULL default '0' COMMENT '̑x2',
  `HOKA_KAISU_3` int(4) NOT NULL default '0' COMMENT '̑x3',
  `HOKA_KAISU_4` int(4) NOT NULL default '0' COMMENT '̑x4',
  `HOKA_KAISU_5` int(4) NOT NULL default '0' COMMENT '̑x5',
  `SINSEI_GAKU` int(8) NOT NULL default '0' COMMENT 'x\z',
  `WARIMASI_1` int(11) NOT NULL default '0' COMMENT '1.00',
  `WEEK_DAY_OVER_TIME` int(11) NOT NULL default '0' COMMENT 'ԊO',
  `WEEK_HOLIDAY_OVER_TIME` int(11) NOT NULL default '0' COMMENT 'xԊO',
  `MONTHLY_OVER_TIME` int(11) NOT NULL default '0' COMMENT '60ԒߕԊO',
  `MONTHLY_WEEK_HOLIDAY` int(11) NOT NULL default '0' COMMENT '60ԒߏxԊO',
  `HOUR_HOLIDAY` int(11) NOT NULL default '0' COMMENT 'ԒPʔNx擾',
  `SUBSTITUTE_HOLIDAY` double NOT NULL default '0' COMMENT 'ԊOԑ֋xɎ擾',
  `AMEND_FLAG` int(11) NOT NULL default '0' COMMENT 'CtO',
  `INSERT_DATE` datetime NOT NULL COMMENT '쐬',
  `INSERT_USER` varchar(10) NOT NULL default '' COMMENT '쐬',
  `UPDATE_DATE` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT 'XV',
  `UPDATE_USER` varchar(10) NOT NULL default '' COMMENT 'XV',
  PRIMARY KEY  (`K_CODE`,`SIKYU_YM`)
) ENGINE=InnoDB DEFAULT CHARSET=cp932 COMMENT='ΑӏWv';

DROP TABLE IF EXISTS `KT_HOLIDAY_REQUEST`;
CREATE TABLE IF NOT EXISTS `KT_HOLIDAY_REQUEST` (
  `VOUCHER` int(10) unsigned zerofill NOT NULL COMMENT 'xɐ\`[ԍ',
  `WORKFLOW` bigint(20) unsigned zerofill NOT NULL COMMENT '[Nt[ԍ',
  `K_CODE` varchar(10) NOT NULL COMMENT 'ЈR[h',
  `HOLIDAY_DATE` date NOT NULL COMMENT 'xɓ',
  `START_TIME` int(11) NOT NULL COMMENT 'xɊJn',
  `END_TIME` int(11) NOT NULL COMMENT 'xɏI',
  `REASON` varchar(10) NOT NULL COMMENT 'xɗR',
  `HOLIDAY_TYPE` varchar(10) NOT NULL COMMENT 'L敪',
  `OCCUR_DATE_1` varchar(10) NOT NULL default '' COMMENT 'N1',
  `USE_TIME_1` int(11) NOT NULL default '0' COMMENT 'p1',
  `OCCUR_DATE_2` varchar(10) NOT NULL default '' COMMENT 'N2',
  `USE_TIME_2` int(11) NOT NULL default '0' COMMENT 'p2',
  `SUBSTITUTE_DATE` varchar(10) NOT NULL COMMENT '[',
  `CAUSE_COMMENT` text NOT NULL COMMENT 'R',
  `DELETE_FLAG` int(10) unsigned NOT NULL default '0' COMMENT '폜tO',
  `INSERT_DATE` datetime NOT NULL COMMENT '쐬',
  `INSERT_USER` varchar(10) NOT NULL default '' COMMENT '쐬',
  `UPDATE_DATE` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT 'XV',
  `UPDATE_USER` varchar(10) NOT NULL default '' COMMENT 'XV',
  PRIMARY KEY  (`VOUCHER`)
) ENGINE=InnoDB DEFAULT CHARSET=cp932 COMMENT='xɐ\e[u';

DELETE FROM `M_CODE` WHERE 

TID ='^x' OR 
TID ='^T' OR 
TID ='ܗ^x' OR 
TID ='ܗ^T'
;

INSERT INTO `M_CODE` VALUES
('x', '0', '1T', '1,week', NOW(), 'admin', NOW(), 'admin'),
('x', '1', '2T', '2,week', NOW(), 'admin', NOW(), 'admin'),
('x', '2', '4T', '4,week', NOW(), 'admin', NOW(), 'admin'),
('x', '3', '1', '1,month', NOW(), 'admin', NOW(), 'admin'),
('x', '4', '2', '2,month', NOW(), 'admin', NOW(), 'admin'),
('x', '5', '3', '3,month', NOW(), 'admin', NOW(), 'admin'),

('', '0', 'PNPʂ̕ό`JԐɊYȂJ', '', NOW(), 'admin', NOW(), 'admin'),
('', '1', 'PNPʂ̕ό`JԐɂJJ', '', NOW(), 'admin', NOW(), 'admin'),
('', '2', '玙ExƖ@̎ԊOJ̐𐿋J', '', NOW(), 'admin', NOW(), 'admin'),

('ΑӊǗ', 'ۂߏ', '', '0', NOW(), 'admin', NOW(), 'admin'),
('ΑӊǗ', 'vZ', '', '0', NOW(), 'admin', NOW(), 'admin'),
('ΑӊǗ', '60ԎԊO@\', '', '1', NOW(), 'admin', NOW(), 'admin'),
('ΑӊǗ', 'xC', '', '1', NOW(), 'admin', NOW(), 'admin'),
('ΑӊǗ', '֋xɋ@\', '', '1', NOW(), 'admin', NOW(), 'admin'),

('Lx', 'ԒPʔNx', '', '1', NOW(), 'admin', NOW(), 'admin'),
('Lx', 'NxPʎ', '', '', NOW(), 'admin', NOW(), 'admin'),

('FR', '5', '', '', NOW(), 'admin', NOW(), 'admin')

;
