/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model.table;

import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.table.TableTable;

public class TableTableColumn {
    private TableTable table;
    protected String tableDefaultCellStyleName;
    protected String tableNumberColumnsRepeated;
    protected String tableStyleName;
    protected String tableVisibility;

    public StyleStyle getDefaultCellStyle() {
        StyleStyle styleStyle = this.table.getCellStyle(this.tableDefaultCellStyleName);
        if (styleStyle == null) {
            throw new IllegalStateException("Unable to find cell style:'" + this.tableDefaultCellStyleName + "'");
        }
        return styleStyle;
    }

    public String getTableDefaultCellStyleName() {
        return this.tableDefaultCellStyleName;
    }

    public int getTableNumberColumnsRepeated() {
        if (this.tableNumberColumnsRepeated == null) {
            return 1;
        }
        return Integer.valueOf(this.tableNumberColumnsRepeated);
    }

    public String getTableStyleName() {
        return this.tableStyleName;
    }

    public String getTableVisibility() {
        if (this.tableVisibility == null) {
            return "visible";
        }
        return this.tableVisibility;
    }

    public int getWidth() {
        if (this.getTableStyleName() == null) {
            return 25000;
        }
        StyleStyle styleStyle = this.table.getSpreadsheet().getBody().getDocument().getAutomaticStyles().getColumnStyle(this.getTableStyleName());
        return styleStyle.getStyleTableColumnProperties().getColumnWidth();
    }

    public void setTable(TableTable tableTable) {
        this.table = tableTable;
    }

    public void setTableDefaultCellStyleName(String string) {
        this.tableDefaultCellStyleName = string;
    }

    public void setTableNumberColumnsRepeated(String string) {
        this.tableNumberColumnsRepeated = string;
    }

    public void setTableStyleName(String string) {
        this.tableStyleName = string;
    }

    public void setTableVisibility(String string) {
        this.tableVisibility = string;
    }

    public String toString() {
        return "TableColumn: style:" + this.getTableStyleName() + " defaultCellStyle:" + this.tableDefaultCellStyleName;
    }
}

