/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * [U[e[u𑀍@\񋟂B<br><br>
 * {@link CmUserDto}pāADBJavavOԂŃR[hLB<br>
 */
public class CmUserDao extends BaseDao {
	
	// e[uyуL[
	/**
	 *  [U[e[uB<br>
	 */
	public static final String TABLE  = "CM_USER";
	
	/**
	 *  [U[e[uAL[B<br>
	 */
	public static final String KEY_01 = "USER_ID";
	
	// 
	/**
	 *  [U[e[uA(ID)B<br>
	 */
	public static final String COL_USER_ID     = "USER_ID";
	
	/**
	 *  [U[e[uA(pX[h)B<br>
	 */
	public static final String COL_PASSWORD    = "PASSWORD";
	
	/**
	 *  [U[e[uA(ЈR[h)B<br>
	 */
	public static final String COL_K_CODE      = "K_CODE";
	
	/**
	 *  [U[e[uA([U[)B<br>
	 */
	public static final String COL_USER_NAME   = "USER_NAME";
	
	/**
	 *  [U[e[uA(vOp)B<br>
	 */
	public static final String COL_AUTHORITY   = "AUTHORITY";
	
	/**
	 *  [U[e[uA(f[^Qƃx)B<br>
	 */
	public static final String COL_DATA_LEVEL  = "DATA_LEVEL";
	
	/**
	 *  [U[e[uA(pX[hύX)B<br>
	 */
	public static final String COL_CHANGE_PASS = "CHANGE_PASS";
	
	/**
	 *  [U[e[uA(폜tO)B<br>
	 */
	public static final String COL_DELETE_FLAG = "DELETE_FLAG";
	
	/**
	 * RXgN^B<br>
	 */
	public CmUserDao() {
		super();
		INSERT_DATE = "INSERT_DATE";
		INSERT_USER = "INSERT_USER";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
	/**
	 * RXgN^B<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public CmUserDao(
			Properties   cfg,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user,
			Connection   conn
	) {
		this();
		initDao(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return Xg
	 * @throws SQLException
	 */
	private List<CmUserDto> mappingAll() throws SQLException {
		List<CmUserDto> all = new ArrayList<CmUserDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return R[h(DTO)
	 * @throws SQLException
	 */
	private CmUserDto mapping() throws SQLException {
		CmUserDto dto = new CmUserDto();
		dto.setUserId    (rs.getString(COL_USER_ID    ));
		dto.setPassword  (rs.getString(COL_PASSWORD   ));
		dto.setKCode     (rs.getString(COL_K_CODE     ));
		dto.setUserName  (rs.getString(COL_USER_NAME  ));
		dto.setAuthority (rs.getString(COL_AUTHORITY  ));
		dto.setDataLevel (rs.getInt   (COL_DATA_LEVEL ));
		dto.setChangePass(rs.getDate  (COL_CHANGE_PASS));
		dto.setDeleteFlag(rs.getInt   (COL_DELETE_FLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	
	/**
	 * Sf[^擾B<br>
	 * @return (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmUserDto> findAllCmUser() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * L[ɂf[^擾B<br>
	 * @param userId [U[ID(L[)
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmUserDto findForKey(String userId) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, userId);
			executeQuery();
			CmUserDto cmUserDto = null;
			if (rs.next()) {
				cmUserDto = mapping();
			}
			return cmUserDto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * L[ɂsbN擾B<br>
	 * @param userId [U[ID(L[)
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmUserDto findForUpdate(String userId) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, userId);
			executeQuery();
			CmUserDto cmUserDto = null;
			if (rs.next()) {
				cmUserDto = mapping();
			}
			return cmUserDto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * ɂf[^擾B<br>
	 * @param userId [U[ID
	 * @param userName [U[
	 * @param authority MosPp
	 * @param deleteFlag 폜tO
	 * @return (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmUserDto> findCmUserForCondition(
			String userId,
			String userName,
			String authority,
			String deleteFlag
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_USER_ID);
		sb.append(" LIKE ? AND ");
		sb.append(COL_USER_NAME);
		sb.append(" LIKE ? ");
		if (!authority.equals("")) {
			sb.append("AND ");
			sb.append(COL_AUTHORITY);
			sb.append(" = ? ");
		}
		if (!deleteFlag.equals("")) {
			sb.append("AND ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ? ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, userId + "%");
			setParam(index++, "%" + userName + "%");
			if (!authority.equals("")) {
				setParam(index++, authority);
			}
			if (!deleteFlag.equals("")) {
				setParam(index++, Integer.parseInt(deleteFlag));
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	
	/**
	 * f[^}B<br>
	 * @param dto }ΏDTO
	 * @return }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmUserDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * f[^XVB<br>
	 * @param dto XVΏDTO
	 * @return XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmUserDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getUserId());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * p[^ݒ
	 * @param dto      XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CmUserDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getUserId    ());
		setParam(index++, dto.getPassword  ());
		setParam(index++, dto.getKCode     ());
		setParam(index++, dto.getUserName  ());
		setParam(index++, dto.getAuthority ());
		setParam(index++, dto.getDataLevel ());
		setParam(index++, dto.getChangePass());
		setParam(index++, dto.getDeleteFlag());
		setCommonParams(isInsert);
	}
	
}
