/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

/**
 * CX^X
 * @author yoshida
 *	@version	0.0.1
 */
public class InstanceFactory {

	/**
	 * NX[_[CX^X𐶐
	 * @param className	 ΏۃNX
	 * @return ΏۃNXCX^X
	 * @throws MospException
	 */
	public static Object loadInstance(String className) throws MospException {
		Object obj = null;
		try {
			if (className == null) {
				throw new NullPointerException();
			}
			obj = Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
		} catch (NullPointerException e) {
			throw new MospException(5010, "NX͂Ă܂B");
		} catch (ClassNotFoundException e) {
			throw new MospException(5011, className + "̃NX܂B");
		} catch (InstantiationException e) {
			throw new MospException(5012, className + "̏Ɏs܂B");
		} catch (IllegalAccessException e) {
			throw new MospException(5013, className + "̃RXgN^ɃANZXł܂łB");
		} 
		return obj;
	}

	/**
	 * NXCX^X𐶐
	 * @param className ΏۃNX
	 * @return ΏۃNXCX^X
	 * @throws MospException
	 */
	public static Object simplifiedInstance(String className) throws MospException {
		Object obj = null;
		try {
			if (className == null) {
				throw new NullPointerException();
			}
			obj = Class.forName(className).newInstance();
		} catch (NullPointerException e) {
			throw new MospException(5010, "NX͂Ă܂B");
		} catch (ClassNotFoundException e) {
			throw new MospException(5011, className + "̃NX܂B");
		} catch (InstantiationException e) {
			throw new MospException(5012, className + "̏Ɏs܂B");
		} catch (IllegalAccessException e) {
			throw new MospException(5013, className + "̃RXgN^ɃANZXł܂łB");
		} 
		return obj;
	}

}
