/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

/**
 * DBƂ̐ڑǗB
 */
public abstract class DBConnBean {
	
	/**
	 * DBRlNVB<br>
	 * {@link #getConnection(String, String, String, String)}
	 * ɂAݒ肳B
	 */
	protected Connection conn;
	
	/**
	 * RXgN^B
	 */
	protected DBConnBean() {
		conn = null;
	}
	
	/**
	 * DBRlNV擾B<br>
	 * JDBCpDBRlNV擾A
	 * {@link #conn}ɊĂB<br>
	 * 擾RlNVAutoCommit@\𗘗pȂB<br>
	 * @param RDBDRIVER JDBC
	 * @param RDBNAME DBURL
	 * @param USERID DBڑ[U[ID
	 * @param PASSWORD pX[h
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 */
	protected void getConnection(
			String RDBDRIVER,
			String RDBNAME  ,
			String USERID   ,
			String PASSWORD
	) throws ClassNotFoundException, SQLException {
		Class.forName(RDBDRIVER);
		conn = DriverManager.getConnection(RDBNAME, USERID, PASSWORD);
		conn.setAutoCommit(false);
	}
	
	/**
	 * DBRlNV擾B<br>
	 * DataSourcepDBRlNV擾A
	 * {@link #conn}ɊĂB<br>
	 * 擾RlNVAutoCommit@\𗘗pȂB<br>
	 * @param DATASOURCE f[^\[X
	 * @throws NamingException 
	 * @throws SQLException 
	 */
	protected void getConnection(
			String DATASOURCE
	) throws NamingException, SQLException {
		DataSource ds;
		ds = (DataSource)new InitialContext().lookup("java:comp/env/" + DATASOURCE);
		conn = ds.getConnection();
		conn.setAutoCommit(false);
	}
	
	/**
	 * DBRlNVJB<br>
	 * {@link #conn}JB
	 * @throws SQLException
	 */
	protected void releaseConnection() throws SQLException {
		if (conn != null && !conn.isClosed()) {
			conn.close();
		}
		if (conn != null) {
			conn = null;
		}
	}
	
	
	/**
	 * gUNVR~bgB<br>
	 * {@link #conn}̃gUNVR~bgB
	 * @throws SQLException
	 */
	protected void commit() throws SQLException {
		if (conn != null && !conn.isClosed()) {
			conn.commit();
		}
	}
	
	
	/**
	 * gUNV[obNB<br>
	 * {@link #conn}̃gUNV[obNB
	 * @throws SQLException
	 */
	protected void rollback() throws SQLException {
		if (conn != null && !conn.isClosed()) {
			conn.rollback();
		}
	}
	
}
