/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.SocketException;
import java.util.List;
import java.util.Properties;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;

/**
 * Mospt[[NFrontControllerB<br><br>
 *  
 * ̃T[ubgMosPContorollerƂĂ̖ʂB<br>
 * ݒt@CǍAȎɁAȉ̗ŃAvP[V𐧌䂷@\LB<br>
 * <ul>
 * <li>NGXg̎tAyыʑO</li>
 * <li>ActionCX^X̐Ayяs</li>
 * <li>Viewւ̏ϏA̓X|X̐</li>
 * </ul>
 * sActionNX́ANGXgɊ܂܂CommandɂČ肳B<br>
 * ActionCommand́Aݒt@Ccontroller.propertiesɂĊ֘AtB<br>
 * <br>
 * X|X`́AHTTPNGXgp[^uresTypevɂ茈肳B<br>
 * uresTypevuhtmlvł΁AHTTPNGXg̑({@link MospConst#ATT_URL})
 * ݒ肳ꂽURLɃNGXgtH[hAHTMLŃX|XoB<br>
 * uresTypevufilevł΁AHTTPNGXg̑({@link MospConst#ATT_FILE_OBJECT})
 * ɐݒ肳ꂽIuWFNgt@CƂđoB<br>
 */
public class Controller extends HttpServlet {
	
	private static final long serialVersionUID = 5986464246296477656L;
	
	private transient ServletContext ctx = null;
	private Properties ctl = null;
	private Properties cfg = null;
	private Properties nam = null;
	private Properties msg = null;
	
	/**
	 * B<br>
	 * T[ubgReLXg擾Ayѐݒt@CǍsB<br>
	 */
	@Override
	public void init(ServletConfig config) throws ServletException {
		try {
			super.init(config);
			// T[ubgReLXg̎擾
			if (ctx == null) {
				ctx = config.getServletContext();
			}
			// vpeBt@CǍ
			getResources();
			// MosPt[[No[WOo
			LogUtility.log(cfg, "", "", "", 4, MospConst.LOG_MOSPINF,
					MospConst.LOG_MSG_MOSP_VERSION + MospUtility.getMospJarVersion());
			// MosPSE[eBeB[݊mF
			try {
				Thread.currentThread().getContextClassLoader().loadClass("jp.mosp.se.SeUtility").newInstance();
				String seVer = jp.mosp.se.SeUtility.getMospSeJarVersion();
				ctx.setAttribute(MospConst.ATT_SE_VER, seVer);
				// MosPSE[eBeB[o[WOo
				LogUtility.log(cfg, "", "", "", 4,
						MospConst.LOG_MOSPINF, MospConst.LOG_MSG_SE_VERSION + seVer);
			} catch(ClassNotFoundException e) {
				// MosPSE[eBeB[sgp
				ctx.removeAttribute(MospConst.ATT_SE_VER);
			}
			// MosP@胆[eBeB[݊mF
			try {
				Thread.currentThread().getContextClassLoader().loadClass("jp.mosp.legal.LegalUtility").newInstance();
				String legalVer = jp.mosp.legal.LegalUtility.getMospLegalJarVersion();
				ctx.setAttribute(MospConst.ATT_LEGAL_VER, legalVer);
				// MosP@胆[eBeB[o[WOo
				LogUtility.log(cfg, "", "", "", 4,
						MospConst.LOG_MOSPINF, MospConst.LOG_MSG_LEGAL_VERSION + legalVer);
			} catch(ClassNotFoundException e) {
				// MosP@胆[eBeB[sgp
				ctx.removeAttribute(MospConst.ATT_LEGAL_VER);
			}
			// MosPvZ[eBeB[݊mF
			try {
				Thread.currentThread().getContextClassLoader().loadClass("jp.mosp.express.ExpressUtility").newInstance();
				String expressVer = jp.mosp.express.ExpressUtility.getMospExpressJarVersion();
				ctx.setAttribute(MospConst.ATT_EXPRESS_VER, expressVer);
				// MosPvZ[eBeB[o[WOo
				LogUtility.log(cfg, "", "", "", 4,
						MospConst.LOG_MOSPINF, MospConst.LOG_MSG_EXPRESS_VERSION + expressVer);
			} catch(ClassNotFoundException e) {
				// MosPvZ[eBeB[sgp
				ctx.removeAttribute(MospConst.ATT_EXPRESS_VER);
			}
			// PoiCu݊mF
			try {
				Thread.currentThread().getContextClassLoader().loadClass("org.apache.poi.hssf.usermodel.HSSFWorkbook").newInstance();
				ctx.setAttribute(MospConst.ATT_POI_EXIST, Boolean.valueOf(true));
			} catch(ClassNotFoundException e) {
				// PoiCusgp
				ctx.removeAttribute(MospConst.ATT_POI_EXIST);
			}
			// jOpenDocumentCu݊mF
			try {
				Thread.currentThread().getContextClassLoader().loadClass("org.jopendocument.dom.ODPackage").newInstance();
				ctx.setAttribute(MospConst.ATT_JOD_EXIST, Boolean.valueOf(true));
			} catch(ClassNotFoundException e) {
				// PoiCusgp
				ctx.removeAttribute(MospConst.ATT_JOD_EXIST);
			}
			// JasperReportCu݊mF
			try {
				Thread.currentThread().getContextClassLoader().loadClass("net.sf.jasperreports.engine.JasperPrint").newInstance();
				ctx.setAttribute(MospConst.ATT_JASPER_EXIST, Boolean.valueOf(true));
			} catch(ClassNotFoundException e) {
				// JasperReportCusgp
				ctx.removeAttribute(MospConst.ATT_JASPER_EXIST);
			}
			// FileUploadCu݊mF
			try {
				Thread.currentThread().getContextClassLoader().loadClass("org.apache.commons.fileupload.servlet.ServletFileUpload").newInstance();
				ctx.setAttribute(MospConst.ATT_UPLOAD_EXIST, Boolean.valueOf(true));
			} catch(ClassNotFoundException e) {
				// FileUploadCusgp
				ctx.removeAttribute(MospConst.ATT_UPLOAD_EXIST);
			}
		} catch (IOException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Get\bhNGXg擾B<br>
	 * 摜擾ɂ̂ݗpAȊȌꍇdoPost(request, response)pB<br>
	 */
	@Override
	public void doGet(HttpServletRequest request, HttpServletResponse response) {
		try {
			// X|X^Cv擾
			String responseType = request.getParameter(MospConst.PRM_RESPONSE_TYPE);
			String cmd          = request.getParameter(MospConst.PRM_CMD);
			String procSeq      = request.getParameter(MospConst.PRM_PROC_SEQ);
			// X|X^CvmF
			if (responseType == null || cmd == null || procSeq == null) {
				request.setAttribute(MospConst.ATT_CFG, cfg);
				throw new MospException(MospConst.EX_REQUEST_TYPE);
			}
			// C[W̏ꍇ
			if (responseType.equals(MospConst.RESPONSE_TYPE_IMAGE)) {
				doPost(request, response);
				return;
			}
			// Mobilȅꍇ
			if (responseType.equals(MospConst.RESPONSE_TYPE_HTML)
					&& MobileUserUtility.isMobileUser(request)) {
				doPost(request, response);
				return;
			}
			// NGXg^CvsOs
			request.setAttribute(MospConst.ATT_CFG, cfg);
			throw new MospException(MospConst.EX_REQUEST_TYPE);
		} catch (Exception e) {
			handleException(e, request, response);
		}
	}
	
	/**
	 * Post\bhNGXg擾B<br>
	 * Contoroller̃CƂȂ鏈sAAvP[V𐧌䂷B<br>
	 * NCAǵÃ\bhs悤HTTPNGXg𓊂KvB<br>
	 */
	@Override
	public void doPost(HttpServletRequest request, HttpServletResponse response) {
		try {
			// T[ubgO
			doCommonPreProcess(request);
			// ANZXOo
			LogUtility.log(request, 0, MospConst.LOG_ACCESS, "");
			// R}h̎擾
			String cmd = (String)request.getAttribute(MospConst.ATT_CMD);
			// ANVNX̎擾yя
			ActionInterface action = (ActionInterface)MospUtility.getInstance(ctl, cmd);
			action.init(request, response);
			// ANVs
			action.doAction();
			// ANVj
			action = null;
			// tH[h
			forward(request, response);
		} catch (Exception e) {
			handleException(e, request, response);
		} catch (Error e) {
			handleException(e, request, response);
		}
	}
	
	/**
	 * vpeBt@CQǍ
	 * @throws IOException
	 */
	private void getResources() throws IOException {
		String docbase = ctx.getRealPath("");
		// ݒt@C̎擾
		cfg = MospUtility.getResource(docbase + MospConst.PATH_INF + MospConst.FILE_CFG);
		MospUtility.addResources(cfg, docbase + MospConst.PATH_INF, MospConst.FILE_EXT);
		cfg.setProperty(MospConst.PPT_APP_DOCBASE, docbase);
		// Rg[[t@C̎擾
		ctl = MospUtility.getResource(docbase + MospConst.PATH_INF + MospConst.FILE_CTL);
		MospUtility.addResources(ctl, docbase + MospConst.PATH_INF, MospConst.FILE_CTL);
		// t@C̎擾
		try {
			nam = MospUtility.getResource(docbase + MospConst.PATH_INF + MospConst.FILE_NAM);
		} catch (IOException e) {
			// t@C݂Ȃꍇ
			nam = new Properties();
		}
		MospUtility.addResources(nam, docbase + MospConst.PATH_INF, MospConst.FILE_NAM);
		// bZ[Wt@C̎擾
		msg = MospUtility.getResource(docbase + MospConst.PATH_INF + MospConst.FILE_MSG);
		MospUtility.addResources(msg, docbase + MospConst.PATH_INF, MospConst.FILE_MSG);
		// bZ[Wt@C(javascript)̏o
		MospUtility.convProperties(msg, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + MospConst.JS_MESSAGE, MospConst.JS_MESSAGE_NAME);
	}
	
	/**
	 * tH[h
	 * @param request NGXg
	 * @param response X|X
	 * @throws IOException
	 * @throws ServletException
	 * @throws MospException
	 */
	private void forward(
			HttpServletRequest  request ,
			HttpServletResponse response
	) throws IOException, ServletException, MospException {
		String url = null;
		// X|X^Cv擾
		String responseType = (String)request.getAttribute(MospConst.ATT_RESPONSE_TYPE);
		// X|X^CvURLݒ
		if (responseType == null) {
			// y[WURLႵ̓G[y[WURL(null̏ꍇ)
			url = (String)request.getAttribute(MospConst.ATT_URL);
			if (url == null || !url.equals(MospConst.URL_INDEX)) {
				url = MospConst.URL_ERROR;
			}
		} else if (responseType.equals(MospConst.RESPONSE_TYPE_HTML)) {
			// NGXgɃZbgĂURL(HTML̏ꍇ)
			url = (String)request.getAttribute(MospConst.ATT_URL);
		} else if (responseType.equals(MospConst.RESPONSE_TYPE_XML)) {
			// XMLo̓y[W(XML̏ꍇ)
			url = MospConst.URL_XML;
		} else if (responseType.equals(MospConst.RESPONSE_TYPE_FILE)) {
			// t@Co(eLXgt@C邢Excelt@C̏ꍇ)
			Object objFile = request.getAttribute(MospConst.ATT_FILE_OBJECT);
			String strFile = (String)request.getAttribute(MospConst.ATT_FILE_NAME);
			response.setContentType(MospConst.RESPONSE_CONT_TYPE_FILE);
			response.setHeader(MospConst.RESPONSE_HEADER_FILE, MospConst.RESPONSE_HEADER_VALUE_FILE + strFile);
			if (objFile instanceof String || objFile instanceof StringBuffer) {
				// eLXgt@C̏ꍇ
				PrintWriter pw = response.getWriter();
				pw.print(objFile);
			} else {
				// eLXgt@CȊȌꍇ
				// Cu[݊mF
				boolean hasPoi          = true;
				boolean hasJOpenDoc     = true;
				boolean hasJasperReport = true;
				if (ctx.getAttribute(MospConst.ATT_POI_EXIST) == null) {
					hasPoi = false;
				}
				if (ctx.getAttribute(MospConst.ATT_JOD_EXIST) == null) {
					hasJOpenDoc = false;
				}
				if (ctx.getAttribute(MospConst.ATT_JASPER_EXIST) == null) {
					hasJasperReport = false;
				}
				// t@Co
				if (hasPoi && objFile instanceof org.apache.poi.hssf.usermodel.HSSFWorkbook) {
					org.apache.poi.hssf.usermodel.HSSFWorkbook workbook = (org.apache.poi.hssf.usermodel.HSSFWorkbook)objFile;
					workbook.write(response.getOutputStream());
				} else if (hasJOpenDoc && objFile instanceof org.jopendocument.dom.spreadsheet.SpreadSheet) {
					org.jopendocument.dom.spreadsheet.SpreadSheet spreadSheet = (org.jopendocument.dom.spreadsheet.SpreadSheet)objFile;
					spreadSheet.getPackage().save(response.getOutputStream());
				} else if (hasJasperReport && objFile instanceof net.sf.jasperreports.engine.JRExporter) {
					net.sf.jasperreports.engine.JRExporter exporter = (net.sf.jasperreports.engine.JRExporter)objFile;
					exporter.setParameter(net.sf.jasperreports.engine.JRExporterParameter.OUTPUT_STREAM, response.getOutputStream());
					try {
						exporter.exportReport();
					} catch(Exception e) {
						throw new MospException(MospConst.EX_RUNTIME_ERR);
					}
				} else {
					PrintWriter pw = response.getWriter();
					pw.print(objFile);
				}
			}
			return;
		} else if (responseType.equals(MospConst.RESPONSE_TYPE_IMAGE)) {
			// C[Wt@C̏ꍇ
			Object objFile = request.getAttribute(MospConst.ATT_FILE_OBJECT);
			response.setContentType(MospConst.RESPONSE_CONT_TYPE_IMAGE);
		    ServletOutputStream out = response.getOutputStream();
		    byte[] data = new byte[1024];
		    int len;
		    BufferedInputStream in = (BufferedInputStream)objFile;
		    while ((len = in.read(data, 0, 1024)) != -1) {
		        out.write(data, 0, len);
		    }
		    in.close();
			return;
		} else {
			// G[y[WURL(̑̏ꍇ)
			url = MospConst.URL_ERROR;
		}
		if (url == null) {
			url = MospConst.URL_ERROR;
			LogUtility.log(request, 6, MospConst.LOG_MOSPERR, MospConst.LOG_MSG_NO_URL);
		}
		RequestDispatcher rd = ctx.getRequestDispatcher(url);
		rd.forward(request, response);
	}
	
	/**
	 * ʑO
	 * @param request NGXg
	 * @throws Exception
	 */
	private void doCommonPreProcess(
			HttpServletRequest  request
	) throws Exception {
		// NGXgւ̃Zbg
		request.setAttribute(MospConst.ATT_CTX, ctx);
		request.setAttribute(MospConst.ATT_CTL, ctl);
		request.setAttribute(MospConst.ATT_CFG, cfg);
		request.setAttribute(MospConst.ATT_NAM, nam);
		request.setAttribute(MospConst.ATT_MSG, msg);
		// NGXg{fB[̃oCgmF
		if (MospConst.CONTENT_MAX_LEN < request.getContentLength()) {
			throw new MospException(MospConst.EX_CONTENT_LENGTH);
		}
		// vpeBt@CǍ(app.hot=0̂)
		Properties hot = MospUtility.getResource(
				cfg.getProperty(MospConst.PPT_APP_DOCBASE) + MospConst.PATH_INF + MospConst.FILE_HOT);
		if (hot.getProperty(MospConst.PPT_APP_HOT).equals("0")) {
			getResources();
			LogUtility.setLevel(cfg);
		}
		// nextcmdɂ郊NGXg񐔊mF
		Integer forward = (Integer)request.getAttribute(MospConst.ATT_FORWARD);
		forward = forward != null ? forward : new Integer(0);
		if (forward.intValue() > 1) {
			throw new MospException(MospConst.EX_COUNT_FORWARD);
		}
		// NGXg̕R[hw
		String contentType = request.getHeader("content-type");
		if (contentType != null && contentType.indexOf("charset") == -1) {
			request.setCharacterEncoding(MospConst.REQUEST_CHAR_ENC);
		}
		// MultipartmF
		List<?> multipartFieldList = null;
		if (ctx.getAttribute(MospConst.ATT_UPLOAD_EXIST) != null) {
			multipartFieldList = FileUploadUtility.getMultipartFieldList(request);
		}
		request.setAttribute(MospConst.ATT_MULTIPART_LIST, multipartFieldList);
		// X|X^Cv擾
		String responseType = (String)request.getAttribute(MospConst.ATT_RESPONSE_TYPE);
		if (responseType == null) {
			responseType = request.getParameter(MospConst.PRM_RESPONSE_TYPE);
		}
		if (responseType == null && multipartFieldList != null) {
			responseType = FileUploadUtility.getMultipartField(multipartFieldList, MospConst.PRM_RESPONSE_TYPE);
		}
		// X|X^CvmF
		if (responseType == null) {
			throw new MospException(MospConst.EX_RESTYPE_NULL);
		} else if (
				!responseType.equals(MospConst.RESPONSE_TYPE_HTML) &&
				!responseType.equals(MospConst.RESPONSE_TYPE_FILE) &&
				!responseType.equals(MospConst.RESPONSE_TYPE_XML)  &&
				!responseType.equals(MospConst.RESPONSE_TYPE_IMAGE)
		) {
			throw new MospException(MospConst.EX_RESTYPE_INVALID);
		}
		// NGXgւ̃Zbg
		request.setAttribute(MospConst.ATT_RESPONSE_TYPE, responseType);
		// R}hmF
		String cmd = (String)request.getAttribute(MospConst.ATT_NEXTCMD);
		request.removeAttribute(MospConst.ATT_NEXTCMD);
		if (cmd == null) {
			cmd = request.getParameter(MospConst.PRM_CMD);
			if (cmd == null) {
				cmd = FileUploadUtility.getMultipartField(multipartFieldList, MospConst.PRM_CMD);
			}
			if (cmd == null) {
				throw new MospException(MospConst.EX_CMD_NULL);
			}
			request.removeAttribute(MospConst.ATT_FORWARD);
		} else {
			request.setAttribute(MospConst.ATT_FORWARD, new Integer(forward.intValue() + 1));
		}
		if (cmd.length() > MospConst.LEN_COMMAND) {
			throw new MospException(MospConst.EX_CMD_FORMAT);
		}
		// NGXgւ̃Zbg
		request.setAttribute(MospConst.ATT_CMD, cmd);
	}
	
	/**
	 * T[ubgG[
	 * @param ex O邢̓G[IuWFNg
	 * @param request NGXg
	 * @param response X|X
	 */
	private void handleException(
			Object             obj,
			HttpServletRequest request,
			HttpServletResponse response
	) {
		try {
			if (response.isCommitted()) {
				return;
			}
			String url = MospConst.URL_ERROR;
			HttpSession session = request.getSession(false);
			String responseType = (String)request.getAttribute(MospConst.ATT_RESPONSE_TYPE);
			if (obj instanceof MospException) {
				MospException me = (MospException)obj;
				int           exCode   = me.getExCode();
				int           logLevel = getExLogLevel(exCode);
				String        logType  = getExLogType(exCode);
				StringBuffer  message  = new StringBuffer();
				message.append(exCode);
				message.append("-");
				if (me.getExMessage() == null) {
					message.append(getExLogMessage(exCode));
				} else {
					message.append(me.getExMessage());
				}
				LogUtility.log(request, logLevel, logType, message.toString());
				if (needInitSession(exCode)) {
					if (session != null) {
						session.invalidate();
					}
					request.getSession(true);
				}
				url = getUrl(exCode, request);
			} else if (obj instanceof Exception) {
				Exception ex = (Exception)obj;
				LogUtility.outputErrorLog(ex, request);
				if (ex.getCause() instanceof SocketException && responseType.equals(MospConst.RESPONSE_TYPE_FILE)) {
					return;
				}
				if (session != null) {
					session.invalidate();
				}
				request.getSession(true);
				url = MospConst.URL_ERROR;
			} else if (obj instanceof Error) {
				Error er = (Error)obj;
				LogUtility.outputErrorLog(er, request);
				if (session != null) {
					session.invalidate();
				}
				request.getSession(true);
				url = MospConst.URL_ERROR;
			}
			request.setAttribute(MospConst.ATT_URL, url);
			// X|X^Cv̏
			if (responseType != null && responseType.equals(MospConst.RESPONSE_TYPE_FILE)) {
				// X|X^CvHTMLɕύX(FILȄꍇ)
				request.setAttribute(MospConst.ATT_RESPONSE_TYPE, MospConst.RESPONSE_TYPE_HTML);
			} else if (responseType != null && responseType.equals(MospConst.RESPONSE_TYPE_XML)) {
				// XMLpG[R[hݒ(XML̏ꍇ)
				setXmlErrCode(obj, request);
			}
			forward(request, response);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * XMLX|XG[R[hݒ
	 * @param ex O
	 * @param request NGXg
	 * @throws ParserConfigurationException
	 */
	private void setXmlErrCode(
			Object ex,
			HttpServletRequest request
	) throws ParserConfigurationException {
		BaseVo vo = (BaseVo)request.getAttribute(MospConst.ATT_VO);
		if (vo == null) {
			vo = new BaseVo();
			request.setAttribute(MospConst.ATT_VO, vo);
		}
		vo.initXmlDoc();
		if (ex instanceof MospException) {
			MospException me = (MospException)ex;
			vo.setXmlRetCode(String.valueOf(me.getExCode()));
		} else {
			vo.setXmlRetCode(String.valueOf(MospConst.EX_RUNTIME_ERR));
		}
		if (vo.getDocXml() == null) {
			vo.initXmlDoc();
		}
	}

	/**
	 * OObZ[W擾
	 * @param exCode OR[h
	 * @return OR[hɑΉ郍ObZ[W
	 */
	private String getExLogMessage(int exCode) {
		String message = "";
		try {
			Field field = MospConst.class.getField("LOG_MSG_" + String.valueOf(exCode));
			message = (String)field.get(null);
		} catch(NoSuchFieldException e) {
			message = MospConst.LOG_MSG_MESSAGE_ERROR;
		} catch(IllegalAccessException e) {
			message = MospConst.LOG_MSG_MESSAGE_ERROR;
		}
		return message;
	}
	
	/**
	 * OO^Cv擾
	 * @param exCode OR[h
	 * @return OR[hɑΉ郍O^Cv
	 */
	private String getExLogType(int exCode) {
		String logType = "";
		if (exCode >= 1000 && exCode < 4000) {
			logType = MospConst.LOG_MOSPINF;
		} else if (exCode >= 4000 && exCode < 5000) {
			logType = MospConst.LOG_SECURE;
		} else {
			logType = MospConst.LOG_MOSPERR;
		}
		return logType;
	}
	
	/**
	 * OOx擾
	 * @param exCode OR[h
	 * @return OR[hɑΉ郍Ox
	 */
	private int getExLogLevel(int exCode) {
		int logLevel = 0;
		if (exCode >= 1000 && exCode < 4000) {
			logLevel = 4;
		} else if (exCode >= 4000 && exCode < 5000) {
			logLevel = 5;
		} else {
			logLevel = 6;
		}
		return logLevel;
	}
	
	/**
	 * ZbVv
	 * @param exCode OR[h
	 * @return OR[hɑΉZbVv(true/false)
	 */
	private boolean needInitSession(int exCode) {
		if (exCode >= 1000 && exCode < 3000) {
			return false;
		}
		return true;
	}
	
	/**
	 * tH[h擾
	 * @param exCode OR[h
	 * @param request NGXg
	 * @return OR[hɑΉtH[h
	 */
	private String getUrl(int exCode, HttpServletRequest request) {
		String url = "";
		if (exCode >= 1000 && exCode < 2000) {
			url = (String)request.getAttribute(MospConst.ATT_URL);
		} else if (exCode >= 2000 && exCode < 3000) {
			url = MospConst.URL_SRV;
		} else if (exCode >= 3000 && exCode < 4000) {
			url = MospConst.URL_INDEX;
		} else {
			url = MospConst.URL_ERROR;
		}
		return url;
	}
	
}
