/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import java.util.Date;

import jp.mosp.common.bean.AuthBean;
import jp.mosp.common.common.BaseAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.vo.LoginVo;

/**
 * MosPt[[NW̔F؋@\񋟂B<br><br>
 * pX[hɂF؂̑AOCs񐔂⎞Ԃɂ
 * AJEgǗsB
 */
public class AuthAction extends BaseAction {
	
	/**
	 * RXgN^B<br>
	 * ȉ̐ݒsB<br>
	 * <ul>
	 * <li>ZbVmFsv    </li>
	 * <li>ASP[U[mFsv   </li>
	 * <li>[U[mFsv      </li>
	 * <li>mFsv          </li>
	 * <li>V[PXmFsv</li>
	 * </ul>
	 */
	public AuthAction() {
		super();
		setNeedSession (false);
		setNeedAspUser (false);
		setNeedUser    (false);
		setCheckAuth   (false);
		setCheckProcSeq(false);
	}
	
	/**
	 * ANVB<br>
	 * F؏{@link #login(BaseVo)}sB
	 */
	public void action() throws Exception {
		// VȌ
		BaseVo vo = getInitVo();
		// VOyёJڐZbg(Fؐɏ㏑)
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DBڑ̐ݒ
		createAspUser();
		// F؏
		login(vo);
		// R}hݒ
		setNextPage(vo);
		// [U[ݒ
		setUserField();
		// [U[ۑ
		storeUserInfo();
		// Oo
		LogUtility.log(request, 4, MospConst.LOG_MOSPINF, MospConst.LOG_MSG_LOGIN);
	}
	
	
	/**
	 * F؏B<br>
	 * pX[hɂF؁AyуAJEgǗsB
	 * @param baseVo OCʂVO
	 */
	protected void login(BaseVo baseVo) throws Exception {
		// VO
		chkInstance(baseVo instanceof LoginVo);
		LoginVo vo = (LoginVo)baseVo;
		// p[^̎擾
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DBRlNV̎擾
		getConnection();
		// F؏
		AuthBean authBean = new AuthBean(cfg, cmd, aspUser, conn, hasMospSeJar());
		authBean.login(vo.getUserId(), vo.getPass());
		// F؂sĂꍇ
		if (authBean.isErrMessage()) {
			// R~bg
			commit();
			// G[bZ[W̐ݒ
			vo.addErrMessage(MospUtility.getMessage(msg, authBean.getErrMessageCode(), ""));
			throw new MospException(authBean.getMosPExceptionCode());
		}
		this.user = authBean.getCmUserDto();
	}
	
	/**
	 * y[WJڏ
	 * @param vo ΏVO
	 * @throws Exception
	 */
	@SuppressWarnings("unused")
	protected void setNextPage(BaseVo vo) throws Exception {
		// R}hݒ
		String nextCmd = MospConst.CMD_MENU;
		// pX[hLmF
		int passTerm = getPasswordTerm();
		// pX[hL߂ĂApX[hύXʂɑJڂB
		if (isExpirePassWord(passTerm, user.getChangePass())) {
			nextCmd = MospConst.CMD_PASS_FORCE;
		}
		// [U[IDƃpX[hꍇApX[hύXʂɑJڂB
		if (isDefaultPassWord(user.getUserId(), user.getPassword())) {
			nextCmd = MospConst.CMD_PASS_FORCE;
		}
		// R}hݒ
		setNextCmd(nextCmd);
		// T[ubg
		setUrl(MospConst.URL_SRV);
	}
	
	/**
	 * pX[hL擾B<br>
	 * @return	int pX[hL
	 * @throws Exception
	 */
	protected int getPasswordTerm() throws Exception {
		// ݒt@C擾
		String days = cfg.getProperty(MospConst.PPT_ACC_VALIDITY);
		// ݒ̏ꍇint̍ől
		if (days == null) {
			return Integer.MAX_VALUE;
		}
		return Integer.parseInt(days);
	}
	
	/**
	 * pX[hL`FbNB<br>
	 * @param passTerm   L
	 * @param updateDate XV
	 * @return
	 * <p>
	 * L𒴉߂trueAłȂꍇfalse
	 * </p>
	 */
	private boolean isExpirePassWord(int passTerm, Date updateDate) {
		if (passTerm > 0 && MospUtility.getSystemDate().
				compareTo(MospUtility.addDay(updateDate, passTerm)) > 0) {
			return true;
		}
		return false;
	}

	/**
	 * ftHgpX[h`FbNB<br>
	 * @param userid        Ώۃ[UID
	 * @param inputPassWord	 ΏۃpX[h
	 * @return
	 * <p>
	 * ftHgpX[h̏ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	private boolean isDefaultPassWord(String userid, String passWord) throws Exception {
		if (MospUtility.encrypt(MospUtility.getDigest(userid), hasMospSeJar()).equals(passWord)) {
			return true;
		}
		return false;
	}
	
	/**
	 * VO擾B<br>
	 * {@link BaseVo}gVOB<br>
	 * @return VOCX^X
	 */
	protected BaseVo getInitVo() {
		return new LoginVo(cfg, msg, nam, cmd, aspUser, user);
	}
	
	/**
	 * CmAspUserDto̐B<br>
	 * mosp.properties̐ݒɂāADBڑ擾Aݒ肷B<br>
	 */
	protected void createAspUser() {
		aspUser = new CmAspUserDto();
		aspUser.setAspUserId(cfg.getProperty(MospConst.PPT_ASP_ASPUSER ));
		aspUser.setAspName  (cfg.getProperty(MospConst.PPT_ASP_ASPNAME ));
		aspUser.setDbDriver (cfg.getProperty(MospConst.PPT_ASP_DBDRIVER));
		aspUser.setDbUrl    (cfg.getProperty(MospConst.PPT_ASP_DBURL   ));
		aspUser.setDbUser   (cfg.getProperty(MospConst.PPT_ASP_DBUSER  ));
		aspUser.setDbPass   (cfg.getProperty(MospConst.PPT_ASP_DBPASS  ));
	}
	
	/**
	 * [U[̐ݒB<br>
	 * F؂ɐ[U[ɁAeݒ肷B<br>
	 */
	protected void setUserField() {
		// [U[ݒ
		user.setPassword("");
	}
	
	/**
	 * [U[̕ۑB<br>
	 * F؂ɐ[U[ZbVɐݒ肷B<br>
	 */
	protected void storeUserInfo() {
		// ZbV̍Ď擾
		if (session != null) {
			session.invalidate();
		}
		session = request.getSession(true);
		// [U[ݒ
		session.setAttribute(MospConst.ATT_ASPUSER, aspUser);
		session.setAttribute(MospConst.ATT_USER, user);
		request.setAttribute(MospConst.ATT_USER, user);
	}
	
}
