/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.dto.CtAccountDto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtAccountDao
extends BaseDao {
    public static final String TABLE = "CT_ACCOUNT";
    public static final String KEY_01 = "USER_ID";
    public static final String COL_USER_ID = "USER_ID";
    public static final String COL_ATTEMPT = "ATTEMPT";

    public CtAccountDao() {
        this.INSERT_DATE = "";
        this.INSERT_USER = "";
        this.UPDATE_DATE = "UPDATE_DATE";
        this.UPDATE_USER = "";
    }

    public CtAccountDao(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
        this();
        this.initDao(cfg, cmd, aspUser, user, conn);
    }

    private List<CtAccountDto> mappingAll() throws SQLException {
        ArrayList<CtAccountDto> all = new ArrayList<CtAccountDto>();
        while (this.rs.next()) {
            all.add(this.mapping());
        }
        return all;
    }

    private CtAccountDto mapping() throws SQLException {
        CtAccountDto dto = new CtAccountDto();
        dto.setUserId(this.rs.getString("USER_ID"));
        dto.setAttempt(this.rs.getInt(COL_ATTEMPT));
        this.mappingCommonInfo(dto);
        return dto;
    }

    public List<CtAccountDto> findAllCtAccount() throws SQLException, IllegalAccessException, NoSuchFieldException {
        try {
            this.prepareStatement(this.getSelectQuery(this.getClass()));
            this.executeQuery();
            List<CtAccountDto> list = this.mappingAll();
            return list;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public CtAccountDto findCtAccountForUserId(String userId) throws SQLException, IllegalAccessException, NoSuchFieldException {
        try {
            this.index = 1;
            this.prepareStatement(this.getSelectQuery(this.getClass()) + this.getConditionForKey(this.getClass()));
            this.setParam(this.index++, userId);
            this.executeQuery();
            CtAccountDto dto = null;
            if (this.rs.next()) {
                dto = this.mapping();
            }
            CtAccountDto ctAccountDto = dto;
            return ctAccountDto;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int insert(CtAccountDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException {
        try {
            this.index = 1;
            this.prepareStatement(this.getInsertQuery(this.getClass()));
            this.setParam(this.index++, dto.getUserId());
            this.setParam(this.index++, dto.getAttempt());
            this.setCommonParams(true);
            this.executeUpdate(false);
            int n = this.cnt;
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(CtAccountDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParam(this.index++, dto.getUserId());
            this.setParam(this.index++, dto.getAttempt());
            this.setCommonParams(false);
            this.setParam(this.index++, dto.getUserId());
            this.executeUpdate(false);
            int n = this.cnt;
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }
}

