/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.mosp.common.common.HtmlUtility;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.ValidateUtility;
import jp.mosp.common.common.ViewFileLocationUtility;
import jp.mosp.common.common.VoInterface;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseVo
implements VoInterface,
Serializable {
    private static final long serialVersionUID = -5856596970807014781L;
    private String title;
    private String version;
    private String copy;
    private String aspUserId;
    private String aspName;
    private String userId;
    private String userName;
    private String commonCss;
    private String message;
    private String procSeq;
    private boolean isDialog;
    private List<String> extraJs;
    private List<String> extraCss;
    protected String cmd;
    protected boolean isValid;
    protected Properties cfg;
    protected Properties msg;
    protected Properties nam;
    protected List<String> errMessage;
    protected ArrayList<String> errFields;
    protected ArrayList<DetailsVo> errDetails;
    protected boolean needDirectJs = false;
    protected String retUrl;
    protected transient Document docXml;
    protected String xmlRetCode;
    protected String subTitle;
    protected String[][] aryMenu;

    public BaseVo() {
    }

    public BaseVo(Properties cfg, Properties msg, Properties nam, String cmd, CmAspUserDto aspUser, CmUserDto user) {
        this();
        this.initVo(cfg, msg, nam, cmd, aspUser, user);
        this.setFieldsName();
        this.setSubTitle();
    }

    public void initVo(Properties cfg, Properties msg, String cmd, CmAspUserDto aspUser, CmUserDto user) {
        this.cfg = cfg;
        this.msg = msg;
        this.cmd = cmd;
        this.title = cfg.getProperty("app.title");
        this.version = cfg.getProperty("app.version");
        this.copy = cfg.getProperty("app.copy");
        if (aspUser != null) {
            this.aspUserId = aspUser.getAspUserId();
            this.aspName = aspUser.getAspName();
        }
        if (user != null) {
            this.userId = user.getUserId();
            this.userName = user.getUserName();
            this.commonCss = user.getCommonCss();
        }
        this.commonCss = this.commonCss == null || this.commonCss.equals("") ? "/pub/common/css/mosp.css" : this.commonCss;
        this.xmlRetCode = "0";
        this.isDialog = false;
    }

    public void initVo(Properties cfg, Properties msg, Properties nam, String cmd, CmAspUserDto aspUser, CmUserDto user) {
        this.initVo(cfg, msg, cmd, aspUser, user);
        this.nam = nam;
        this.setFieldsName();
        this.setSubTitle();
    }

    protected void setFieldsName() {
    }

    protected void setSubTitle() {
        this.subTitle = "";
        this.aryMenu = null;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public String getEscTitle() {
        return BaseVo.escapeHTML(this.title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public String getEscVersion() {
        return BaseVo.escapeHTML(this.version);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCopy() {
        return this.copy;
    }

    @Override
    public String getEscCopy() {
        return BaseVo.escapeHTML(this.copy);
    }

    public void setCopy(String copy) {
        this.copy = copy;
    }

    public String getAspUserId() {
        return this.aspUserId;
    }

    public String getEscAspUserId() {
        return BaseVo.escapeHTML(this.aspUserId);
    }

    public void setAspUserId(String aspUserId) {
        this.aspUserId = aspUserId;
    }

    public String getAspName() {
        return this.aspName;
    }

    public String getEscAspName() {
        return BaseVo.escapeHTML(this.aspName);
    }

    public void setAspName(String aspName) {
        this.aspName = aspName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEscUserId() {
        return BaseVo.escapeHTML(this.userId);
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getEscUserName() {
        return BaseVo.escapeHTML(this.userName);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getCommonCss() {
        return this.commonCss;
    }

    @Override
    public String getEscCommonCss() {
        return BaseVo.escapeHTML(this.commonCss);
    }

    public void setCommonCss(String commonCss) {
        this.commonCss = commonCss;
    }

    @Override
    public List<String> getExtraJs() {
        return this.extraJs;
    }

    public void setExtraJs(String extraJs) {
        this.extraJs = new ArrayList<String>();
        this.extraJs.add(extraJs);
    }

    public void addExtraJs(String extraJs) {
        this.extraJs = this.extraJs != null ? this.extraJs : new ArrayList<String>();
        this.extraJs.add(extraJs);
    }

    @Override
    public List<String> getExtraCss() {
        return this.extraCss;
    }

    public void setExtraCss(String extraCss) {
        this.extraCss = new ArrayList<String>();
        this.extraCss.add(extraCss);
    }

    public void addExtraCss(String extraCss) {
        this.extraCss = this.extraCss != null ? this.extraCss : new ArrayList<String>();
        this.extraCss.add(extraCss);
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public String getEscMessage() {
        return BaseVo.escapeHTML(this.message);
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    public String getProcSeq() {
        return this.procSeq;
    }

    @Override
    public String getEscProcSeq() {
        return BaseVo.escapeHTML(this.procSeq);
    }

    @Override
    public void setProcSeq(String procSeq) {
        this.procSeq = procSeq;
    }

    @Override
    public void setErrMessage(List<String> errMessage) {
        this.errMessage = errMessage;
    }

    @Override
    public List<String> getErrMessage() {
        return this.errMessage;
    }

    public String getRetUrl() {
        return this.retUrl;
    }

    public void setRetUrl(String retUrl) {
        this.retUrl = retUrl;
    }

    @Override
    public String getXmlRetCode() {
        return this.xmlRetCode;
    }

    public void setXmlRetCode(String xmlRetCode) {
        this.xmlRetCode = xmlRetCode;
    }

    public Document getDocXml() {
        return this.docXml;
    }

    @Override
    public boolean getIsDialog() {
        return this.isDialog;
    }

    public void setIsDialog(boolean isDialog) {
        this.isDialog = isDialog;
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public String[][] getAryMenu() {
        return this.getAryField(this.aryMenu);
    }

    @Override
    public void addErrMessage(String errorMessage) {
        this.errMessage = this.errMessage != null ? this.errMessage : new ArrayList<String>();
        this.errMessage.add(errorMessage);
    }

    @Override
    public void addErrField(String errorFieldId) {
        this.errFields = this.errFields != null ? this.errFields : new ArrayList();
        this.errFields.add(errorFieldId);
    }

    @Override
    public void addErrDetails(int rowNo, String fieldId) {
        this.errDetails = this.errDetails != null ? this.errDetails : new ArrayList();
        this.errDetails.add(new DetailsVo(rowNo, fieldId));
    }

    public void clearMessage() {
        if (this.errMessage != null) {
            this.errMessage.clear();
        }
        this.message = "";
    }

    public void clearErrField() {
        this.errFields = this.errFields != null ? this.errFields : new ArrayList();
        this.errFields.clear();
        this.errDetails = this.errDetails != null ? this.errDetails : new ArrayList();
        this.errDetails.clear();
    }

    protected void startValidation() {
        this.isValid = true;
        this.errMessage = new ArrayList<String>();
        this.errFields = new ArrayList();
        this.errDetails = new ArrayList();
    }

    protected void endValidation() throws MospException {
        if (!this.isValid) {
            this.errMessage.add(0, MospUtility.getMessage(this.msg, "WC1007", ""));
            throw new MospException(1001);
        }
    }

    protected void checkRequired(String value, String name, String id) throws MospException {
        if (!ValidateUtility.chkRequired(value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0001", name);
            this.addErrMessage(errMsg);
            this.addErrField(id);
            this.isValid = false;
            this.logValid(errMsg);
        }
    }

    protected void checkRequired(String value, String name, int rowNo, String id) throws MospException {
        if (!ValidateUtility.chkRequired(value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0001", name);
            this.addErrMessage(errMsg);
            this.addErrDetails(rowNo, id);
            this.isValid = false;
            this.logValid(errMsg);
        }
    }

    protected void checkCode(String value, String name, String id) throws MospException {
        if (!ValidateUtility.chkRegex("\\w*", value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0002", name);
            this.addErrMessage(errMsg);
            this.addErrField(id);
            this.isValid = false;
            errMsg = errMsg + "(" + value + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkCode(String value, String name, int rowNo, String id) throws MospException {
        if (!ValidateUtility.chkRegex("\\w*", value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0002", name);
            this.addErrMessage(errMsg);
            this.addErrDetails(rowNo, id);
            this.isValid = false;
            errMsg = errMsg + "(" + value + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkNumber(String value, String name, String id) throws MospException {
        if (!ValidateUtility.chkRegex("\\d*", value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0003", name);
            this.addErrMessage(errMsg);
            this.addErrField(id);
            this.isValid = false;
            errMsg = errMsg + "(" + value + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkNumber(String value, String name, int rowNo, String id) throws MospException {
        if (!ValidateUtility.chkRegex("\\d*", value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0003", name);
            this.addErrMessage(errMsg);
            this.addErrDetails(rowNo, id);
            this.isValid = false;
            errMsg = errMsg + "(" + value + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkRegex(String value, String regex, String name, String id) throws MospException {
        if (!ValidateUtility.chkRegex(regex, value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0005", name);
            this.addErrMessage(errMsg);
            this.addErrField(id);
            this.isValid = false;
            errMsg = errMsg + "(" + value + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkRegex(String value, String regex, String name, int rowNo, String id) throws MospException {
        if (!ValidateUtility.chkRegex(regex, value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0005", name);
            this.addErrMessage(errMsg);
            this.addErrDetails(rowNo, id);
            this.isValid = false;
            errMsg = errMsg + "(" + value + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkNumeric(String value, String name, String id) throws MospException {
        if (!ValidateUtility.chkNumeric(value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0003", name);
            this.addErrMessage(errMsg);
            this.addErrField(id);
            this.isValid = false;
            errMsg = errMsg + "(" + value + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkNumeric(String value, String name, int rowNo, String id) throws MospException {
        if (!ValidateUtility.chkNumeric(value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0003", name);
            this.addErrMessage(errMsg);
            this.addErrDetails(rowNo, id);
            this.isValid = false;
            errMsg = errMsg + "(" + value + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkLength(String value, int maxLength, String name, String id) throws MospException {
        String regex = ".{0," + String.valueOf(maxLength) + "}";
        if (!ValidateUtility.chkRegex(regex, value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0004", name + "," + String.valueOf(maxLength));
            this.addErrMessage(errMsg);
            this.addErrField(id);
            this.isValid = false;
            errMsg = errMsg + "(" + value + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkLength(String value, int maxLength, String name, int rowNo, String id) throws MospException {
        String regex = ".{0," + String.valueOf(maxLength) + "}";
        if (!ValidateUtility.chkRegex(regex, value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0004", name + "," + String.valueOf(maxLength));
            this.addErrMessage(errMsg);
            this.addErrDetails(rowNo, id);
            this.isValid = false;
            errMsg = errMsg + "(" + value + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkDate(int year, int month, int day, String name, String id) throws MospException {
        if (!ValidateUtility.chkDate(year, month - 1, day)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0006", name);
            this.addErrMessage(errMsg);
            this.addErrField(id);
            this.isValid = false;
            errMsg = errMsg + "(" + String.valueOf(year) + "/" + String.valueOf(month) + "/" + String.valueOf(day) + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkDate(int year, int month, int day, String name, int rowNo, String id) throws MospException {
        if (!ValidateUtility.chkDate(year, month - 1, day)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0006", name);
            this.addErrMessage(errMsg);
            this.addErrDetails(rowNo, id);
            this.isValid = false;
            errMsg = errMsg + "(" + String.valueOf(year) + "/" + String.valueOf(month) + "/" + String.valueOf(day) + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkTerm(Date date, Date startDate, Date endDate, String name, String id) throws MospException {
        if (startDate.compareTo(date) > 0 || endDate.compareTo(date) < 0) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0006", name);
            this.addErrMessage(errMsg);
            this.addErrField(id);
            this.isValid = false;
            errMsg = errMsg + "(" + name + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkTerm(Date date, Date startDate, Date endDate, String name, int rowNo, String id) throws MospException {
        if (!ValidateUtility.chkTerm(date, startDate, endDate)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0006", name);
            this.addErrMessage(errMsg);
            this.addErrDetails(rowNo, id);
            this.isValid = false;
            errMsg = errMsg + "(" + name + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkTime(int hour, int minute, int second, String name, String id) throws MospException {
        if (!ValidateUtility.chkTime(hour, minute, second)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0007", name);
            this.addErrMessage(errMsg);
            this.addErrField(id);
            this.isValid = false;
            errMsg = errMsg + "(" + String.valueOf(hour) + ":" + String.valueOf(minute) + ":" + String.valueOf(second) + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkTime(int hour, int minute, int second, String name, int rowNo, String id) throws MospException {
        if (!ValidateUtility.chkTime(hour, minute, second)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0007", name);
            this.addErrMessage(errMsg);
            this.addErrDetails(rowNo, id);
            this.isValid = false;
            errMsg = errMsg + "(" + String.valueOf(hour) + ":" + String.valueOf(minute) + ":" + String.valueOf(second) + ")";
            this.logValid(errMsg);
        }
    }

    protected void checkCompare(String value1, String value2, int compareFlag, String name, String id1, String id2) throws MospException {
        String messageCode = "";
        switch (compareFlag) {
            case 0: {
                if (value1.equals(value2)) break;
                messageCode = "WC0008";
                break;
            }
            case 1: {
                if (!value1.equals(value2)) break;
                messageCode = "WC0009";
                break;
            }
        }
        if (!messageCode.equals("")) {
            String errMsg = MospUtility.getMessage(this.msg, messageCode, name);
            this.addErrMessage(errMsg);
            this.addErrField(id1);
            this.addErrField(id2);
            this.isValid = false;
            this.logValid(errMsg);
        }
    }

    public void checkDateBeforeAfter(Date beforeDate, Date afterDate, boolean isSameValid, String beforeName, String afterName, String idYear, String idMonth, String idDay) throws MospException {
        if (beforeDate.compareTo(afterDate) > 0) {
            if (isSameValid && beforeDate.compareTo(afterDate) == 0) {
                return;
            }
            String errMsg = MospUtility.getMessage(this.msg, "WC0023", afterName + "," + beforeName);
            this.addErrMessage(errMsg);
            this.addErrField(idYear);
            this.addErrField(idMonth);
            this.addErrField(idDay);
            this.isValid = false;
            this.logValid(errMsg);
        }
    }

    protected void checkPhone(String value, String name, String id) throws MospException {
        if (!ValidateUtility.chkRegex("[0-9-]*", value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0005", name);
            this.addErrMessage(errMsg);
            this.addErrField(id);
            this.isValid = false;
            this.logValid(errMsg);
        }
    }

    protected void checkDecimal(String value, int integer, int decimal, String name, String id, boolean isDetails, int rowNo) throws MospException {
        String regex = "^(([1-9]\\d{0," + String.valueOf(integer - 1) + "})|0)(\\.\\d{1," + String.valueOf(decimal) + "})?$";
        if (value != null && !value.equals("") && !ValidateUtility.chkRegex(regex, value)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC0011", name + "," + String.valueOf(integer) + "," + String.valueOf(decimal));
            this.addErrMessage(errMsg);
            if (isDetails) {
                this.addErrDetails(rowNo, id);
            } else {
                this.addErrField(id);
            }
            this.isValid = false;
            this.logValid(errMsg);
        }
    }

    protected void checkPassword(String oldPassword, String currentPass, String id) throws MospException {
        if (!oldPassword.equals(currentPass)) {
            String errMsg = MospUtility.getMessage(this.msg, "WC1004", "");
            this.addErrMessage(errMsg);
            this.addErrField(id);
            this.isValid = false;
            this.logValid(errMsg);
        }
    }

    public int getIntParam(String value) {
        if (value == null || value.equals("")) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public long getLongParam(String value) {
        if (value == null || value.equals("")) {
            return 0L;
        }
        return Long.parseLong(value);
    }

    public float getFloatParam(String value) {
        if (value == null || value.equals("")) {
            return 0.0f;
        }
        return Float.parseFloat(value);
    }

    public double getDoubleParam(String value) {
        if (value == null || value.equals("")) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    public Date getTime(String time) throws MospException {
        try {
            if (time == null) {
                return null;
            }
            DateFormat df = DateFormat.getTimeInstance();
            return df.parse(time + ":00");
        }
        catch (ParseException e) {
            throw new MospException(5009);
        }
    }

    public Date getDate(String year, String month, String day) throws MospException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(MospUtility.getDate(year + "/" + month + "/" + day));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    protected String[] getAryField(String[] aryField) {
        return aryField == null ? null : (String[])aryField.clone();
    }

    protected String[][] getAryField(String[][] aryField) {
        return aryField == null ? (String[][])null : (String[][])aryField.clone();
    }

    protected Date[] getAryField(Date[] aryField) {
        return aryField == null ? null : (Date[])aryField.clone();
    }

    protected Date getDateField(Date dateField) {
        return dateField == null ? null : (Date)dateField.clone();
    }

    protected String getStrYear(Date dateField) {
        return dateField == null ? "" : String.valueOf(MospUtility.getYear(dateField));
    }

    protected String getStrMonth(Date dateField) {
        return dateField == null ? "" : String.valueOf(MospUtility.getMonth(dateField));
    }

    protected String getStrDay(Date dateField) {
        return dateField == null ? "" : String.valueOf(MospUtility.getDay(dateField));
    }

    protected String getFormatNumber(double value, String format) {
        DecimalFormat df = new DecimalFormat(format);
        return df.format(value);
    }

    public static String escapeHTML(String aStr) {
        return HtmlUtility.escapeHTML(aStr);
    }

    protected Element initXmlDoc() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.docXml = documentBuilder.newDocument();
        Element elmMospData = this.createElement("MospData");
        this.docXml.appendChild(elmMospData);
        Element elmFields = this.createElement("Fields");
        this.appendElement(elmMospData, elmFields);
        return elmFields;
    }

    protected Element createElement(String tagName) {
        return this.docXml.createElement(tagName);
    }

    protected void appendElement(Element parentElement, Element childElement) {
        parentElement.appendChild(childElement);
    }

    protected void appendTextElement(Element parentElement, String tagName, String data) {
        Element childElement = this.createElement(tagName);
        Text textNode = this.docXml.createTextNode(data);
        childElement.appendChild(textNode);
        this.appendElement(parentElement, childElement);
    }

    public String getStrDocXml() throws TransformerException {
        int i;
        Element elmMospData = this.docXml.getDocumentElement();
        Element elmXmlRetCode = this.docXml.createElement("XmlRetCode");
        Text txnXmlRetCode = this.docXml.createTextNode(BaseVo.escapeHTML(this.getXmlRetCode()));
        elmXmlRetCode.appendChild(txnXmlRetCode);
        elmMospData.appendChild(elmXmlRetCode);
        if (this.errMessage != null) {
            for (i = 0; i < this.errMessage.size(); ++i) {
                Element elmErrorMessage = this.docXml.createElement("ErrorMessage");
                Text txnErrMessage = this.docXml.createTextNode(BaseVo.escapeHTML(String.valueOf(this.errMessage.get(i))));
                elmErrorMessage.appendChild(txnErrMessage);
                elmMospData.appendChild(elmErrorMessage);
            }
        }
        if (this.errFields != null) {
            for (i = 0; i < this.errFields.size(); ++i) {
                Element elmErrorFields = this.docXml.createElement("ErrorFields");
                Text txnErrFields = this.docXml.createTextNode(BaseVo.escapeHTML(String.valueOf(this.errFields.get(i))));
                elmErrorFields.appendChild(txnErrFields);
                elmMospData.appendChild(elmErrorFields);
            }
        }
        if (this.errDetails != null) {
            for (i = 0; i < this.errDetails.size(); ++i) {
                DetailsVo vo = this.errDetails.get(i);
                Element elmErrorFields = this.docXml.createElement("ErrorDetails");
                elmErrorFields.setAttribute("rowNo", String.valueOf(vo.rowNo));
                Text txnErrFields = this.docXml.createTextNode(BaseVo.escapeHTML(String.valueOf(vo.fieldId)));
                elmErrorFields.appendChild(txnErrFields);
                elmMospData.appendChild(elmErrorFields);
            }
        }
        Element elmMessage = this.docXml.createElement("Message");
        Text txnMessage = this.docXml.createTextNode(BaseVo.escapeHTML(this.message));
        elmMessage.appendChild(txnMessage);
        elmMospData.appendChild(elmMessage);
        Element elmProcSeq = this.docXml.createElement("ProcSeq");
        Text txnProcSeq = this.docXml.createTextNode(this.getEscProcSeq());
        elmProcSeq.appendChild(txnProcSeq);
        elmMospData.appendChild(elmProcSeq);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter sw = new StringWriter();
        transformer.setOutputProperty("encoding", "SHIFT_JIS");
        transformer.transform(new DOMSource(this.docXml), new StreamResult(sw));
        return sw.toString();
    }

    private void logValid(String errMsg) {
        LogUtility.log(this.cfg, this.aspUserId, this.userId, this.cmd, 4, "\u5165\u529b\u5024\u30a8\u30e9\u30fc", errMsg);
    }

    @Override
    public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
        StringBuffer sb = new StringBuffer();
        if (this.needDirectJs) {
            sb.append(this.getJsFieldsInfo(cls, obj));
            sb.append(this.getJsErrFieldsId());
        }
        return sb.toString();
    }

    @Override
    public String getDirectJs(Class<?> cls) throws IllegalAccessException {
        StringBuffer sb = new StringBuffer();
        if (this.needDirectJs) {
            sb.append(this.getJsFieldsInfo(cls, null));
            sb.append(this.getJsErrFieldsId());
        }
        return sb.toString();
    }

    private String getJsFieldsInfo(Class<?> cls, Object obj) throws IllegalAccessException {
        String name;
        Field field;
        int i;
        StringBuffer sb = new StringBuffer();
        Field[] fields = cls.getFields();
        for (i = 0; i < fields.length; ++i) {
            field = fields[i];
            name = field.getName();
            if (name.indexOf("PRM_") == 0 || name.indexOf("NAM_") == 0 || name.indexOf("REG_") == 0) {
                sb.append("var " + name + " = \"");
                sb.append(field.get(obj));
                sb.append("\";");
                continue;
            }
            if (name.indexOf("LEN_") != 0) continue;
            sb.append("var " + name + " = ");
            sb.append(field.get(obj));
            sb.append(";");
        }
        sb.append("var ARY_FIELDS_ID = new Array(");
        for (i = 0; i < fields.length; ++i) {
            field = fields[i];
            name = field.getName();
            if (name.indexOf("PRM_") != 0) continue;
            sb.append(name + ", ");
        }
        if (sb.charAt(sb.length() - 2) == ',' && sb.charAt(sb.length() - 1) == ' ') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(");");
        return sb.toString();
    }

    private String getJsErrFieldsId() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("var ARY_ERR_FIELDS_ID = new Array(");
        if (this.errFields != null) {
            for (i = 0; i < this.errFields.size(); ++i) {
                sb.append("\"" + this.errFields.get(i) + "\", ");
            }
            if (this.errFields.size() > 0) {
                sb.delete(sb.length() - 2, sb.length());
            }
        }
        sb.append(");");
        sb.append("var ARY_ERR_DETAILS = new Array(");
        if (this.errDetails != null) {
            for (i = 0; i < this.errDetails.size(); ++i) {
                DetailsVo vo = this.errDetails.get(i);
                sb.append("new Array(\"" + vo.fieldId + "\", \"" + vo.rowNo + "\"), ");
            }
            if (this.errDetails.size() > 0) {
                sb.delete(sb.length() - 2, sb.length());
            }
        }
        sb.append(");");
        return sb.toString();
    }

    public String getLogoPath() {
        String pass = this.cfg.getProperty("app.logo");
        if (pass == null || pass.equals("")) {
            return null;
        }
        return pass;
    }

    public String getName(String key) {
        if (this.nam == null) {
            return "";
        }
        return this.nam.getProperty(key, "");
    }

    protected void setViewPath(String className) {
        ViewFileLocationUtility location = new ViewFileLocationUtility(className);
        this.setRetUrl(location.getRetUrl());
        this.addExtraCss(location.getExtraCss());
        this.addExtraJs(location.getExtraJs());
    }

    private static class DetailsVo
    implements Serializable {
        private static final long serialVersionUID = 8052715720150027371L;
        protected int rowNo;
        protected String fieldId;

        protected DetailsVo(int rowNo, String fieldId) {
            this.rowNo = rowNo;
            this.fieldId = fieldId;
        }
    }
}

