/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.validator;

import java.io.Serializable;

/**
 * <P>
 * ̃NX́AtB[h of[^̃Gg\܂B
 * </P>
 * @author Kenichi Fukuda
 */
public class FieldValidatorEntry implements Serializable
{
	/** tB[h of[^ */
	private FieldValidator validator = null;

	/** bZ[W ID */
	private String messageId = null;

	/** ̃Gg̐ */
	private String description = null;

	/**
	 * <P>
	 * bZ[W ID Ԃ܂B
	 * </P>
	 * @return bZ[W ID
	 */
	public String getMessageId()
	{
		return messageId;
	}

	/**
	 * <P>
	 * tB[h of[^Ԃ܂B
	 * </P>
	 * @return tB[h of[^
	 */
	public FieldValidator getValidator()
	{
		return validator;
	}

	/**
	 * <P>
	 * ̃Gg̐Ԃ܂B
	 * </P>
	 * @return ̃Gg̐
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * <P>
	 * bZ[W ID ݒ肵܂B
	 * </P>
	 * @param messageId bZ[W ID
	 */
	public void setMessageId(String messageId)
	{
		this.messageId = messageId;
	}

	/**
	 * <P>
	 * tB[h of[^ݒ肵܂B
	 * </P>
	 * @param validator tB[h of[^
	 */
	public void setValidator(FieldValidator validator)
	{
		this.validator = validator;
	}

	/**
	 * <P>
	 * ̃Gg̐ݒ肵܂B
	 * </P>
	 * @param description ̃Gg̐
	 */
	public void setDescription(String description)
	{
		this.description = description;
	}

}
