/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.validator;

import java.text.SimpleDateFormat;
import java.util.Locale;

import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.http.HttpActionRequest;

/**
 * <P>
 * HTTP p[^tł邩؂邽߂̃NXłB
 * ݒ肳ꂽp^[gpāAHTTP p[^Ƃĉ͂ł邩؂܂B
 * </P>
 * <P>
 * p^[͕Kݒ肷Kv܂B
 * ݒłp^[ɂẮAjava.text.SimpleDateFormat ̓t/p^[QƂĂB
 * </P>
 * <P>
 * ŏlݒ肳Ăꍇ͍ŏlȏł邩Aőlݒ肳Ăꍇ͍őlȉł邩؂܂B
 * </P>
 * @author Kenichi Fukuda
 * @see java.text.SimpleDateFormat
 */
public class DateValidator extends AbstractFieldValidator
{
	private String pattern = null;
	private Locale locale = null;
	private java.util.Date minimum = null;
	private java.util.Date maximum = null;

	/**
	 * <P>
	 * w肳ꂽvIuWFNg HTTP p[^̑Ó؂܂B
	 * </P>
	 * @param request vIuWFNg
	 * @throws ValidationException Ó؂Ƃɖ肪oꂽꍇ
	 */
	public void validate(HttpActionRequest request) throws ValidationException
	{
		if (pattern == null)
		{
			throw new ValidationException("pattern is not set");
		}

		String value = request.getParameter(this.getFieldName());

		if (!this.isValidate(value))
		{
			return;
		}
		this.validateRequired(value);

		SimpleDateFormat dateFormat = null;
		if (locale == null)
		{
			dateFormat = new SimpleDateFormat(pattern);
		}
		else
		{
			dateFormat = new SimpleDateFormat(pattern, locale);
		}

		java.util.Date date = null;
		try
		{
			date = dateFormat.parse(value);
			if (date == null)
			{
				throw new ValidationException("value is not date");
			}
		}
		catch (Exception e)
		{
			throw new ValidationException("value is not date");
		}

		if (minimum != null)
		{
			if (minimum.compareTo(date) < 0)
			{
				throw new ValidationException("out of range");
			}
		}

		if (maximum != null)
		{
			if (maximum.compareTo(date) > 0)
			{
				throw new ValidationException("out of range");
			}
		}

		if (this.getCompareFieldName() != null)
		{
			if (this.getCompareOperator() == null)
			{
				throw new ValidationException("compare operator is not set");
			}
			else
			{
				ConversionMap form = ConversionMap.valueOf(request.getParameterMap());
				java.util.Date compareValue = form.parseDate(this.getCompareFieldName(), pattern);
				String ope = this.getCompareOperator().trim();
				if (ope.equals(">"))
				{
					if (!(date.compareTo(compareValue) > 0))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals(">="))
				{
					if (!(date.compareTo(compareValue) >= 0))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals("=="))
				{
					if (!(date.compareTo(compareValue) == 0))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals("<="))
				{
					if (!(date.compareTo(compareValue) <= 0))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals("<"))
				{
					if (!(date.compareTo(compareValue) < 0))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals("!="))
				{
					if (!(date.compareTo(compareValue) != 0))
					{
						throw new ValidationException("compare error");
					}
				}
			}
		}

	}

	/**
	 * <P>
	 * ݒ肳Ăt/p^[Ԃ܂B
	 * </P>
	 * @return ݒ肳Ăt/p^[Bݒ肳ĂȂꍇ null
	 */
	public String getPattern()
	{
		return pattern;
	}

	/**
	 * <P>
	 * t/p^[ݒ肵܂B
	 * </P>
	 * @param value t/p^[
	 */
	public void setPattern(String value)
	{
		pattern = value;
	}

	/**
	 * <P>
	 * ݒ肳Ă郍P[Ԃ܂B
	 * </P>
	 * @return ݒ肳Ă郍P[Bݒ肳ĂȂꍇ null
	 */
	public Locale getLocale()
	{
		return locale;
	}

	/**
	 * <P>
	 * P[ݒ肵܂B
	 * </P>
	 * @param locale P[
	 */
	public void setLocale(Locale locale)
	{
		this.locale = locale;
	}

	/**
	 * <P>
	 * ŏlݒ肵܂B
	 * </P>
	 * @param value ŏl
	 */
	public void setMinimum(java.util.Date value)
	{
		this.minimum = value;
	}

	/**
	 * <P>
	 * őlݒ肵܂B
	 * </P>
	 * @param value ől
	 */
	public void setMaximum(java.util.Date value)
	{
		this.maximum = value;
	}

	/**
	 * <P>
	 * ݒ肳ĂőlԂ܂B
	 * </P>
	 * @return ݒ肳ĂőlBݒ肳ĂȂꍇ null
	 */
	public java.util.Date getMaximum()
	{
		return maximum;
	}

	/**
	 * <P>
	 * ݒ肳ĂŏlԂ܂B
	 * </P>
	 * @return ݒ肳ĂŏlBݒ肳ĂȂꍇ null
	 */
	public java.util.Date getMinimum()
	{
		return minimum;
	}

}
