/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

/**
 * <P>
 * HTML  TABLE ^OnhłB
 * </P>
 * <P>
 * TABLE  HTML 4 `͎̂ƂłB
 * <PRE>
 * &lt;!ELEMENT TABLE - -
 *      (CAPTION?, (COL*|COLGROUP*), THEAD?, TFOOT?, TBODY+)&gt;
 * &lt;!ATTLIST TABLE                        -- table element --
 *   %attrs;                              -- %coreattrs, %i18n, %events --
 *   summary     %Text;         #IMPLIED  -- purpose/structure for speech output--
 *   width       %Length;       #IMPLIED  -- table width --
 *   border      %Pixels;       #IMPLIED  -- controls frame width around table --
 *   frame       %TFrame;       #IMPLIED  -- which parts of frame to render --
 *   rules       %TRules;       #IMPLIED  -- rulings between rows and cols --
 *   cellspacing %Length;       #IMPLIED  -- spacing between cells --
 *   cellpadding %Length;       #IMPLIED  -- spacing within cells --
 *   &gt;
 * </PRE>
 * </P>
 * @author Kenichi Fukuda
 */
public class TableTag extends AttrsSupportTag
{
	/**
	 * <P>
	 * TableTag 쐬܂B
	 * </P>
	 */
	public TableTag()
	{
		super();
	}

	/**
	 * <P>
	 * align Ԃ܂B
	 * </P>
	 * @return align 
	 */
	public String getAlign()
	{
		return getAttributeMap().getString("align");
	}

	/**
	 * <P>
	 * background Ԃ܂B
	 * </P>
	 * @return background 
	 */
	public String getBackground()
	{
		return getAttributeMap().getString("background");
	}

	/**
	 * <P>
	 * bgcolor Ԃ܂B
	 * </P>
	 * @return bgcolor 
	 */
	public String getBgcolor()
	{
		return getAttributeMap().getString("bgcolor");
	}

	/**
	 * <P>
	 * border Ԃ܂B
	 * </P>
	 * @return border 
	 */
	public String getBorder()
	{
		return getAttributeMap().getString("border");
	}

	/**
	 * <P>
	 * bordercolor Ԃ܂B
	 * </P>
	 * @return bordercolor 
	 */
	public String getBordercolor()
	{
		return getAttributeMap().getString("bordercolor");
	}

	/**
	 * <P>
	 * cellpadding Ԃ܂B
	 * </P>
	 * @return cellpadding 
	 */
	public String getCellpadding()
	{
		return getAttributeMap().getString("cellpadding");
	}

	/**
	 * <P>
	 * cellspacing Ԃ܂B
	 * </P>
	 * @return cellspacing 
	 */
	public String getCellspacing()
	{
		return getAttributeMap().getString("cellspacing");
	}

	/**
	 * <P>
	 * frame Ԃ܂B
	 * </P>
	 * @return frame 
	 */
	public String getFrame()
	{
		return getAttributeMap().getString("frame");
	}

	/**
	 * <P>
	 * height Ԃ܂B
	 * </P>
	 * @return height 
	 */
	public String getHeight()
	{
		return getAttributeMap().getString("height");
	}

	/**
	 * <P>
	 * rules Ԃ܂B
	 * </P>
	 * @return rules 
	 */
	public String getRules()
	{
		return getAttributeMap().getString("rules");
	}

	/**
	 * <P>
	 * summary Ԃ܂B
	 * </P>
	 * @return summary 
	 */
	public String getSummary()
	{
		return getAttributeMap().getString("summary");
	}

	/**
	 * <P>
	 * width Ԃ܂B
	 * </P>
	 * @return width 
	 */
	public String getWidth()
	{
		return getAttributeMap().getString("width");
	}

	/**
	 * <P>
	 * align ݒ肵܂B
	 * </P>
	 * @param align align 
	 */
	public void setAlign(String align)
	{
		getAttributeMap().putString("align", align);
	}

	/**
	 * <P>
	 * background ݒ肵܂B
	 * </P>
	 * @param background background 
	 */
	public void setBackground(String background)
	{
		getAttributeMap().putString("background", background);
	}

	/**
	 * <P>
	 * bgcolor ݒ肵܂B
	 * </P>
	 * @param bgcolor bgcolor 
	 */
	public void setBgcolor(String bgcolor)
	{
		getAttributeMap().putString("bgcolor", bgcolor);
	}

	/**
	 * <P>
	 * border ݒ肵܂B
	 * </P>
	 * @param border border 
	 */
	public void setBorder(String border)
	{
		getAttributeMap().putString("border", border);
	}

	/**
	 * <P>
	 * bordercolor ݒ肵܂B
	 * </P>
	 * @param bordercolor bordercolor 
	 */
	public void setBordercolor(String bordercolor)
	{
		getAttributeMap().putString("bordercolor", bordercolor);
	}

	/**
	 * <P>
	 * cellpadding ݒ肵܂B
	 * </P>
	 * @param cellpadding cellpadding 
	 */
	public void setCellpadding(String cellpadding)
	{
		getAttributeMap().putString("cellpadding", cellpadding);
	}

	/**
	 * <P>
	 * cellspacing ݒ肵܂B
	 * </P>
	 * @param cellspacing cellspacing 
	 */
	public void setCellspacing(String cellspacing)
	{
		getAttributeMap().putString("cellspacing", cellspacing);
	}

	/**
	 * <P>
	 * frame ݒ肵܂B
	 * </P>
	 * @param frame frame 
	 */
	public void setFrame(String frame)
	{
		getAttributeMap().putString("frame", frame);
	}

	/**
	 * <P>
	 * height ݒ肵܂B
	 * </P>
	 * @param height height 
	 */
	public void setHeight(String height)
	{
		getAttributeMap().putString("height", height);
	}

	/**
	 * <P>
	 * rules ݒ肵܂B
	 * </P>
	 * @param rules rules 
	 */
	public void setRules(String rules)
	{
		getAttributeMap().putString("rules", rules);
	}

	/**
	 * <P>
	 * summary ݒ肵܂B
	 * </P>
	 * @param summary summary 
	 */
	public void setSummary(String summary)
	{
		getAttributeMap().putString("summary", summary);
	}

	/**
	 * <P>
	 * width ݒ肵܂B
	 * </P>
	 * @param width width 
	 */
	public void setWidth(String width)
	{
		getAttributeMap().putString("width", width);
	}

	/**
	 * <P>
	 * I^ȌłB
	 * </P>
	 * @return EVAL_PAGE
	 * @see javax.servlet.jsp.tagext.Tag#doEndTag()
	 */
	public int doEndTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();
		buf.append("</table>");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doEndTag();
	}

	/**
	 * <P>
	 * Jn^ȌłB
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();
		buf.append("<table");

		String keys[] = new String[this.getAttributeMap().size()];
		keys = (String[])this.getAttributeMap().keySet().toArray(keys);
		for (int i = 0; i < keys.length; i++)
		{
			buf.append(" ").append(keys[i]).append("=\"");
			buf.append(this.getAttributeMap().getString(keys[i]));
			buf.append("\"");
		}

		buf.append(">");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doStartTag();
	}

}
