/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.io.IOException;
import java.util.Map;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

import jp.morpho.util.ConversionMap;
import jp.morpho.util.StringTokenizer;
import jp.morpho.webapp.servlet.jsp.tagext.BaseTag;
import jp.morpho.webapp.servlet.jsp.tagext.PropertySupportTag;

/**
 * <P>
 * ̉BRg[쐬܂B
 * </P>
 * @author Kenichi Fukuda
 */
public class HiddensTag
	extends BaseTag
	implements PropertySupportTag
{

	/** ̃^ÕvpeB */
	private ConversionMap property = new ConversionMap();

	/** ̃^OT|[gvpeB */
	private ConversionMap supportedPropertyMap = new ConversionMap();

	/**
	 * <P>
	 * HiddensTag 쐬܂B
	 * </P>
	 */
	public HiddensTag()
	{
		super();

		//hiddens
		supportedPropertyMap.putString("includes", "");
		supportedPropertyMap.putString("excludes", "");
	}

	/**
	 * <P>
	 * name Ԃ܂B
	 * </P>
	 * @return name 
	 */
	public String getName()
	{
		return getAttributeMap().getString("name");
	}

	/**
	 * <P>
	 * name ݒ肵܂B
	 * </P>
	 * @param name name 
	 */
	public void setName(String name)
	{
		getAttributeMap().putString("name", name);
	}

	/**
	 * <P>
	 * scope Ԃ܂B
	 * </P>
	 * @return scope 
	 */
	public String getScope()
	{
		return getAttributeMap().getString("scope");
	}

	/**
	 * <P>
	 * scope ݒ肵܂B
	 * </P>
	 * @param scope scope 
	 */
	public void setScope(String scope)
	{
		getAttributeMap().putString("scope", scope);
	}

	/**
	 * <P>
	 * I^ȌłB
	 * </P>
	 * @return EVAL_PAGE
	 * @see javax.servlet.jsp.tagext.Tag#doEndTag()
	 */
	public int doEndTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();

		Map parameterMap = getParameterMap();
		if (parameterMap != null)
		{
			String includes = property.getString("includes");
			StringTokenizer includesTokenizer = new StringTokenizer(includes, ",");
			ConversionMap includesMap = new ConversionMap();
			while (includesTokenizer.hasMoreTokens())
			{
				String name = includesTokenizer.nextToken();
				if (!name.equals(""))
				{
					includesMap.putString(name, "");
				}
			}

			String excludes = property.getString("excludes");
			StringTokenizer excludesTokenizer = new StringTokenizer(excludes, ",");
			ConversionMap excludesMap = new ConversionMap();
			while (excludesTokenizer.hasMoreTokens())
			{
				String name = excludesTokenizer.nextToken();
				if (!name.equals(""))
				{
					excludesMap.putString(name, "");
				}
			}

			HtmlEncoder encoder = this.getTagManager().getHtmlEncoder();
			ConversionMap tagInfo = ConversionMap.valueOf(parameterMap);
			if (includesMap.size() > 0)
			{
				String[] keys = new String[includesMap.size()];
				keys = (String[])includesMap.keySet().toArray(keys);
				for (int i = 0; i < keys.length; i++)
				{
					if (!tagInfo.containsKey(keys[i]))
					{
						continue;
					}

					buf.append("<input type=\"hidden\"");
					buf.append(" name=\"").append(keys[i]).append("\"");
					buf.append(" value=\"").append(encoder.encode(tagInfo.getString(keys[i]))).append("\"");
					buf.append(">");
				}
			}
			else
			{
				String[] keys = new String[tagInfo.size()];
				keys = (String[])tagInfo.keySet().toArray(keys);
				for (int i = 0; i < keys.length; i++)
				{
					if (excludesMap.containsKey(keys[i]))
					{
						continue;
					}

					buf.append("<input type=\"hidden\"");
					buf.append(" name=\"").append(keys[i]).append("\"");
					buf.append(" value=\"").append(encoder.encode(tagInfo.getString(keys[i]))).append("\"");
					buf.append(">");
				}
			}
		}

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doEndTag();
	}

	/**
	 * <P>
	 * BRg[̃L[ƒl֘At}bv擾܂B
	 * </P>
	 * @return BRg[̃L[ƒl֘At}bv
	 */
	protected Map getParameterMap()
	{
		if (!this.getScope().equals("request"))
		{
			if (this.getName() == null || this.getName().equals(""))
			{
				return null;
			}
		}

		if (this.getScope().equals("request"))
		{
			if (this.getName() == null || this.getName().equals(""))
			{
				return pageContext.getRequest().getParameterMap();
			}
		}

		int scope = PageContext.PAGE_SCOPE;
		if (this.getScope().equals("request"))
		{
			scope = PageContext.REQUEST_SCOPE;
		}
		else if (this.getScope().equals("session"))
		{
			scope = PageContext.SESSION_SCOPE;
		}
		else if (this.getScope().equals("application"))
		{
			scope = PageContext.APPLICATION_SCOPE;
		}
		return (Map)pageContext.getAttribute(this.getName(), scope);
	}

	/**
	 * <P>
	 * w肳ꂽL[vpeBÃ^ÕvpeBXgT܂B
	 * ̃vpeBȂꍇ́Anull Ԃ܂B
	 * </P>
	 * @param key vpeBL[
	 * @return w肳ꂽL[l̃^ÕvpeBXg̒l
	 */
	public String getProperty(String key)
	{
		if (!supportedPropertyMap.containsKey(key))
		{
			throw new IllegalArgumentException(key + " is not supported");
		}

		return property.getString(key);
	}

	/**
	 * <P>
	 * ̃^OɃvpeBݒ肵܂B
	 * vpeB̃L[ђlɕgƂ`t܂B
	 * </P>
	 * @param key ̃^ÕvpeBXgɔzuL[
	 * @param value key ɑΉl
	 */
	public void setProperty(String key, String value)
	{
		if (!supportedPropertyMap.containsKey(key))
		{
			throw new IllegalArgumentException(key + " is not supported");
		}

		property.putString(key, value);
	}

}
