/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpActionRequestFactory;

/**
 * <P>
 * HTML  CAPTION ^OnhłB
 * </P>
 * <P>
 * CAPTION  HTML 4 `͎̂ƂłB
 * <PRE>
 * &lt;!ELEMENT CAPTION  - - (%inline;)*     -- table caption --&gt;
 * 
 * &lt;!ATTLIST CAPTION
 *   %attrs;                              -- %coreattrs, %i18n, %events --
 *   &gt;
 * </PRE>
 * </P>
 * @author Kenichi Fukuda
 */
public class CaptionTag extends AttrsSupportTag
{
	/**
	 * <P>
	 * CaptionTag 쐬܂B
	 * </P>
	 */
	public CaptionTag()
	{
		super();
	}

	/**
	 * <P>
	 * align Ԃ܂B
	 * </P>
	 * @return align 
	 */
	public String getAlign()
	{
		return getAttributeMap().getString("align");
	}

	/**
	 * <P>
	 * align ݒ肵܂B
	 * </P>
	 * @param align align 
	 */
	public void setAlign(String align)
	{
		getAttributeMap().putString("align", align);
	}

	/**
	 * <P>
	 * I^ȌłB
	 * </P>
	 * @return EVAL_PAGE
	 * @see javax.servlet.jsp.tagext.Tag#doEndTag()
	 */
	public int doEndTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();
		buf.append("</caption>");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doEndTag();
	}

	/**
	 * <P>
	 * Jn^ȌłB
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		HttpActionRequest request =
			HttpActionRequestFactory.getInstance().getRequest(
				(HttpServletRequest)pageContext.getRequest());

		StringBuffer buf = new StringBuffer();
		buf.append("<caption");

		String keys[] = new String[this.getAttributeMap().size()];
		keys = (String[])this.getAttributeMap().keySet().toArray(keys);
		for (int i = 0; i < keys.length; i++)
		{
			buf.append(" ").append(keys[i]).append("=\"");
			buf.append(this.getAttributeMap().getString(keys[i]));
			buf.append("\"");
		}

		buf.append(">");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doStartTag();
	}

}
