/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.http.impl;

import javax.servlet.http.HttpServletRequest;

import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpActionRequestFactory;

/**
 * <P>
 * HTTP ANV T[ubgp̗v t@Ng̋@\`܂B
 * </P>
 * @author Kenichi Fukuda
 */
public class HttpActionRequestFactoryImpl
	extends HttpActionRequestFactory
{

	/**
	 * <P>
	 * HttpActionRequestFactory 쐬܂B
	 * </P>
	 */
	protected HttpActionRequestFactoryImpl()
	{
		super();
	}

	/**
	 * <P>
	 * HTTP ANV T[ubgp̗v t@Ng IuWFNg쐬܂B
	 * </P>
	 * @return HTTP ANV T[ubgp̗v t@Ng IuWFNg
	 */
	public static synchronized HttpActionRequestFactory getInstance()
	{
		return new HttpActionRequestFactoryImpl();
	}

	/**
	 * <P>
	 * HTTP ANV T[ubgp̗v IuWFNgԂ܂B
	 * </P>
	 * @param request vIuWFNg
	 * @return HTTP ANV T[ubgp̗v IuWFNg
	 */
	public HttpActionRequest getRequest(HttpServletRequest request)
	{
		if (request instanceof HttpActionRequest)
		{
			return (HttpActionRequest)request;
		}

		return new HttpActionRequestImpl(request);
	}

}
